/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4Q\u0001D\u0007\u0002\u0002iAQ!\n\u0001\u0005\u0002\u0019BQ\u0001\u000b\u0001\u0007\u0002%BQ\u0001\r\u0001\u0007\u0012EBQ!\u000e\u0001\u0005RYBQA\u000f\u0001\u0005R%BQa\u000f\u0001\u0005BqBQa\u0014\u0001\u0005BACQ\u0001\u0016\u0001\u0005B%BQ!\u0016\u0001\u0005\nYCQ\u0001\u0018\u0001\u0005BuCQa\u001a\u0001\u0005B!\u00141\u0002V8US6,7\u000f^1na*\u0011abD\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0011#\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00017}\u0011\u0003C\u0001\u000f\u001e\u001b\u0005i\u0011B\u0001\u0010\u000e\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002\u001dA%\u0011\u0011%\u0004\u0002\u0019)&lWm\u001d;b[B4uN]7biR,'\u000fS3ma\u0016\u0014\bC\u0001\u000f$\u0013\t!SBA\tFqB,7\r^:J]B,H\u000fV=qKN\fa\u0001P5oSRtD#A\u0014\u0011\u0005q\u0001\u0011a\u00034bS2|e.\u0012:s_J,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\b\u0005>|G.Z1o\u0003=!wn\u001e8TG\u0006dWMR1di>\u0014X#\u0001\u001a\u0011\u0005-\u001a\u0014B\u0001\u001b-\u0005\u0011auN\\4\u0002\u0019\u0019|'/\\1u'R\u0014\u0018N\\4\u0016\u0003]\u0002\"\u0001\b\u001d\n\u0005ej!AC#yaJ,7o]5p]\u0006I\u0011n\u001d)beNLgnZ\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A\u001f\u0011\u0007y2\u0015J\u0004\u0002@\t:\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)G\u0001\u0007yI|w\u000e\u001e \n\u00035J!!\u0012\u0017\u0002\u000fA\f7m[1hK&\u0011q\t\u0013\u0002\u0004'\u0016\f(BA#-!\tQU*D\u0001L\u0015\ta\u0015#A\u0003usB,7/\u0003\u0002O\u0017\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0011\u000b\u0005\u0002K%&\u00111k\u0013\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0007jgB\u000b'o]3FeJ|'\u000f\u0006\u0002+/\")\u0001,\u0003a\u00013\u0006\tQ\r\u0005\u0002?5&\u00111\f\u0013\u0002\n)\"\u0014xn^1cY\u0016\fA!\u001a<bYR\u0011a,\u0019\t\u0003W}K!\u0001\u0019\u0017\u0003\u0007\u0005s\u0017\u0010C\u0004c\u0015A\u0005\t\u0019A2\u0002\u000b%t\u0007/\u001e;\u0011\u0005\u0011,W\"A\b\n\u0005\u0019|!aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007%|G\u000f\u0005\u0002k[6\t1N\u0003\u0002m\u001b\u000591m\u001c3fO\u0016t\u0017B\u00018l\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00029\f\u0001\u0004\t\u0018aA2uqB\u0011!N]\u0005\u0003g.\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003v\u0017\u0001\u0007\u0011.\u0001\u0002fm\u0002")
public abstract class ToTimestamp
extends BinaryExpression
implements TimestampFormatterHelper,
ExpectsInputTypes {
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatterOption$lzycompute() : this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public abstract boolean failOnError();

    public abstract long downScaleFactor();

    @Override
    public Expression formatString() {
        return (Expression)this.right();
    }

    @Override
    public boolean isParsing() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nullable())) : true;
    }

    private boolean isParseError(Throwable e) {
        Throwable throwable = e;
        boolean bl = throwable instanceof DateTimeParseException ? true : (throwable instanceof DateTimeException ? true : throwable instanceof ParseException);
        boolean bl2 = bl;
        return bl2;
    }

    @Override
    public Object eval(InternalRow input) {
        Long l;
        Object t = ((Expression)this.left()).eval(input);
        if (t == null) {
            l = null;
        } else {
            Long l2;
            DataType dataType = ((Expression)this.left()).dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                l2 = BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.daysToMicros(BoxesRunTime.unboxToInt((Object)t), this.zoneId()) / this.downScaleFactor()));
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                l2 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)t) / this.downScaleFactor()));
            } else if (StringType$.MODULE$.equals(dataType)) {
                Long l3;
                Object fmt = ((Expression)this.right()).eval(input);
                if (fmt == null) {
                    l3 = null;
                } else {
                    TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getFormatter(fmt.toString()));
                    try {
                        l3 = BoxesRunTime.boxToLong((long)(formatter.parse(((UTF8String)t).toString()) / this.downScaleFactor()));
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (this.isParseError(throwable2)) {
                            if (this.failOnError()) {
                                throw throwable2;
                            }
                        } else {
                            throw throwable;
                        }
                        Object var3_9 = null;
                        l3 = var3_9;
                    }
                }
                l2 = l3;
            } else {
                throw new MatchError((Object)dataType);
            }
            l = l2;
        }
        return l;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String parseErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        DataType dataType = ((Expression)this.left()).dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            exprCode = (ExprCode)this.formatterOption().map((Function1 & Serializable & scala.Serializable)fmt -> {
                String df = TimestampFormatter.class.getName();
                String formatterName = ctx.addReferenceObj("formatter", fmt, df);
                return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(datetimeStr, x$3) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(322).append("\n             |try {\n             |  ").append(ev.value()).append(" = ").append(formatterName).append(".parse(").append((String)datetimeStr).append(".toString()) / ").append(this.downScaleFactor()).append(";\n             |} catch (java.time.DateTimeException e) {\n             |  ").append(parseErrorBranch).append("\n             |} catch (java.time.format.DateTimeParseException e) {\n             |  ").append(parseErrorBranch).append("\n             |} catch (java.text.ParseException e) {\n             |  ").append(parseErrorBranch).append("\n             |}\n             |").toString())).stripMargin());
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
                String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
                String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
                String timestampFormatter = ctx.freshName("timestampFormatter");
                return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(string, format) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(481).append("\n             |").append(tf).append(" ").append(timestampFormatter).append(" = ").append(tf).append("$.MODULE$.apply(\n             |  ").append((String)format).append(".toString(),\n             |  ").append(zid).append(",\n             |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n             |  true);\n             |try {\n             |  ").append(ev.value()).append(" = ").append(timestampFormatter).append(".parse(").append((String)string).append(".toString()) / ").append(this.downScaleFactor()).append(";\n             |} catch (java.time.format.DateTimeParseException e) {\n             |    ").append(parseErrorBranch).append("\n             |} catch (java.time.DateTimeException e) {\n             |    ").append(parseErrorBranch).append("\n             |} catch (java.text.ParseException e) {\n             |    ").append(parseErrorBranch).append("\n             |}\n             |").toString())).stripMargin());
            });
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            ExprCode eval1 = ((Expression)this.left()).genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", " / ", ";\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval1.code(), ev.isNull(), eval1.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), eval1.value(), BoxesRunTime.boxToLong((long)this.downScaleFactor())})), ev.copy$default$2(), ev.copy$default$3());
        } else if (DateType$.MODULE$.equals(dataType)) {
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            ExprCode eval1 = ((Expression)this.left()).genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".daysToMicros(", ", ", ") / ", ";\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval1.code(), ev.isNull(), eval1.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), dtu, eval1.value(), zid, BoxesRunTime.boxToLong((long)this.downScaleFactor())})), ev.copy$default$2(), ev.copy$default$3());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    public ToTimestamp() {
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

