/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the negated value of `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_(1);\n       -1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0011#\u0001>B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Y\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\u0011\b\u0001\"\u0011t\u0011!a\b\u0001#b\u0001\n\u0013i\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003O\u0001A\u0011KA\u0015\u0011\u00199\u0003\u0001\"\u0011\u00020!9\u0011\u0011\u0007\u0001\u0005R\u0005M\u0002\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0011%\t\t\u0005AI\u0001\n\u0003\t\u0019\u0005C\u0005\u0002Z\u0001\t\n\u0011\"\u0001\u0002\\!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0013\u0011\r\u0005\n\u0003c\u0002\u0011\u0011!C\u0001\u0003gB\u0011\"a\u001f\u0001\u0003\u0003%\t!! \t\u0013\u0005\r\u0005!!A\u0005B\u0005\u0015\u0005\"CAJ\u0001\u0005\u0005I\u0011AAK\u0011%\tI\nAA\u0001\n\u0003\nYjB\u0005\u0002@\n\n\t\u0011#\u0001\u0002B\u001aA\u0011EIA\u0001\u0012\u0003\t\u0019\r\u0003\u0004T3\u0011\u0005\u0011\u0011\u001b\u0005\tef\t\t\u0011\"\u0012\u0002T\"I\u0011Q[\r\u0002\u0002\u0013\u0005\u0015q\u001b\u0005\n\u0003;L\u0012\u0013!C\u0001\u00037B\u0011\"a8\u001a\u0003\u0003%\t)!9\t\u0013\u0005M\u0018$%A\u0005\u0002\u0005m\u0003\"CA{3\u0005\u0005I\u0011BA|\u0005))f.\u0019:z\u001b&tWo\u001d\u0006\u0003G\u0011\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QEJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\r\u001b8}\u0011\u0003\"!\r\u001a\u000e\u0003\tJ!a\r\u0012\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!M\u001b\n\u0005Y\u0012#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0001h\u000f\b\u0003ceJ!A\u000f\u0012\u0002\u000fA\f7m[1hK&\u0011A(\u0010\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tQ$\u0005\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005IA\u0004Qe>$Wo\u0019;\u0011\u0005}*\u0015B\u0001$A\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005I\u0005CA\u0019K\u0013\tY%E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012a\u0014\t\u0003\u007fAK!!\u0015!\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"2!\u0016,X!\t\t\u0004\u0001C\u0003H\u000b\u0001\u0007\u0011\nC\u0004N\u000bA\u0005\t\u0019A(\u0015\u0005UK\u0006\"B$\u0007\u0001\u0004I\u0015AC5oaV$H+\u001f9fgV\tA\fE\u0002^I\u001et!AX2\u000f\u0005}\u0013W\"\u00011\u000b\u0005\u0005t\u0013A\u0002\u001fs_>$h(C\u0001B\u0013\tQ\u0004)\u0003\u0002fM\n\u00191+Z9\u000b\u0005i\u0002\u0005C\u00015l\u001b\u0005I'B\u00016'\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0017N\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001p!\tA\u0007/\u0003\u0002rS\nAA)\u0019;b)f\u0004X-\u0001\u0005u_N#(/\u001b8h)\u0005!\bCA;z\u001d\t1x\u000f\u0005\u0002`\u0001&\u0011\u0001\u0010Q\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y\u0001\u00069a.^7fe&\u001cW#\u0001@\u0011\tu{\u00181A\u0005\u0004\u0003\u00031'a\u0002(v[\u0016\u0014\u0018n\u0019\t\u0004\u007f\u0005\u0015\u0011bAA\u0004\u0001\n\u0019\u0011I\\=\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0007\u00033\t\u0019\u0003\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019BI\u0001\bG>$WmZ3o\u0013\u0011\t9\"!\u0005\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0007\f\u0001\u0004\ti\"A\u0002dib\u0004B!a\u0004\u0002 %!\u0011\u0011EA\t\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\n\f\u0001\u0004\ti!\u0001\u0002fm\u0006aa.\u001e7m'\u00064W-\u0012<bYR!\u00111AA\u0016\u0011\u001d\ti\u0003\u0004a\u0001\u0003\u0007\tQ!\u001b8qkR,\u0012\u0001^\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007U\u000b)\u0004\u0003\u0004\u000289\u0001\r!S\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u0015)\u0016QHA \u0011\u001d9u\u0002%AA\u0002%Cq!T\b\u0011\u0002\u0003\u0007q*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015#fA%\u0002H-\u0012\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003%)hn\u00195fG.,GMC\u0002\u0002T\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9&!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u#fA(\u0002H\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005!A.\u00198h\u0015\t\ti'\u0001\u0003kCZ\f\u0017b\u0001>\u0002h\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000f\t\u0004\u007f\u0005]\u0014bAA=\u0001\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111AA@\u0011%\t\t\tFA\u0001\u0002\u0004\t)(A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0003b!!#\u0002\u0010\u0006\rQBAAF\u0015\r\ti\tQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAI\u0003\u0017\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q*a&\t\u0013\u0005\u0005e#!AA\u0002\u0005\r\u0011AB3rk\u0006d7\u000fF\u0002P\u0003;C\u0011\"!!\u0018\u0003\u0003\u0005\r!a\u0001)'\u0001\t\t+a*\u0002*\u00065\u0016qVAZ\u0003k\u000bI,a/\u0011\u0007E\n\u0019+C\u0002\u0002&\n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002,\u0006\u0019tLR+O\u0007~CS\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002rWmZ1uK\u0012\u0004c/\u00197vK\u0002zg\r\t1fqB\u0014\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011W\u00016\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011.c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00028\u0006)\u0011G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011QX\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\u0018AC+oCJLX*\u001b8vgB\u0011\u0011'G\n\u00053\u0005\u0015G\tE\u0004\u0002H\u00065\u0017jT+\u000e\u0005\u0005%'bAAf\u0001\u00069!/\u001e8uS6,\u0017\u0002BAh\u0003\u0013\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t\t\r\u0006\u0002\u0002d\u0005)\u0011\r\u001d9msR)Q+!7\u0002\\\")q\t\ba\u0001\u0013\"9Q\n\bI\u0001\u0002\u0004y\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111]Ax!\u0015y\u0014Q]Au\u0013\r\t9\u000f\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b}\nY/S(\n\u0007\u00055\bI\u0001\u0004UkBdWM\r\u0005\t\u0003ct\u0012\u0011!a\u0001+\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005e\b\u0003BA3\u0003wLA!!@\u0002h\t1qJ\u00196fGR\u0004")
public class UnaryMinus
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return UnaryMinus$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnaryMinus unaryMinus) {
        return UnaryMinus$.MODULE$.unapply(unaryMinus);
    }

    public static boolean apply$default$2() {
        return UnaryMinus$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, UnaryMinus> tupled() {
        return UnaryMinus$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, UnaryMinus>> curried() {
        return UnaryMinus$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.NumericAndInterval()}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public String toString() {
        return new StringBuilder(1).append("-").append(this.child()).toString();
    }

    private Numeric<Object> numeric$lzycompute() {
        UnaryMinus unaryMinus = this;
        synchronized (unaryMinus) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(15).append((String)c).append(".unary_$minus()").toString());
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
            if (bl && this.failOnError()) {
                exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> {
                    String javaBoxedType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                    String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
                    String originValue = ctx.freshName("origin");
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n           |").append(javaType).append(" ").append(originValue).append(" = (").append(javaType).append(")(").append((String)eval).append(");\n           |if (").append(originValue).append(" == ").append(javaBoxedType).append(".MIN_VALUE) {\n           |  throw QueryExecutionErrors.unaryMinusCauseOverflowError(").append(originValue).append(");\n           |}\n           |").append(ev.value()).append(" = (").append(javaType).append(")(-(").append(originValue).append("));\n           ").toString())).stripMargin();
                });
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                if (bl2 && this.failOnError()) {
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> {
                        String mathClass = Math.class.getName();
                        return new StringBuilder(18).append(ev.value()).append(" = ").append(mathClass).append(".negateExact(").append((String)eval).append(");").toString();
                    });
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> {
                        String originValue = ctx.freshName("origin");
                        return new StringBuilder(45).append("\n        ").append(CodeGenerator$.MODULE$.javaType(numericType)).append(" ").append(originValue).append(" = (").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(").append((String)eval).append(");\n        ").append(ev.value()).append(" = (").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(-(").append(originValue).append("));\n      ").toString();
                    });
                } else if (dataType instanceof CalendarIntervalType) {
                    String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
                    String method = this.failOnError() ? "negateExact" : "negate";
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(3).append(iu).append(".").append(method).append("(").append((String)c).append(")").toString());
                } else {
                    boolean bl3 = DayTimeIntervalType$.MODULE$.equals(dataType) ? true : YearMonthIntervalType$.MODULE$.equals(dataType);
                    if (bl3) {
                        exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> {
                            String mathClass = Math.class.getName();
                            return new StringBuilder(18).append(ev.value()).append(" = ").append(mathClass).append(".negateExact(").append((String)eval).append(");").toString();
                        });
                    } else {
                        throw new MatchError((Object)dataType);
                    }
                }
            }
        }
        return exprCode;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object nullSafeEval(Object input) {
        void var2_10;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                CalendarInterval calendarInterval = IntervalUtils$.MODULE$.negateExact((CalendarInterval)input);
                return var2_10;
            }
        }
        if (bl) {
            CalendarInterval calendarInterval = IntervalUtils$.MODULE$.negate((CalendarInterval)input);
            return var2_10;
        }
        if (DayTimeIntervalType$.MODULE$.equals(dataType2)) {
            Long l = BoxesRunTime.boxToLong((long)Math.negateExact(BoxesRunTime.unboxToLong((Object)input)));
            return var2_10;
        }
        if (YearMonthIntervalType$.MODULE$.equals(dataType2)) {
            Integer n = BoxesRunTime.boxToInteger((int)Math.negateExact(BoxesRunTime.unboxToInt((Object)input)));
            return var2_10;
        }
        Object object = this.numeric().negate(input);
        return var2_10;
    }

    @Override
    public String sql() {
        String string = (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
        String string2 = "-".equals(string) ? new StringBuilder(4).append("(- ").append(this.child().sql()).append(")").toString() : new StringBuilder(2).append(string).append("(").append(this.child().sql()).append(")").toString();
        return string2;
    }

    @Override
    public UnaryMinus withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public UnaryMinus copy(Expression child, boolean failOnError) {
        return new UnaryMinus(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnaryMinus";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnaryMinus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnaryMinus)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnaryMinus unaryMinus = (UnaryMinus)x$1;
        Expression expression = this.child();
        Expression expression2 = unaryMinus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.failOnError() != unaryMinus.failOnError()) return false;
        if (!unaryMinus.canEqual(this)) return false;
        return true;
    }

    public UnaryMinus(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnaryMinus(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

