/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.sql.catalyst.expressions.XxHash64$;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a 64-bit hash value of the arguments.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       5602566077635097486\n  ", since="3.0.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u000f\u001e\u0001*B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005{!AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005P\u0001\tE\t\u0015!\u00030\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0001\u0006\u0001\"\u0001V\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Q\u0007\u0001\"\u0015b\u0011\u0015Y\u0007\u0001\"\u0015m\u0011\u0015!\b\u0001\"\u0015v\u0011\u001dY\b!!A\u0005\u0002qD\u0001b \u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u00033A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0002\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0011%\t\t\u0005AA\u0001\n\u0003\n\u0019\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0013qL\u0004\n\u0003\u0007k\u0012\u0011!E\u0001\u0003\u000b3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u0011\u0005\u0007!Z!\t!!&\t\u0013\u0005]e#!A\u0005F\u0005e\u0005\"CAN-\u0005\u0005I\u0011QAO\u0011%\t\u0019KFA\u0001\n\u0003\u000b)\u000bC\u0005\u00028Z\t\t\u0011\"\u0003\u0002:\nA\u0001\f\u001f%bg\"4DG\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0011\u00011&\u000e\u001d\u0011\u00071js&D\u0001\u001e\u0013\tqSD\u0001\bICNDW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\t1{gn\u001a\t\u0003aYJ!aN\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001'O\u0005\u0003uE\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002{A\u0019aHR%\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"*\u0003\u0019a$o\\8u}%\t!'\u0003\u0002Fc\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005\r\u0019V-\u001d\u0006\u0003\u000bF\u0002\"\u0001\f&\n\u0005-k\"AC#yaJ,7o]5p]\u0006I1\r[5mIJ,g\u000eI\u0001\u0005g\u0016,G-F\u00010\u0003\u0015\u0019X-\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019!k\u0015+\u0011\u00051\u0002\u0001\"B\u001e\u0006\u0001\u0004i\u0004\"B'\u0006\u0001\u0004yCC\u0001*W\u0011\u00159f\u00011\u0001>\u0003%\t'oZ;nK:$8/\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0006CA._\u001b\u0005a&BA/\"\u0003\u0015!\u0018\u0010]3t\u0013\tyFL\u0001\u0005ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002EB\u00111m\u001a\b\u0003I\u0016\u0004\"\u0001Q\u0019\n\u0005\u0019\f\u0014A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ\u0019\u0002\u001f!\f7\u000f[3s\u00072\f7o\u001d(b[\u0016\f1bY8naV$X\rS1tQR!q&\u001c:t\u0011\u0015q'\u00021\u0001p\u0003\u00151\u0018\r\\;f!\t\u0001\u0004/\u0003\u0002rc\t\u0019\u0011I\\=\t\u000baS\u0001\u0019\u0001.\t\u000b5S\u0001\u0019A\u0018\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGC\u0001*w\u0011\u001598\u00021\u0001y\u0003-qWm^\"iS2$'/\u001a8\u0011\u0007yJ\u0018*\u0003\u0002{\u0011\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0004%vt\bbB\u001e\r!\u0003\u0005\r!\u0010\u0005\b\u001b2\u0001\n\u00111\u00010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0001+\u0007u\n)a\u000b\u0002\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011!C;oG\",7m[3e\u0015\r\t\t\"M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000b\u0003\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0007+\u0007=\n)!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0003mC:<'BAA\u0016\u0003\u0011Q\u0017M^1\n\u0007!\f)#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00024A\u0019\u0001'!\u000e\n\u0007\u0005]\u0012GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002p\u0003{A\u0011\"a\u0010\u0012\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0005E\u0003\u0002H\u00055s.\u0004\u0002\u0002J)\u0019\u00111J\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002P\u0005%#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0016\u0002\\A\u0019\u0001'a\u0016\n\u0007\u0005e\u0013GA\u0004C_>dW-\u00198\t\u0011\u0005}2#!AA\u0002=\fa!Z9vC2\u001cH\u0003BA+\u0003CB\u0001\"a\u0010\u0015\u0003\u0003\u0005\ra\u001c\u0015\u0014\u0001\u0005\u0015\u00141NA7\u0003c\n\u0019(a\u001e\u0002z\u0005u\u0014q\u0010\t\u0004Y\u0005\u001d\u0014bAA5;\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA8\u0003%{f)\u0016(D?\"*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3Y\u0001rcFL\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t\u001c5[\tLG\u000f\t5bg\"\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\n'oZ;nK:$8OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QO\u0001\\\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u001eb\u0003%\u0019:sCfD\u0013GM\u001a*Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116mA\u0012TG\u000e\u001c1o]24'\u000e\u0019:oQBdG\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY(A\u00034]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002\u0002\u0006Q\u0001.Y:i?\u001a,hnY:\u0002\u0011aC\b*Y:imQ\u0002\"\u0001\f\f\u0014\tY\tI\t\u000f\t\b\u0003\u0017\u000b\t*P\u0018S\u001b\t\tiIC\u0002\u0002\u0010F\nqA];oi&lW-\u0003\u0003\u0002\u0014\u00065%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011QQ\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011E\u0001\u0006CB\u0004H.\u001f\u000b\u0006%\u0006}\u0015\u0011\u0015\u0005\u0006we\u0001\r!\u0010\u0005\u0006\u001bf\u0001\raL\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9+a-\u0011\u000bA\nI+!,\n\u0007\u0005-\u0016G\u0001\u0004PaRLwN\u001c\t\u0006a\u0005=VhL\u0005\u0004\u0003c\u000b$A\u0002+va2,'\u0007\u0003\u0005\u00026j\t\t\u00111\u0001S\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002<B!\u00111EA_\u0013\u0011\ty,!\n\u0003\r=\u0013'.Z2u\u0001")
public class XxHash64
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final long seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(XxHash64 xxHash64) {
        return XxHash64$.MODULE$.unapply(xxHash64);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, XxHash64> tupled() {
        return XxHash64$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, XxHash64>> curried() {
        return XxHash64$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "xxhash64";
    }

    @Override
    public String hasherClassName() {
        return XXH64.class.getName();
    }

    @Override
    public long computeHash(Object value, DataType dataType, long seed) {
        return XxHash64Function$.MODULE$.hash(value, dataType, seed);
    }

    @Override
    public XxHash64 withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public XxHash64 copy(Seq<Expression> children2, long seed) {
        return new XxHash64(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public long copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "XxHash64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.seed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XxHash64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XxHash64)) return false;
        boolean bl = true;
        if (!bl) return false;
        XxHash64 xxHash64 = (XxHash64)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = xxHash64.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.seed() != xxHash64.seed()) return false;
        if (!xxHash64.canEqual(this)) return false;
        return true;
    }

    public XxHash64(Seq<Expression> children2, long seed) {
        this.children = children2;
        this.seed = seed;
    }

    public XxHash64(Seq<Expression> arguments) {
        this(arguments, 42L);
    }
}

