/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.ZipWith$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(left, right, func) - Merges the two given arrays, element-wise, into a single array using function. If one array is shorter, nulls are appended at the end to match the length of the longer array, before applying function.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array('a', 'b', 'c'), (x, y) -> (y, x));\n       [{\"y\":\"a\",\"x\":1},{\"y\":\"b\",\"x\":2},{\"y\":\"c\",\"x\":3}]\n      > SELECT _FUNC_(array(1, 2), array(3, 4), (x, y) -> x + y);\n       [4,6]\n      > SELECT _FUNC_(array('a', 'b', 'c'), array('d', 'e', 'f'), (x, y) -> concat(x, y));\n       [\"ad\",\"be\",\"cf\"]\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0015+\u0001^B\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t-\u0002\u0011\t\u0012)A\u0005q!Aq\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u00039\u0011!I\u0006A!f\u0001\n\u0003)\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011\u0002\u001d\t\u000bm\u0003A\u0011\u0001/\t\u000b\u0005\u0004A\u0011A+\t\u000b\t\u0004A\u0011I2\t\u000bA\u0004A\u0011I9\t\u000be\u0004A\u0011I2\t\u000bi\u0004A\u0011I9\t\u000bm\u0004A\u0011\t?\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!a\u0011\u0011\u0006\u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u0002,!Q\u0011Q\u0007\u0001\t\u0006\u0004%\t!a\u000e\t\u0015\u0005\u0005\u0003\u0001#b\u0001\n\u0003\t9\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!1\u0011q\u000e\u0001\u0005BUCa!!\u001d\u0001\t\u0003*\u0006BBA:\u0001\u0011\u0005S\u000bC\u0004\u0002v\u0001!\t&a\u001e\t\u0013\u0005\u0015\u0005!!A\u0005\u0002\u0005\u001d\u0005\"CAH\u0001E\u0005I\u0011AAI\u0011%\t9\u000bAI\u0001\n\u0003\t\t\nC\u0005\u0002*\u0002\t\n\u0011\"\u0001\u0002\u0012\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003{\u0003\u0011\u0011!C\u0001\u0003\u007fC\u0011\"a2\u0001\u0003\u0003%\t!!3\t\u0013\u0005=\u0007!!A\u0005B\u0005E\u0007\"CAp\u0001\u0005\u0005I\u0011AAq\u0011%\t)\u000fAA\u0001\n\u0003\n9oB\u0005\u0003\f)\n\t\u0011#\u0001\u0003\u000e\u0019A\u0011FKA\u0001\u0012\u0003\u0011y\u0001\u0003\u0004\\G\u0011\u0005!Q\u0004\u0005\n\u0005?\u0019\u0013\u0011!C#\u0005CA\u0011Ba\t$\u0003\u0003%\tI!\n\t\u0013\t52%!A\u0005\u0002\n=\u0002\"\u0003B!G\u0005\u0005I\u0011\u0002B\"\u0005\u001dQ\u0016\u000e],ji\"T!a\u000b\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003[9\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003_A\n1a]9m\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7\u0001A\n\b\u0001abt(R&R!\tI$(D\u0001+\u0013\tY$F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!O\u001f\n\u0005yR#a\u0005%jO\",'o\u0014:eKJ4UO\\2uS>t\u0007C\u0001!D\u001b\u0005\t%B\u0001\"+\u0003\u001d\u0019w\u000eZ3hK:L!\u0001R!\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u00042AR%9\u001b\u00059%B\u0001%-\u0003\u0015!(/Z3t\u0013\tQuIA\u0006UKJt\u0017M]=MS.,\u0007C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0019JK!aU'\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002q\u0005)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n\u0001BZ;oGRLwN\\\u0001\nMVt7\r^5p]\u0002\na\u0001P5oSRtD\u0003B/_?\u0002\u0004\"!\u000f\u0001\t\u000bQ;\u0001\u0019\u0001\u001d\t\u000b];\u0001\u0019\u0001\u001d\t\u000be;\u0001\u0019\u0001\u001d\u0002\u001f\u0019,hn\u0019;j_:4uN]#wC2\f\u0011\"\u0019:hk6,g\u000e^:\u0016\u0003\u0011\u00042!Z79\u001d\t17N\u0004\u0002hU6\t\u0001N\u0003\u0002jm\u00051AH]8pizJ\u0011AT\u0005\u0003Y6\u000bq\u0001]1dW\u0006<W-\u0003\u0002o_\n\u00191+Z9\u000b\u00051l\u0015!D1sOVlWM\u001c;UsB,7/F\u0001s!\r)Wn\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m:\nQ\u0001^=qKNL!\u0001_;\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017!\u00034v]\u000e$\u0018n\u001c8t\u000351WO\\2uS>tG+\u001f9fg\u0006AA-\u0019;b)f\u0004X-F\u0001~!\t!h0\u0003\u0002\u0000k\nI\u0011I\u001d:bsRK\b/Z\u0001\u0005E&tG\rF\u0002^\u0003\u000bAq!a\u0002\u000f\u0001\u0004\tI!A\u0001g!!a\u00151\u0002\u001d\u0002\u0010\u0005\r\u0012bAA\u0007\u001b\nIa)\u001e8di&|gN\r\t\u0005K6\f\t\u0002E\u0004M\u0003'\t9\"!\b\n\u0007\u0005UQJ\u0001\u0004UkBdWM\r\t\u0004i\u0006e\u0011bAA\u000ek\nAA)\u0019;b)f\u0004X\rE\u0002M\u0003?I1!!\tN\u0005\u001d\u0011un\u001c7fC:\u00042!OA\u0013\u0013\r\t9C\u000b\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0003\u0011AHeN\u001d\u0016\u0005\u00055\u0002c\u0002'\u0002\u0014\u0005=\u0012q\u0006\t\u0004s\u0005E\u0012bAA\u001aU\t\u0019b*Y7fI2\u000bWN\u00193b-\u0006\u0014\u0018.\u00192mK\u0006YA.\u001a4u\u000b2,WNV1s+\t\ty\u0003K\u0002\u0011\u0003w\u00012\u0001TA\u001f\u0013\r\ty$\u0014\u0002\niJ\fgn]5f]R\fAB]5hQR,E.Z7WCJD3!EA\u001e\u0003\u0011)g/\u00197\u0015\t\u0005%\u0013q\n\t\u0004\u0019\u0006-\u0013bAA'\u001b\n\u0019\u0011I\\=\t\u0013\u0005E#\u0003%AA\u0002\u0005M\u0013!B5oaV$\b\u0003BA+\u0003/j\u0011\u0001L\u0005\u0004\u00033b#aC%oi\u0016\u0014h.\u00197S_^\f!\u0002\u001d:fiRLh*Y7f+\t\ty\u0006\u0005\u0003\u0002b\u0005%d\u0002BA2\u0003K\u0002\"aZ'\n\u0007\u0005\u001dT*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\niG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Oj\u0015!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9Q,!\u001f\u0002~\u0005\u0005\u0005BBA>/\u0001\u0007\u0001(\u0001\u0005oK^4\u0015N]:u\u0011\u0019\tyh\u0006a\u0001q\u0005Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003\u0007;\u0002\u0019\u0001\u001d\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9Q,!#\u0002\f\u00065\u0005b\u0002+\u0019!\u0003\u0005\r\u0001\u000f\u0005\b/b\u0001\n\u00111\u00019\u0011\u001dI\u0006\u0004%AA\u0002a\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0014*\u001a\u0001(!&,\u0005\u0005]\u0005\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!)N\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\u000bYJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u000b\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\t1\fgn\u001a\u0006\u0003\u0003s\u000bAA[1wC&!\u00111NAZ\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\rE\u0002M\u0003\u0007L1!!2N\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI%a3\t\u0013\u00055g$!AA\u0002\u0005\u0005\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002TB1\u0011Q[An\u0003\u0013j!!a6\u000b\u0007\u0005eW*\u0001\u0006d_2dWm\u0019;j_:LA!!8\u0002X\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti\"a9\t\u0013\u00055\u0007%!AA\u0002\u0005%\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001e\u0005%\b\"CAgC\u0005\u0005\t\u0019AA%QM\u0001\u0011Q^Az\u0003k\fI0a?\u0002\u0000\n\u0005!Q\u0001B\u0004!\rI\u0014q^\u0005\u0004\u0003cT#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003o\f\u0011\u0011Z0G+:\u001bu\f\u000b7fMRd\u0003E]5hQRd\u0003EZ;oG&\u0002S\u0006I'fe\u001e,7\u000f\t;iK\u0002\"xo\u001c\u0011hSZ,g\u000eI1se\u0006L8\u000f\f\u0011fY\u0016lWM\u001c;.o&\u001cX\r\f\u0011j]R|\u0007%\u0019\u0011tS:<G.\u001a\u0011beJ\f\u0017\u0010I;tS:<\u0007EZ;oGRLwN\u001c\u0018!\u0013\u001a\u0004sN\\3!CJ\u0014\u0018-\u001f\u0011jg\u0002\u001a\bn\u001c:uKJd\u0003E\\;mYN\u0004\u0013M]3!CB\u0004XM\u001c3fI\u0002\nG\u000f\t;iK\u0002*g\u000e\u001a\u0011u_\u0002j\u0017\r^2iAQDW\r\t7f]\u001e$\b\u000eI8gAQDW\r\t7p]\u001e,'\u000fI1se\u0006LH\u0006\t2fM>\u0014X\rI1qa2L\u0018N\\4!MVt7\r^5p]:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003{\f!q\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\n'O]1zQ\u001d\nw\u0005\f\u0011(E\u001eb\u0003eJ2(S1\u0002\u0003\u0006\u001f\u0017!s&\u0002SF\u0010\u0011)s2\u0002\u00030K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u001f\u0012;E\u0005\u0014CF\t=#uEjHf\u001f\u0012zEi\u0012#M\t\u0017#q\nR$' \u0017|Ee\u0014#HI2#Y\tB(EO\u001a~;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a*Y\u0001\n'O]1zQMb\u0003\u0005N\u0015-A!BH\u0006I=*A5r\u0004\u0005\u001f\u0011,AeL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.5YYj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bfJ1(Y\u0001:#m\n\u0017!O\r<\u0013\u0006\f\u0011beJ\f\u0017\u0010K\u0014eO1\u0002s%Z\u0014-A\u001d2w%\u000b\u0017!Qad\u0003%_\u0015![y\u00023m\u001c8dCRD\u0003\u0010\f\u0011zS%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012bI\nb#EY3#Y\t\u001agMI/\u000bA\u0001\nQa]5oG\u0016\f#Aa\u0001\u0002\u000bIrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t%\u0011\u0001\u00047b[\n$\u0017m\u00184v]\u000e\u001c\u0018a\u0002.ja^KG\u000f\u001b\t\u0003s\r\u001aBa\tB\t#BA!1\u0003B\rqaBT,\u0004\u0002\u0003\u0016)\u0019!qC'\u0002\u000fI,h\u000e^5nK&!!1\u0004B\u000b\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005\u001b\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003_\u000bQ!\u00199qYf$r!\u0018B\u0014\u0005S\u0011Y\u0003C\u0003UM\u0001\u0007\u0001\bC\u0003XM\u0001\u0007\u0001\bC\u0003ZM\u0001\u0007\u0001(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE\"Q\b\t\u0006\u0019\nM\"qG\u0005\u0004\u0005ki%AB(qi&|g\u000e\u0005\u0004M\u0005sA\u0004\bO\u0005\u0004\u0005wi%A\u0002+va2,7\u0007\u0003\u0005\u0003@\u001d\n\t\u00111\u0001^\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003FA!\u0011\u0011\u0017B$\u0013\u0011\u0011I%a-\u0003\r=\u0013'.Z2u\u0001")
public class ZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
TernaryLike<Expression>,
Serializable {
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$79;
    private transient NamedLambdaVariable leftElemVar;
    private transient NamedLambdaVariable rightElemVar;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private transient Seq<Expression> children;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ZipWith zipWith) {
        return ZipWith$.MODULE$.unapply(zipWith);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ZipWith> tupled() {
        return ZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ZipWith>>> curried() {
        return ZipWith$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.children$lzycompute() : this.children;
    }

    private boolean argumentsResolved$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        ArrayType$ arrayType$ = ArrayType$.MODULE$;
        ArrayType$ arrayType$2 = ArrayType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)arrayType$2).$colon$colon((Object)arrayType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.function();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.function().dataType(), this.function().nullable());
    }

    @Override
    public ZipWith bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType rightElementType;
        DataType leftElementType;
        DataType dataType = this.left().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType dataType2 = leftElementType = arrayType.elementType();
        DataType leftElementType2 = dataType2;
        DataType dataType3 = this.right().dataType();
        if (!(dataType3 instanceof ArrayType)) {
            throw new MatchError((Object)dataType3);
        }
        ArrayType arrayType2 = (ArrayType)dataType3;
        DataType dataType4 = rightElementType = arrayType2.elementType();
        DataType rightElementType2 = dataType4;
        Tuple2 tuple2 = new Tuple2((Object)leftElementType2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Tuple2 tuple22 = new Tuple2((Object)rightElementType2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2));
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$79$lzycompute() {
        block5: {
            ZipWith zipWith = this;
            synchronized (zipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression rightElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block6;
                        NamedExpression leftElemVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        rightElemVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                        if (!(leftElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)leftElemVar;
                        if (rightElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)rightElemVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$79 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$79;
    }

    private /* synthetic */ Tuple2 x$79() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$79$lzycompute() : this.x$79;
    }

    private NamedLambdaVariable leftElemVar$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.leftElemVar = (NamedLambdaVariable)this.x$79()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.leftElemVar;
    }

    public NamedLambdaVariable leftElemVar() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.leftElemVar$lzycompute() : this.leftElemVar;
    }

    private NamedLambdaVariable rightElemVar$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rightElemVar = (NamedLambdaVariable)this.x$79()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.rightElemVar;
    }

    public NamedLambdaVariable rightElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rightElemVar$lzycompute() : this.rightElemVar;
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        ArrayData leftArr = (ArrayData)this.left().eval(input);
        if (leftArr == null) {
            genericArrayData = null;
        } else {
            ArrayData rightArr = (ArrayData)this.right().eval(input);
            if (rightArr == null) {
                genericArrayData = null;
            } else {
                int resultLength = package$.MODULE$.max(leftArr.numElements(), rightArr.numElements());
                Expression f = this.functionForEval();
                GenericArrayData result = new GenericArrayData(new Object[resultLength]);
                for (int i = 0; i < resultLength; ++i) {
                    if (i < leftArr.numElements()) {
                        this.leftElemVar().value().set(leftArr.get(i, this.leftElemVar().dataType()));
                    } else {
                        this.leftElemVar().value().set(null);
                    }
                    if (i < rightArr.numElements()) {
                        this.rightElemVar().value().set(rightArr.get(i, this.rightElemVar().dataType()));
                    } else {
                        this.rightElemVar().value().set(null);
                    }
                    Object v = InternalRow$.MODULE$.copyValue(f.eval(input));
                    result.update(i, v);
                }
                genericArrayData = result;
            }
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "zip_with";
    }

    @Override
    public Expression first() {
        return this.left();
    }

    @Override
    public Expression second() {
        return this.right();
    }

    @Override
    public Expression third() {
        return this.function();
    }

    @Override
    public ZipWith withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public ZipWith copy(Expression left, Expression right, Expression function) {
        return new ZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "ZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 2: {
                expression = this.function();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ZipWith;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        ZipWith zipWith = (ZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = zipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = zipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = zipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!zipWith.canEqual(this)) return false;
        return true;
    }

    public ZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        TernaryLike.$init$(this);
    }
}

