/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate `percentile` of the numeric\n      column `col` which is the smallest value in the ordered `col` values (sorted from least to\n      greatest) such that no more than `percentage` of `col` values is less than the value\n      or equal to that value. The value of percentage must be between 0.0 and 1.0. The `accuracy`\n      parameter (default: 10000) is a positive numeric literal which controls approximation accuracy\n      at the cost of memory. Higher value of `accuracy` yields better accuracy, `1.0/accuracy` is\n      the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col, array(0.5, 0.4, 0.1), 100) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [1,1,0]\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (0), (6), (7), (9), (10) AS tab(col);\n       7\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\r\u001dd\u0001B&M\u0001nC!\"!+\u0001\u0005+\u0007I\u0011\u0001B\u0002\u0011)\u0011)\u0001\u0001B\tB\u0003%\u00111\u0016\u0005\u000b\u0003k\u0003!Q3A\u0005\u0002\t\r\u0001B\u0003B\u0004\u0001\tE\t\u0015!\u0003\u0002,\"Q\u0011\u0011\u0018\u0001\u0003\u0016\u0004%\tAa\u0001\t\u0015\t%\u0001A!E!\u0002\u0013\tY\u000b\u0003\u0006\u0002>\u0002\u0011)\u001a!C!\u0003\u000bA!Ba\u0003\u0001\u0005#\u0005\u000b\u0011BA\u0004\u0011)\t\t\r\u0001BK\u0002\u0013\u0005\u0013Q\u0001\u0005\u000b\u0005\u001b\u0001!\u0011#Q\u0001\n\u0005\u001d\u0001BB@\u0001\t\u0003\u0011y\u0001\u0003\u0004\u0000\u0001\u0011\u0005!1\u0004\u0005\u0007\u007f\u0002!\tAa\t\t\u0015\t%\u0002\u0001#b\u0001\n\u0013\u0011Y\u0003C\u0004\u00034\u0001!\tE!\u000e\t\u0019\u0005=\u0002\u0001%A\t\b\u0004&IA!\u0016\t\u0015\tu\u0003\u0001#b\u0001\n\u0013\tI\u0005\u0003\u0006\u0002p\u0001A)\u0019!C\u0005\u0005?BqA!\u0019\u0001\t\u0003\u0012\u0019\u0007C\u0004\u0003r\u0001!\tEa\u001d\t\u000f\tU\u0004\u0001\"\u0011\u0003x!9\u00111\f\u0001\u0005B\t%\u0005b\u0002BH\u0001\u0011\u0005#\u0011\u0013\u0005\b\u00057\u0003A\u0011\tBO\u0011\u001d\u0011\u0019\u000b\u0001C!\u0005KCqA!+\u0001\t\u0003\u0012\u0019\u0001C\u0004\u0003,\u0002!\tEa\u0001\t\u000f\t5\u0006\u0001\"\u0011\u0003\u0004!9!q\u0016\u0001\u0005B\u0005%\u0003B\u0003BY\u0001!\u0015\r\u0011\"\u0003\u00034\"9!1\u0018\u0001\u0005B\tM\u0006b\u0002B_\u0001\u0011\u0005#q\u0018\u0005\b\u0003\u0007\u0003A\u0011\tBi\u0011\u001d\t\u0019\n\u0001C!\u0005+DqA!7\u0001\t#\u0012Y\u000eC\u0005\u0003j\u0002\t\t\u0011\"\u0001\u0003l\"I!q\u001f\u0001\u0012\u0002\u0013\u0005!\u0011 \u0005\n\u0007\u001f\u0001\u0011\u0013!C\u0001\u0005sD\u0011b!\u0005\u0001#\u0003%\tA!?\t\u0013\rM\u0001!%A\u0005\u0002\rU\u0001\"CB\r\u0001E\u0005I\u0011AB\u000b\u0011%\u0019Y\u0002AA\u0001\n\u0003\u001ai\u0002C\u0005\u0004$\u0001\t\t\u0011\"\u0001\u0002\u0006!I1Q\u0005\u0001\u0002\u0002\u0013\u00051q\u0005\u0005\n\u0007W\u0001\u0011\u0011!C!\u0007[A\u0011ba\u000f\u0001\u0003\u0003%\ta!\u0010\t\u0013\r\u0005\u0003!!A\u0005B\r\rs!B:M\u0011\u0003!h!B&M\u0011\u0003)\bBB@2\t\u0003\t\t\u0001C\u0005\u0002\u0004E\u0012\r\u0011\"\u0001\u0002\u0006!A\u0011QB\u0019!\u0002\u0013\t9A\u0002\u0004\u0002\u0010E\u0002\u0011\u0011\u0003\u0005\u000b\u0003')$\u00111A\u0005\n\u0005U\u0001BCA\u0012k\t\u0005\r\u0011\"\u0003\u0002&!Q\u0011\u0011G\u001b\u0003\u0002\u0003\u0006K!a\u0006\t\r},D\u0011AA\u001a\u0011\u0019yX\u0007\"\u0001\u0002<!A\u0011qI\u001b\u0005\u0002I\u000bI\u0005C\u0004\u0002RU\"\t!!\u0006\t\u000f\u0005MS\u0007\"\u0001\u0002V!9\u00111L\u001b\u0005\u0002\u0005u\u0003bBA2k\u0011\u0005\u0011Q\r\u0005\b\u0003c*DQBA:\r\u0019\t)(\r\u0001\u0002x!1q0\u0011C\u0001\u0003sBq!! B\t\u001b\ty\bC\u0004\u0002\u0004\u0006#)!!\"\t\u000f\u0005M\u0015\t\"\u0002\u0002\u0016\"I\u00111T\u0019C\u0002\u0013\u0005\u0011Q\u0014\u0005\t\u0003?\u000b\u0004\u0015!\u0003\u0002|!I\u0011\u0011U\u0019\u0002\u0002\u0013\u0005\u00151\u0015\u0005\n\u0003\u0007\f\u0014\u0011!CA\u0003\u000bD\u0011\"a62\u0003\u0003%I!!7\u0003+\u0005\u0003\bO]8yS6\fG/\u001a)fe\u000e,g\u000e^5mK*\u0011QJT\u0001\nC\u001e<'/Z4bi\u0016T!a\u0014)\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003#J\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u0003'R\u000b1a]9m\u0015\t)f+A\u0003ta\u0006\u00148N\u0003\u0002X1\u00061\u0011\r]1dQ\u0016T\u0011!W\u0001\u0004_J<7\u0001A\n\n\u0001q\u000bY/!=\u0002~r\u00042!\u00180a\u001b\u0005a\u0015BA0M\u0005a!\u0016\u0010]3e\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003CVr!A\u0019\u0019\u000f\u0005\r\u0014hB\u00013r\u001d\t)\u0007O\u0004\u0002g_:\u0011qM\u001c\b\u0003Q6t!!\u001b7\u000e\u0003)T!a\u001b.\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0016BA,Y\u0013\t)f+\u0003\u0002T)&\u0011\u0011KU\u0005\u0003\u001fBK!!\u0014(\u0002+\u0005\u0003\bO]8yS6\fG/\u001a)fe\u000e,g\u000e^5mKB\u0011Q,M\n\u0004cYd\bCA<{\u001b\u0005A(\"A=\u0002\u000bM\u001c\u0017\r\\1\n\u0005mD(AB!osJ+g\r\u0005\u0002x{&\u0011a\u0010\u001f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\f1\u0004R#G\u0003VcEk\u0018)F%\u000e+e\nV%M\u000b~\u000b5iQ+S\u0003\u000eKVCAA\u0004!\r9\u0018\u0011B\u0005\u0004\u0003\u0017A(aA%oi\u0006aB)\u0012$B+2#v\fU#S\u0007\u0016sE+\u0013'F?\u0006\u001b5)\u0016*B\u0007f\u0003#\u0001\u0005)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\t)d/A\u0005tk6l\u0017M]5fgV\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004)\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\tYBA\tRk\u0006tG/\u001b7f'VlW.\u0019:jKN\fQb];n[\u0006\u0014\u0018.Z:`I\u0015\fH\u0003BA\u0014\u0003[\u00012a^A\u0015\u0013\r\tY\u0003\u001f\u0002\u0005+:LG\u000fC\u0005\u00020]\n\t\u00111\u0001\u0002\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u0015M,X.\\1sS\u0016\u001c\b\u0005\u0006\u0003\u00026\u0005e\u0002cAA\u001ck5\t\u0011\u0007C\u0004\u0002\u0014e\u0002\r!a\u0006\u0015\t\u0005U\u0012Q\b\u0005\b\u0003\u007fQ\u0004\u0019AA!\u00035\u0011X\r\\1uSZ,WI\u001d:peB\u0019q/a\u0011\n\u0007\u0005\u0015\u0003P\u0001\u0004E_V\u0014G.Z\u0001\rSN\u001cu.\u001c9sKN\u001cX\rZ\u000b\u0003\u0003\u0017\u00022a^A'\u0013\r\ty\u0005\u001f\u0002\b\u0005>|G.Z1o\u0003E\tX/\u00198uS2,7+^7nCJLWm]\u0001\u0004C\u0012$G\u0003BA\u0014\u0003/Bq!!\u0017>\u0001\u0004\t\t%A\u0003wC2,X-A\u0003nKJ<W\r\u0006\u0003\u0002(\u0005}\u0003bBA1}\u0001\u0007\u0011QG\u0001\u0006_RDWM]\u0001\u000fO\u0016$\b+\u001a:dK:$\u0018\u000e\\3t)\u0011\t9'!\u001c\u0011\u000b]\fI'!\u0011\n\u0007\u0005-\u0004PA\u0003BeJ\f\u0017\u0010C\u0004\u0002p}\u0002\r!a\u001a\u0002\u0017A,'oY3oi\u0006<Wm]\u0001\tG>l\u0007O]3tgR\u0011\u0011q\u0005\u0002\u001b!\u0016\u00148-\u001a8uS2,G)[4fgR\u001cVM]5bY&TXM]\n\u0003\u0003Z$\"!a\u001f\u0011\u0007\u0005]\u0012)\u0001\u0004mK:<G\u000f\u001b\u000b\u0005\u0003\u000f\t\t\tC\u0004\u0002\u0014\r\u0003\r!a\u0006\u0002\u0013M,'/[1mSj,G\u0003BAD\u0003\u001f\u0003Ra^A5\u0003\u0013\u00032a^AF\u0013\r\ti\t\u001f\u0002\u0005\u0005f$X\rC\u0004\u0002\u0012\u0012\u0003\r!!\u000e\u0002\u0007=\u0014'.A\u0006eKN,'/[1mSj,G\u0003BA\u001b\u0003/Cq!!'F\u0001\u0004\t9)A\u0003csR,7/\u0001\u0006tKJL\u0017\r\\5{KJ,\"!a\u001f\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\r\u0003K\u000b9+a-\u00028\u0006m\u0016q\u0018\t\u0003;\u0002Aq!!+I\u0001\u0004\tY+A\u0003dQ&dG\r\u0005\u0003\u0002.\u0006=V\"\u0001(\n\u0007\u0005EfJ\u0001\u0006FqB\u0014Xm]:j_:Dq!!.I\u0001\u0004\tY+\u0001\u000bqKJ\u001cWM\u001c;bO\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003sC\u0005\u0019AAV\u0003I\t7mY;sC\u000eLX\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005u\u0006\n1\u0001\u0002\b\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fC\u0004\u0002B\"\u0003\r!a\u0002\u0002)%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003\u001d)h.\u00199qYf$B!a2\u0002TB)q/!3\u0002N&\u0019\u00111\u001a=\u0003\r=\u0003H/[8o!59\u0018qZAV\u0003W\u000bY+a\u0002\u0002\b%\u0019\u0011\u0011\u001b=\u0003\rQ+\b\u000f\\36\u0011%\t).SA\u0001\u0002\u0004\t)+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0018\u0001\u00026bm\u0006LA!!;\u0002`\n1qJ\u00196fGR\u0004B!!,\u0002n&\u0019\u0011q\u001e(\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004b!a=\u0002z\u0006-VBAA{\u0015\r\t9\u0010U\u0001\u0006iJ,Wm]\u0005\u0005\u0003w\f)PA\u0006UKJt\u0017M]=MS.,\u0007cA<\u0002\u0000&\u0019!\u0011\u0001=\u0003\u000fA\u0013x\u000eZ;diV\u0011\u00111V\u0001\u0007G\"LG\u000e\u001a\u0011\u0002+A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8oA\u0005\u0019\u0012mY2ve\u0006\u001c\u00170\u0012=qe\u0016\u001c8/[8oA\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!)1\t)K!\u0005\u0003\u0014\tU!q\u0003B\r\u0011\u001d\tIk\u0003a\u0001\u0003WCq!!.\f\u0001\u0004\tY\u000bC\u0004\u0002:.\u0001\r!a+\t\u000f\u0005u6\u00021\u0001\u0002\b!9\u0011\u0011Y\u0006A\u0002\u0005\u001dA\u0003CAS\u0005;\u0011yB!\t\t\u000f\u0005%F\u00021\u0001\u0002,\"9\u0011Q\u0017\u0007A\u0002\u0005-\u0006bBA]\u0019\u0001\u0007\u00111\u0016\u000b\u0007\u0003K\u0013)Ca\n\t\u000f\u0005%V\u00021\u0001\u0002,\"9\u0011QW\u0007A\u0002\u0005-\u0016\u0001C1dGV\u0014\u0018mY=\u0016\u0005\t5\u0002cA<\u00030%\u0019!\u0011\u0007=\u0003\t1{gnZ\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXC\u0001B\u001c!\u0019\u0011IDa\u0011\u0003J9!!1\bB \u001d\rI'QH\u0005\u0002s&\u0019!\u0011\t=\u0002\u000fA\f7m[1hK&!!Q\tB$\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u0003B\b\u0003\u0002B&\u0005#j!A!\u0014\u000b\u0007\t=#+A\u0003usB,7/\u0003\u0003\u0003T\t5#\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f+\t\u00119\u0006E\u0004x\u00053\nY%a\u001a\n\u0007\tm\u0003P\u0001\u0004UkBdWMM\u0001\u0016e\u0016$XO\u001d8QKJ\u001cWM\u001c;jY\u0016\f%O]1z+\t\t9'A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0003fA!!q\rB7\u001b\t\u0011IGC\u0002\u0003lA\u000b\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0005_\u0012IGA\bUsB,7\t[3dWJ+7/\u001e7u\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001a\u0003\u0019)\b\u000fZ1uKR)\u0001M!\u001f\u0003~!1!1P\u000bA\u0002\u0001\faAY;gM\u0016\u0014\bb\u0002B@+\u0001\u0007!\u0011Q\u0001\tS:\u0004X\u000f\u001e*poB!!1\u0011BC\u001b\u0005\u0001\u0016b\u0001BD!\nY\u0011J\u001c;fe:\fGNU8x)\u0015\u0001'1\u0012BG\u0011\u0019\u0011YH\u0006a\u0001A\"1\u0011\u0011\r\fA\u0002\u0001\fA!\u001a<bYR!!1\u0013BM!\r9(QS\u0005\u0004\u0005/C(aA!os\"1!1P\fA\u0002\u0001\fQd^5uQ:+w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003K\u0013y\nC\u0004\u0003\"b\u0001\r!a\u0002\u0002\u00139,wo\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002&\n\u001d\u0006b\u0002BQ3\u0001\u0007\u0011qA\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u00119,H\u000e\\1cY\u0016\f\u0001#\u001b8uKJt\u0017\r\u001c#bi\u0006$\u0016\u0010]3\u0016\u0005\tU\u0006\u0003\u0002B&\u0005oKAA!/\u0003N\tAA)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0005\u0003\u0004BAa1\u0003L:!!Q\u0019Bd!\tI\u00070C\u0002\u0003Jb\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002Bg\u0005\u001f\u0014aa\u0015;sS:<'b\u0001BeqR!\u0011q\u0011Bj\u0011\u0019\t\t*\ta\u0001AR\u0019\u0001Ma6\t\u000f\u0005e%\u00051\u0001\u0002\b\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\t\u0003K\u0013iN!9\u0003f\"9!q\\\u0012A\u0002\u0005-\u0016\u0001\u00038fo\u001aK'o\u001d;\t\u000f\t\r8\u00051\u0001\u0002,\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\b\u0005O\u001c\u0003\u0019AAV\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$B\"!*\u0003n\n=(\u0011\u001fBz\u0005kD\u0011\"!+%!\u0003\u0005\r!a+\t\u0013\u0005UF\u0005%AA\u0002\u0005-\u0006\"CA]IA\u0005\t\u0019AAV\u0011%\ti\f\nI\u0001\u0002\u0004\t9\u0001C\u0005\u0002B\u0012\u0002\n\u00111\u0001\u0002\b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B~U\u0011\tYK!@,\u0005\t}\b\u0003BB\u0001\u0007\u0017i!aa\u0001\u000b\t\r\u00151qA\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0003y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u001b\u0019\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0003\u0016\u0005\u0003\u000f\u0011i0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019y\u0002\u0005\u0003\u0002^\u000e\u0005\u0012\u0002\u0002Bg\u0003?\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0014\u000e%\u0002\"CA\u0018Y\u0005\u0005\t\u0019AA\u0004\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u0018!\u0019\u0019\tda\u000e\u0003\u00146\u001111\u0007\u0006\u0004\u0007kA\u0018AC2pY2,7\r^5p]&!1\u0011HB\u001a\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-3q\b\u0005\n\u0003_q\u0013\u0011!a\u0001\u0005'\u000ba!Z9vC2\u001cH\u0003BA&\u0007\u000bB\u0011\"a\f0\u0003\u0003\u0005\rAa%)'\u0001\u0019Iea\u0014\u0004R\rU3qKB.\u0007;\u001a\tga\u0019\u0011\t\u0005561J\u0005\u0004\u0007\u001br%!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0007'\na1\u0014\u0006!A\u0001\u0002sLR+O\u0007~C3m\u001c7-AA,'oY3oi\u0006<W\rI.-A\u0005\u001c7-\u001e:bGfl\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI1qaJ|\u00070[7bi\u0016\u0004\u0003\r]3sG\u0016tG/\u001b7fA\u0002zg\r\t;iK\u0002rW/\\3sS\u000eT\u0001\u0005\t\u0011!A\u0001\u001aw\u000e\\;n]\u0002\u00027m\u001c7aA]D\u0017n\u00195!SN\u0004C\u000f[3!g6\fG\u000e\\3ti\u00022\u0018\r\\;fA%t\u0007\u0005\u001e5fA=\u0014H-\u001a:fI\u0002\u00027m\u001c7aAY\fG.^3tA!\u001axN\u001d;fI\u00022'o\\7!Y\u0016\f7\u000f\u001e\u0011u_*\u0001\u0003\u0005\t\u0011!A\u001d\u0014X-\u0019;fgRL\u0003e];dQ\u0002\"\b.\u0019;!]>\u0004Sn\u001c:fAQD\u0017M\u001c\u0011aa\u0016\u00148-\u001a8uC\u001e,\u0007\rI8gA\u0001\u001cw\u000e\u001c1!m\u0006dW/Z:!SN\u0004C.Z:tAQD\u0017M\u001c\u0011uQ\u0016\u0004c/\u00197vK*\u0001\u0003\u0005\t\u0011!A=\u0014\b%Z9vC2\u0004Co\u001c\u0011uQ\u0006$\bE^1mk\u0016t\u0003\u0005\u00165fAY\fG.^3!_\u001a\u0004\u0003/\u001a:dK:$\u0018mZ3![V\u001cH\u000f\t2fA\t,Go^3f]\u0002\u0002d\u0006\r\u0011b]\u0012\u0004\u0013G\f\u0019/AQCW\r\t1bG\u000e,(/Y2zA*\u0001\u0003\u0005\t\u0011!AA\f'/Y7fi\u0016\u0014\b\u0005\u000b3fM\u0006,H\u000e\u001e\u001e!cA\u0002\u0004\u0007M\u0015!SN\u0004\u0013\r\t9pg&$\u0018N^3!]VlWM]5dA1LG/\u001a:bY\u0002:\b.[2iA\r|g\u000e\u001e:pYN\u0004\u0013\r\u001d9s_bLW.\u0019;j_:\u0004\u0013mY2ve\u0006\u001c\u0017P\u0003\u0011!A\u0001\u0002\u0003%\u0019;!i\",\u0007eY8ti\u0002zg\rI7f[>\u0014\u0018P\f\u0011IS\u001eDWM\u001d\u0011wC2,X\rI8gA\u0001\f7mY;sC\u000eL\b\rI=jK2$7\u000f\t2fiR,'\u000fI1dGV\u0014\u0018mY=-A\u0001\fd\u0006M\u0018bG\u000e,(/Y2zA\u0002J7O\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e5fAI,G.\u0019;jm\u0016\u0004SM\u001d:pe\u0002zg\r\t;iK\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^5p]:R\u0001\u0005\t\u0011!A\u0001:\u0006.\u001a8!AB,'oY3oi\u0006<W\r\u0019\u0011jg\u0002\ng\u000eI1se\u0006LH\u0006I3bG\"\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\u0002XM]2f]R\fw-\u001a\u0011beJ\f\u0017\u0010I7vgR\u0004#-\u001a\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0006!A\u0001\u0002\u0003\u0005I%oAQD\u0017n\u001d\u0011dCN,G\u0006\t:fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013\r\u001d9s_bLW.\u0019;fAA,'oY3oi&dW\rI1se\u0006L\be\u001c4!G>dW/\u001c8!A\u000e|G\u000e\u0019\u0011bi\u0002\"\b.\u001a\u0011hSZ,gN\u0003\u0011!A\u0001\u0002\u0003\u0005]3sG\u0016tG/Y4fA\u0005\u0014(/Y=/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\re\u0013!a2\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G\u000e\f\u0011beJ\f\u0017\u0010\u000b\u0019/k1\u0002\u0003G\f\u001b-AAr\u0013'\u000b\u0017!cA\u0002\u0014\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003\u0006M\u0015-A!\n\u0014\u0006\f\u0011)e%b\u0003\u0005K\u00191S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u000bD&\r\u00171;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7-AArS\u0007\f\u00112aAJ\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0003'\u000b\u0017!QYJC\u0006\t\u00158S1\u0002\u0003&O\u0015-A!\n\u0004'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001c\u000bA\u0001\nQa\u001a:pkB\f#aa\u0018\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAB3\u0003\u0015\u0011d&\r\u00181\u0001")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
scala.Serializable {
    private long accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private DataType internalDataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private long accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = ((Number)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1())).longValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracy;
    }

    private long accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, new ArrayType(DoubleType$.MODULE$, false)})), IntegralType$.MODULE$}));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), null);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                } else {
                    throw new MatchError(object);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                boolean returnPercentileArray = tuple22._1$mcZ$sp();
                double[] percentages = (double[])tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)returnPercentileArray), (Object)percentages);
                this.x$1 = tuple23;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() || !this.accuracyExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal") : (this.accuracy() <= 0L || this.accuracy() > Integer.MAX_VALUE ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("The accuracy provided must be a literal between (0, ").append(Integer.MAX_VALUE).append("]").append(" (current value = ").append(this.accuracy()).append(")").toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(62).append("All percentage values must be between 0.0 and 1.0 ").append("(current = ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).mkString(", ")).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToLong((Object)value);
            } else if (dataType instanceof NumericType) {
                NumericType numericType = (NumericType)dataType;
                d = numericType.numeric().toDouble(value);
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
                }
                throw new MatchError((Object)dataType);
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        Object object;
        double[] doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        if (DateType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$2 -> (int)x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$3 -> (long)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$4))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$5))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$6 -> (int)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$7 -> (long)x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$8 -> (float)x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = doubleResult;
        } else if (dataType instanceof DecimalType) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$9 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Decimal.class)));
        } else {
            if (dataType != null) {
                DataType dataType2 = dataType;
                throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
            }
            throw new MatchError((Object)dataType);
        }
        Object result = object;
        return ScalaRunTime$.MODULE$.array_length(result) == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : ScalaRunTime$.MODULE$.array_apply(result, 0));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.accuracyExpression();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType internalDataType$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.internalDataType = this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.internalDataType$lzycompute() : this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "percentile_approx");
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    @Override
    public ApproximatePercentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5());
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$5) {
        return (short)x$5;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                dArray = Array$.MODULE$.emptyDoubleArray();
            } else {
                void var2_2;
                double[] result = new double[percentages.length];
                for (int i = 0; i < percentages.length; ++i) {
                    result[i] = BoxesRunTime.unboxToDouble((Object)this.summaries().query(percentages[i]).get());
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, x$3));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

