/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0011#\u0001FB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0001\")q\n\u0001C\u0001!\")1\u000b\u0001C!)\")\u0001\f\u0001C!3\")\u0001\r\u0001C!C\")\u0011\u000f\u0001C!e\"A\u0011\u0010\u0001EC\u0002\u0013%!\u0010\u0003\u0006\u0002\u0004\u0001A)\u0019!C\u0005\u0003\u000bA!\"!\u0004\u0001\u0011\u000b\u0007I\u0011BA\u0003\u0011)\ty\u0001\u0001EC\u0002\u0013%\u0011\u0011\u0003\u0005\u000b\u00033\u0001\u0001R1A\u0005B\u0005m\u0001BCA\u0010\u0001!\u0015\r\u0011\"\u0011\u0002\"!Q\u0011Q\u0005\u0001\t\u0006\u0004%\t%!\t\t\u0015\u0005\u001d\u0002\u0001#b\u0001\n\u0003\n\t\u0003C\u0005\u0002*\u0001A)\u0019!C!\u001b\"9\u00111\u0006\u0001\u0005R\u00055\u0002\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0011%\tI\u0004AI\u0001\n\u0003\tY\u0004C\u0005\u0002R\u0001\t\t\u0011\"\u0011\u0002T!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0011q\r\u0005\n\u0003_\u0002\u0011\u0011!C\u0001\u0003cB\u0011\"! \u0001\u0003\u0003%\t%a \t\u0013\u00055\u0005!!A\u0005\u0002\u0005=\u0005\"CAJ\u0001\u0005\u0005I\u0011IAK\u000f%\tILIA\u0001\u0012\u0003\tYL\u0002\u0005\"E\u0005\u0005\t\u0012AA_\u0011\u0019y5\u0004\"\u0001\u0002L\"I\u0011QZ\u000e\u0002\u0002\u0013\u0015\u0013q\u001a\u0005\n\u0003#\\\u0012\u0011!CA\u0003'D\u0011\"a6\u001c\u0003\u0003%\t)!7\t\u0013\u0005\u00158$!A\u0005\n\u0005\u001d(aA*v[*\u00111\u0005J\u0001\nC\u001e<'/Z4bi\u0016T!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0007\u0001I2$hQ%\u0011\u0005M\"T\"\u0001\u0012\n\u0005U\u0012#\u0001\u0006#fG2\f'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u00028q5\tA%\u0003\u0002:I\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0003{\u0019\nQ\u0001\u001e:fKNL!a\u0010\u001f\u0003\u0013Us\u0017M]=MS.,\u0007CA\u001cB\u0013\t\u0011EE\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002E\u0015&\u00111*\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0001\u000611\r[5mI\u0002\na\u0001P5oSRtDCA)S!\t\u0019\u0004\u0001C\u0003M\u0007\u0001\u0007\u0001)\u0001\u0005ok2d\u0017M\u00197f+\u0005)\u0006C\u0001#W\u0013\t9VIA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\"\nQ\u0001^=qKNL!a\u0018/\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0011\u0007cA2l]:\u0011A-\u001b\b\u0003K\"l\u0011A\u001a\u0006\u0003OB\na\u0001\u0010:p_Rt\u0014\"\u0001$\n\u0005),\u0015a\u00029bG.\fw-Z\u0005\u0003Y6\u00141aU3r\u0015\tQW\t\u0005\u0002\\_&\u0011\u0001\u000f\u0018\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m\u001a\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003qV\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u000be\u0016\u001cX\u000f\u001c;UsB,W#A>\u0013\tqt8)\u0013\u0004\u0005{\u0002\u00011P\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002\\\u007f&\u0019\u0011\u0011\u0001/\u0003\u00179+X.\u001a:jGRK\b/Z\u0001\u0004gVlWCAA\u0004!\r9\u0014\u0011B\u0005\u0004\u0003\u0017!#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\fq![:F[B$\u00180\u0001\u0003{KJ|WCAA\n!\r9\u0014QC\u0005\u0004\u0003/!#a\u0002'ji\u0016\u0014\u0018\r\\\u0001\u0014C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003;\u0001BaY6\u0002\b\u0005i\u0011N\\5uS\u0006dg+\u00197vKN,\"!a\t\u0011\u0007\r\\\u0007)A\tva\u0012\fG/Z#yaJ,7o]5p]N\f\u0001#\\3sO\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007E\u000by\u0003\u0003\u0004\u00022E\u0001\r\u0001Q\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\r\t\u0016q\u0007\u0005\b\u0019J\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0010+\u0007\u0001\u000byd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tY%R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0013\u0001\u00026bm\u0006LA!a\u0019\u0002Z\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001b\u0011\u0007\u0011\u000bY'C\u0002\u0002n\u0015\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001d\u0002zA\u0019A)!\u001e\n\u0007\u0005]TIA\u0002B]fD\u0011\"a\u001f\u0017\u0003\u0003\u0005\r!!\u001b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\t\u0005\u0004\u0002\u0004\u0006%\u00151O\u0007\u0003\u0003\u000bS1!a\"F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA+\u0002\u0012\"I\u00111\u0010\r\u0002\u0002\u0003\u0007\u00111O\u0001\u0007KF,\u0018\r\\:\u0015\u0007U\u000b9\nC\u0005\u0002|e\t\t\u00111\u0001\u0002t!\u001a\u0002!a'\u0002\"\u0006\r\u0016qUAU\u0003[\u000by+a-\u00026B\u0019q'!(\n\u0007\u0005}EEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0016!Q0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];nA\r\fGnY;mCR,G\r\t4s_6\u0004c/\u00197vKN\u0004sN\u001a\u0011bA\u001d\u0014x.\u001e9/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAV\u0003\u0005}(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY&\u0002cIU(NAY\u000bE*V#TA!*\u0014\u0006\f\u0011)cAJC\u0006\t\u00152k%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002Bc*\u0016'MS1\u0002\u0003&\r\u0019*Y\u0001B\u0013'N\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113k)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)\u001dVcE*\u000b\u0017!Q9+F\nT\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005E\u0016!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t9,A\u00032]Ar\u0003'A\u0002Tk6\u0004\"aM\u000e\u0014\tm\ty,\u0013\t\u0007\u0003\u0003\f9\rQ)\u000e\u0005\u0005\r'bAAc\u000b\u00069!/\u001e8uS6,\u0017\u0002BAe\u0003\u0007\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\tY,\u0001\u0005u_N#(/\u001b8h)\t\t)&A\u0003baBd\u0017\u0010F\u0002R\u0003+DQ\u0001\u0014\u0010A\u0002\u0001\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\\\u0006\u0005\b\u0003\u0002#\u0002^\u0002K1!a8F\u0005\u0019y\u0005\u000f^5p]\"A\u00111]\u0010\u0002\u0002\u0003\u0007\u0011+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u001e\t\u0005\u0003/\nY/\u0003\u0003\u0002n\u0006e#AB(cU\u0016\u001cG\u000f")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression> {
    private NumericType resultType;
    private AttributeReference sum;
    private AttributeReference isEmpty;
    private Literal zero;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static Option<Expression> unapply(Sum sum) {
        return Sum$.MODULE$.unapply(sum);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sum, A> function1) {
        return Sum$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Sum> compose(Function1<A, Expression> function1) {
        return Sum$.MODULE$.compose(function1);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType$[]{NumericType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForNumericExpr(this.child().dataType(), "function sum");
    }

    private NumericType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                NumericType numericType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    numericType = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else {
                    numericType = dataType instanceof IntegralType ? LongType$.MODULE$ : DoubleType$.MODULE$;
                }
                this.resultType = numericType;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private NumericType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                String x$1 = "sum";
                NumericType x$2 = this.resultType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.sum = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 2;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        return (this.bitmap$0 & 2) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private AttributeReference isEmpty$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "isEmpty";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.isEmpty = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.isEmpty;
    }

    private AttributeReference isEmpty() {
        return (this.bitmap$0 & 4) == 0 ? this.isEmpty$lzycompute() : this.isEmpty;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default(this.resultType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        return (this.bitmap$0 & 8) == 0 ? this.zero$lzycompute() : this.zero;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                List list;
                NumericType numericType = this.resultType();
                if (numericType instanceof DecimalType) {
                    AttributeReference attributeReference = this.sum();
                    AttributeReference attributeReference2 = this.isEmpty();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                } else {
                    AttributeReference attributeReference = this.sum();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference);
                }
                this.aggBufferAttributes = list;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                NumericType numericType = this.resultType();
                Seq seq = numericType instanceof DecimalType ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{this.zero(), new Literal(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$)})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{new Literal(null, this.resultType())}));
                this.initialValues = seq;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                Seq seq;
                NumericType numericType = this.resultType();
                if (numericType instanceof DecimalType) {
                    Expression sumExpr = this.child().nullable() ? new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.sum(), package$expressions$.MODULE$.DslExpression(this.sum()).$plus(package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.child())).cast(this.resultType()))) : package$expressions$.MODULE$.DslExpression(this.sum()).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType()));
                    Literal isEmptyExpr = this.child().nullable() ? (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.isEmpty()).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))) : new Literal(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{sumExpr, isEmptyExpr}));
                } else {
                    seq = this.child().nullable() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType())), this.sum()}))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType()))}));
                }
                this.updateExpressions = seq;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Seq seq;
                NumericType numericType = this.resultType();
                if (numericType instanceof DecimalType) {
                    Predicate bufferOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).isNull()));
                    Predicate inputOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).right()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).right()).isNull()));
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)bufferOverflow)).$bar$bar((Expression)((Object)inputOverflow))), Literal$.MODULE$.create(null, this.resultType()), package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.RichAttribute(this.sum()).left())).$plus(new KnownNotNull(this.RichAttribute(this.sum()).right()))), (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).$amp$amp(this.RichAttribute(this.isEmpty()).right()))}));
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()}))).$plus(this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()}))}));
                }
                this.mergeExpressions = seq;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x80) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                NumericType numericType = this.resultType();
                if (numericType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)numericType;
                    expression = new If(this.isEmpty(), Literal$.MODULE$.create(null, this.resultType()), new CheckOverflowInSum(this.sum(), decimalType, !SQLConf$.MODULE$.get().ansiEnabled()));
                } else {
                    expression = this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x100) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public Sum withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Sum copy(Expression child) {
        return new Sum(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
    }
}

