/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.LongType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(start: long, end: long, step: long, numSlices: integer)\n    _FUNC_(start: long, end: long, step: long)\n    _FUNC_(start: long, end: long)\n    _FUNC_(end: long)", examples="\n    Examples:\n      > SELECT * FROM _FUNC_(1);\n        +---+\n        | id|\n        +---+\n        |  0|\n        +---+\n      > SELECT * FROM _FUNC_(0, 2);\n        +---+\n        |id |\n        +---+\n        |0  |\n        |1  |\n        +---+\n      > SELECT * FROM _FUNC_(0, 4, 2);\n        +---+\n        |id |\n        +---+\n        |0  |\n        |2  |\n        +---+\n  ", since="2.0.0", group="table_funcs")
@ScalaSignature(bytes="\u0006\u0001\t}v!B\u001c9\u0011\u00039e!B%9\u0011\u0003Q\u0005\"\u0002+\u0002\t\u0003)\u0006\"\u0002,\u0002\t\u00039\u0006B\u0002B'\u0003\u0011\u0005Q\u0010C\u0004\u0003P\u0005!IA!\u0015\t\u000f\te\u0013\u0001\"\u0003\u0003\\!9!1Q\u0001\u0005\u0002\t\u0015\u0005b\u0002BE\u0003\u0011\u0005!1\u0012\u0005\t-\u0006\t\t\u0011\"!\u0003\u0010\"I!QT\u0001\u0012\u0002\u0013\u0005\u00111\u001c\u0005\n\u0005?\u000b\u0011\u0013!C\u0001\u0003CD\u0011B!)\u0002\u0003\u0003%\tIa)\t\u0013\tE\u0016!%A\u0005\u0002\u0005m\u0007\"\u0003BZ\u0003E\u0005I\u0011AAq\u0011%\u0011),AA\u0001\n\u0013\u00119L\u0002\u0003Jq\u0001K\u0006\u0002C5\u0011\u0005+\u0007I\u0011\u00016\t\u00119\u0004\"\u0011#Q\u0001\n-D\u0001b\u001c\t\u0003\u0016\u0004%\tA\u001b\u0005\taB\u0011\t\u0012)A\u0005W\"A\u0011\u000f\u0005BK\u0002\u0013\u0005!\u000e\u0003\u0005s!\tE\t\u0015!\u0003l\u0011!\u0019\bC!f\u0001\n\u0003!\b\u0002C>\u0011\u0005#\u0005\u000b\u0011B;\t\u0011q\u0004\"Q3A\u0005BuD\u0011\"!\t\u0011\u0005#\u0005\u000b\u0011\u0002@\t\u0015\u0005\r\u0002C!f\u0001\n\u0003\n)\u0003\u0003\u0006\u0002.A\u0011\t\u0012)A\u0005\u0003OAa\u0001\u0016\t\u0005\u0002\u0005=\u0002B\u0002+\u0011\t\u0003\ti\u0004\u0003\u0004U!\u0011\u0005\u0011Q\n\u0005\u0007)B!\t!!\u0016\t\rQ\u0003B\u0011AA.\u0011%\ty\u0006\u0005b\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002jA\u0001\u000b\u0011BA2\u0011\u001d\tY\u0007\u0005C\u0001\u0003[Bq!a \u0011\t\u0003\n\t\tC\u0004\u0002\u0004B!\t%!\"\t\u000f\u0005-\u0005\u0003\"\u0011\u0002\u000e\"9\u0011\u0011\u0013\t\u0005B\u0005M\u0005bBAN!\u0011\u0005\u0013Q\u0014\u0005\n\u0003O\u0003\u0012\u0011!C\u0001\u0003SC\u0011\"a.\u0011#\u0003%\t!!/\t\u0013\u0005=\u0007#%A\u0005\u0002\u0005e\u0006\"CAi!E\u0005I\u0011AA]\u0011%\t\u0019\u000eEI\u0001\n\u0003\t)\u000eC\u0005\u0002ZB\t\n\u0011\"\u0001\u0002\\\"I\u0011q\u001c\t\u0012\u0002\u0013\u0005\u0011\u0011\u001d\u0005\n\u0003K\u0004\u0012\u0011!C!\u0003OD\u0011\"a>\u0011\u0003\u0003%\t!!?\t\u0013\u0005m\b#!A\u0005\u0002\u0005u\b\"\u0003B\u0005!\u0005\u0005I\u0011\tB\u0006\u0011%\u0011I\u0002EA\u0001\n\u0003\u0011Y\u0002C\u0005\u0003 A\t\t\u0011\"\u0011\u0003\"\u0005)!+\u00198hK*\u0011\u0011HO\u0001\bY><\u0017nY1m\u0015\tYD(A\u0003qY\u0006t7O\u0003\u0002>}\u0005A1-\u0019;bYf\u001cHO\u0003\u0002@\u0001\u0006\u00191/\u001d7\u000b\u0005\u0005\u0013\u0015!B:qCJ\\'BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002I\u00035\t\u0001HA\u0003SC:<WmE\u0002\u0002\u0017F\u0003\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013a!\u00118z%\u00164\u0007C\u0001'S\u0013\t\u0019VJ\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f\u0006)\u0011\r\u001d9msRI\u0001L!\u0012\u0003H\t%#1\n\t\u0003\u0011B\u0019b\u0001\u0005.^A\u001a\f\u0006C\u0001%\\\u0013\ta\u0006HA\u0006M_\u001eL7-\u00197QY\u0006t\u0007C\u0001%_\u0013\ty\u0006H\u0001\u0005MK\u00064gj\u001c3f!\t\tG-D\u0001c\u0015\t\u0019G(\u0001\u0005b]\u0006d\u0017p]5t\u0013\t)'MA\u000bNk2$\u0018.\u00138ti\u0006t7-\u001a*fY\u0006$\u0018n\u001c8\u0011\u00051;\u0017B\u00015N\u0005\u001d\u0001&o\u001c3vGR\fQa\u001d;beR,\u0012a\u001b\t\u0003\u00192L!!\\'\u0003\t1{gnZ\u0001\u0007gR\f'\u000f\u001e\u0011\u0002\u0007\u0015tG-\u0001\u0003f]\u0012\u0004\u0013\u0001B:uKB\fQa\u001d;fa\u0002\n\u0011B\\;n'2L7-Z:\u0016\u0003U\u00042\u0001\u0014<y\u0013\t9XJ\u0001\u0004PaRLwN\u001c\t\u0003\u0019fL!A_'\u0003\u0007%sG/\u0001\u0006ok6\u001cF.[2fg\u0002\naa\\;uaV$X#\u0001@\u0011\u000b}\fy!!\u0006\u000f\t\u0005\u0005\u00111\u0002\b\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001$\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0015bAA\u0007\u001b\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\t\u0003'\u00111aU3r\u0015\r\ti!\u0014\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u001f\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003?\tIBA\u0005BiR\u0014\u0018NY;uK\u00069q.\u001e;qkR\u0004\u0013aC5t'R\u0014X-Y7j]\u001e,\"!a\n\u0011\u00071\u000bI#C\u0002\u0002,5\u0013qAQ8pY\u0016\fg.\u0001\u0007jgN#(/Z1nS:<\u0007\u0005F\u0007Y\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121\b\u0005\u0006Sv\u0001\ra\u001b\u0005\u0006_v\u0001\ra\u001b\u0005\u0006cv\u0001\ra\u001b\u0005\u0006gv\u0001\r!\u001e\u0005\byv\u0001\n\u00111\u0001\u007f\u0011%\t\u0019#\bI\u0001\u0002\u0004\t9\u0003F\u0005Y\u0003\u007f\t9%!\u0013\u0002L!1\u0011N\ba\u0001\u0003\u0003\u0002B!a\u0006\u0002D%!\u0011QIA\r\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0007_z\u0001\r!!\u0011\t\rEt\u0002\u0019AA!\u0011\u0019\u0019h\u00041\u0001\u0002BQ9\u0001,a\u0014\u0002R\u0005M\u0003BB5 \u0001\u0004\t\t\u0005\u0003\u0004p?\u0001\u0007\u0011\u0011\t\u0005\u0007c~\u0001\r!!\u0011\u0015\u000ba\u000b9&!\u0017\t\r%\u0004\u0003\u0019AA!\u0011\u0019y\u0007\u00051\u0001\u0002BQ\u0019\u0001,!\u0018\t\r=\f\u0003\u0019AA!\u0003-qW/\\#mK6,g\u000e^:\u0016\u0005\u0005\r\u0004cA@\u0002f%!\u0011qMA\n\u0005\u0019\u0011\u0015nZ%oi\u0006aa.^7FY\u0016lWM\u001c;tA\u0005)Ao\\*R\u0019R\u0011\u0011q\u000e\t\u0005\u0003c\nIH\u0004\u0003\u0002t\u0005U\u0004cAA\u0002\u001b&\u0019\u0011qO'\u0002\rA\u0013X\rZ3g\u0013\u0011\tY(! \u0003\rM#(/\u001b8h\u0015\r\t9(T\u0001\f]\u0016<\u0018J\\:uC:\u001cW\rF\u0001Y\u00031\u0019\u0018.\u001c9mKN#(/\u001b8h)\u0011\ty'a\"\t\r\u0005%e\u00051\u0001y\u0003%i\u0017\r\u001f$jK2$7/A\u0004nCb\u0014vn^:\u0016\u0005\u0005=\u0005c\u0001'wW\u0006a1m\\7qkR,7\u000b^1ugR\u0011\u0011Q\u0013\t\u0004\u0011\u0006]\u0015bAAMq\tQ1\u000b^1uSN$\u0018nY:\u0002\u001d=,H\u000f];u\u001fJ$WM]5oOV\u0011\u0011q\u0014\t\u0006\u007f\u0006=\u0011\u0011\u0015\t\u0005\u0003/\t\u0019+\u0003\u0003\u0002&\u0006e!!C*peR|%\u000fZ3s\u0003\u0011\u0019w\u000e]=\u0015\u001ba\u000bY+!,\u00020\u0006E\u00161WA[\u0011\u001dI'\u0006%AA\u0002-Dqa\u001c\u0016\u0011\u0002\u0003\u00071\u000eC\u0004rUA\u0005\t\u0019A6\t\u000fMT\u0003\u0013!a\u0001k\"9AP\u000bI\u0001\u0002\u0004q\b\"CA\u0012UA\u0005\t\u0019AA\u0014\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a/+\u0007-\fil\u000b\u0002\u0002@B!\u0011\u0011YAf\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017!C;oG\",7m[3e\u0015\r\tI-T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAg\u0003\u0007\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005]'fA;\u0002>\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAAoU\rq\u0018QX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\t\u0019O\u000b\u0003\u0002(\u0005u\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002jB!\u00111^A{\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018\u0001\u00027b]\u001eT!!a=\u0002\t)\fg/Y\u0005\u0005\u0003w\ni/\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001y\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a@\u0003\u0006A\u0019AJ!\u0001\n\u0007\t\rQJA\u0002B]fD\u0001Ba\u00024\u0003\u0003\u0005\r\u0001_\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t5\u0001C\u0002B\b\u0005+\ty0\u0004\u0002\u0003\u0012)\u0019!1C'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0018\tE!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\n\u0003\u001e!I!qA\u001b\u0002\u0002\u0003\u0007\u0011q`\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\"1\u0005\u0005\n\u0005\u000f1\u0014\u0011!a\u0001\u0003\u007fD3\u0003\u0005B\u0014\u0005[\u0011yCa\r\u00036\te\"1\bB \u0005\u0003\u0002B!a\u0006\u0003*%!!1FA\r\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\r\u0002\u0003/R\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\f'\u000f\u001e\u001e!Y>tw\r\f\u0011f]\u0012T\u0004\u0005\\8oO2\u00023\u000f^3qu\u0001bwN\\4-A9,Xn\u00157jG\u0016\u001c(\bI5oi\u0016<WM]\u0015\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;beRT\u0004\u0005\\8oO2\u0002SM\u001c3;A1|gn\u001a\u0017!gR,\u0007O\u000f\u0011m_:<\u0017F\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aH/\u0019:uu\u0001bwN\\4-A\u0015tGM\u000f\u0011m_:<\u0017F\u0003\u0011!A\u0001zf)\u0016(D?\"*g\u000e\u001a\u001e!Y>tw-K\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qG\u0001\u0003X*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0006\t$S\u001f6\u0003sLR+O\u0007~C\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011!Aq\u0004\u0013\u000e\u001a?\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011!Aq\u0004\u0003\u0005\r?\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA)\u0002cIU(NA}3UKT\"`QAb\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001ZS&L\u0017,\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001b\u0018\u000e\u001a\u0011}\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001ZS&L\u0017,\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001b\b\u0007\t\u0011}\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001b\u0018\u0007\t\u0011}\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001ZS&L\u0017,\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002R\u0003E\u0012*P\u001b\u0002zf)\u0016(D?\"\u0002D\u0006\t\u001b-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011,[5j3F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011}S\u0012\u0004CP\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011,[5j3F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011}a\u0001\u0002CP\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011}e\u0001\u0002CP\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011,[5j3F\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011i$A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0003D\u0005YA/\u00192mK~3WO\\2t\u0011\u0015I7\u00011\u0001l\u0011\u0015y7\u00011\u0001l\u0011\u0015\t8\u00011\u0001l\u0011\u0015\u00198\u00011\u0001y\u000399W\r^(viB,H/\u0011;ueN\fA\u0002^=qK\u000e{WM]2j_:,\"Aa\u0015\u0011\u0007\u0005\u0014)&C\u0002\u0003X\t\u0014\u0001\u0003V=qK\u000e{WM]2j_:\u0014\u0015m]3\u0002\u0017\r\f7\u000f^!oI\u00163\u0018\r\\\u000b\u0005\u0005;\u0012\u0019\u0007\u0006\u0004\u0003`\t=$1\u000f\t\u0005\u0005C\u0012\u0019\u0007\u0004\u0001\u0005\u000f\t\u0015dA1\u0001\u0003h\t\tA+\u0005\u0003\u0003j\u0005}\bc\u0001'\u0003l%\u0019!QN'\u0003\u000f9{G\u000f[5oO\"9!\u0011\u000f\u0004A\u0002\u0005\u0005\u0013AC3yaJ,7o]5p]\"9!Q\u000f\u0004A\u0002\t]\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\te$qP\u0007\u0003\u0005wR1A! ?\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011\tIa\u001f\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fa\u0001^8M_:<GcA6\u0003\b\"9!\u0011O\u0004A\u0002\u0005\u0005\u0013!\u0002;p\u0013:$Hc\u0001=\u0003\u000e\"9!\u0011\u000f\u0005A\u0002\u0005\u0005C#\u0004-\u0003\u0012\nM%Q\u0013BL\u00053\u0013Y\nC\u0003j\u0013\u0001\u00071\u000eC\u0003p\u0013\u0001\u00071\u000eC\u0003r\u0013\u0001\u00071\u000eC\u0003t\u0013\u0001\u0007Q\u000fC\u0004}\u0013A\u0005\t\u0019\u0001@\t\u0013\u0005\r\u0012\u0002%AA\u0002\u0005\u001d\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003&\n5\u0006\u0003\u0002'w\u0005O\u0003\"\u0002\u0014BUW.\\WO`A\u0014\u0013\r\u0011Y+\u0014\u0002\u0007)V\u0004H.\u001a\u001c\t\u0011\t=F\"!AA\u0002a\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0018\t\u0005\u0003W\u0014Y,\u0003\u0003\u0003>\u00065(AB(cU\u0016\u001cG\u000f")
public class Range
extends LogicalPlan
implements LeafNode,
MultiInstanceRelation,
scala.Serializable {
    private final long start;
    private final long end;
    private final long step;
    private final Option<Object> numSlices;
    private final Seq<Attribute> output;
    private final boolean isStreaming;
    private final BigInt numElements;

    public static boolean $lessinit$greater$default$6() {
        return Range$.MODULE$.$lessinit$greater$default$6();
    }

    public static Seq<Attribute> $lessinit$greater$default$5() {
        return Range$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<Object, Object, Object, Option<Object>, Seq<Attribute>, Object>> unapply(Range range) {
        return Range$.MODULE$.unapply(range);
    }

    public static boolean apply$default$6() {
        return Range$.MODULE$.apply$default$6();
    }

    public static Seq<Attribute> apply$default$5() {
        return Range$.MODULE$.apply$default$5();
    }

    public static int toInt(Expression expression) {
        return Range$.MODULE$.toInt(expression);
    }

    public static long toLong(Expression expression) {
        return Range$.MODULE$.toLong(expression);
    }

    public static Seq<Attribute> getOutputAttrs() {
        return Range$.MODULE$.getOutputAttrs();
    }

    @Override
    public AttributeSet producedAttributes() {
        return LeafNode.producedAttributes$(this);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long step() {
        return this.step;
    }

    public Option<Object> numSlices() {
        return this.numSlices;
    }

    @Override
    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public boolean isStreaming() {
        return this.isStreaming;
    }

    public BigInt numElements() {
        return this.numElements;
    }

    public String toSQL() {
        return this.numSlices().isDefined() ? new StringBuilder(34).append("SELECT id AS `").append(((NamedExpression)this.output().head()).name()).append("` FROM range(").append(this.start()).append(", ").append(this.end()).append(", ").append(this.step()).append(", ").append(this.numSlices().get()).append(")").toString() : new StringBuilder(32).append("SELECT id AS `").append(((NamedExpression)this.output().head()).name()).append("` FROM range(").append(this.start()).append(", ").append(this.end()).append(", ").append(this.step()).append(")").toString();
    }

    @Override
    public Range newInstance() {
        Seq x$1 = (Seq)this.output().map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.newInstance(), Seq$.MODULE$.canBuildFrom());
        long x$2 = this.copy$default$1();
        long x$3 = this.copy$default$2();
        long x$4 = this.copy$default$3();
        Option<Object> x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, (Seq<Attribute>)x$1, x$6);
    }

    @Override
    public String simpleString(int maxFields) {
        return new StringBuilder(26).append("Range (").append(this.start()).append(", ").append(this.end()).append(", step=").append(this.step()).append(", splits=").append(this.numSlices()).append(")").toString();
    }

    @Override
    public Option<Object> maxRows() {
        return this.numElements().isValidLong() ? new Some((Object)BoxesRunTime.boxToLong((long)this.numElements().toLong())) : None$.MODULE$;
    }

    @Override
    public Statistics computeStats() {
        return new Statistics(BigInt$.MODULE$.int2bigInt(LongType$.MODULE$.defaultSize()).$times(this.numElements()), (Option<BigInt>)new Some((Object)this.numElements()), Statistics$.MODULE$.apply$default$3());
    }

    @Override
    public Seq<SortOrder> outputOrdering() {
        SortDirection order = this.step() > 0L ? Ascending$.MODULE$ : Descending$.MODULE$;
        return (Seq)this.output().map((Function1 & Serializable & scala.Serializable)a -> SortOrder$.MODULE$.apply((Expression)a, order, SortOrder$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom());
    }

    public Range copy(long start, long end, long step, Option<Object> numSlices, Seq<Attribute> output, boolean isStreaming) {
        return new Range(start, end, step, numSlices, output, isStreaming);
    }

    public long copy$default$1() {
        return this.start();
    }

    public long copy$default$2() {
        return this.end();
    }

    public long copy$default$3() {
        return this.step();
    }

    public Option<Object> copy$default$4() {
        return this.numSlices();
    }

    public Seq<Attribute> copy$default$5() {
        return this.output();
    }

    public boolean copy$default$6() {
        return this.isStreaming();
    }

    @Override
    public String productPrefix() {
        return "Range";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToLong((long)this.start());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.end());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.step());
                break;
            }
            case 3: {
                object = this.numSlices();
                break;
            }
            case 4: {
                object = this.output();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isStreaming());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Range)) return false;
        boolean bl = true;
        if (!bl) return false;
        Range range = (Range)x$1;
        if (this.start() != range.start()) return false;
        if (this.end() != range.end()) return false;
        if (this.step() != range.step()) return false;
        Option<Object> option = this.numSlices();
        Option<Object> option2 = range.numSlices();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = range.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.isStreaming() != range.isStreaming()) return false;
        if (!range.canEqual(this)) return false;
        return true;
    }

    public Range(long start, long end, long step, Option<Object> numSlices, Seq<Attribute> output, boolean isStreaming) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.numSlices = numSlices;
        this.output = output;
        this.isStreaming = isStreaming;
        LeafLike.$init$(this);
        LeafNode.$init$(this);
        Predef$.MODULE$.require(step != 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("step (").append(this.step()).append(") cannot be 0").toString());
        BigInt safeStart = package$.MODULE$.BigInt().apply(start);
        BigInt safeEnd = package$.MODULE$.BigInt().apply(end);
        this.numElements = BoxesRunTime.equalsNumObject((Number)safeEnd.$minus(safeStart).$percent(BigInt$.MODULE$.long2bigInt(step)), (Object)BoxesRunTime.boxToInteger((int)0)) || safeEnd.$greater((Object)safeStart) != step > 0L ? safeEnd.$minus(safeStart).$div(BigInt$.MODULE$.long2bigInt(step)) : safeEnd.$minus(safeStart).$div(BigInt$.MODULE$.long2bigInt(step)).$plus(BigInt$.MODULE$.int2bigInt(1));
    }

    public Range(Expression start, Expression end, Expression step, Expression numSlices) {
        this(Range$.MODULE$.toLong(start), Range$.MODULE$.toLong(end), Range$.MODULE$.toLong(step), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Range$.MODULE$.toInt(numSlices))), Range$.MODULE$.$lessinit$greater$default$5(), Range$.MODULE$.$lessinit$greater$default$6());
    }

    public Range(Expression start, Expression end, Expression step) {
        this(Range$.MODULE$.toLong(start), Range$.MODULE$.toLong(end), Range$.MODULE$.toLong(step), (Option<Object>)None$.MODULE$, Range$.MODULE$.$lessinit$greater$default$5(), Range$.MODULE$.$lessinit$greater$default$6());
    }

    public Range(Expression start, Expression end) {
        this(start, end, Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)1L), LongType$.MODULE$));
    }

    public Range(Expression end) {
        this(Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)0L), LongType$.MODULE$), end);
    }
}

