/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.InterpretedOrdering;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TypeUtils$ {
    public static TypeUtils$ MODULE$;

    static {
        new TypeUtils$();
    }

    /*
     * Enabled aggressive block sorting
     */
    public TypeCheckResult checkForNumericExpr(DataType dt, String caller) {
        TypeCheckResult typeCheckResult;
        block3: {
            block2: {
                if (dt instanceof NumericType) break block2;
                DataType dataType = dt;
                NullType$ nullType$ = NullType$.MODULE$;
                if (dataType != null ? !dataType.equals(nullType$) : nullType$ != null) break block3;
            }
            typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            return typeCheckResult;
        }
        typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(29).append(caller).append(" requires numeric types, not ").append(dt.catalogString()).toString());
        return typeCheckResult;
    }

    public TypeCheckResult checkForOrderingExpr(DataType dt, String caller) {
        return RowOrdering$.MODULE$.isOrderable(dt) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(35).append(caller).append(" does not support ordering on type ").append(dt.catalogString()).toString());
    }

    public TypeCheckResult checkForSameTypeInputExpr(Seq<DataType> types, String caller) {
        return TypeCoercion$.MODULE$.haveSameType(types) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append("input to ").append(caller).append(" should all be the same type, but it's ").append(((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.catalogString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString());
    }

    public TypeCheckResult checkForMapKeyType(DataType keyType) {
        return keyType.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.$anonfun$checkForMapKeyType$1(x$2))) ? new TypeCheckResult.TypeCheckFailure("The key of map cannot be/contain map.") : TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public Numeric<Object> getNumeric(DataType t, boolean exactNumericRequired) {
        return exactNumericRequired ? ((NumericType)t).exactNumeric() : ((NumericType)t).numeric();
    }

    public boolean getNumeric$default$2() {
        return false;
    }

    public Ordering<Object> getInterpretedOrdering(DataType t) {
        InterpretedOrdering interpretedOrdering;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = t) instanceof AtomicType) {
                    AtomicType atomicType = (AtomicType)dataType;
                    interpretedOrdering = atomicType.ordering();
                    break block4;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    interpretedOrdering = arrayType.interpretedOrdering();
                    break block4;
                }
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    interpretedOrdering = structType.interpretedOrdering();
                    break block4;
                }
                if (!(dataType instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                t = userDefinedType.sqlType();
            }
            throw new MatchError((Object)dataType);
        }
        return interpretedOrdering;
    }

    public int compareBinary(byte[] x, byte[] y) {
        int limit = x.length <= y.length ? x.length : y.length;
        for (int i = 0; i < limit; ++i) {
            int res = (x[i] & 0xFF) - (y[i] & 0xFF);
            if (res == 0) continue;
            return res;
        }
        return x.length - y.length;
    }

    public boolean typeWithProperEquals(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = BinaryType$.MODULE$.equals(dataType2) ? false : dataType2 instanceof AtomicType;
        return bl;
    }

    public void failWithIntervalType(DataType dataType) {
        this.invokeOnceForInterval(dataType, (Function0<BoxedUnit>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException("Cannot use interval type in the table schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        });
    }

    public void invokeOnceForInterval(DataType dataType2, Function0<BoxedUnit> f) {
        block0: {
            if (!dataType2.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)dataType -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.isInterval$1(dataType)))) break block0;
            f.apply$mcV$sp();
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkForMapKeyType$1(DataType x$2) {
        return x$2 instanceof MapType;
    }

    private static final boolean isInterval$1(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = CalendarIntervalType$.MODULE$.equals(dataType2) ? true : (DayTimeIntervalType$.MODULE$.equals(dataType2) ? true : YearMonthIntervalType$.MODULE$.equals(dataType2));
        boolean bl2 = bl;
        return bl2;
    }

    private TypeUtils$() {
        MODULE$ = this;
    }
}

