/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.DateTimeException;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Partition;
import org.apache.spark.SparkException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedGenerator;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnevaluableAggregate;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.UTF8String;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.InternalCompilerException;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class QueryExecutionErrors$ {
    public static QueryExecutionErrors$ MODULE$;

    static {
        new QueryExecutionErrors$();
    }

    public Throwable columnChangeUnsupportedError() {
        return new UnsupportedOperationException("Please add an implementation for a column change here");
    }

    public Throwable logicalHintOperatorNotRemovedDuringAnalysisError() {
        return new IllegalStateException("Internal error: logical hint operator should have been removed during analysis");
    }

    public Throwable cannotEvaluateExpressionError(Expression expression) {
        return new UnsupportedOperationException(new StringBuilder(28).append("Cannot evaluate expression: ").append(expression).toString());
    }

    public Throwable cannotGenerateCodeForExpressionError(Expression expression) {
        return new UnsupportedOperationException(new StringBuilder(37).append("Cannot generate code for expression: ").append(expression).toString());
    }

    public Throwable cannotTerminateGeneratorError(UnresolvedGenerator generator) {
        return new UnsupportedOperationException(new StringBuilder(29).append("Cannot terminate expression: ").append(generator).toString());
    }

    public ArithmeticException castingCauseOverflowError(Object t, String targetType) {
        return new ArithmeticException(new StringBuilder(28).append("Casting ").append(t).append(" to ").append(targetType).append(" causes overflow").toString());
    }

    public ArithmeticException cannotChangeDecimalPrecisionError(Decimal value, int decimalPrecision, int decimalScale) {
        return new ArithmeticException(new StringBuilder(38).append(value.toDebugString()).append(" cannot be represented as ").append("Decimal(").append(decimalPrecision).append(", ").append(decimalScale).append(").").toString());
    }

    public NumberFormatException invalidInputSyntaxForNumericError(UTF8String s) {
        return new NumberFormatException(new StringBuilder(39).append("invalid input syntax for type numeric: ").append(s).toString());
    }

    public Throwable cannotCastFromNullTypeError(DataType to) {
        return new SparkException(new StringBuilder(43).append("should not directly cast from NullType to ").append(to).append(".").toString());
    }

    public Throwable cannotCastError(DataType from, DataType to) {
        return new SparkException(new StringBuilder(17).append("Cannot cast ").append(from).append(" to ").append(to).append(".").toString());
    }

    public Throwable cannotParseDecimalError() {
        return new IllegalArgumentException("Cannot parse any decimal");
    }

    public Throwable simpleStringWithNodeIdUnsupportedError(String nodeName) {
        return new UnsupportedOperationException(new StringBuilder(42).append(nodeName).append(" does not implement simpleStringWithNodeId").toString());
    }

    public Throwable evaluateUnevaluableAggregateUnsupportedError(String methodName, UnevaluableAggregate unEvaluable) {
        return new UnsupportedOperationException(new StringBuilder(18).append("Cannot evaluate ").append(methodName).append(": ").append(unEvaluable).toString());
    }

    public Throwable dataTypeUnsupportedError(DataType dt) {
        return new SparkException(new StringBuilder(22).append("Unsupported data type ").append(dt).toString());
    }

    public Throwable dataTypeUnsupportedError(String dataType, String failure) {
        return new IllegalArgumentException(new StringBuilder(24).append("Unsupported dataType: ").append(dataType).append(", ").append(failure).toString());
    }

    public Throwable failedExecuteUserDefinedFunctionError(String funcCls, String inputTypes, String outputType, Throwable e) {
        return new SparkException(new StringBuilder(50).append("Failed to execute user defined function (").append(funcCls).append(": (").append(inputTypes).append(") => ").append(outputType).append(")").toString(), e);
    }

    public ArithmeticException divideByZeroError() {
        return new ArithmeticException("divide by zero");
    }

    public ArrayIndexOutOfBoundsException invalidArrayIndexError(int index, int numElements) {
        return new ArrayIndexOutOfBoundsException(new StringBuilder(30).append("Invalid index: ").append(index).append(", numElements: ").append(numElements).toString());
    }

    public NoSuchElementException mapKeyNotExistError(Object key) {
        return new NoSuchElementException(new StringBuilder(20).append("Key ").append(key).append(" does not exist.").toString());
    }

    public Throwable rowFromCSVParserNotExpectedError() {
        return new IllegalArgumentException("Expected one row from CSV parser.");
    }

    public Throwable inputTypeUnsupportedError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(23).append("Unsupported input type ").append(dataType.catalogString()).toString());
    }

    public DateTimeException invalidFractionOfSecondError() {
        return new DateTimeException("The fraction of sec must be zero. Valid range is [0, 60].");
    }

    public ArithmeticException overflowInSumOfDecimalError() {
        return new ArithmeticException("Overflow in sum of decimals.");
    }

    public RuntimeException mapSizeExceedArraySizeWhenZipMapError(int size) {
        return new RuntimeException(new StringBuilder(86).append("Unsuccessful try to zip maps with ").append(size).append(" ").append("unique keys due to exceeding the array size limit ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(".").toString());
    }

    public Throwable copyNullFieldNotAllowedError() {
        return new IllegalStateException("Do not attempt to copy a null field");
    }

    public RuntimeException literalTypeUnsupportedError(Object v) {
        return new RuntimeException(new StringBuilder(26).append("Unsupported literal type ").append(v.getClass()).append(" ").append(v).toString());
    }

    public RuntimeException noDefaultForDataTypeError(DataType dataType) {
        return new RuntimeException(new StringBuilder(20).append("no default for type ").append(dataType).toString());
    }

    public Throwable doGenCodeOfAliasShouldNotBeCalledError() {
        return new IllegalStateException("Alias.doGenCode should not be called.");
    }

    public Throwable orderedOperationUnsupportedByDataTypeError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(41).append("Type ").append(dataType).append(" does not support ordered operations").toString());
    }

    public Throwable regexGroupIndexLessThanZeroError() {
        return new IllegalArgumentException("The specified group index cannot be less than zero");
    }

    public Throwable regexGroupIndexExceedGroupCountError(int groupCount, int groupIndex) {
        return new IllegalArgumentException(new StringBuilder(56).append("Regex group count is ").append(groupCount).append(", but the specified group index is ").append(groupIndex).toString());
    }

    public Throwable invalidUrlError(UTF8String url, URISyntaxException e) {
        return new IllegalArgumentException(new StringBuilder(27).append("Find an invaild url string ").append(url.toString()).toString(), e);
    }

    public Throwable dataTypeOperationUnsupportedError() {
        return new UnsupportedOperationException("dataType");
    }

    public Throwable mergeUnsupportedByWindowFunctionError() {
        return new UnsupportedOperationException("Window Functions do not support merging.");
    }

    public Throwable dataTypeUnexpectedError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType.catalogString()).toString());
    }

    public Throwable typeUnsupportedError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dataType).toString());
    }

    public Throwable negativeValueUnexpectedError(Expression frequencyExpression) {
        return new SparkException(new StringBuilder(25).append("Negative values found in ").append(frequencyExpression.sql()).toString());
    }

    public Throwable addNewFunctionMismatchedWithFunctionError(String funcName) {
        return new IllegalArgumentException(new StringBuilder(33).append(funcName).append(" is not matched at addNewFunction").toString());
    }

    public Throwable cannotGenerateCodeForUncomparableTypeError(String codeType, DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(46).append("cannot generate ").append(codeType).append(" code for un-comparable type: ").append(dataType.catalogString()).toString());
    }

    public Throwable cannotGenerateCodeForUnsupportedTypeError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(43).append("cannot generate code for unsupported type: ").append(dataType).toString());
    }

    public Throwable cannotInterpolateClassIntoCodeBlockError(Object arg) {
        return new IllegalArgumentException(new StringBuilder(37).append("Can not interpolate ").append(arg.getClass().getName()).append(" into code block.").toString());
    }

    public Throwable customCollectionClsNotResolvedError() {
        return new UnsupportedOperationException("not resolved");
    }

    public RuntimeException classUnsupportedByMapObjectsError(Class<?> cls) {
        return new RuntimeException(new StringBuilder(66).append("class `").append(cls.getName()).append("` is not supported by `MapObjects` as ").append("resulting collection.").toString());
    }

    public RuntimeException nullAsMapKeyNotAllowedError() {
        return new RuntimeException("Cannot use null as map key!");
    }

    public Throwable methodNotDeclaredError(String name) {
        return new NoSuchMethodException(new StringBuilder(74).append("A method named \"").append(name).append("\" is not declared ").append("in any enclosing class nor any supertype").toString());
    }

    public RuntimeException inputExternalRowCannotBeNullError() {
        return new RuntimeException("The input external row cannot be null.");
    }

    public String fieldCannotBeNullMsg(int index, String fieldName) {
        return new StringBuilder(44).append("The ").append(index).append("th field '").append(fieldName).append("' of input row cannot be null.").toString();
    }

    public RuntimeException fieldCannotBeNullError(int index, String fieldName) {
        return new RuntimeException(this.fieldCannotBeNullMsg(index, fieldName));
    }

    public Throwable unableToCreateDatabaseAsFailedToCreateDirectoryError(CatalogDatabase dbDefinition, IOException e) {
        return new SparkException(new StringBuilder(61).append("Unable to create database ").append(dbDefinition.name()).append(" as failed ").append("to create its directory ").append(dbDefinition.locationUri()).toString(), (Throwable)e);
    }

    public Throwable unableToDropDatabaseAsFailedToDeleteDirectoryError(CatalogDatabase dbDefinition, IOException e) {
        return new SparkException(new StringBuilder(59).append("Unable to drop database ").append(dbDefinition.name()).append(" as failed ").append("to delete its directory ").append(dbDefinition.locationUri()).toString(), (Throwable)e);
    }

    public Throwable unableToCreateTableAsFailedToCreateDirectoryError(String table, Path defaultTableLocation, IOException e) {
        return new SparkException(new StringBuilder(58).append("Unable to create table ").append(table).append(" as failed ").append("to create its directory ").append(defaultTableLocation).toString(), (Throwable)e);
    }

    public Throwable unableToDeletePartitionPathError(Path partitionPath, IOException e) {
        return new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
    }

    public Throwable unableToDropTableAsFailedToDeleteDirectoryError(String table, Path dir, IOException e) {
        return new SparkException(new StringBuilder(56).append("Unable to drop table ").append(table).append(" as failed ").append("to delete its directory ").append(dir).toString(), (Throwable)e);
    }

    public Throwable unableToRenameTableAsFailedToRenameDirectoryError(String oldName, String newName, Path oldDir, IOException e) {
        return new SparkException(new StringBuilder(62).append("Unable to rename table ").append(oldName).append(" to ").append(newName).append(" as failed ").append("to rename its directory ").append(oldDir).toString(), (Throwable)e);
    }

    public Throwable unableToCreatePartitionPathError(Path partitionPath, IOException e) {
        return new SparkException(new StringBuilder(32).append("Unable to create partition path ").append(partitionPath).toString(), (Throwable)e);
    }

    public Throwable unableToRenamePartitionPathError(Path oldPartPath, IOException e) {
        return new SparkException(new StringBuilder(32).append("Unable to rename partition path ").append(oldPartPath).toString(), (Throwable)e);
    }

    public Throwable methodNotImplementedError(String methodName) {
        return new UnsupportedOperationException(new StringBuilder(19).append(methodName).append(" is not implemented").toString());
    }

    public Throwable tableStatsNotSpecifiedError() {
        return new IllegalStateException("table stats must be specified.");
    }

    public ArithmeticException unaryMinusCauseOverflowError(short originValue) {
        return new ArithmeticException(new StringBuilder(19).append("- ").append(originValue).append(" caused overflow.").toString());
    }

    public ArithmeticException binaryArithmeticCauseOverflowError(short eval1, String symbol, short eval2) {
        return new ArithmeticException(new StringBuilder(19).append(eval1).append(" ").append(symbol).append(" ").append(eval2).append(" caused overflow.").toString());
    }

    public String failedSplitSubExpressionMsg(int length) {
        return new StringBuilder(141).append("Failed to split subexpression code into small functions because ").append("the parameter length of at least one split function went over the JVM limit: ").append(length).toString();
    }

    public Throwable failedSplitSubExpressionError(int length) {
        return new IllegalStateException(this.failedSplitSubExpressionMsg(length));
    }

    public String failedToCompileMsg(Exception e) {
        return new StringBuilder(19).append("failed to compile: ").append(e).toString();
    }

    public Throwable internalCompilerError(InternalCompilerException e) {
        return new InternalCompilerException(this.failedToCompileMsg((Exception)((Object)e)), (Throwable)e);
    }

    public Throwable compilerError(CompileException e) {
        return new CompileException(this.failedToCompileMsg((Exception)((Object)e)), e.getLocation());
    }

    public Throwable unsupportedTableChangeError(IllegalArgumentException e) {
        return new SparkException(new StringBuilder(26).append("Unsupported table change: ").append(e.getMessage()).toString(), (Throwable)e);
    }

    public Throwable notADatasourceRDDPartitionError(Partition split) {
        return new SparkException(new StringBuilder(36).append("[BUG] Not a DataSourceRDDPartition: ").append(split).toString());
    }

    public Throwable dataPathNotSpecifiedError() {
        return new IllegalArgumentException("'path' is not specified");
    }

    public Throwable createStreamingSourceNotSpecifySchemaError() {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("\n         |Schema must be specified when creating a streaming source DataFrame. If some\n         |files already exist in the directory, then depending on the file format you\n         |may be able to create a static DataFrame on that directory with\n         |'spark.read.load(directory)' and infer schema from it.\n       ")).stripMargin());
    }

    public Throwable streamedOperatorUnsupportedByDataSourceError(String className, String operator) {
        return new UnsupportedOperationException(new StringBuilder(39).append("Data source ").append(className).append(" does not support streamed ").append(operator).toString());
    }

    public Throwable multiplePathsSpecifiedError(Seq<String> allPaths) {
        return new IllegalArgumentException(new StringBuilder(52).append("Expected exactly one path to be specified, but ").append("got: ").append(allPaths.mkString(", ")).toString());
    }

    public Throwable failedToFindDataSourceError(String provider, Throwable error) {
        return new ClassNotFoundException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(132).append("\n         |Failed to find data source: ").append(provider).append(". Please find packages at\n         |http://spark.apache.org/third-party-projects.html\n       ").toString())).stripMargin(), error);
    }

    public Throwable removedClassInSpark2Error(String className, Throwable e) {
        return new ClassNotFoundException(new StringBuilder(84).append(className).append(" was removed in Spark 2.0. ").append("Please check if your library is compatible with Spark 2.0").toString(), e);
    }

    public Throwable incompatibleDataSourceRegisterError(Throwable e) {
        return new ClassNotFoundException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n         |Detected an incompatible DataSourceRegister. Please remove the incompatible\n         |library from classpath or upgrade it. Error: ").append(e.getMessage()).append("\n       ").toString())).stripMargin(), e);
    }

    public Throwable unrecognizedFileFormatError(String format) {
        return new IllegalStateException(new StringBuilder(20).append("unrecognized format ").append(format).toString());
    }

    public SparkUpgradeException sparkUpgradeInReadingDatesError(String format, String config, String option) {
        return new SparkUpgradeException("3.0", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(637).append("\n         |reading dates before 1582-10-15 or timestamps before 1900-01-01T00:00:00Z from ").append(format).append("\n         |files can be ambiguous, as the files may be written by Spark 2.x or legacy versions of\n         |Hive, which uses a legacy hybrid calendar that is different from Spark 3.0+'s Proleptic\n         |Gregorian calendar. See more details in SPARK-31404. You can set the SQL config\n         |'").append(config).append("' or the datasource option '").append(option).append("' to 'LEGACY' to rebase the datetime values\n         |w.r.t. the calendar difference during reading. To read the datetime values as it is,\n         |set the SQL config '").append(config).append("' or the datasource option '").append(option).append("' to 'CORRECTED'.\n       ").toString())).stripMargin(), null);
    }

    public SparkUpgradeException sparkUpgradeInWritingDatesError(String format, String config) {
        return new SparkUpgradeException("3.0", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(728).append("\n         |writing dates before 1582-10-15 or timestamps before 1900-01-01T00:00:00Z into ").append(format).append("\n         |files can be dangerous, as the files may be read by Spark 2.x or legacy versions of Hive\n         |later, which uses a legacy hybrid calendar that is different from Spark 3.0+'s Proleptic\n         |Gregorian calendar. See more details in SPARK-31404. You can set ").append(config).append(" to 'LEGACY' to\n         |rebase the datetime values w.r.t. the calendar difference during writing, to get maximum\n         |interoperability. Or set ").append(config).append(" to 'CORRECTED' to write the datetime values as it is,\n         |if you are 100% sure that the written files will only be read by Spark 3.0+ or other\n         |systems that use Proleptic Gregorian calendar.\n       ").toString())).stripMargin(), null);
    }

    public Throwable buildReaderUnsupportedForFileFormatError(String format) {
        return new UnsupportedOperationException(new StringBuilder(33).append("buildReader is not supported for ").append(format).toString());
    }

    public Throwable jobAbortedError(Throwable cause) {
        return new SparkException("Job aborted.", cause);
    }

    public Throwable taskFailedWhileWritingRowsError(Throwable cause) {
        return new SparkException("Task failed while writing rows.", cause);
    }

    public Throwable readCurrentFileNotFoundError(FileNotFoundException e) {
        return new FileNotFoundException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(255).append("\n         |").append(e.getMessage()).append("\n\n         |It is possible the underlying files have been updated. You can explicitly invalidate\n         |the cache in Spark by running 'REFRESH TABLE tableName' command in SQL or by\n         |recreating the Dataset/DataFrame involved.\n       ").toString())).stripMargin());
    }

    public Throwable unsupportedSaveModeError(String saveMode, boolean pathExists) {
        return new IllegalStateException(new StringBuilder(25).append("unsupported save mode ").append(saveMode).append(" (").append(pathExists).append(")").toString());
    }

    public Throwable cannotClearOutputDirectoryError(Path staticPrefixPath) {
        return new IOException(new StringBuilder(56).append("Unable to clear output directory ").append(staticPrefixPath).append(" prior to writing to it").toString());
    }

    public Throwable cannotClearPartitionDirectoryError(Path path) {
        return new IOException(new StringBuilder(59).append("Unable to clear partition directory ").append(path).append(" prior to writing to it").toString());
    }

    public Throwable failedToCastValueToDataTypeForPartitionColumnError(String value, DataType dataType, String columnName) {
        return new RuntimeException(new StringBuilder(53).append("Failed to cast value `").append(value).append("` to ").append("`").append(dataType).append("` for partition column `").append(columnName).append("`").toString());
    }

    public Throwable endOfStreamError() {
        return new NoSuchElementException("End of stream");
    }

    public Throwable fallbackV1RelationReportsInconsistentSchemaError(StructType v2Schema, StructType v1Schema) {
        return new IllegalArgumentException(new StringBuilder(101).append("The fallback v1 relation reports inconsistent schema:\nSchema of v2 scan:     ").append(v2Schema).append("\n").append("Schema of v1 relation: ").append(v1Schema).toString());
    }

    public Throwable cannotDropNonemptyNamespaceError(Seq<String> namespace) {
        return new SparkException(new StringBuilder(86).append("Cannot drop a non-empty namespace: ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(namespace).quoted()).append(". ").append("Use CASCADE option to drop a non-empty namespace.").toString());
    }

    public Throwable noRecordsFromEmptyDataReaderError() {
        return new IOException("No records should be returned from EmptyDataReader");
    }

    public Throwable fileNotFoundError(FileNotFoundException e) {
        return new FileNotFoundException(new StringBuilder(150).append(e.getMessage()).append("\n").append("It is possible the underlying files have been updated. ").append("You can explicitly invalidate the cache in Spark by ").append("recreating the Dataset/DataFrame involved.").toString());
    }

    public Throwable unsupportedSchemaColumnConvertError(String filePath, String column, String logicalType, String physicalType, Exception e) {
        String message = new StringBuilder(74).append("Parquet column cannot be converted in ").append("file ").append(filePath).append(". Column: ").append(column).append(", ").append("Expected: ").append(logicalType).append(", Found: ").append(physicalType).toString();
        return new QueryExecutionException(message, e);
    }

    public Throwable cannotReadParquetFilesError(Exception e) {
        String message = "Encounter error while reading parquet files. One possible cause: Parquet column cannot be converted in the corresponding files. Details: ";
        return new QueryExecutionException(message, e);
    }

    public Throwable cannotCreateColumnarReaderError() {
        return new UnsupportedOperationException("Cannot create columnar reader.");
    }

    public Throwable invalidNamespaceNameError(String[] namespace) {
        return new IllegalArgumentException(new StringBuilder(24).append("Invalid namespace name: ").append(CatalogV2Implicits$.MODULE$.NamespaceHelper(namespace).quoted()).toString());
    }

    public Throwable unsupportedPartitionTransformError(Transform transform) {
        return new UnsupportedOperationException(new StringBuilder(53).append("SessionCatalog does not support partition transform: ").append(transform).toString());
    }

    public Throwable missingDatabaseLocationError() {
        return new IllegalArgumentException("Missing database location");
    }

    public Throwable cannotRemoveReservedPropertyError(String property) {
        return new UnsupportedOperationException(new StringBuilder(33).append("Cannot remove reserved property: ").append(property).toString());
    }

    public Throwable namespaceNotEmptyError(String[] namespace) {
        return new IllegalStateException(new StringBuilder(23).append("Namespace ").append(CatalogV2Implicits$.MODULE$.NamespaceHelper(namespace).quoted()).append(" is not empty").toString());
    }

    public Throwable writingJobFailedError(Throwable cause) {
        return new SparkException("Writing job failed.", cause);
    }

    public Throwable writingJobAbortedError(Throwable e) {
        return new SparkException("Writing job aborted.", e);
    }

    public Throwable commitDeniedError(int partId, long taskId, int attemptId, int stageId, int stageAttempt) {
        String message = new StringBuilder(55).append("Commit denied for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString();
        return new CommitDeniedException(message, stageId, partId, attemptId);
    }

    public Throwable unsupportedTableWritesError(Identifier ident) {
        return new SparkException(new StringBuilder(46).append("Table implementation does not support writes: ").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString());
    }

    public Throwable cannotCreateJDBCTableWithPartitionsError() {
        return new UnsupportedOperationException("Cannot create JDBC table with partition");
    }

    public Throwable unsupportedUserSpecifiedSchemaError() {
        return new UnsupportedOperationException("user-specified schema");
    }

    public Throwable writeUnsupportedForBinaryFileDataSourceError() {
        return new UnsupportedOperationException("Write is not supported for binary file data source");
    }

    public Throwable fileLengthExceedsMaxLengthError(FileStatus status, int maxLength) {
        return new SparkException(new StringBuilder(59).append("The length of ").append(status.getPath()).append(" is ").append(status.getLen()).append(", ").append("which exceeds the max length allowed: ").append(maxLength).append(".").toString());
    }

    public Throwable unsupportedFieldNameError(String fieldName) {
        return new RuntimeException(new StringBuilder(24).append("Unsupported field name: ").append(fieldName).toString());
    }

    public Throwable cannotSpecifyBothJdbcTableNameAndQueryError(String jdbcTableName, String jdbcQueryString) {
        return new IllegalArgumentException(new StringBuilder(53).append("Both '").append(jdbcTableName).append("' and '").append(jdbcQueryString).append("' can not be specified at the same time.").toString());
    }

    public Throwable missingJdbcTableNameAndQueryError(String jdbcTableName, String jdbcQueryString) {
        return new IllegalArgumentException(new StringBuilder(28).append("Option '").append(jdbcTableName).append("' or '").append(jdbcQueryString).append("' is required.").toString());
    }

    public Throwable emptyOptionError(String optionName) {
        return new IllegalArgumentException(new StringBuilder(27).append("Option `").append(optionName).append("` can not be empty.").toString());
    }

    public Throwable invalidJdbcTxnIsolationLevelError(String jdbcTxnIsolationLevel, String value) {
        return new IllegalArgumentException(new StringBuilder(129).append("Invalid value `").append(value).append("` for parameter `").append(jdbcTxnIsolationLevel).append("`. This can be ").append("`NONE`, `READ_UNCOMMITTED`, `READ_COMMITTED`, `REPEATABLE_READ` or `SERIALIZABLE`.").toString());
    }

    public Throwable cannotGetJdbcTypeError(DataType dt) {
        return new IllegalArgumentException(new StringBuilder(24).append("Can't get JDBC type for ").append(dt.catalogString()).toString());
    }

    public Throwable unrecognizedSqlTypeError(int sqlType) {
        return new SQLException(new StringBuilder(22).append("Unrecognized SQL type ").append(sqlType).toString());
    }

    public Throwable unsupportedJdbcTypeError(String content) {
        return new SQLException(new StringBuilder(17).append("Unsupported type ").append(content).toString());
    }

    public Throwable unsupportedArrayElementTypeBasedOnBinaryError(DataType dt) {
        return new IllegalArgumentException(new StringBuilder(47).append("Unsupported array element ").append("type ").append(dt.catalogString()).append(" based on binary").toString());
    }

    public Throwable nestedArraysUnsupportedError() {
        return new IllegalArgumentException("Nested arrays unsupported");
    }

    public Throwable cannotTranslateNonNullValueForFieldError(int pos) {
        return new IllegalArgumentException(new StringBuilder(41).append("Can't translate non-null value for field ").append(pos).toString());
    }

    public Throwable invalidJdbcNumPartitionsError(int n, String jdbcNumPartitions) {
        return new IllegalArgumentException(new StringBuilder(84).append("Invalid value `").append(n).append("` for parameter `").append(jdbcNumPartitions).append("` in table writing ").append("via JDBC. The minimum value is 1.").toString());
    }

    public Throwable transactionUnsupportedByJdbcServerError() {
        return new SQLFeatureNotSupportedException("The target JDBC server does not support transaction and can only support ALTER TABLE with a single action.");
    }

    public Throwable dataTypeUnsupportedYetError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(22).append(dataType).append(" is not supported yet.").toString());
    }

    public Throwable unsupportedOperationForDataTypeError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(10).append("DataType: ").append(dataType.catalogString()).toString());
    }

    public Throwable inputFilterNotFullyConvertibleError(String owner) {
        return new SparkException(new StringBuilder(49).append("The input filter of ").append(owner).append(" should be fully convertible.").toString());
    }

    public Throwable cannotReadFooterForFileError(Path file, IOException e) {
        return new SparkException(new StringBuilder(32).append("Could not read footer for file: ").append(file).toString(), (Throwable)e);
    }

    public Throwable cannotReadFooterForFileError(FileStatus file, RuntimeException e) {
        return new IOException(new StringBuilder(32).append("Could not read footer for file: ").append(file).toString(), e);
    }

    public Throwable foundDuplicateFieldInCaseInsensitiveModeError(String requiredFieldName, String matchedOrcFields) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("\n         |Found duplicate field(s) \"").append(requiredFieldName).append("\": ").append(matchedOrcFields).append("\n         |in case-insensitive mode\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable failedToMergeIncompatibleSchemasError(StructType left, StructType right, Throwable e) {
        return new SparkException(new StringBuilder(42).append("Failed to merge incompatible schemas ").append(left).append(" and ").append(right).toString(), e);
    }

    private QueryExecutionErrors$() {
        MODULE$ = this;
    }
}

