/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.connector.expressions.BucketTransform;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.NamedTransform$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public void checkSchemaColumnNameDuplication(DataType schema, String colType, boolean caseSensitiveAnalysis) {
        DataType dataType;
        while (true) {
            if ((dataType = schema) instanceof ArrayType) {
                DataType elementType;
                ArrayType arrayType = (ArrayType)dataType;
                schema = elementType = arrayType.elementType();
                continue;
            }
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            this.checkSchemaColumnNameDuplication(keyType, colType, caseSensitiveAnalysis);
            schema = valueType;
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            this.checkColumnNameDuplication((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), colType, caseSensitiveAnalysis);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).foreach((Function1 & Serializable & scala.Serializable)field -> {
                SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication(field.dataType(), colType, caseSensitiveAnalysis);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void checkSchemaColumnNameDuplication(StructType schema, String colType, Function2<String, String, Object> resolver) {
        this.checkSchemaColumnNameDuplication((DataType)schema, colType, this.isCaseSensitiveAnalysis(resolver));
    }

    public boolean checkSchemaColumnNameDuplication$default$3() {
        return false;
    }

    private boolean isCaseSensitiveAnalysis(Function2<String, String, Object> resolver) {
        boolean bl;
        Function2<String, String, Object> function2 = resolver;
        Function2<String, String, Object> function22 = package$.MODULE$.caseSensitiveResolution();
        if (!(function2 != null ? !function2.equals(function22) : function22 != null)) {
            bl = true;
        } else {
            Function2<String, String, Object> function23 = resolver;
            Function2<String, String, Object> function24 = package$.MODULE$.caseInsensitiveResolution();
            if (!(function23 != null ? !function23.equals(function24) : function24 != null)) {
                bl = false;
            } else {
                throw scala.sys.package$.MODULE$.error("A resolver to check if two identifiers are equal must be `caseSensitiveResolution` or `caseInsensitiveResolution` in o.a.s.sql.catalyst.");
            }
        }
        return bl;
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, String colType, Function2<String, String, Object> resolver) {
        this.checkColumnNameDuplication(columnNames, colType, this.isCaseSensitiveAnalysis(resolver));
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, String colType, boolean caseSensitiveAnalysis) {
        Seq names;
        Seq seq = names = caseSensitiveAnalysis ? columnNames : (Seq)columnNames.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(), Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)names.distinct()).length() != names.length()) {
            Iterable duplicateColumns = (Iterable)names.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = new StringBuilder(2).append("`").append(x).append("`").toString();
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw new AnalysisException(new StringBuilder(28).append("Found duplicate column(s) ").append(colType).append(": ").append(((TraversableOnce)duplicateColumns.toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public Seq<String> explodeNestedFieldNames(StructType schema) {
        return (Seq)this.explode$1(schema).map((Function1 & Serializable & scala.Serializable)x$6 -> new UnresolvedAttribute((Seq<String>)x$6).name(), Seq$.MODULE$.canBuildFrom());
    }

    public void checkTransformDuplication(Seq<Transform> transforms, String checkType, boolean isCaseSensitive) {
        Seq normalizedTransforms;
        Seq extractedTransforms = (Seq)transforms.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Transform transform = x0$1;
            if (transform instanceof BucketTransform) {
                BucketTransform bucketTransform = (BucketTransform)transform;
                Seq colNames = (Seq)bucketTransform.columns().map((Function1 & Serializable & scala.Serializable)c -> new UnresolvedAttribute((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])c.fieldNames())).name(), Seq$.MODULE$.canBuildFrom());
                MODULE$.checkColumnNameDuplication((Seq<String>)colNames, "in the bucket definition", isCaseSensitive);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bucketTransform.name()), (Object)colNames);
            } else {
                Some<Tuple2<String, Seq<Expression>>> some = NamedTransform$.MODULE$.unapply(transform);
                if (!some.isEmpty()) {
                    String transformName = (String)((Tuple2)some.get())._1();
                    Seq refs = (Seq)((Tuple2)some.get())._2();
                    Seq fieldNameParts = (Seq)refs.collect((PartialFunction)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof FieldReference) {
                                FieldReference fieldReference = (FieldReference)A1;
                                Seq<String> parts = fieldReference.parts();
                                object = new UnresolvedAttribute(parts).name();
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            boolean bl = expression instanceof FieldReference;
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transformName), (Object)fieldNameParts);
                } else {
                    throw new MatchError((Object)transform);
                }
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq seq = normalizedTransforms = isCaseSensitive ? extractedTransforms : (Seq)extractedTransforms.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t._1()), ((TraversableLike)t._2()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(Locale.ROOT), Seq$.MODULE$.canBuildFrom())), Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)normalizedTransforms.distinct()).length() != normalizedTransforms.length()) {
            Iterable duplicateColumns = (Iterable)normalizedTransforms.groupBy((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 != null) {
                        Tuple2 x = (Tuple2)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = String.valueOf(((TraversableOnce)x._2()).mkString("."));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>> x2) {
                    Seq ys;
                    Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>> tuple2 = x2;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw new AnalysisException(new StringBuilder(28).append("Found duplicate column(s) ").append(checkType).append(": ").append(duplicateColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public Seq<Object> findColumnPosition(Seq<String> column, StructType schema, Function2<String, String, Object> resolver) {
        Seq seq;
        try {
            seq = SchemaUtils$.find$1(column, schema, (Seq)Nil$.MODULE$, resolver);
        }
        catch (IndexOutOfBoundsException i) {
            throw new AnalysisException(new StringBuilder(26).append("Couldn't find column ").append(i.getMessage()).append(" in:\n").append(schema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        catch (AnalysisException e) {
            throw new AnalysisException(new StringBuilder(2).append(e.getMessage()).append(":\n").append(schema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return seq;
    }

    public Seq<String> getColumnName(Seq<Object> position, StructType schema) {
        StructField topLevel = schema.apply(BoxesRunTime.unboxToInt((Object)position.head()));
        Tuple2 field = (Tuple2)((TraversableOnce)position.tail()).foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topLevel.name()}))), (Object)topLevel), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> SchemaUtils$.$anonfun$getColumnName$1(schema, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)));
        return (Seq)field._1();
    }

    public String escapeMetaCharacters(String str) {
        return str.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r").replaceAll("\t", "\\\\t").replaceAll("\f", "\\\\f").replaceAll("\b", "\\\\b").replaceAll("\u000b", "\\\\v").replaceAll("\u0007", "\\\\a");
    }

    private final Seq recurseIntoComplexTypes$1(DataType complexType) {
        Seq seq;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = complexType) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    seq = this.explode$1(structType);
                    break block4;
                }
                if (!(dataType instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType;
                complexType = arrayType.elementType();
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                seq = (Seq)((TraversableLike)this.recurseIntoComplexTypes$1(mapType.keyType()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))).$plus$plus((GenTraversableOnce)x$3, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$1(mapType.valueType()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$plus$plus((GenTraversableOnce)x$4, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            } else {
                seq = Nil$.MODULE$;
            }
        }
        return seq;
    }

    private final Seq explode$1(StructType schema) {
        return (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType s = structField.dataType();
                if (s instanceof StructType) {
                    StructType structType = (StructType)s;
                    return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)this.explode$1(structType).map((Function1 & Serializable & scala.Serializable)nested -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus((GenTraversableOnce)nested, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType a = structField.dataType();
                if (a instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)a;
                    return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$1(arrayType).map((Function1 & Serializable & scala.Serializable)nested -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus((GenTraversableOnce)nested, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType m = structField.dataType();
                if (m instanceof MapType) {
                    MapType mapType = (MapType)m;
                    return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$1(mapType).map((Function1 & Serializable & scala.Serializable)nested -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus((GenTraversableOnce)nested, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                }
            }
            Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{structField.name()}));
            return Nil$.MODULE$.$colon$colon((Object)seq);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static final /* synthetic */ String columnPath$lzycompute$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        String string;
        LazyRef lazyRef = columnPath$lzy$1;
        synchronized (lazyRef) {
            string = columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : (String)columnPath$lzy$1.initialize((Object)new UnresolvedAttribute((Seq<String>)((Seq)stack$1.$colon$plus((Object)thisCol$1, Seq$.MODULE$.canBuildFrom()))).name());
        }
        return string;
    }

    private static final String columnPath$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        return columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : SchemaUtils$.columnPath$lzycompute$1(columnPath$lzy$1, stack$1, thisCol$1);
    }

    public static final /* synthetic */ boolean $anonfun$findColumnPosition$1(Function2 resolver$1, String thisCol$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)thisCol$1));
    }

    private static final Seq find$1(Seq column, StructType schema, Seq stack, Function2 resolver$1) {
        ArrayType arrayType;
        DataType s;
        Nil$ nil$;
        LazyRef columnPath$lzy = new LazyRef();
        if (column.isEmpty()) {
            return Nil$.MODULE$;
        }
        String thisCol = (String)column.head();
        int pos = schema.indexWhere((Function1<StructField, Object>)(Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findColumnPosition$1(resolver$1, thisCol, f)));
        if (pos == -1) {
            throw new IndexOutOfBoundsException(SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol));
        }
        DataType dataType = schema.apply(pos).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            nil$ = SchemaUtils$.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
        } else if (dataType instanceof ArrayType && (s = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType) {
            StructType structType = (StructType)s;
            nil$ = SchemaUtils$.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
        } else {
            if (column.length() > 1) {
                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("Expected ").append(SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol)).append(" to be a nested data type, but found ").append(dataType).append(". Was looking for the\n                 |index of ").append(new UnresolvedAttribute((Seq<String>)column).name()).append(" in a nested field\n              ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            nil$ = Nil$.MODULE$;
        }
        Nil$ children2 = nil$;
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{pos}))).$plus$plus((GenTraversableOnce)children2, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple2 $anonfun$getColumnName$1(StructType schema$1, Tuple2 x0$1, int x1$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Tuple2 nameAndField = (Tuple2)tuple22._1();
        int pos = tuple22._2$mcI$sp();
        DataType dataType = ((StructField)nameAndField._2()).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField nowField = structType.apply(pos);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((SeqLike)nameAndField._1()).$colon$plus((Object)nowField.name(), Seq$.MODULE$.canBuildFrom())), (Object)nowField);
            return tuple2;
        } else {
            if (!(dataType instanceof ArrayType)) throw new AnalysisException(new StringBuilder(49).append("The positions provided (").append(pos).append(") cannot be resolved in\n").append(schema$1.treeString()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            ArrayType arrayType = (ArrayType)dataType;
            DataType s = arrayType.elementType();
            if (!(s instanceof StructType)) throw new AnalysisException(new StringBuilder(49).append("The positions provided (").append(pos).append(") cannot be resolved in\n").append(schema$1.treeString()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            StructType structType = (StructType)s;
            StructField nowField = structType.apply(pos);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((SeqLike)nameAndField._1()).$colon$plus((Object)nowField.name(), Seq$.MODULE$.canBuildFrom())), (Object)nowField);
        }
        return tuple2;
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

