/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.DenseRank$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Computes the rank of a value in a group of values. The result is one plus the\n      previously assigned rank value. Unlike the function rank, dense_rank will not produce gaps\n      in the ranking sequence.\n  ", arguments="\n    Arguments:\n      * children - this is to base the rank on; a change in the value of one the children will\n          trigger a change in rank. This is an internal parameter and will be assigned by the\n          Analyser.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t2\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u0010 \u00012B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005y!)A\n\u0001C\u0001\u001b\")A\n\u0001C\u0001!\")\u0011\u000b\u0001C!%\")Q\u000b\u0001C)-\"9q\u000b\u0001b\u0001\n\u0003Z\u0004B\u0002-\u0001A\u0003%A\bC\u0004Z\u0001\t\u0007I\u0011\t.\t\r}\u0003\u0001\u0015!\u0003\\\u0011\u001d\u0001\u0007A1A\u0005BmBa!\u0019\u0001!\u0002\u0013a\u0004\"\u00022\u0001\t\u0003\u001a\u0007\"\u00027\u0001\t#j\u0007bB:\u0001\u0003\u0003%\t\u0001\u001e\u0005\bm\u0002\t\n\u0011\"\u0001x\u0011%\t)\u0001AA\u0001\n\u0003\n9\u0001C\u0005\u0002\u0018\u0001\t\t\u0011\"\u0001\u0002\u001a!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003_\u0001\u0011\u0011!C!\u0003cA\u0011\"a\u0010\u0001\u0003\u0003%\t!!\u0011\t\u0013\u0005-\u0003!!A\u0005B\u00055s!CA<?\u0005\u0005\t\u0012AA=\r!qr$!A\t\u0002\u0005m\u0004B\u0002'\u0019\t\u0003\tI\tC\u0005\u0002\fb\t\t\u0011\"\u0012\u0002\u000e\"I\u0011q\u0012\r\u0002\u0002\u0013\u0005\u0015\u0011\u0013\u0005\n\u0003+C\u0012\u0011!CA\u0003/C\u0011\"a)\u0019\u0003\u0003%I!!*\u0003\u0013\u0011+gn]3SC:\\'B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001i\u0013g\u000e\t\u0003]=j\u0011aH\u0005\u0003a}\u0011\u0001BU1oW2K7.\u001a\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\b!J|G-^2u!\t\u0011\u0004(\u0003\u0002:g\ta1+\u001a:jC2L'0\u00192mK\u0006A1\r[5mIJ,g.F\u0001=!\riT\t\u0013\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!Q\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001#4\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0007M+\u0017O\u0003\u0002EgA\u0011a&S\u0005\u0003\u0015~\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u001d>\u0003\"A\f\u0001\t\u000bi\u001a\u0001\u0019\u0001\u001f\u0015\u00039\u000b\u0011b^5uQ>\u0013H-\u001a:\u0015\u00059\u001b\u0006\"\u0002+\u0006\u0001\u0004a\u0014!B8sI\u0016\u0014\u0018A\u0003:b].\u001cv.\u001e:dKV\t\u0001*A\tva\u0012\fG/Z#yaJ,7o]5p]N\f!#\u001e9eCR,W\t\u001f9sKN\u001c\u0018n\u001c8tA\u0005\u0019\u0012mZ4Ck\u001a4WM]!uiJL'-\u001e;fgV\t1\fE\u0002>\u000br\u0003\"AL/\n\u0005y{\"AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\fA#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\u0004\u0013!D5oSRL\u0017\r\u001c,bYV,7/\u0001\bj]&$\u0018.\u00197WC2,Xm\u001d\u0011\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001e!\t)\u0017N\u0004\u0002gOB\u0011qhM\u0005\u0003QN\na\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001nM\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\"A\u00148\t\u000b=t\u0001\u0019\u00019\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0004{ED\u0015B\u0001:H\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Ok\"9!h\u0004I\u0001\u0002\u0004a\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002q*\u0012A(_\u0016\u0002uB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0013Ut7\r[3dW\u0016$'BA@4\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0007a(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005!A.\u00198h\u0015\t\t\u0019\"\u0001\u0003kCZ\f\u0017b\u00016\u0002\u000e\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0004\t\u0004e\u0005u\u0011bAA\u0010g\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QEA\u0016!\r\u0011\u0014qE\u0005\u0004\u0003S\u0019$aA!os\"I\u0011QF\n\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0002CBA\u001b\u0003w\t)#\u0004\u0002\u00028)\u0019\u0011\u0011H\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002>\u0005]\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0011\u0002JA\u0019!'!\u0012\n\u0007\u0005\u001d3GA\u0004C_>dW-\u00198\t\u0013\u00055R#!AA\u0002\u0005\u0015\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002D\u0005=\u0003\"CA\u0017-\u0005\u0005\t\u0019AA\u0013Q]\u0001\u00111KA-\u00037\ny&!\u0019\u0002f\u0005\u001d\u00141NA7\u0003c\n\u0019\bE\u0002/\u0003+J1!a\u0016 \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0018\u0002\u0003\u0003T\u0001\u0005\t\u0011!?\u001a+fjQ0)S\u0001j\u0003eQ8naV$Xm\u001d\u0011uQ\u0016\u0004#/\u00198lA=4\u0007%\u0019\u0011wC2,X\rI5oA\u0005\u0004sM]8va\u0002zg\r\t<bYV,7O\f\u0011UQ\u0016\u0004#/Z:vYR\u0004\u0013n\u001d\u0011p]\u0016\u0004\u0003\u000f\\;tAQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\u001d:fm&|Wo\u001d7zA\u0005\u001c8/[4oK\u0012\u0004#/\u00198lAY\fG.^3/AUsG.[6fAQDW\r\t4v]\u000e$\u0018n\u001c8!e\u0006t7\u000e\f\u0011eK:\u001cXm\u0018:b].\u0004s/\u001b7mA9|G\u000f\t9s_\u0012,8-\u001a\u0011hCB\u001c(\u0002\t\u0011!A\u0001\u0002\u0013N\u001c\u0011uQ\u0016\u0004#/\u00198lS:<\u0007e]3rk\u0016t7-\u001a\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\r\u0014!a2\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001a\u0007.\u001b7ee\u0016t\u0007%\f\u0011uQ&\u001c\b%[:!i>\u0004#-Y:fAQDW\r\t:b].\u0004sN\\\u001e!C\u0002\u001a\u0007.\u00198hK\u0002Jg\u000e\t;iK\u00022\u0018\r\\;fA=4\u0007e\u001c8fAQDW\rI2iS2$'/\u001a8!o&dGN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014\u0018nZ4fe\u0002\n\u0007e\u00195b]\u001e,\u0007%\u001b8!e\u0006t7N\f\u0011UQ&\u001c\b%[:!C:\u0004\u0013N\u001c;fe:\fG\u000e\t9be\u0006lW\r^3sA\u0005tG\rI<jY2\u0004#-\u001a\u0011bgNLwM\\3eA\tL\b\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00118bYf\u001cXM\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003S\n\u0011q\u0013\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!C2\u0002#\r\f\u0011`\rVs5i\u0018\u0015cS\u0001ze+\u0012*!QA\u000b%\u000bV%U\u0013>s\u0005EQ-!C\u0002z%\u000bR#SA\tK\u0006EY\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015(\u0003F:C\u0006\t\u001a*Y\u0001Bs%Q\u0019(Y\u0001\n\u0014\u0006\f\u0011)O\u0005\u0013t\u0005\f\u00114S1\u0002\u0003fJ!2O1\u0002\u0013'\u000b\u0011uC\nD\u0013\r\f\u0011cSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00052\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00052\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053\u0013IR\u0001\u0005\t\u0011!A\u0001\u0002\u0013IM\u00054\u0013ER\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003_\nQA\r\u00181]A\nQa\u001a:pkB\f#!!\u001e\u0002\u0019]Lg\u000eZ8x?\u001a,hnY:\u0002\u0013\u0011+gn]3SC:\\\u0007C\u0001\u0018\u0019'\u0011A\u0012QP\u001c\u0011\r\u0005}\u0014Q\u0011\u001fO\u001b\t\t\tIC\u0002\u0002\u0004N\nqA];oi&lW-\u0003\u0003\u0002\b\u0006\u0005%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011\u0011P\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011B\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001d\u0006M\u0005\"\u0002\u001e\u001c\u0001\u0004a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00033\u000by\n\u0005\u00033\u00037c\u0014bAAOg\t1q\n\u001d;j_:D\u0001\"!)\u001d\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a*\u0011\t\u0005-\u0011\u0011V\u0005\u0005\u0003W\u000biA\u0001\u0004PE*,7\r\u001e")
public class DenseRank
extends RankLike {
    private final Seq<Expression> children;
    private final Seq<Expression> updateExpressions;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;

    public static Option<Seq<Expression>> unapply(DenseRank denseRank) {
        return DenseRank$.MODULE$.unapply(denseRank);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<DenseRank, A> function1) {
        return DenseRank$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, DenseRank> compose(Function1<A, Seq<Expression>> function1) {
        return DenseRank$.MODULE$.compose(function1);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public DenseRank withOrder(Seq<Expression> order) {
        return new DenseRank(order);
    }

    @Override
    public Expression rankSource() {
        return package$expressions$.MODULE$.DslExpression(this.rank()).$plus(this.one());
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public String prettyName() {
        return "dense_rank";
    }

    @Override
    public DenseRank withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public DenseRank copy(Seq<Expression> children2) {
        return new DenseRank(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "DenseRank";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DenseRank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DenseRank)) return false;
        boolean bl = true;
        if (!bl) return false;
        DenseRank denseRank = (DenseRank)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = denseRank.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!denseRank.canEqual(this)) return false;
        return true;
    }

    public DenseRank(Seq<Expression> children2) {
        this.children = children2;
        If if_ = this.increaseRank();
        this.updateExpressions = (Seq)children2.$plus$colon((Object)if_, Seq$.MODULE$.canBuildFrom());
        AttributeReference attributeReference = this.rank();
        this.aggBufferAttributes = (Seq)this.orderAttrs().$plus$colon((Object)attributeReference, Seq$.MODULE$.canBuildFrom());
        Literal literal = this.zero();
        this.initialValues = (Seq)this.orderInit().$plus$colon((Object)literal, Seq$.MODULE$.canBuildFrom());
    }

    public DenseRank() {
        this((Seq<Expression>)Nil$.MODULE$);
    }
}

