/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u000e\u001d\u0001%B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005k!)!\b\u0001C\u0001w!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002$\u0001A\u0003%\u0001\tC\u0004H\u0001\t\u0007I\u0011B \t\r!\u0003\u0001\u0015!\u0003A\u0011\u001dI\u0005A1A\u0005\n)Ca!\u0019\u0001!\u0002\u0013Y\u0005\"\u00022\u0001\t\u0003\u0019\u0007\"B<\u0001\t\u0003A\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\f\u0001\t\u0013\ty\u0003C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003#\u0002A\u0011BA*\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002~\tq1i\u0015,J]\u001a,'oU2iK6\f'BA\u000f\u001f\u0003\r\u00197O\u001e\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0004\u0001)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u0002,c%\u0011!\u0007\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\b_B$\u0018n\u001c8t+\u0005)\u0004C\u0001\u001c8\u001b\u0005a\u0012B\u0001\u001d\u001d\u0005)\u00195KV(qi&|gn]\u0001\t_B$\u0018n\u001c8tA\u00051A(\u001b8jiz\"\"\u0001P\u001f\u0011\u0005Y\u0002\u0001\"B\u001a\u0004\u0001\u0004)\u0014a\u0004;j[\u0016\u001cH/Y7q!\u0006\u00148/\u001a:\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003\u000b\n\u0013!\u0003V5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\u0006\u0001B/[7fgR\fW\u000e\u001d)beN,'\u000fI\u0001\u0016i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3s\u0003Y!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\u0004\u0013!\u00043fG&l\u0017\r\u001c)beN,'/F\u0001L!\u0011YCJT-\n\u00055c#!\u0003$v]\u000e$\u0018n\u001c82!\tyeK\u0004\u0002Q)B\u0011\u0011\u000bL\u0007\u0002%*\u00111\u000bK\u0001\u0007yI|w\u000e\u001e \n\u0005Uc\u0013A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!\u0016\u0017\u0011\u0005i{V\"A.\u000b\u0005qk\u0016\u0001B7bi\"T\u0011AX\u0001\u0005U\u00064\u0018-\u0003\u0002a7\nQ!)[4EK\u000eLW.\u00197\u0002\u001d\u0011,7-[7bYB\u000b'o]3sA\u0005)\u0011N\u001c4feR\u0019AM[;\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d\u0004\u0013!\u0002;za\u0016\u001c\u0018BA5g\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006W*\u0001\r\u0001\\\u0001\ti>\\WM\u001c*E\tB\u0019Q\u000e\u001d:\u000e\u00039T!a\u001c\u0012\u0002\u0007I$G-\u0003\u0002r]\n\u0019!\u000b\u0012#\u0011\u0007-\u001ah*\u0003\u0002uY\t)\u0011I\u001d:bs\")aO\u0003a\u0001e\u00061\u0001.Z1eKJ\fa\u0002^8TiJ,8\r\u001e$jK2$7\u000f\u0006\u0003z{\u0006\u001d\u0001cA\u0016tuB\u0011Qm_\u0005\u0003y\u001a\u00141b\u0015;sk\u000e$h)[3mI\")ap\u0003a\u0001\u007f\u0006Qa-[3mIRK\b/Z:\u0011\t-\u001a\u0018\u0011\u0001\t\u0004K\u0006\r\u0011bAA\u0003M\nAA)\u0019;b)f\u0004X\rC\u0003w\u0017\u0001\u0007!/\u0001\u0007j]\u001a,'OU8x)f\u0004X\rF\u0003\u0000\u0003\u001b\t\t\u0002\u0003\u0004\u0002\u00101\u0001\ra`\u0001\te><8k\u001c$be\"1\u00111\u0003\u0007A\u0002I\fAA\\3yi\u0006iQ.\u001a:hKJ{w\u000fV=qKN$Ra`A\r\u0003;Aa!a\u0007\u000e\u0001\u0004y\u0018!\u00024jeN$\bBBA\u0010\u001b\u0001\u0007q0\u0001\u0004tK\u000e|g\u000eZ\u0001\u000bS:4WM\u001d$jK2$GCBA\u0001\u0003K\tI\u0003C\u0004\u0002(9\u0001\r!!\u0001\u0002\u0013QL\b/Z*p\r\u0006\u0014\bBBA\u0016\u001d\u0001\u0007a*A\u0003gS\u0016dG-\u0001\u0006jg&sgm\u0014:OC:$B!!\r\u00028A\u00191&a\r\n\u0007\u0005UBFA\u0004C_>dW-\u00198\t\r\u0005-r\u00021\u0001O\u0003=!(/\u001f)beN,\u0017J\u001c;fO\u0016\u0014H\u0003BA\u0001\u0003{Aa!a\u000b\u0011\u0001\u0004q\u0015\u0001\u0004;ssB\u000b'o]3M_:<G\u0003BA\u0001\u0003\u0007Ba!a\u000b\u0012\u0001\u0004q\u0015a\u0004;ssB\u000b'o]3EK\u000eLW.\u00197\u0015\t\u0005\u0005\u0011\u0011\n\u0005\u0007\u0003W\u0011\u0002\u0019\u0001(\u0002\u001dQ\u0014\u0018\u0010U1sg\u0016$u.\u001e2mKR!\u0011\u0011AA(\u0011\u0019\tYc\u0005a\u0001\u001d\u0006!BO]=QCJ\u001cX\rV5nKN$\u0018-\u001c9O)j#B!!\u0001\u0002V!1\u00111\u0006\u000bA\u00029\u000b\u0011\u0003\u001e:z!\u0006\u00148/\u001a+j[\u0016\u001cH/Y7q)\u0011\t\t!a\u0017\t\r\u0005-R\u00031\u0001O\u0003=!(/\u001f)beN,'i\\8mK\u0006tG\u0003BA\u0001\u0003CBa!a\u000b\u0017\u0001\u0004q\u0015AC:ue&tw\rV=qKR\u0011\u0011\u0011A\u0001\u000fG>l\u0007/\u0019;jE2,G+\u001f9f)\u0019\tY'!\u001d\u0002vA)1&!\u001c\u0002\u0002%\u0019\u0011q\u000e\u0017\u0003\r=\u0003H/[8o\u0011\u001d\t\u0019\b\u0007a\u0001\u0003\u0003\t!\u0001^\u0019\t\u000f\u0005]\u0004\u00041\u0001\u0002\u0002\u0005\u0011AOM\u0001\u0019M&tGmQ8na\u0006$\u0018N\u00197f)f\u0004XMR8s\u0007N3VCAA?!%Y\u0013qPA\u0001\u0003\u0003\tY'C\u0002\u0002\u00022\u0012\u0011BR;oGRLwN\u001c\u001a\u00023\u0019Lg\u000eZ\"p[B\fG/\u001b2mKRK\b/\u001a$pe\u000e\u001bf\u000b\t")
public class CSVInferSchema
implements scala.Serializable {
    private final CSVOptions options;
    private final TimestampFormatter timestampParser;
    private final TimestampFormatter timestampNTZFormatter;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV;

    public CSVOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header) {
        StructField[] structFieldArray;
        if (this.options().inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable & scala.Serializable)(rowSoFar, next) -> this.inferRowType((DataType[])rowSoFar, (String[])next), (Function2 & Serializable & scala.Serializable)(first, second) -> this.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = this.toStructFields(rootTypes, header);
        } else {
            structFieldArray = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).map((Function1 & Serializable & scala.Serializable)fieldName -> new StructField((String)fieldName, StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public StructField[] toStructFields(DataType[] fieldTypes, String[] header) {
        return (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String thisHeader = (String)tuple2._1();
            DataType rootType = (DataType)tuple2._2();
            DataType dataType = rootType;
            DataType dataType2 = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
            DataType dType = dataType2;
            StructField structField = new StructField(thisHeader, dType, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public DataType[] inferRowType(DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i]);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])first)).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            DataType dataType = (DataType)this.compatibleType(a, b).getOrElse((Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$);
            return dataType;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public DataType inferField(DataType typeSoFar, String field) {
        DataType dataType;
        DataType dataType2;
        block21: {
            block20: {
                if (field == null || field.isEmpty()) break block20;
                String string = field;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block21;
            }
            dataType2 = typeSoFar;
            return dataType2;
        }
        DataType dataType3 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (LongType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseLong(field);
        } else if (dataType3 instanceof DecimalType) {
            dataType = this.tryParseDecimal(field);
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseDouble(field);
        } else if (TimestampNTZType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseTimestampNTZ(field);
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseTimestamp(field);
        } else if (BooleanType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseBoolean(field);
        } else {
            if (!StringType$.MODULE$.equals(dataType3)) {
                if (dataType3 == null) throw new MatchError((Object)dataType3);
                DataType dataType4 = dataType3;
                throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType4);
            }
            dataType = StringType$.MODULE$;
        }
        DataType typeElemInfer = dataType;
        dataType2 = (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
        return dataType2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field) {
        String string = field;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toInt()).isDefined() ? IntegerType$.MODULE$ : this.tryParseLong(field);
    }

    private DataType tryParseLong(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toLong()).isDefined() ? LongType$.MODULE$ : this.tryParseDecimal(field);
    }

    private DataType tryParseDecimal(String field) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field);
            return bigDecimal.scale() <= 0 ? new DecimalType(bigDecimal.precision(), bigDecimal.scale()) : this.tryParseDouble(field);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.tryParseDouble(field));
    }

    private DataType tryParseDouble(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toDouble()).isDefined() || this.isInfOrNan(field) ? DoubleType$.MODULE$ : this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseTimestampNTZ(String field) {
        return this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined() ? SQLConf$.MODULE$.get().timestampType() : this.tryParseTimestamp(field);
    }

    private DataType tryParseTimestamp(String field) {
        return this.timestampParser().parseOptional(field).isDefined() ? TimestampType$.MODULE$ : this.tryParseBoolean(field);
    }

    private DataType tryParseBoolean(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toBoolean()).isDefined() ? BooleanType$.MODULE$ : this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        return ((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)this.findCompatibleTypeForCSV().apply((Object)t1, (Object)t2));
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV() {
        return this.findCompatibleTypeForCSV;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForCSV$1(CSVInferSchema $this, DataType x0$1, DataType x1$1) {
        block5: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    var6_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                                                    if (var6_3 == null || !StringType$.MODULE$.equals(var7_4 = (DataType)var6_3._1())) break block4;
                                                    var3_5 /* !! */  = new Some((Object)StringType$.MODULE$);
                                                    break block5;
                                                }
                                                if (var6_3 == null || !StringType$.MODULE$.equals(var8_6 = (DataType)var6_3._2())) break block6;
                                                var3_5 /* !! */  = new Some((Object)StringType$.MODULE$);
                                                break block5;
                                            }
                                            if (var6_3 == null) break block7;
                                            t1 = (DataType)var6_3._1();
                                            t2 = (DataType)var6_3._2();
                                            if (!(t1 instanceof IntegralType)) break block7;
                                            var11_9 = (IntegralType)t1;
                                            if (!(t2 instanceof DecimalType)) break block7;
                                            var12_10 = (DecimalType)t2;
                                            var3_5 /* !! */  = $this.compatibleType(DecimalType$.MODULE$.forType(var11_9), var12_10);
                                            break block5;
                                        }
                                        if (var6_3 == null) break block8;
                                        t1 = (DataType)var6_3._1();
                                        t2 = (DataType)var6_3._2();
                                        if (!(t1 instanceof DecimalType)) break block8;
                                        var15_13 = (DecimalType)t1;
                                        if (!(t2 instanceof IntegralType)) break block8;
                                        var16_14 = (IntegralType)t2;
                                        var3_5 /* !! */  = $this.compatibleType(var15_13, DecimalType$.MODULE$.forType(var16_14));
                                        break block5;
                                    }
                                    if (var6_3 == null || !DoubleType$.MODULE$.equals(var17_15 = (DataType)var6_3._1()) || !(var6_3._2() instanceof DecimalType)) break block9;
                                    var5_16 = true;
                                    break block10;
                                }
                                if (var6_3 == null) ** GOTO lbl-1000
                                var18_17 = (DataType)var6_3._2();
                                if (var6_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var18_17)) {
                                    var5_16 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var5_16 = false;
                                }
                            }
                            if (!var5_16) break block11;
                            var3_5 /* !! */  = new Some((Object)DoubleType$.MODULE$);
                            break block5;
                        }
                        if (var6_3 == null) break block12;
                        t1 = (DataType)var6_3._1();
                        t2 = (DataType)var6_3._2();
                        if (!(t1 instanceof DecimalType)) break block12;
                        var21_20 = (DecimalType)t1;
                        if (!(t2 instanceof DecimalType)) break block12;
                        var22_21 = (DecimalType)t2;
                        scale = package$.MODULE$.max(var21_20.scale(), var22_21.scale());
                        range = package$.MODULE$.max(var21_20.precision() - var21_20.scale(), var22_21.precision() - var22_21.scale());
                        var3_5 /* !! */  = range + scale > 38 ? new Some((Object)DoubleType$.MODULE$) : new Some((Object)new DecimalType(range + scale, scale));
                        break block5;
                    }
                    if (var6_3 == null) break block13;
                    var25_24 = (DataType)var6_3._1();
                    var26_25 = (DataType)var6_3._2();
                    if (!TimestampNTZType$.MODULE$.equals(var25_24) || !TimestampType$.MODULE$.equals(var26_25)) break block13;
                    var4_26 = true;
                    break block14;
                }
                if (var6_3 == null) ** GOTO lbl-1000
                var27_27 = (DataType)var6_3._1();
                var28_28 = (DataType)var6_3._2();
                if (TimestampType$.MODULE$.equals(var27_27) && TimestampNTZType$.MODULE$.equals(var28_28)) {
                    var4_26 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var4_26 = false;
                }
            }
            var3_5 /* !! */  = var4_26 ? new Some((Object)TimestampType$.MODULE$) : None$.MODULE$;
        }
        return var3_5 /* !! */ ;
    }

    public CSVInferSchema(CSVOptions options) {
        this.options = options;
        this.timestampParser = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        Locale locale = options.locale();
        Locale locale2 = Locale.US;
        this.decimalParser = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? s -> new BigDecimal((String)s) : ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.findCompatibleTypeForCSV = (arg_0, arg_1) -> CSVInferSchema.$anonfun$findCompatibleTypeForCSV$1(this, arg_0, arg_1);
    }
}

