/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Atan2$;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(exprY, exprX) - Returns the angle in radians between the positive x-axis of a plane\n      and the point given by the coordinates (`exprX`, `exprY`), as if computed by\n      `java.lang.Math._FUNC_`.\n  ", arguments="\n    Arguments:\n      * exprY - coordinate on y-axis\n      * exprX - coordinate on x-axis\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 0);\n       0.0\n  ", since="1.4.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\r\u001b\u0001\u001eB\u0001\"\u000e\u0001\u0003\u0016\u0004%\tA\u000e\u0005\tu\u0001\u0011\t\u0012)A\u0005o!A1\b\u0001BK\u0002\u0013\u0005a\u0007\u0003\u0005=\u0001\tE\t\u0015!\u00038\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0011\u0005\u0001\"\u0015D\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015Q\u0006\u0001\"\u0015\\\u0011\u001d\u0001\u0007!!A\u0005\u0002\u0005Dq\u0001\u001a\u0001\u0012\u0002\u0013\u0005Q\rC\u0004q\u0001E\u0005I\u0011A3\t\u000fE\u0004\u0011\u0011!C!e\"91\u0010AA\u0001\n\u0003a\b\"CA\u0001\u0001\u0005\u0005I\u0011AA\u0002\u0011%\tI\u0001AA\u0001\n\u0003\nY\u0001C\u0005\u0002\u001a\u0001\t\t\u0011\"\u0001\u0002\u001c!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0013qE\u0004\n\u0003#R\u0012\u0011!E\u0001\u0003'2\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011Q\u000b\u0005\u0007{M!\t!a\u0019\t\u0013\u0005\u00154#!A\u0005F\u0005\u001d\u0004\"CA5'\u0005\u0005I\u0011QA6\u0011%\t\thEA\u0001\n\u0003\u000b\u0019\bC\u0005\u0002\u0006N\t\t\u0011\"\u0003\u0002\b\n)\u0011\t^1oe)\u00111\u0004H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001e=\u0005A1-\u0019;bYf\u001cHO\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!B:qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001Q1\u0012\u0004CA\u0015+\u001b\u0005Q\u0012BA\u0016\u001b\u0005Q\u0011\u0015N\\1ss6\u000bG\u000f[#yaJ,7o]5p]B\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t9\u0001K]8ek\u000e$\bCA\u00174\u0013\t!dF\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#A\u001c\u0011\u0005%B\u0014BA\u001d\u001b\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\ry\u0004)\u0011\t\u0003S\u0001AQ!N\u0003A\u0002]BQaO\u0003A\u0002]\nAB\\;mYN\u000bg-Z#wC2$2\u0001R$J!\tiS)\u0003\u0002G]\t\u0019\u0011I\\=\t\u000b!3\u0001\u0019\u0001#\u0002\r%t\u0007/\u001e;2\u0011\u0015Qe\u00011\u0001E\u0003\u0019Ig\u000e];ue\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0004\u001bNC\u0006C\u0001(R\u001b\u0005y%B\u0001)\u001b\u0003\u001d\u0019w\u000eZ3hK:L!AU(\u0003\u0011\u0015C\bO]\"pI\u0016DQ\u0001V\u0004A\u0002U\u000b1a\u0019;y!\tqe+\u0003\u0002X\u001f\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B-\b\u0001\u0004i\u0015AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u000289zCQ!\u0018\u0005A\u0002]\nqA\\3x\u0019\u00164G\u000fC\u0003`\u0011\u0001\u0007q'\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0007}\u00127\rC\u00046\u0013A\u0005\t\u0019A\u001c\t\u000fmJ\u0001\u0013!a\u0001o\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00014+\u0005]:7&\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!C;oG\",7m[3e\u0015\tig&\u0001\u0006b]:|G/\u0019;j_:L!a\u001c6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011a\u0017M\\4\u000b\u0003a\fAA[1wC&\u0011!0\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003u\u0004\"!\f@\n\u0005}t#aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001#\u0002\u0006!A\u0011q\u0001\b\u0002\u0002\u0003\u0007Q0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001b\u0001R!a\u0004\u0002\u0016\u0011k!!!\u0005\u000b\u0007\u0005Ma&\u0001\u0006d_2dWm\u0019;j_:LA!a\u0006\u0002\u0012\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti\"a\t\u0011\u00075\ny\"C\u0002\u0002\"9\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\bA\t\t\u00111\u0001E\u0003\u0019)\u0017/^1mgR!\u0011QDA\u0015\u0011!\t9!EA\u0001\u0002\u0004!\u0005f\u0006\u0001\u0002.\u0005M\u0012QGA\u001d\u0003w\ty$!\u0011\u0002F\u0005\u001d\u00131JA'!\rI\u0013qF\u0005\u0004\u0003cQ\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003o\t\u0011\u0011\u0016\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9s32\u0002S\r\u001f9s1&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013M\\4mK\u0002Jg\u000e\t:bI&\fgn\u001d\u0011cKR<X-\u001a8!i\",\u0007\u0005]8tSRLg/\u001a\u0011y[\u0005D\u0018n\u001d\u0011pM\u0002\n\u0007\u0005\u001d7b]\u0016T\u0001\u0005\t\u0011!A\u0001\ng\u000e\u001a\u0011uQ\u0016\u0004\u0003o\\5oi\u0002:\u0017N^3oA\tL\b\u0005\u001e5fA\r|wN\u001d3j]\u0006$Xm\u001d\u0011)A\u0016D\bO\u001d-aY\u0001\u0002W\r\u001f9s3\u0002LC\u0006I1tA%4\u0007eY8naV$X\r\u001a\u0011cs*\u0001\u0003\u0005\t\u0011!A\u0001T\u0017M^1/Y\u0006twML'bi\"tsLR+O\u0007~\u0003gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002>\u0005a&\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\fI\u0017!G>|'\u000fZ5oCR,\u0007e\u001c8!s6\n\u00070[:\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO\u001d-![\u0001\u001awn\u001c:eS:\fG/\u001a\u0011p]\u0002BX&\u0019=jg*\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019%A\u001d\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QAb\u0003\u0005M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAr\u0003G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tI%A\u00032]Qr\u0003'A\u0003he>,\b/\t\u0002\u0002P\u0005QQ.\u0019;i?\u001a,hnY:\u0002\u000b\u0005#\u0018M\u001c\u001a\u0011\u0005%\u001a2\u0003B\n\u0002XI\u0002r!!\u0017\u0002`]:t(\u0004\u0002\u0002\\)\u0019\u0011Q\f\u0018\u0002\u000fI,h\u000e^5nK&!\u0011\u0011MA.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003'\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002g\u0006)\u0011\r\u001d9msR)q(!\u001c\u0002p!)QG\u0006a\u0001o!)1H\u0006a\u0001o\u00059QO\\1qa2LH\u0003BA;\u0003\u0003\u0003R!LA<\u0003wJ1!!\u001f/\u0005\u0019y\u0005\u000f^5p]B)Q&! 8o%\u0019\u0011q\u0010\u0018\u0003\rQ+\b\u000f\\33\u0011!\t\u0019iFA\u0001\u0002\u0004y\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\tE\u0002u\u0003\u0017K1!!$v\u0005\u0019y%M[3di\u0002")
public class Atan2
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Atan2 atan2) {
        return Atan2$.MODULE$.unapply(atan2);
    }

    public static Function1<Tuple2<Expression, Expression>, Atan2> tupled() {
        return Atan2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Atan2>> curried() {
        return Atan2$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(BoxesRunTime.unboxToDouble((Object)input1) + 0.0, BoxesRunTime.unboxToDouble((Object)input2) + 0.0));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(c1, c2) -> new StringBuilder(36).append("java.lang.Math.atan2(").append((String)c1).append(" + 0.0, ").append((String)c2).append(" + 0.0)").toString());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Atan2 copy(Expression left, Expression right) {
        return new Atan2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Atan2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Atan2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Atan2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Atan2 atan2 = (Atan2)x$1;
        Expression expression = this.left();
        Expression expression2 = atan2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = atan2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!atan2.canEqual(this)) return false;
        return true;
    }

    public Atan2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double y, double x) {
                return this.apply$mcDDD$sp(y, x);
            }

            public double apply$mcDDD$sp(double y, double x) {
                return package$.MODULE$.atan2(y, x);
            }
        }, "ATAN2");
    }
}

