/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Randn$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) values drawn from the standard normal distribution.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       -0.3254147983080288\n      > SELECT _FUNC_(0);\n       1.6034991609278433\n      > SELECT _FUNC_(null);\n       1.6034991609278433\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u00051\t\u0003\u0005H\u0001\tE\t\u0015!\u0003E\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015A\u0005\u0001\"\u0001N\u0011\u0015A\u0005\u0001\"\u0001O\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u00159\u0006\u0001\"\u0015Y\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015\t\b\u0001\"\u0011s\u0011\u00191\u0003\u0001\"\u0011\u0002\u0006!9\u0011q\u0003\u0001\u0005R\u0005e\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\t9\u0003AI\u0001\n\u0003\tI\u0003C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013q\t\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u0005%\u0004!!A\u0005B\u0005-\u0004\"CA<\u0001\u0005\u0005I\u0011AA=\u0011%\ti\bAA\u0001\n\u0003\nyhB\u0004\u0002*\u0006B\t!a+\u0007\r\u0001\n\u0003\u0012AAW\u0011\u0019A\u0005\u0004\"\u0001\u00026\"9\u0011q\u0017\r\u0005\u0002\u0005e\u0006\"CA\\1\u0005\u0005I\u0011QA_\u0011%\t\u0019\rGI\u0001\n\u0003\t\t\u0005C\u0005\u0002Fb\t\t\u0011\"!\u0002H\"I\u0011\u0011\u001c\r\u0012\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u00037D\u0012\u0011!C\u0005\u0003;\u0014QAU1oI:T!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0015\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0005\u0001=\u001a\u0014\b\u0005\u00021c5\t\u0011%\u0003\u00023C\t\u0019!\u000bR$\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011AGO\u0005\u0003wU\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012A\u0010\t\u0003a}J!\u0001Q\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\tQ&$WmU3fIV\tA\t\u0005\u00025\u000b&\u0011a)\u000e\u0002\b\u0005>|G.Z1o\u0003%A\u0017\u000eZ3TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0015.c\u0005C\u0001\u0019\u0001\u0011\u0015aT\u00011\u0001?\u0011\u001d\u0011U\u0001%AA\u0002\u0011#\u0012A\u0013\u000b\u0003\u0015>CQ\u0001P\u0004A\u0002y\n1b^5uQ:+woU3fIR\u0011!J\u0015\u0005\u0006'\"\u0001\r\u0001V\u0001\u0005g\u0016,G\r\u0005\u00025+&\u0011a+\u000e\u0002\u0005\u0019>tw-\u0001\u0007fm\u0006d\u0017J\u001c;fe:\fG\u000e\u0006\u0002Z9B\u0011AGW\u0005\u00037V\u0012a\u0001R8vE2,\u0007\"B/\n\u0001\u0004q\u0016!B5oaV$\bCA0a\u001b\u0005\u0019\u0013BA1$\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00013k_B\u0011Q\r[\u0007\u0002M*\u0011q-I\u0001\bG>$WmZ3o\u0013\tIgM\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015Y'\u00021\u0001m\u0003\r\u0019G\u000f\u001f\t\u0003K6L!A\u001c4\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")\u0001O\u0003a\u0001I\u0006\u0011QM^\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0003M\u00042\u0001\u001e?\u0000\u001d\t)(P\u0004\u0002ws6\tqO\u0003\u0002y[\u00051AH]8pizJ\u0011AN\u0005\u0003wV\nq\u0001]1dW\u0006<W-\u0003\u0002~}\nA\u0011\n^3sCR|'O\u0003\u0002|kA\u0019A'!\u0001\n\u0007\u0005\rQGA\u0002B]f,\"!a\u0002\u0011\t\u0005%\u0011\u0011\u0003\b\u0005\u0003\u0017\ti\u0001\u0005\u0002wk%\u0019\u0011qB\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019\"!\u0006\u0003\rM#(/\u001b8h\u0015\r\ty!N\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007)\u000bY\u0002\u0003\u0004\u0002\u001e5\u0001\rAP\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u0015Q\u00151EA\u0013\u0011\u001dad\u0002%AA\u0002yBqA\u0011\b\u0011\u0002\u0003\u0007A)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-\"f\u0001 \u0002.-\u0012\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0002:U\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti$a\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r#f\u0001#\u0002.\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0013\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005!A.\u00198h\u0015\t\t\u0019&\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u001b\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0017\u0011\u0007Q\ni&C\u0002\u0002`U\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a`A3\u0011%\t9gEA\u0001\u0002\u0004\tY&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003[\u0002R!a\u001c\u0002v}l!!!\u001d\u000b\u0007\u0005MT'\u0001\u0006d_2dWm\u0019;j_:L1!`A9\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001#\u0002|!A\u0011qM\u000b\u0002\u0002\u0003\u0007q0\u0001\u0004fcV\fGn\u001d\u000b\u0004\t\u0006\u0005\u0005\u0002CA4-\u0005\u0005\t\u0019A@)/\u0001\t))a#\u0002\u000e\u0006E\u00151SAL\u00033\u000bi*a(\u0002$\u0006\u0015\u0006c\u0001\u0019\u0002\b&\u0019\u0011\u0011R\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qR\u0001\u0002$}3UKT\"`Qm\u001bX-\u001a3^S\u0001j\u0003EU3ukJt7\u000fI1!e\u0006tGm\\7!m\u0006dW/\u001a\u0011xSRD\u0007%\u001b8eKB,g\u000eZ3oi\u0002\ng\u000e\u001a\u0011jI\u0016tG/[2bY2L\b\u0005Z5tiJL'-\u001e;fI\u0002B\u0013NL5/I:J\u0003E^1mk\u0016\u001c\b\u0005\u001a:bo:\u0004cM]8nAQDW\rI:uC:$\u0017M\u001d3!]>\u0014X.\u00197!I&\u001cHO]5ckRLwN\u001c\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!&\u0002\u0003CR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011![Ar3GM\u001b5cQ:\u0014\bO\u001a1qA\u0012\u0004\b\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u00187aM\"\u0014(O\u00197ae\u0012t\u0007\u000f\u001b4g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.\u001e7mSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\f\u001c1gQJ\u0014(\r\u001c1sI:\u0004\bN\u001a4\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!a'\u0002u)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\rI5oA\u001d,g.\u001a:bY\u0002\u001a\u0017m]3/\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAQ\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\t9+\u0001\u0006nCRDwLZ;oGN\fQAU1oI:\u0004\"\u0001\r\r\u0014\ta\ty+\u000f\t\u0004i\u0005E\u0016bAAZk\t1\u0011I\\=SK\u001a$\"!a+\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007)\u000bY\fC\u0003T5\u0001\u0007A\u000bF\u0003K\u0003\u007f\u000b\t\rC\u0003=7\u0001\u0007a\bC\u0004C7A\u0005\t\u0019\u0001#\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002J\u0006U\u0007#\u0002\u001b\u0002L\u0006=\u0017bAAgk\t1q\n\u001d;j_:\u0004R\u0001NAi}\u0011K1!a56\u0005\u0019!V\u000f\u001d7fe!A\u0011q[\u000f\u0002\u0002\u0003\u0007!*A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a8\u0011\t\u0005-\u0013\u0011]\u0005\u0005\u0003G\fiE\u0001\u0004PE*,7\r\u001e")
public class Randn
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Randn$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Randn randn) {
        return Randn$.MODULE$.unapply(randn);
    }

    public static boolean apply$default$2() {
        return Randn$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Randn withNewSeed(long seed) {
        return new Randn(new Literal(BoxesRunTime.boxToLong((long)seed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextGaussian();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextGaussian();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(7).append("randn(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    @Override
    public Randn withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Randn copy(Expression child, boolean hideSeed) {
        return new Randn(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Randn";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Randn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Randn)) return false;
        boolean bl = true;
        if (!bl) return false;
        Randn randn = (Randn)x$1;
        Expression expression = this.child();
        Expression expression2 = randn.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.hideSeed() != randn.hideSeed()) return false;
        if (!randn.canEqual(this)) return false;
        return true;
    }

    public Randn(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Randn() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Randn(Expression child) {
        this(child, false);
    }
}

