/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IntegerLiteral$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NonNullLiteral$;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class TimeWindow$
implements Serializable {
    public static TimeWindow$ MODULE$;
    private final String marker;

    static {
        new TimeWindow$();
    }

    public String marker() {
        return this.marker;
    }

    public long getIntervalInMicroSeconds(String interval) {
        CalendarInterval cal = IntervalUtils$.MODULE$.fromIntervalString(interval);
        if (cal.months != 0) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Intervals greater than a month is not supported (").append(interval).append(").").toString());
        }
        return Math.addExact(Math.multiplyExact((long)cal.days, 86400000000L), cal.microseconds);
    }

    public long parseExpression(Expression expr) {
        Option<Tuple2<Object, DataType>> option;
        Option<Object> option2;
        boolean bl = false;
        Literal literal = null;
        Expression expression = expr;
        if (expression instanceof Literal) {
            bl = true;
            literal = (Literal)expression;
            Option<Tuple2<Object, DataType>> option3 = NonNullLiteral$.MODULE$.unapply(literal);
            if (!option3.isEmpty()) {
                Object s = ((Tuple2)option3.get())._1();
                DataType dataType = (DataType)((Tuple2)option3.get())._2();
                if (StringType$.MODULE$.equals(dataType)) {
                    return this.getIntervalInMicroSeconds(s.toString());
                }
            }
        }
        if (!(option2 = IntegerLiteral$.MODULE$.unapply(expression)).isEmpty()) {
            int i = BoxesRunTime.unboxToInt((Object)option2.get());
            return i;
        }
        if (bl && !(option = NonNullLiteral$.MODULE$.unapply(literal)).isEmpty()) {
            Object l = ((Tuple2)option.get())._1();
            DataType dataType = (DataType)((Tuple2)option.get())._2();
            if (LongType$.MODULE$.equals(dataType)) {
                return new StringOps(Predef$.MODULE$.augmentString(l.toString())).toLong();
            }
        }
        throw QueryCompilationErrors$.MODULE$.invalidLiteralForWindowDurationError();
    }

    public TimeWindow apply(Expression timeColumn, String windowDuration, String slideDuration, String startTime) {
        return new TimeWindow(timeColumn, this.getIntervalInMicroSeconds(windowDuration), this.getIntervalInMicroSeconds(slideDuration), this.getIntervalInMicroSeconds(startTime));
    }

    public TimeWindow apply(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        return new TimeWindow(timeColumn, windowDuration, slideDuration, startTime);
    }

    public Option<Tuple4<Expression, Object, Object, Object>> unapply(TimeWindow x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.timeColumn(), (Object)BoxesRunTime.boxToLong((long)x$0.windowDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.slideDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.startTime())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TimeWindow$() {
        MODULE$ = this;
        this.marker = "spark.timeWindow";
    }
}

