/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.7604953758285915\n      > SELECT _FUNC_(null);\n       0.7604953758285915\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0012$\u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Y\u0011\u0015\u0019\u0006\u0001\"\u0001Z\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0011\u0007\u0001\"\u0015d\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015a\b\u0001\"\u0011Y\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u0019A\u0003\u0001\"\u0011\u0002\f!9\u0011Q\u0004\u0001\u0005R\u0005}\u0001\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u0011%\ti\u0003AI\u0001\n\u0003\ty\u0003C\u0005\u0002F\u0001\t\n\u0011\"\u0001\u0002H!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013Q\n\u0005\n\u0003;\u0002\u0011\u0011!C\u0001\u0003?B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t\u0019\tAA\u0001\n\u0003\n)\tC\u0005\u0002\n\u0002\t\t\u0011\"\u0011\u0002\f\u001e9\u0011QW\u0012\t\u0002\u0005]fA\u0002\u0012$\u0011\u0003\tI\f\u0003\u0004T5\u0011\u0005\u00111\u001a\u0005\b\u0003\u001bTB\u0011AAh\u0011%\tiMGA\u0001\n\u0003\u000b\u0019\u000eC\u0005\u0002Zj\t\n\u0011\"\u0001\u0002H!I\u00111\u001c\u000e\u0002\u0002\u0013\u0005\u0015Q\u001c\u0005\n\u0003_T\u0012\u0013!C\u0001\u0003\u000fB\u0011\"!=\u001b\u0003\u0003%I!a=\u0003\tI\u000bg\u000e\u001a\u0006\u0003I\u0015\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011aeJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M!\u0001!M\u001b<!\t\u00114'D\u0001$\u0013\t!4EA\u0002S\t\u001e\u0003\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002=\t:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001>\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005\r;\u0014a\u00029bG.\fw-Z\u0005\u0003\u000b\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aQ\u001c\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003%\u0003\"A\r&\n\u0005-\u001b#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n\u0001\u0002[5eKN+W\rZ\u000b\u0002\u001fB\u0011a\u0007U\u0005\u0003#^\u0012qAQ8pY\u0016\fg.A\u0005iS\u0012,7+Z3eA\u00051A(\u001b8jiz\"2!\u0016,X!\t\u0011\u0004\u0001C\u0003H\u000b\u0001\u0007\u0011\nC\u0004N\u000bA\u0005\t\u0019A(\u0015\u0003U#\"!\u0016.\t\u000b\u001d;\u0001\u0019A%\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003+vCQA\u0018\u0005A\u0002}\u000bAa]3fIB\u0011a\u0007Y\u0005\u0003C^\u0012A\u0001T8oO\u0006aQM^1m\u0013:$XM\u001d8bYR\u0011Am\u001a\t\u0003m\u0015L!AZ\u001c\u0003\r\u0011{WO\u00197f\u0011\u0015A\u0017\u00021\u0001j\u0003\u0015Ig\u000e];u!\tQ7.D\u0001&\u0013\taWEA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\ryWO\u001f\t\u0003aNl\u0011!\u001d\u0006\u0003e\u000e\nqaY8eK\u001e,g.\u0003\u0002uc\nAQ\t\u001f9s\u0007>$W\rC\u0003w\u0015\u0001\u0007q/A\u0002dib\u0004\"\u0001\u001d=\n\u0005e\f(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006w*\u0001\ra\\\u0001\u0003KZ\f\u0011B\u001a:fg\"\u001cu\u000e]=\u0002\u001b\u0019d\u0017\r^!sOVlWM\u001c;t+\u0005y\b#\u0002\u001f\u0002\u0002\u0005\u0015\u0011bAA\u0002\r\nA\u0011\n^3sCR|'\u000fE\u00027\u0003\u000fI1!!\u00038\u0005\r\te._\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00189!\u0011\u0011CA\n!\tqt'C\u0002\u0002\u0016]\na\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000bo\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2!VA\u0011\u0011\u0019\t\u0019C\u0004a\u0001\u0013\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#B+\u0002*\u0005-\u0002bB$\u0010!\u0003\u0005\r!\u0013\u0005\b\u001b>\u0001\n\u00111\u0001P\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\r+\u0007%\u000b\u0019d\u000b\u0002\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012!C;oG\",7m[3e\u0015\r\tydN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\"\u0003s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0013+\u0007=\u000b\u0019$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002\\5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003mC:<'BAA-\u0003\u0011Q\u0017M^1\n\t\u0005e\u00111K\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00022ANA2\u0013\r\t)g\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000b\tY\u0007C\u0005\u0002nQ\t\t\u00111\u0001\u0002b\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001d\u0011\r\u0005U\u00141PA\u0003\u001b\t\t9HC\u0002\u0002z]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019!a\u001e\u0002\u0011\r\fg.R9vC2$2aTAA\u0011%\tiGFA\u0001\u0002\u0004\t)!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA(\u0003\u000fC\u0011\"!\u001c\u0018\u0003\u0003\u0005\r!!\u0019\u0002\r\u0015\fX/\u00197t)\ry\u0015Q\u0012\u0005\n\u0003[B\u0012\u0011!a\u0001\u0003\u000bAs\u0003AAI\u0003/\u000bI*!(\u0002 \u0006\r\u0016QUAU\u0003W\u000by+!-\u0011\u0007I\n\u0019*C\u0002\u0002\u0016\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u001c\u0006\tYa\u0018$V\u001d\u000e{\u0006fW:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!S:$W\r]3oI\u0016tG\u000fI1oI\u0002JG-\u001a8uS\u000e\fG\u000e\\=!I&\u001cHO]5ckR,G\r\t\u0015j]%tCML\u0015!k:Lgm\u001c:nYf\u0004C-[:ue&\u0014W\u000f^3eAY\fG.^3tA%t\u0007e\u0017\u0019-AEJc&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t+AA0\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019/sY\u0012\u0014h\u000e\u001b3sU\nDg\r\u001b6iMR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AArsG\u000e\u00195sU\u001at'\u000e\u001d3qUJ\u0014'\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9:d\u0007\r\u001b:kM:T\u0007\u000f\u001a9ke\nTG\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005\u001d\u0016A\u000f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg\u000eI4f]\u0016\u0014\u0018\r\u001c\u0011dCN,gF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti+A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u00024\u0006QQ.\u0019;i?\u001a,hnY:\u0002\tI\u000bg\u000e\u001a\t\u0003ei\u0019RAGA^\u0003\u0003\u00042ANA_\u0013\r\tyl\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bTA!a2\u0002X\u0005\u0011\u0011n\\\u0005\u0004\u000b\u0006\u0015GCAA\\\u0003\u0015\t\u0007\u000f\u001d7z)\r)\u0016\u0011\u001b\u0005\u0006=r\u0001\ra\u0018\u000b\u0006+\u0006U\u0017q\u001b\u0005\u0006\u000fv\u0001\r!\u0013\u0005\b\u001bv\u0001\n\u00111\u0001P\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003?\fY\u000fE\u00037\u0003C\f)/C\u0002\u0002d^\u0012aa\u00149uS>t\u0007#\u0002\u001c\u0002h&{\u0015bAAuo\t1A+\u001e9mKJB\u0001\"!< \u0003\u0003\u0005\r!V\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002vB!\u0011\u0011KA|\u0013\u0011\tI0a\u0015\u0003\r=\u0013'.Z2u\u0001")
public class Rand
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Rand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Rand x$0) {
        return Rand$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Rand$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Rand freshCopy() {
        return new Rand(this.child(), this.hideSeed());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(6).append("rand(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    @Override
    public Rand withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Rand copy(Expression child, boolean hideSeed) {
        return new Rand(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "hideSeed";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        if (this.hideSeed() != rand.hideSeed()) return false;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Rand() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Rand(Expression child) {
        this(child, false);
    }
}

