/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.HyperLogLogPlusPlusHelper;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr[, relativeSD]) - Returns the estimated cardinality by HyperLogLog++.\n      `relativeSD` defines the maximum relative standard deviation allowed.", examples="\n    Examples:\n      > SELECT _FUNC_(col1) FROM VALUES (1), (1), (2), (2), (3) tab(col1);\n       3\n  ", group="agg_funcs", since="1.6.0")
@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u001c9\u0001\u001eC\u0001\u0002\u001b\u0001\u0003\u0016\u0004%\t!\u001b\u0005\tU\u0002\u0011\t\u0012)A\u0005%\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\tE\t\u0015!\u0003n\u0011!\t\bA!f\u0001\n\u0003\u0011\b\u0002\u0003<\u0001\u0005#\u0005\u000b\u0011B:\t\u0011]\u0004!Q3A\u0005\u0002ID\u0001\u0002\u001f\u0001\u0003\u0012\u0003\u0006Ia\u001d\u0005\u0006s\u0002!\tA\u001f\u0005\u0007s\u0002!\t!!\u0001\t\re\u0004A\u0011AA\u0003\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003'\u0002A\u0011IA+\u0011%\t\u0019\u0007\u0001b\u0001\n\u0003\t)\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA4\u0011%\t)\b\u0001b\u0001\n\u0003\n9\b\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA=\u0011%\t9\t\u0001b\u0001\n\u0003\n9\b\u0003\u0005\u0002\n\u0002\u0001\u000b\u0011BA=\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u00111\u0019\u0001\u0005R\u0005\u0015\u0007\"CAf\u0001\u0005\u0005I\u0011AAg\u0011%\t9\u000eAI\u0001\n\u0003\tI\u000eC\u0005\u0002p\u0002\t\n\u0011\"\u0001\u0002r\"I\u0011Q\u001f\u0001\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0003w\u0004\u0011\u0013!C\u0001\u0003oD\u0011\"!@\u0001\u0003\u0003%\t%a@\t\u0011\t=\u0001!!A\u0005\u0002ID\u0011B!\u0005\u0001\u0003\u0003%\tAa\u0005\t\u0013\te\u0001!!A\u0005B\tm\u0001\"\u0003B\u0015\u0001\u0005\u0005I\u0011\u0001B\u0016\u0011%\u0011y\u0003AA\u0001\n\u0003\u0012\t\u0004C\u0005\u00036\u0001\t\t\u0011\"\u0011\u00038\u001d9!1\f\u001d\t\u0002\tucAB\u001c9\u0011\u0003\u0011y\u0006\u0003\u0004zW\u0011\u0005!\u0011\u000f\u0005\b\u0005gZC\u0011\u0001B;\u0011%\u0011YhKA\u0001\n\u0003\u0013i\bC\u0005\u0003\b.\n\n\u0011\"\u0001\u0002r\"I!\u0011R\u0016\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0005\u0017[\u0013\u0013!C\u0001\u0003oD\u0011B!$,\u0003\u0003%\tIa$\t\u0013\tu5&%A\u0005\u0002\u0005E\b\"\u0003BPWE\u0005I\u0011AA|\u0011%\u0011\tkKI\u0001\n\u0003\t9\u0010C\u0005\u0003$.\n\t\u0011\"\u0003\u0003&\n\u0019\u0002*\u001f9fe2{w\rT8h!2,8\u000f\u00157vg*\u0011\u0011HO\u0001\nC\u001e<'/Z4bi\u0016T!a\u000f\u001f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003{y\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u007f\u0001\u000b1a]9m\u0015\t\t%)A\u0003ta\u0006\u00148N\u0003\u0002D\t\u00061\u0011\r]1dQ\u0016T\u0011!R\u0001\u0004_J<7\u0001A\n\u0006\u0001!ce\u000b\u0018\t\u0003\u0013*k\u0011\u0001O\u0005\u0003\u0017b\u00121#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u00042!\u0014)S\u001b\u0005q%BA(=\u0003\u0015!(/Z3t\u0013\t\tfJA\u0005V]\u0006\u0014\u0018\u0010T5lKB\u00111\u000bV\u0007\u0002u%\u0011QK\u000f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA,[\u001b\u0005A&\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC&a\u0002)s_\u0012,8\r\u001e\t\u0003;\u0016t!AX2\u000f\u0005}\u0013W\"\u00011\u000b\u0005\u00054\u0015A\u0002\u001fs_>$h(C\u0001Z\u0013\t!\u0007,A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019<'\u0001D*fe&\fG.\u001b>bE2,'B\u00013Y\u0003\u0015\u0019\u0007.\u001b7e+\u0005\u0011\u0016AB2iS2$\u0007%\u0001\u0006sK2\fG/\u001b<f'\u0012+\u0012!\u001c\t\u0003/:L!a\u001c-\u0003\r\u0011{WO\u00197f\u0003-\u0011X\r\\1uSZ,7\u000b\u0012\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012a\u001d\t\u0003/RL!!\u001e-\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u0006wrlhp \t\u0003\u0013\u0002AQ\u0001[\u0005A\u0002ICqa[\u0005\u0011\u0002\u0003\u0007Q\u000eC\u0004r\u0013A\u0005\t\u0019A:\t\u000f]L\u0001\u0013!a\u0001gR\u001910a\u0001\t\u000b!T\u0001\u0019\u0001*\u0015\u000bm\f9!!\u0003\t\u000b!\\\u0001\u0019\u0001*\t\u000b-\\\u0001\u0019\u0001*\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\r\u001d\u0011\t\u0019\"!\u0006\u0011\u0005}C\u0016bAA\f1\u00061\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t11\u000b\u001e:j]\u001eT1!a\u0006Y\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$Hc\u0001%\u0002$!1\u0011QE\u0007A\u0002M\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2\u0001SA\u0016\u0011\u0019\tiC\u0004a\u0001g\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\t]VdG.\u00192mKV\u0011\u00111\u0007\t\u0004/\u0006U\u0012bAA\u001c1\n9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005u\u0002\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\rc(A\u0003usB,7/\u0003\u0003\u0002H\u0005\u0005#\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u001f\u0005<wMQ;gM\u0016\u00148k\u00195f[\u0006,\"!!\u0014\u0011\t\u0005}\u0012qJ\u0005\u0005\u0003#\n\tE\u0001\u0006TiJ,8\r\u001e+za\u0016\fQ\u0002Z3gCVdGOU3tk2$XCAA,!\u00159\u0016\u0011LA/\u0013\r\tY\u0006\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007M\u000by&C\u0002\u0002bi\u0012q\u0001T5uKJ\fG.A\u0006iY2\u0004\b\u000fS3ma\u0016\u0014XCAA4!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7y\u0005!Q\u000f^5m\u0013\u0011\t\t(a\u001b\u00033!K\b/\u001a:M_\u001edun\u001a)mkN\u0004F.^:IK2\u0004XM]\u0001\rQ2d\u0007\u000f\u001d%fYB,'\u000fI\u0001\u0014C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003s\u0002R!XA>\u0003\u007fJ1!! h\u0005\r\u0019V-\u001d\t\u0004'\u0006\u0005\u0015bAABu\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003Q\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3tA\u0005A\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u00023%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7\u000fI\u0001\u000bS:LG/[1mSj,G\u0003BAH\u0003+\u00032aVAI\u0013\r\t\u0019\n\u0017\u0002\u0005+:LG\u000fC\u0004\u0002\u0018f\u0001\r!!'\u0002\r\t,hMZ3s!\u0011\tY*!(\u000e\u0003qJ1!a(=\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\rU\u0004H-\u0019;f)\u0019\ty)!*\u0002(\"9\u0011q\u0013\u000eA\u0002\u0005e\u0005bBAU5\u0001\u0007\u0011\u0011T\u0001\u0006S:\u0004X\u000f^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0007\u0003\u001f\u000by+a-\t\u000f\u0005E6\u00041\u0001\u0002\u001a\u00069!-\u001e4gKJ\f\u0004bBA[7\u0001\u0007\u0011\u0011T\u0001\bEV4g-\u001a:3\u0003\u0011)g/\u00197\u0015\t\u0005m\u0016\u0011\u0019\t\u0004/\u0006u\u0016bAA`1\n\u0019\u0011I\\=\t\u0013\u0005]E\u0004%AA\u0002\u0005e\u0015\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002|\u0003\u000fDa!!3\u001e\u0001\u0004\u0011\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\nw\u0006=\u0017\u0011[Aj\u0003+Dq\u0001\u001b\u0010\u0011\u0002\u0003\u0007!\u000bC\u0004l=A\u0005\t\u0019A7\t\u000fEt\u0002\u0013!a\u0001g\"9qO\bI\u0001\u0002\u0004\u0019\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037T3AUAoW\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\u0013Ut7\r[3dW\u0016$'bAAu1\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00181\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003gT3!\\Ao\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!?+\u0007M\fi.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0017\tAA[1wC&!\u00111\u0004B\u0003\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a/\u0003\u0016!A!qC\u0013\u0002\u0002\u0003\u00071/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005;\u0001bAa\b\u0003&\u0005mVB\u0001B\u0011\u0015\r\u0011\u0019\u0003W\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0014\u0005C\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\u0007B\u0017\u0011%\u00119bJA\u0001\u0002\u0004\tY,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u0001\u0005gA\u0001Ba\u0006)\u0003\u0003\u0005\ra]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\"\u0011\b\u0005\n\u0005/I\u0013\u0011!a\u0001\u0003wC3\u0003\u0001B\u001f\u0005\u0007\u0012)E!\u0013\u0003L\t=#\u0011\u000bB+\u0005/\u00022a\u0015B \u0013\r\u0011\tE\u000f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u00119%AA\"\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJ\\F\u0006\t:fY\u0006$\u0018N^3T\tvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%Z:uS6\fG/\u001a3!G\u0006\u0014H-\u001b8bY&$\u0018\u0010\t2zA!K\b/\u001a:M_\u001edunZ\u0016,])\u0001\u0003\u0005\t\u0011!A\u0001\u0014X\r\\1uSZ,7\u000b\u00121!I\u00164\u0017N\\3tAQDW\rI7bq&lW/\u001c\u0011sK2\fG/\u001b<fAM$\u0018M\u001c3be\u0012\u0004C-\u001a<jCRLwN\u001c\u0011bY2|w/\u001a3/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B'\u0003\u0015T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mc%\u0002cIU(NAY\u000bE*V#TA!\n\u0014\u0006\f\u0011)c%b\u0003\u0005\u000b\u001a*Y\u0001B#'\u000b\u0017!QMJ\u0003\u0005^1cQ\r|G.M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005'\n\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\te\u0013!B\u0019/m9\u0002\u0014a\u0005%za\u0016\u0014Hj\\4M_\u001e\u0004F.^:QYV\u001c\bCA%,'\u0015Y#\u0011\rB4!\r9&1M\u0005\u0004\u0005KB&AB!osJ+g\r\u0005\u0003\u0003j\t=TB\u0001B6\u0015\u0011\u0011iG!\u0003\u0002\u0005%|\u0017b\u00014\u0003lQ\u0011!QL\u0001\u0016m\u0006d\u0017\u000eZ1uK\u0012{WO\u00197f\u0019&$XM]1m)\ri'q\u000f\u0005\u0007\u0005sj\u0003\u0019\u0001*\u0002\u0007\u0015D\b/A\u0003baBd\u0017\u0010F\u0005|\u0005\u007f\u0012\tIa!\u0003\u0006\")\u0001N\fa\u0001%\"91N\fI\u0001\u0002\u0004i\u0007bB9/!\u0003\u0005\ra\u001d\u0005\bo:\u0002\n\u00111\u0001t\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0012\ne\u0005#B,\u0002Z\tM\u0005cB,\u0003\u0016Jk7o]\u0005\u0004\u0005/C&A\u0002+va2,G\u0007\u0003\u0005\u0003\u001cJ\n\t\u00111\u0001|\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0015\t\u0005\u0005\u0007\u0011I+\u0003\u0003\u0003,\n\u0015!AB(cU\u0016\u001cG\u000f")
public class HyperLogLogPlusPlus
extends ImperativeAggregate
implements UnaryLike<Expression>,
Serializable {
    private final Expression child;
    private final double relativeSD;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final HyperLogLogPlusPlusHelper hllppHelper;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(HyperLogLogPlusPlus x$0) {
        return HyperLogLogPlusPlus$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$2();
    }

    public static double validateDoubleLiteral(Expression exp) {
        return HyperLogLogPlusPlus$.MODULE$.validateDoubleLiteral(exp);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HyperLogLogPlusPlus hyperLogLogPlusPlus = this;
        synchronized (hyperLogLogPlusPlus) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public double relativeSD() {
        return this.relativeSD;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "approx_count_distinct";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        double x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        double x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)0L), this.dataType()));
    }

    public HyperLogLogPlusPlusHelper hllppHelper() {
        return this.hllppHelper;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        for (int word = 0; word < this.hllppHelper().numWords(); ++word) {
            buffer.setLong(this.mutableAggBufferOffset() + word, 0L);
        }
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        block0: {
            Object v = this.child().eval(input);
            if (v == null) break block0;
            this.hllppHelper().update(buffer, this.mutableAggBufferOffset(), v, this.child().dataType());
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        this.hllppHelper().merge(buffer1, buffer2, this.mutableAggBufferOffset(), this.inputAggBufferOffset());
    }

    @Override
    public Object eval(InternalRow buffer) {
        return BoxesRunTime.boxToLong((long)this.hllppHelper().query(buffer, this.mutableAggBufferOffset()));
    }

    @Override
    public HyperLogLogPlusPlus withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public HyperLogLogPlusPlus copy(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HyperLogLogPlusPlus(child, relativeSD, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public double copy$default$2() {
        return this.relativeSD();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HyperLogLogPlusPlus";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.relativeSD());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogPlusPlus;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "relativeSD";
                break;
            }
            case 2: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 3: {
                string = "inputAggBufferOffset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogPlusPlus)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogPlusPlus hyperLogLogPlusPlus = (HyperLogLogPlusPlus)x$1;
        if (this.relativeSD() != hyperLogLogPlusPlus.relativeSD()) return false;
        if (this.mutableAggBufferOffset() != hyperLogLogPlusPlus.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hyperLogLogPlusPlus.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = hyperLogLogPlusPlus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hyperLogLogPlusPlus.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ AttributeReference $anonfun$aggBufferAttributes$1(int i) {
        String x$1 = new StringBuilder(4).append("MS[").append(i).append("]").toString();
        LongType$ x$2 = LongType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public HyperLogLogPlusPlus(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.relativeSD = relativeSD;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
        this.hllppHelper = new HyperLogLogPlusPlusHelper(relativeSD);
        this.aggBufferAttributes = (Seq)package$.MODULE$.Seq().tabulate(this.hllppHelper().numWords(), (Function1 & Serializable)i -> HyperLogLogPlusPlus.$anonfun$aggBufferAttributes$1(BoxesRunTime.unboxToInt((Object)i)));
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable)x$1 -> x$1.newInstance());
    }

    public HyperLogLogPlusPlus(Expression child) {
        this(child, 0.05, 0, 0);
    }

    public HyperLogLogPlusPlus(Expression child, Expression relativeSD) {
        this(child, HyperLogLogPlusPlus$.MODULE$.validateDoubleLiteral(relativeSD), 0, 0);
    }
}

