/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;

@Experimental
public interface SupportsAtomicPartitionManagement
extends SupportsPartitionManagement {
    @Override
    default public void createPartition(InternalRow ident, Map<String, String> properties) throws PartitionAlreadyExistsException, UnsupportedOperationException {
        try {
            this.createPartitions(new InternalRow[]{ident}, new Map[]{properties});
        }
        catch (PartitionsAlreadyExistException e) {
            throw new PartitionAlreadyExistsException(e.getMessage());
        }
    }

    @Override
    default public boolean dropPartition(InternalRow ident) {
        return this.dropPartitions(new InternalRow[]{ident});
    }

    public void createPartitions(InternalRow[] var1, Map<String, String>[] var2) throws PartitionsAlreadyExistException, UnsupportedOperationException;

    public boolean dropPartitions(InternalRow[] var1);

    default public boolean purgePartitions(InternalRow[] idents) throws NoSuchPartitionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Partition purge is not supported");
    }

    default public boolean truncatePartitions(InternalRow[] idents) throws NoSuchPartitionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Partitions truncate is not supported");
    }
}

