/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(x, pos, val) - Places val into index pos of array x.\n      Array indices start at 1. The maximum negative index is -1 for which the function inserts\n      new element after the current last element.\n      Index above array size appends the array, or prepends the array if index is negative,\n      with 'null' elements.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 5, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(array(5, 4, 3, 2), -1, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(array(5, 3, 2, 1), -4, 4);\n       [5,4,3,2,1]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\tme\u0001B\u0017/\u0001nB\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tM\u0002\u0011\t\u0012)A\u0005G\"Aq\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005i\u0001\tE\t\u0015!\u0003d\u0011!I\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B2\t\u0011-\u0004!Q3A\u0005\u00021D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006I!\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t\u0001\u001f\u0005\u0006y\u0002!\t% \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011)\ty\u0002\u0001EC\u0002\u0013%\u0011\u0011\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0016\u0001\t\u0003\n9\u0006\u0003\u0004\u0002t\u0001!\tE\u0019\u0005\u0007\u0003k\u0002A\u0011\t2\t\r\u0005]\u0004\u0001\"\u0011c\u0011\u001d\tI\b\u0001C!\u0003wBq!!$\u0001\t\u0003\ny\t\u0003\u0004\u0002\u0018\u0002!\t\u0005\u001c\u0005\u000b\u00033\u0003\u0001R1A\u0005\n\u0005=\u0005bBAR\u0001\u0011E\u0013Q\u0015\u0005\b\u0003g\u0003A\u0011IA[\u0011%\t)\rAA\u0001\n\u0003\t9\rC\u0005\u0002R\u0002\t\n\u0011\"\u0001\u0002T\"I\u0011\u0011\u001e\u0001\u0012\u0002\u0013\u0005\u00111\u001b\u0005\n\u0003W\u0004\u0011\u0013!C\u0001\u0003'D\u0011\"!<\u0001#\u0003%\t!a<\t\u0013\u0005M\b!!A\u0005B\u0005U\b\"\u0003B\u0003\u0001\u0005\u0005I\u0011\u0001B\u0004\u0011%\u0011I\u0001AA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u0012\u0001\t\t\u0011\"\u0011\u0003\u0014!I!\u0011\u0005\u0001\u0002\u0002\u0013\u0005!1\u0005\u0005\n\u0005O\u0001\u0011\u0011!C!\u0005SA\u0011B!\f\u0001\u0003\u0003%\tEa\f\b\u0013\tMc&!A\t\u0002\tUc\u0001C\u0017/\u0003\u0003E\tAa\u0016\t\rE<C\u0011\u0001B8\u0011%\u0011\thJA\u0001\n\u000b\u0012\u0019\bC\u0005\u0003v\u001d\n\t\u0011\"!\u0003x!I!\u0011Q\u0014\u0002\u0002\u0013\u0005%1\u0011\u0005\n\u0005#;\u0013\u0011!C\u0005\u0005'\u00131\"\u0011:sCfLen]3si*\u0011q\u0006M\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00022e\u0005A1-\u0019;bYf\u001cHO\u0003\u00024i\u0005\u00191/\u001d7\u000b\u0005U2\u0014!B:qCJ\\'BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001e\u001c\u0001a\u0005\u0005\u0001y\u0001\u001be\tT(V!\tid(D\u0001/\u0013\tydFA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!P!\n\u0005\ts#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005u\"\u0015BA#/\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u001a\u0002\r\u0015\u0014(o\u001c:t\u0013\tY\u0005JA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\tiT*\u0003\u0002O]\t\u00192+\u001e9q_J$\u0018+^3ss\u000e{g\u000e^3yiB\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n9\u0001K]8ek\u000e$\bC\u0001,_\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002[u\u00051AH]8pizJ\u0011AU\u0005\u0003;F\u000bq\u0001]1dW\u0006<W-\u0003\u0002`A\na1+\u001a:jC2L'0\u00192mK*\u0011Q,U\u0001\rgJ\u001c\u0017I\u001d:bs\u0016C\bO]\u000b\u0002GB\u0011Q\bZ\u0005\u0003K:\u0012!\"\u0012=qe\u0016\u001c8/[8o\u00035\u0019(oY!se\u0006LX\t\u001f9sA\u00059\u0001o\\:FqB\u0014\u0018\u0001\u00039pg\u0016C\bO\u001d\u0011\u0002\u0011%$X-\\#yaJ\f\u0011\"\u001b;f[\u0016C\bO\u001d\u0011\u0002'1,w-Y2z\u001d\u0016<\u0017\r^5wK&sG-\u001a=\u0016\u00035\u0004\"\u0001\u00158\n\u0005=\f&a\u0002\"p_2,\u0017M\\\u0001\u0015Y\u0016<\u0017mY=OK\u001e\fG/\u001b<f\u0013:$W\r\u001f\u0011\u0002\rqJg.\u001b;?)\u0015\u0019H/\u001e<x!\ti\u0004\u0001C\u0003b\u0013\u0001\u00071\rC\u0003h\u0013\u0001\u00071\rC\u0003j\u0013\u0001\u00071\rC\u0003l\u0013\u0001\u0007Q\u000e\u0006\u0003tsj\\\b\"B1\u000b\u0001\u0004\u0019\u0007\"B4\u000b\u0001\u0004\u0019\u0007\"B5\u000b\u0001\u0004\u0019\u0017AC5oaV$H+\u001f9fgV\ta\u0010\u0005\u0003W\u007f\u0006\r\u0011bAA\u0001A\n\u00191+Z9\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u00033\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti!a\u0002\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\ra\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u001e\u0005]!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0017A|7/\u001b;jm\u0016\u0004vn]\u000b\u0003\u0003G\u0001R\u0001UA\u0013\u0003SI1!a\nR\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001+a\u000b\n\u0007\u00055\u0012KA\u0002J]R\fA!\u001a<bYR!\u00111GA\u001d!\r\u0001\u0016QG\u0005\u0004\u0003o\t&aA!os\"I\u00111\b\b\u0011\u0002\u0003\u0007\u0011QH\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u007f\t\t%D\u00011\u0013\r\t\u0019\u0005\r\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u00024\u0005%\u0013QJA)\u0011\u001d\tYe\u0004a\u0001\u0003g\t1!\u0019:s\u0011\u001d\tye\u0004a\u0001\u0003g\t1\u0001]8t\u0011\u001d\t\u0019f\u0004a\u0001\u0003g\tA!\u001b;f[\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u00033\n)'a\u001c\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018/\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0019\u0002^\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002hA\u0001\r!!\u001b\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\\\u0005-\u0014\u0002BA7\u0003;\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002rA\u0001\r!!\u0017\u0002\u0005\u00154\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!! \u0011\t\u0005}\u0014q\u0011\b\u0005\u0003\u0003\u000b\u0019\t\u0005\u0002Y#&\u0019\u0011QQ)\u0002\rA\u0013X\rZ3g\u0013\u0011\tI)a#\u0003\rM#(/\u001b8h\u0015\r\t))U\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\u0013\t\u0005\u0003\u000b\t\u0019*\u0003\u0003\u0002\u0016\u0006\u001d!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016\f1\"\u001a7f[\u0016tG\u000fV=qK\"\u001aq#!(\u0011\u0007A\u000by*C\u0002\u0002\"F\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB:\u0002(\u0006-\u0016q\u0016\u0005\u0007\u0003SC\u0002\u0019A2\u0002\u001f9,wo\u0015:d\u0003J\u0014\u0018-_#yaJDa!!,\u0019\u0001\u0004\u0019\u0017A\u00038foB{7/\u0012=qe\"1\u0011\u0011\u0017\rA\u0002\r\f1B\\3x\u0013R,W.\u0012=qe\u0006\u0001\u0012N\\5u#V,'/_\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003o\u0003R\u0001UA\u0013\u0003s\u0003B!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0004\u0003\u007f\u0003\u0014!\u0002;sK\u0016\u001c\u0018\u0002BAb\u0003{\u0013qbU)M#V,'/_\"p]R,\u0007\u0010^\u0001\u0005G>\u0004\u0018\u0010F\u0005t\u0003\u0013\fY-!4\u0002P\"9\u0011M\u0007I\u0001\u0002\u0004\u0019\u0007bB4\u001b!\u0003\u0005\ra\u0019\u0005\bSj\u0001\n\u00111\u0001d\u0011\u001dY'\u0004%AA\u00025\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002V*\u001a1-a6,\u0005\u0005e\u0007\u0003BAn\u0003Kl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a9R\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\fiNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u001f\u0016\u0004[\u0006]\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002xB!\u0011\u0011 B\u0002\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018\u0001\u00027b]\u001eT!A!\u0001\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\u000bY0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002*\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001a\u0005\u001bA\u0011Ba\u0004\"\u0003\u0003\u0005\r!!\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0002\u0005\u0004\u0003\u0018\tu\u00111G\u0007\u0003\u00053Q1Aa\u0007R\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005?\u0011IB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA7\u0003&!I!qB\u0012\u0002\u0002\u0003\u0007\u00111G\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002x\n-\u0002\"\u0003B\bI\u0005\u0005\t\u0019AA\u0015\u0003\u0019)\u0017/^1mgR\u0019QN!\r\t\u0013\t=Q%!AA\u0002\u0005M\u0002f\u0005\u0001\u00036\tm\"Q\bB!\u0005\u0007\u00129E!\u0013\u0003N\t=\u0003cA\u001f\u00038%\u0019!\u0011\b\u0018\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!qH\u0001\u0003\u001c*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015yY\u0001\u0002xn\u001d\u0017!m\u0006d\u0017\u0006I\u0017!!2\f7-Z:!m\u0006d\u0007%\u001b8u_\u0002Jg\u000eZ3yAA|7\u000fI8gA\u0005\u0014(/Y=!q:R\u0001\u0005\t\u0011!A\u0001\n%O]1zA%tG-[2fg\u0002\u001aH/\u0019:uA\u0005$\b%\r\u0018!)\",\u0007%\\1yS6,X\u000e\t8fO\u0006$\u0018N^3!S:$W\r\u001f\u0011jg\u0002j\u0013\u0007\t4pe\u0002:\b.[2iAQDW\r\t4v]\u000e$\u0018n\u001c8!S:\u001cXM\u001d;t\u0015\u0001\u0002\u0003\u0005\t\u0011!]\u0016<\b%\u001a7f[\u0016tG\u000fI1gi\u0016\u0014\b\u0005\u001e5fA\r,(O]3oi\u0002b\u0017m\u001d;!K2,W.\u001a8u])\u0001\u0003\u0005\t\u0011!A%sG-\u001a=!C\n|g/\u001a\u0011beJ\f\u0017\u0010I:ju\u0016\u0004\u0013\r\u001d9f]\u0012\u001c\b\u0005\u001e5fA\u0005\u0014(/Y=-A=\u0014\b\u0005\u001d:fa\u0016tGm\u001d\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002Jg\rI5oI\u0016D\b%[:!]\u0016<\u0017\r^5wK2R\u0001\u0005\t\u0011!A\u0001:\u0018\u000e\u001e5!O9,H\u000e\\\u0014!K2,W.\u001a8ug:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QI\u0001\u0002:*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMb\u0003\u0005N\u0015-AUb\u0003%N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u000bDF\r\u00174YQbS'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00156Y\u0001\"D\u0006I\u001a-AIJC\u0006I\u00172Y\u0001\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\k1\"Df\r\u00173YEj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\u000e\u0017!g1\u0002#\u0007\f\u00112S1\u0002S\u0006\u000e\u0017!i%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u001b-i1\u001aDF\r\u00172;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003L\u0005Y\u0011M\u001d:bs~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t&A\u00034]Qr\u0003'A\u0006BeJ\f\u00170\u00138tKJ$\bCA\u001f('\u00159#\u0011\fB3!%\u0011YF!\u0019dG\u000el7/\u0004\u0002\u0003^)\u0019!qL)\u0002\u000fI,h\u000e^5nK&!!1\rB/\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005O\u0012i'\u0004\u0002\u0003j)!!1NA\u0000\u0003\tIw.C\u0002`\u0005S\"\"A!\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a>\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013M\u0014IHa\u001f\u0003~\t}\u0004\"B1+\u0001\u0004\u0019\u0007\"B4+\u0001\u0004\u0019\u0007\"B5+\u0001\u0004\u0019\u0007\"B6+\u0001\u0004i\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000b\u0013i\tE\u0003Q\u0003K\u00119\tE\u0004Q\u0005\u0013\u001b7mY7\n\u0007\t-\u0015K\u0001\u0004UkBdW\r\u000e\u0005\t\u0005\u001f[\u0013\u0011!a\u0001g\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tU\u0005\u0003BA}\u0005/KAA!'\u0002|\n1qJ\u00196fGR\u0004")
public class ArrayInsert
extends TernaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
SupportQueryContext {
    private Option<Object> positivePos;
    private transient DataType elementType;
    private final Expression srcArrayExpr;
    private final Expression posExpr;
    private final Expression itemExpr;
    private final boolean legacyNegativeIndex;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(ArrayInsert x$0) {
        return ArrayInsert$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, ArrayInsert> tupled() {
        return ArrayInsert$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, ArrayInsert>>>> curried() {
        return ArrayInsert$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Expression srcArrayExpr() {
        return this.srcArrayExpr;
    }

    public Expression posExpr() {
        return this.posExpr;
    }

    public Expression itemExpr() {
        return this.itemExpr;
    }

    public boolean legacyNegativeIndex() {
        return this.legacyNegativeIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple3 tuple3 = new Tuple3((Object)this.srcArrayExpr().dataType(), (Object)this.posExpr().dataType(), (Object)this.itemExpr().dataType());
        if (tuple3 != null) {
            DataType dataType = (DataType)tuple3._1();
            DataType e2 = (DataType)tuple3._2();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        Seq seq2;
                        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e3);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            DataType dt = (DataType)some.value();
                            seq2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), IntegerType$.MODULE$, dt}));
                        } else {
                            seq2 = (Seq)package$.MODULE$.Seq().empty();
                        }
                        seq = seq2;
                        return (Seq)package$.MODULE$.Seq().empty();
                    }
                }
            }
        }
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        seq = (Seq)package$.MODULE$.Seq().empty();
        return (Seq)package$.MODULE$.Seq().empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_7;
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null) {
            DataType e2 = (DataType)tuple3._2();
            if (tuple3._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.second())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.second().dataType()))}))));
                    return var1_7;
                }
            }
        }
        if (tuple3 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple3._1();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType).elementType(), e3)) {
                TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                return var1_7;
            }
        }
        TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.first().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.third().dataType()))}))));
        return var1_7;
    }

    private Option<Object> positivePos$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                InternalRow x$1;
                Expression qual$1;
                int pos;
                this.positivePos = this.second().foldable() ? ((pos = BoxesRunTime.unboxToInt((Object)(qual$1 = this.second()).eval(x$1 = qual$1.eval$default$1()))) > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)pos)) : None$.MODULE$) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.positivePos;
    }

    private Option<Object> positivePos() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.positivePos$lzycompute() : this.positivePos;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.first().eval(input);
        if (value1 != null && (value2 = this.second().eval(input)) != null) {
            Object value3 = this.third().eval(input);
            return this.nullSafeEval(value1, value2, value3);
        }
        return null;
    }

    @Override
    public Object nullSafeEval(Object arr, Object pos, Object item) {
        GenericArrayData genericArrayData;
        ArrayData baseArr = (ArrayData)arr;
        if (this.positivePos().isDefined()) {
            int newArrayLength = scala.math.package$.MODULE$.max(baseArr.numElements() + 1, BoxesRunTime.unboxToInt((Object)this.positivePos().get()));
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            int posInt = BoxesRunTime.unboxToInt((Object)this.positivePos().get()) - 1;
            baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$9(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[posInt] = item;
            genericArrayData = new GenericArrayData(newArray);
        } else {
            boolean newPosExtendsArrayLeft;
            IntRef posInt = IntRef.create((int)BoxesRunTime.unboxToInt((Object)pos));
            if (posInt.elem == 0) {
                throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
            }
            boolean bl = newPosExtendsArrayLeft = posInt.elem < 0 && -posInt.elem > baseArr.numElements();
            if (newPosExtendsArrayLeft) {
                int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
                int newArrayLength = -posInt.elem + baseOffset;
                if (newArrayLength > 0x7FFFFFF0) {
                    throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
                }
                Object[] newArray = new Object[newArrayLength];
                baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                    ArrayInsert.$anonfun$nullSafeEval$10(baseOffset, posInt, baseArr, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                    return BoxedUnit.UNIT;
                });
                newArray[0] = item;
                genericArrayData = new GenericArrayData(newArray);
            } else {
                if (posInt.elem < 0) {
                    posInt.elem = posInt.elem + baseArr.numElements() + (this.legacyNegativeIndex() ? 0 : 1);
                } else if (posInt.elem > 0) {
                    --posInt.elem;
                }
                int newArrayLength = scala.math.package$.MODULE$.max(baseArr.numElements() + 1, posInt.elem + 1);
                if (newArrayLength > 0x7FFFFFF0) {
                    throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
                }
                Object[] newArray = new Object[newArrayLength];
                baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                    ArrayInsert.$anonfun$nullSafeEval$11(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                    return BoxedUnit.UNIT;
                });
                newArray[posInt.elem] = item;
                genericArrayData = new GenericArrayData(newArray);
            }
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Function3 & Serializable f = (Function3 & Serializable)(arrExpr, posExpr, itemExpr) -> {
            String string;
            ExprValue arr = arrExpr.value();
            ExprValue item = itemExpr.value();
            String itemInsertionIndex = ctx.freshName("itemInsertionIndex");
            String adjustedAllocIdx = ctx.freshName("adjustedAllocIdx");
            String resLength = ctx.freshName("resLength");
            String insertedItemIsNull = ctx.freshName("insertedItemIsNull");
            String i = ctx.freshName("i");
            String j = ctx.freshName("j");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(8).append(this.prettyName()).append(" failed.").toString());
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), ExprValue$.MODULE$.exprValueToString(arr), adjustedAllocIdx, i, ((ArrayType)this.first().dataType()).containsNull());
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            if (this.positivePos().isDefined()) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(650).append("\n           |int ").append(itemInsertionIndex).append(" = ").append(BoxesRunTime.unboxToInt((Object)this.positivePos().get()) - 1).append(";\n           |int ").append(adjustedAllocIdx).append(" = 0;\n           |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n           |\n           |final int ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(this.positivePos().get()).append(");\n           |if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n           |  throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n           |}\n           |\n           |").append(allocation).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n           |  ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n           |  if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n           |    ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n           |  }\n           |  ").append(assignment).append("\n           |}\n           |").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n           |\n           |for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n           |  ").append(values).append(".setNullAt(").append(j).append(");\n           |}\n           |\n           |").append(ev.value()).append(" = ").append(values).append(";\n           |").toString()));
            } else {
                ExprValue pos = posExpr.value();
                int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1702).append("\n           |int ").append(itemInsertionIndex).append(" = 0;\n           |int ").append(resLength).append(" = 0;\n           |int ").append(adjustedAllocIdx).append(" = 0;\n           |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n           |\n           |if (").append(pos).append(" == 0) {\n           |  throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n           |}\n           |\n           |if (").append(pos).append(" < 0 && (java.lang.Math.abs(").append(pos).append(") > ").append(arr).append(".numElements())) {\n           |\n           |  ").append(resLength).append(" = java.lang.Math.abs(").append(pos).append(") + ").append(baseOffset).append(";\n           |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n           |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n           |  }\n           |\n           |  ").append(allocation).append("\n           |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n           |    ").append(adjustedAllocIdx).append(" = ").append(i).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements());\n           |    ").append(assignment).append("\n           |  }\n           |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n           |\n           |  for (int ").append(j).append(" = ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(" + ").append(pos).append(" + ").append(arr).append(".numElements(); ").append(j).append(" < 0; ").append(j).append(" ++) {\n           |    ").append(values).append(".setNullAt(").append(j).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements()));\n           |  }\n           |\n           |  ").append(ev.value()).append(" = ").append(values).append(";\n           |} else {\n           |\n           |  ").append(itemInsertionIndex).append(" = 0;\n           |  if (").append(pos).append(" < 0) {\n           |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" + ").append(arr).append(".numElements() + ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(";\n           |  } else if (").append(pos).append(" > 0) {\n           |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" - 1;\n           |  }\n           |\n           |  ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(itemInsertionIndex).append(" + 1);\n           |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n           |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n           |  }\n           |\n           |  ").append(allocation).append("\n           |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n           |    ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n           |    if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n           |      ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n           |    }\n           |    ").append(assignment).append("\n           |  }\n           |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n           |\n           |  for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n           |    ").append(values).append(".setNullAt(").append(j).append(");\n           |  }\n           |\n           |  ").append(ev.value()).append(" = ").append(values).append(";\n           |}\n           |").toString()));
            }
            return string;
        };
        ExprCode leftGen = this.first().genCode(ctx);
        ExprCode midGen = this.second().genCode(ctx);
        ExprCode rightGen = this.third().genCode(ctx);
        String resultCode = (String)f.apply((Object)leftGen, (Object)midGen, (Object)rightGen);
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(this.first().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)midGen.code()), ctx.nullSafeExec(this.second().nullable(), ExprValue$.MODULE$.exprValueToString(midGen.isNull()), new StringBuilder(67).append("\n              ").append(rightGen.code()).append("\n              ").append(ev.isNull()).append(" = false;\n              ").append(resultCode).append("\n            ").toString()))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), midGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    @Override
    public Expression first() {
        return this.srcArrayExpr();
    }

    @Override
    public Expression second() {
        return this.posExpr();
    }

    @Override
    public Expression third() {
        return this.itemExpr();
    }

    @Override
    public String prettyName() {
        return "array_insert";
    }

    @Override
    public DataType dataType() {
        return this.first().dataType().asNullable();
    }

    @Override
    public boolean nullable() {
        return this.first().nullable() | this.second().nullable();
    }

    private DataType elementType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.srcArrayExpr().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayInsert withNewChildrenInternal(Expression newSrcArrayExpr, Expression newPosExpr, Expression newItemExpr) {
        return this.copy(newSrcArrayExpr, newPosExpr, newItemExpr, this.copy$default$4());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public ArrayInsert copy(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        return new ArrayInsert(srcArrayExpr, posExpr, itemExpr, legacyNegativeIndex);
    }

    public Expression copy$default$1() {
        return this.srcArrayExpr();
    }

    public Expression copy$default$2() {
        return this.posExpr();
    }

    public Expression copy$default$3() {
        return this.itemExpr();
    }

    public boolean copy$default$4() {
        return this.legacyNegativeIndex();
    }

    @Override
    public String productPrefix() {
        return "ArrayInsert";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcArrayExpr();
                break;
            }
            case 1: {
                object = this.posExpr();
                break;
            }
            case 2: {
                object = this.itemExpr();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.legacyNegativeIndex());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayInsert;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcArrayExpr";
                break;
            }
            case 1: {
                string = "posExpr";
                break;
            }
            case 2: {
                string = "itemExpr";
                break;
            }
            case 3: {
                string = "legacyNegativeIndex";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayInsert)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayInsert arrayInsert = (ArrayInsert)x$1;
        if (this.legacyNegativeIndex() != arrayInsert.legacyNegativeIndex()) return false;
        Expression expression = this.srcArrayExpr();
        Expression expression2 = arrayInsert.srcArrayExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.posExpr();
        Expression expression4 = arrayInsert.posExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.itemExpr();
        Expression expression6 = arrayInsert.itemExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!arrayInsert.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$9(int posInt$1, Object[] newArray$2, int i, Object v) {
        if (i >= posInt$1) {
            newArray$2[i + 1] = v;
        } else {
            newArray$2[i] = v;
        }
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$10(int baseOffset$1, IntRef posInt$2, ArrayData baseArr$1, Object[] newArray$3, int i, Object v) {
        int elementPosition = i + baseOffset$1 + scala.math.package$.MODULE$.abs(posInt$2.elem + baseArr$1.numElements());
        newArray$3[elementPosition] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$11(IntRef posInt$2, Object[] newArray$4, int i, Object v) {
        if (i >= posInt$2.elem) {
            newArray$4[i + 1] = v;
        } else {
            newArray$4[i] = v;
        }
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        this.srcArrayExpr = srcArrayExpr;
        this.posExpr = posExpr;
        this.itemExpr = itemExpr;
        this.legacyNegativeIndex = legacyNegativeIndex;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        SupportQueryContext.$init$(this);
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        this(srcArrayExpr, posExpr, itemExpr, SQLConf$.MODULE$.get().legacyNegativeIndexInArrayInsert());
    }
}

