/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Mask;
import org.apache.spark.sql.catalyst.expressions.Mask$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(input[, upperChar, lowerChar, digitChar, otherChar]) - masks the given string value.\n       The function replaces characters with 'X' or 'x', and numbers with 'n'.\n       This can be useful for creating copies of tables with sensitive information removed.\n      ", arguments="\n    Arguments:\n      * input      - string value to mask. Supported types: STRING, VARCHAR, CHAR\n      * upperChar  - character to replace upper-case characters with. Specify NULL to retain original character. Default value: 'X'\n      * lowerChar  - character to replace lower-case characters with. Specify NULL to retain original character. Default value: 'x'\n      * digitChar  - character to replace digit characters with. Specify NULL to retain original character. Default value: 'n'\n      * otherChar  - character to replace all other characters with. Specify NULL to retain original character. Default value: NULL\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abcd-EFGH-8765-4321');\n        xxxx-XXXX-nnnn-nnnn\n      > SELECT _FUNC_('abcd-EFGH-8765-4321', 'Q');\n        xxxx-QQQQ-nnnn-nnnn\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#');\n        XxXXnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q');\n        QxQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd');\n        QqQQddd-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd', 'o');\n        QqQQdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, 'q', 'd', 'o');\n        AqCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, 'd', 'o');\n        AbCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, 'o');\n        AbCD123oooo\n      > SELECT _FUNC_(NULL, NULL, NULL, NULL, 'o');\n        NULL\n      > SELECT _FUNC_(NULL);\n        NULL\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, NULL);\n        AbCD123-@$#\n  ", since="3.4.0", group="string_funcs")
public final class MaskExpressionBuilder$
implements ExpressionBuilder {
    public static final MaskExpressionBuilder$ MODULE$ = new MaskExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        InputParameter strArg = new InputParameter("str", InputParameter$.MODULE$.apply$default$2());
        InputParameter upperCharArg = new InputParameter("upperChar", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.MASKED_UPPERCASE()))));
        InputParameter lowerCharArg = new InputParameter("lowerChar", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.MASKED_LOWERCASE()))));
        InputParameter digitCharArg = new InputParameter("digitChar", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.MASKED_DIGIT()))));
        Mask$.MODULE$.MASKED_IGNORE();
        InputParameter otherCharArg = new InputParameter("otherChar", (Option<Expression>)new Some((Object)new Literal(null, (DataType)StringType$.MODULE$)));
        FunctionSignature functionSignature = new FunctionSignature((Seq<InputParameter>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InputParameter[]{strArg, upperCharArg, lowerCharArg, digitCharArg, otherCharArg}))));
        return new Some((Object)functionSignature);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        Predef$.MODULE$.assert(expressions.size() == 5);
        return new Mask((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3), (Expression)expressions.apply(4));
    }

    private MaskExpressionBuilder$() {
    }
}

