/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.UserDefinedExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.CentralMomentAgg;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.optimizer.EliminateSorts$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class EliminateSorts$
extends Rule<LogicalPlan> {
    public static final EliminateSorts$ MODULE$ = new EliminateSorts$();
    private static final PartialFunction<LogicalPlan, LogicalPlan> org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally = new Serializable(){
        private static final long serialVersionUID = 0L;

        /*
         * Enabled aggressive block sorting
         */
        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            Object object;
            boolean bl = false;
            Sort sort = null;
            A1 A1 = x1;
            if (A1 instanceof Sort) {
                bl = true;
                sort = (Sort)A1;
                Seq<SortOrder> orders = sort.order();
                LogicalPlan child = sort.child();
                if (orders.isEmpty() || orders.exists((Function1 & Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)anonfun.5.$anonfun$applyOrElse$33(x$57)))) {
                    Seq newOrders = (Seq)orders.filterNot((Function1 & Serializable)x$58 -> BoxesRunTime.boxToBoolean((boolean)anonfun.5.$anonfun$applyOrElse$34(x$58)));
                    object = newOrders.isEmpty() ? ((Option)EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally().lift().apply((Object)child)).getOrElse((Function0 & Serializable)() -> child) : sort.copy((Seq<SortOrder>)newOrders, sort.copy$default$2(), sort.copy$default$3());
                    return (B1)object;
                }
            }
            if (bl) {
                Seq<SortOrder> orders = sort.order();
                boolean bl2 = sort.global();
                LogicalPlan child = sort.child();
                if (!bl2 && SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), orders)) {
                    object = ((Option)EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally().lift().apply((Object)child)).getOrElse((Function0 & Serializable)() -> child);
                    return (B1)object;
                }
            }
            if (bl) {
                boolean global = sort.global();
                LogicalPlan child = sort.child();
                LogicalPlan x$1 = EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(child, global);
                Seq<SortOrder> x$2 = sort.copy$default$1();
                boolean x$3 = sort.copy$default$2();
                object = sort.copy(x$2, x$3, x$1);
                return (B1)object;
            }
            if (A1 instanceof Join) {
                Join join = (Join)A1;
                LogicalPlan originLeft = join.left();
                LogicalPlan originRight = join.right();
                Option<Expression> cond = join.condition();
                if (cond.forall((Function1 & Serializable)x$59 -> BoxesRunTime.boxToBoolean((boolean)anonfun.5.$anonfun$applyOrElse$37(x$59)))) {
                    object = join.copy(EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(originLeft, true), EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(originRight, true), join.copy$default$3(), join.copy$default$4(), join.copy$default$5());
                    return (B1)object;
                }
            }
            if (A1 instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)A1;
                Seq<NamedExpression> aggs = aggregate.aggregateExpressions();
                LogicalPlan originChild = aggregate.child();
                if (EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$isOrderIrrelevantAggs(aggs)) {
                    LogicalPlan x$4 = EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(originChild, true);
                    Seq<Expression> x$5 = aggregate.copy$default$1();
                    Seq<NamedExpression> x$6 = aggregate.copy$default$2();
                    object = aggregate.copy(x$5, x$6, x$4);
                    return (B1)object;
                }
            }
            object = function1.apply(x1);
            return (B1)object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isDefinedAt(LogicalPlan x1) {
            Join join;
            Option<Expression> cond;
            boolean bl = false;
            Sort sort = null;
            LogicalPlan logicalPlan = x1;
            if (logicalPlan instanceof Sort) {
                bl = true;
                sort = (Sort)logicalPlan;
                Seq<SortOrder> orders = sort.order();
                if (orders.isEmpty()) return true;
                if (orders.exists((Function1 & Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)anonfun.5.$anonfun$isDefinedAt$7(x$57)))) {
                    return true;
                }
            }
            if (bl) {
                Seq<SortOrder> orders = sort.order();
                boolean bl2 = sort.global();
                LogicalPlan child = sort.child();
                if (!bl2 && SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), orders)) {
                    return true;
                }
            }
            if (bl) {
                return true;
            }
            if (logicalPlan instanceof Join && (cond = (join = (Join)logicalPlan).condition()).forall((Function1 & Serializable)x$59 -> BoxesRunTime.boxToBoolean((boolean)anonfun.5.$anonfun$isDefinedAt$8(x$59)))) {
                return true;
            }
            if (!(logicalPlan instanceof Aggregate)) return false;
            Aggregate aggregate = (Aggregate)logicalPlan;
            Seq<NamedExpression> aggs = aggregate.aggregateExpressions();
            if (!EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$isOrderIrrelevantAggs(aggs)) return false;
            return true;
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$33(SortOrder x$57) {
            return x$57.child().foldable();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$34(SortOrder x$58) {
            return x$58.child().foldable();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$37(Expression x$59) {
            return x$59.deterministic();
        }

        public static final /* synthetic */ boolean $anonfun$isDefinedAt$7(SortOrder x$57) {
            return x$57.child().foldable();
        }

        public static final /* synthetic */ boolean $anonfun$isDefinedAt$8(Expression x$59) {
            return x$59.deterministic();
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$33$adapted(org.apache.spark.sql.catalyst.expressions.SortOrder ), $anonfun$applyOrElse$34$adapted(org.apache.spark.sql.catalyst.expressions.SortOrder ), $anonfun$applyOrElse$35(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$36(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$37$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$isDefinedAt$7$adapted(org.apache.spark.sql.catalyst.expressions.SortOrder ), $anonfun$isDefinedAt$8$adapted(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
        }
    };

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.transformWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$56 -> BoxesRunTime.boxToBoolean((boolean)x$56.containsPattern(TreePattern$.MODULE$.SORT())), plan2.transformWithPruning$default$2(), this.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally());
    }

    public PartialFunction<LogicalPlan, LogicalPlan> org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally() {
        return org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogicalPlan org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(LogicalPlan plan2, boolean canRemoveGlobalSort) {
        LogicalPlan logicalPlan;
        Sort sort;
        boolean bl;
        while (true) {
            if (!plan2.containsPattern(TreePattern$.MODULE$.SORT())) {
                return plan2;
            }
            bl = false;
            sort = null;
            logicalPlan = plan2;
            if (!(logicalPlan instanceof Sort)) break;
            bl = true;
            sort = (Sort)logicalPlan;
            boolean global = sort.global();
            LogicalPlan child = sort.child();
            if (!canRemoveGlobalSort && global) break;
            plan2 = child;
        }
        if (bl) {
            Seq<SortOrder> sortOrder = sort.order();
            boolean bl2 = sort.global();
            LogicalPlan child = sort.child();
            if (bl2) {
                return new RepartitionByExpression(sortOrder, this.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(child, true), (Option<Object>)None$.MODULE$, RepartitionByExpression$.MODULE$.apply$default$4());
            }
        }
        if (this.canEliminateSort(logicalPlan)) {
            return (LogicalPlan)logicalPlan.withNewChildren((Seq)logicalPlan.children().map((Function1 & Serializable)c -> MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort((LogicalPlan)c, canRemoveGlobalSort)));
        }
        if (!this.canEliminateGlobalSort(logicalPlan)) return plan2;
        return (LogicalPlan)logicalPlan.withNewChildren((Seq)logicalPlan.children().map((Function1 & Serializable)c -> MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort((LogicalPlan)c, true)));
    }

    private boolean canEliminateSort(LogicalPlan plan2) {
        boolean bl;
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            bl = project.projectList().forall((Function1 & Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)EliminateSorts$.$anonfun$canEliminateSort$1(x$60)));
        } else if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            bl = filter.condition().deterministic();
        } else {
            bl = logicalPlan instanceof LocalLimit;
        }
        return bl;
    }

    private boolean canEliminateGlobalSort(LogicalPlan plan2) {
        boolean bl;
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof RepartitionByExpression) {
            RepartitionByExpression repartitionByExpression = (RepartitionByExpression)logicalPlan;
            bl = repartitionByExpression.partitionExpressions().forall((Function1 & Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)x$61.deterministic()));
        } else if (logicalPlan instanceof RebalancePartitions) {
            RebalancePartitions rebalancePartitions = (RebalancePartitions)logicalPlan;
            bl = rebalancePartitions.partitionExpressions().forall((Function1 & Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)x$62.deterministic()));
        } else {
            bl = logicalPlan instanceof Repartition;
        }
        return bl;
    }

    public boolean org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$isOrderIrrelevantAggs(Seq<NamedExpression> aggs) {
        return aggs.forall((Function1 & Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)EliminateSorts$.checkValidAggregateExpression$1(expr)));
    }

    public static final /* synthetic */ boolean $anonfun$canEliminateSort$1(NamedExpression x$60) {
        return ((Expression)((Object)x$60)).deterministic();
    }

    private static final boolean isOrderIrrelevantAggFunction$1(AggregateFunction func) {
        boolean bl;
        AggregateFunction aggregateFunction = func;
        boolean bl2 = aggregateFunction instanceof Min ? true : (aggregateFunction instanceof Max ? true : (aggregateFunction instanceof Count ? true : aggregateFunction instanceof BitAggregate));
        boolean bl3 = bl2 ? true : ((bl = aggregateFunction instanceof Sum ? true : (aggregateFunction instanceof Average ? true : aggregateFunction instanceof CentralMomentAgg)) ? !package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FractionalType[]{FloatType$.MODULE$, DoubleType$.MODULE$})).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, ((Expression)func.children().head()).dataType()))) : false);
        return bl3;
    }

    private static final boolean checkValidAggregateExpression$1(Expression expr2) {
        boolean bl;
        Expression expression = expr2;
        if (expression instanceof AttributeReference) {
            bl = true;
        } else if (expression instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            bl = EliminateSorts$.isOrderIrrelevantAggFunction$1(aggregateExpression.aggregateFunction());
        } else {
            bl = expression instanceof UserDefinedExpression ? false : expression.children().forall((Function1 & Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)EliminateSorts$.checkValidAggregateExpression$1(expr)));
        }
        return bl;
    }

    private EliminateSorts$() {
    }
}

