/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.arrow.ArrowFieldWriter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i3QAD\b\u0001\u001fmA\u0001\u0002\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tY\u0001\u0011\t\u0011)A\u0005G!AQ\u0006\u0001BC\u0002\u0013\u0005a\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00030\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0004\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\t\u0011Y\u0002!Q1A\u0005\u0002QB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006q\u0001!\t!\u000f\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0006\u000f\u0002!\t\u0005\u0013\u0005\u00061\u0002!\t\u0005\u0011\u0005\u00063\u0002!\t\u0005\u0011\u0002\n\u001b\u0006\u0004xK]5uKJT!\u0001E\t\u0002\u000b\u0005\u0014(o\\<\u000b\u0005I\u0019\u0012!C3yK\u000e,H/[8o\u0015\t!R#A\u0002tc2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u0003=I!aH\b\u0003!\u0005\u0013(o\\<GS\u0016dGm\u0016:ji\u0016\u0014\u0018a\u0003<bYV,g+Z2u_J\u001c\u0001!F\u0001$!\t!#&D\u0001&\u0015\t1s%A\u0004d_6\u0004H.\u001a=\u000b\u0005!J\u0013A\u0002<fGR|'O\u0003\u0002\u0011/%\u00111&\n\u0002\n\u001b\u0006\u0004h+Z2u_J\fAB^1mk\u00164Vm\u0019;pe\u0002\nAb\u001d;sk\u000e$h+Z2u_J,\u0012a\f\t\u0003IAJ!!M\u0013\u0003\u0019M#(/^2u-\u0016\u001cGo\u001c:\u0002\u001bM$(/^2u-\u0016\u001cGo\u001c:!\u0003%YW-_,sSR,'/F\u0001\u001d\u0003)YW-_,sSR,'\u000fI\u0001\fm\u0006dW/Z,sSR,'/\u0001\u0007wC2,Xm\u0016:ji\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0006umbTH\u0010\t\u0003;\u0001AQ\u0001I\u0005A\u0002\rBQ!L\u0005A\u0002=BQaM\u0005A\u0002qAQAN\u0005A\u0002q\tqa]3u\u001dVdG\u000eF\u0001B!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0011)f.\u001b;\u0002\u0011M,GOV1mk\u0016$2!Q%T\u0011\u0015Q5\u00021\u0001L\u0003\u0015Ig\u000e];u!\ta\u0015+D\u0001N\u0015\tqu*A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001)\u0014\u0003!\u0019\u0017\r^1msN$\u0018B\u0001*N\u0005I\u0019\u0006/Z2jC2L'0\u001a3HKR$XM]:\t\u000bQ[\u0001\u0019A+\u0002\u000f=\u0014H-\u001b8bYB\u0011!IV\u0005\u0003/\u000e\u00131!\u00138u\u0003\u00191\u0017N\\5tQ\u0006)!/Z:fi\u0002")
public class MapWriter
extends ArrowFieldWriter {
    private final MapVector valueVector;
    private final StructVector structVector;
    private final ArrowFieldWriter keyWriter;
    private final ArrowFieldWriter valueWriter;

    public MapVector valueVector() {
        return this.valueVector;
    }

    public StructVector structVector() {
        return this.structVector;
    }

    public ArrowFieldWriter keyWriter() {
        return this.keyWriter;
    }

    public ArrowFieldWriter valueWriter() {
        return this.valueWriter;
    }

    @Override
    public void setNull() {
    }

    @Override
    public void setValue(SpecializedGetters input, int ordinal) {
        MapData map = input.getMap(ordinal);
        this.valueVector().startNewValue(this.count());
        ArrayData keys = map.keyArray();
        ArrayData values = map.valueArray();
        for (int i = 0; i < map.numElements(); ++i) {
            this.structVector().setIndexDefined(this.keyWriter().count());
            this.keyWriter().write(keys, i);
            this.valueWriter().write(values, i);
        }
        this.valueVector().endValue(this.count(), map.numElements());
    }

    @Override
    public void finish() {
        super.finish();
        this.keyWriter().finish();
        this.valueWriter().finish();
    }

    @Override
    public void reset() {
        super.reset();
        this.keyWriter().reset();
        this.valueWriter().reset();
    }

    public MapWriter(MapVector valueVector, StructVector structVector, ArrowFieldWriter keyWriter, ArrowFieldWriter valueWriter) {
        this.valueVector = valueVector;
        this.structVector = structVector;
        this.keyWriter = keyWriter;
        this.valueWriter = valueWriter;
    }
}

