/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.spark.annotation.Private;

@Private
public class KVStoreSerializer {
    protected final ObjectMapper mapper = new ObjectMapper();

    public final byte[] serialize(Object o) throws Exception {
        if (o instanceof String) {
            return ((String)o).getBytes(StandardCharsets.UTF_8);
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(bytes);){
            this.mapper.writeValue((OutputStream)out, o);
        }
        return bytes.toByteArray();
    }

    public final <T> T deserialize(byte[] data, Class<T> klass) throws Exception {
        if (klass.equals(String.class)) {
            return (T)new String(data, StandardCharsets.UTF_8);
        }
        try (GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(data));){
            Object object = this.mapper.readValue((InputStream)in, klass);
            return (T)object;
        }
    }

    final byte[] serialize(long value) {
        return String.valueOf(value).getBytes(StandardCharsets.UTF_8);
    }

    final long deserializeLong(byte[] data) {
        return Long.parseLong(new String(data, StandardCharsets.UTF_8));
    }
}

