/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u0011!BT1jm\u0016\u0014\u0015-_3t\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\r\u000e\u0003\u0019I!A\u0007\u0004\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BA\u0002\u0013%Q$\u0001\u0004mC6\u0014G-Y\u000b\u0002=A\u0011qbH\u0005\u0003AA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0007I\u0011B\u0012\u0002\u00151\fWN\u00193b?\u0012*\u0017\u000f\u0006\u0002%OA\u0011q\"J\u0005\u0003MA\u0011A!\u00168ji\"9\u0001&IA\u0001\u0002\u0004q\u0012a\u0001=%c!A!\u0006\u0001B\u0001B\u0003&a$A\u0004mC6\u0014G-\u0019\u0011\t\u00111\u0002!\u00111A\u0005\n5\n\u0011\"\\8eK2$\u0016\u0010]3\u0016\u00039\u0002\"a\f\u001a\u000f\u0005=\u0001\u0014BA\u0019\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\u0002\u0002\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u001c\u0002\u001b5|G-\u001a7UsB,w\fJ3r)\t!\u0003\bC\u0004)k\u0005\u0005\t\u0019\u0001\u0018\t\u0011i\u0002!\u0011!Q!\n9\n!\"\\8eK2$\u0016\u0010]3!\u0011\u0015a\u0004\u0001\"\u0003>\u0003\u0019a\u0014N\\5u}Q\u0019a\bQ!\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000bqY\u0004\u0019\u0001\u0010\t\u000b1Z\u0004\u0019\u0001\u0018\t\u000bq\u0002A\u0011A\"\u0015\u0005y\"\u0005\"\u0002\u000fC\u0001\u0004q\u0002f\u0001\"G\u0019B\u0011qIS\u0007\u0002\u0011*\u0011\u0011JB\u0001\u000bC:tw\u000e^1uS>t\u0017BA&I\u0005\u0015\u0019\u0016N\\2fC\u0005i\u0015!B\u0019/i9\u0002\u0004\"\u0002\u001f\u0001\t\u0003yE#\u0001 )\u000793\u0015+I\u0001S\u0003\u0015\u0001d&\u000f\u00181\u0011\u0015!\u0006\u0001\"\u0001V\u0003%\u0019X\r\u001e'b[\n$\u0017\r\u0006\u0002?-\")Ad\u0015a\u0001=!\u001a1KR)\t\u000be\u0003A\u0011A\u000f\u0002\u0013\u001d,G\u000fT1nE\u0012\f\u0007f\u0001-G\u0019\")A\f\u0001C\u0001;\u0006a1/\u001a;N_\u0012,G\u000eV=qKR\u0011aH\u0018\u0005\u0006Ym\u0003\rA\f\u0015\u00047\u001ac\u0005\"B1\u0001\t\u0003i\u0013\u0001D4fi6{G-\u001a7UsB,\u0007f\u00011G\u0019\")A\r\u0001C\u0001K\u0006\u0019!/\u001e8\u0015\u0005\u0019L\u0007CA h\u0013\tA'AA\bOC&4XMQ1zKNlu\u000eZ3m\u0011\u0015Q7\r1\u0001l\u0003\u0011!\u0017\r^1\u0011\u00071|\u0017/D\u0001n\u0015\tqg!A\u0002sI\u0012L!\u0001]7\u0003\u0007I#E\t\u0005\u0002sk6\t1O\u0003\u0002u\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\n\u0005Y\u001c(\u0001\u0004'bE\u0016dW\r\u001a)pS:$\bfA2G#\"\u001a\u0001AR)\b\u000bi\u0014\u0001\u0012A>\u0002\u00159\u000b\u0017N^3CCf,7\u000f\u0005\u0002@y\u001a)\u0011A\u0001E\u0001{N\u0019AP\u0004\u000b\t\u000bqbH\u0011A@\u0015\u0003mD\u0011\"a\u0001}\u0005\u0004%\tAB\u0017\u0002\u00175+H\u000e^5o_6L\u0017\r\u001c\u0005\b\u0003\u000fa\b\u0015!\u0003/\u00031iU\u000f\u001c;j]>l\u0017.\u00197!\u0011%\tY\u0001 b\u0001\n\u00031Q&A\u0005CKJtw.\u001e7mS\"9\u0011q\u0002?!\u0002\u0013q\u0013A\u0003\"fe:|W\u000f\u001c7jA!Q\u00111\u0003?C\u0002\u0013\u0005a!!\u0006\u0002'M,\b\u000f]8si\u0016$Wj\u001c3fYRK\b/Z:\u0016\u0005\u0005]\u0001#BA\r\u0003GqSBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013%lW.\u001e;bE2,'bAA\u0011!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u00121\u0004\u0002\u0004'\u0016$\b\u0002CA\u0015y\u0002\u0006I!a\u0006\u0002)M,\b\u000f]8si\u0016$Wj\u001c3fYRK\b/Z:!\u0011\u001d\ti\u0003 C\u0001\u0003_\tQ\u0001\u001e:bS:$2AZA\u0019\u0011\u001d\t\u0019$a\u000bA\u0002-\fQ!\u001b8qkRDC!a\u000bG#\"9\u0011Q\u0006?\u0005\u0002\u0005eB#\u00024\u0002<\u0005u\u0002bBA\u001a\u0003o\u0001\ra\u001b\u0005\u00079\u0005]\u0002\u0019\u0001\u0010)\t\u0005]b)\u0015\u0005\b\u0003[aH\u0011AA\")\u001d1\u0017QIA$\u0003\u0013Bq!a\r\u0002B\u0001\u00071\u000e\u0003\u0004\u001d\u0003\u0003\u0002\rA\b\u0005\u0007Y\u0005\u0005\u0003\u0019\u0001\u0018)\t\u0005\u0005c\t\u0014\u0005\n\u0003\u001fb\u0018\u0011!C\u0005\u0003#\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\u0019\u0002X\t1qJ\u00196fGRD3\u0001 $RQ\rIh)\u0015")
public class NaiveBayes
implements Serializable,
Logging {
    private double org$apache$spark$mllib$classification$NaiveBayes$$lambda;
    private String org$apache$spark$mllib$classification$NaiveBayes$$modelType;
    private transient Logger org$apache$spark$Logging$$log_;

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d, String string) {
        return NaiveBayes$.MODULE$.train(rDD, d, string);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d) {
        return NaiveBayes$.MODULE$.train(rDD, d);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD) {
        return NaiveBayes$.MODULE$.train(rDD);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public double org$apache$spark$mllib$classification$NaiveBayes$$lambda() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$lambda;
    }

    private void org$apache$spark$mllib$classification$NaiveBayes$$lambda_$eq(double x$1) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$lambda = x$1;
    }

    public String org$apache$spark$mllib$classification$NaiveBayes$$modelType() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$modelType;
    }

    private void org$apache$spark$mllib$classification$NaiveBayes$$modelType_$eq(String x$1) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$modelType = x$1;
    }

    public NaiveBayes setLambda(double lambda) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$lambda_$eq(lambda);
        return this;
    }

    public double getLambda() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$lambda();
    }

    public NaiveBayes setModelType(String modelType) {
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0)new Serializable(this, modelType){
            public static final long serialVersionUID = 0L;
            private final String modelType$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NaiveBayes was created with an unknown modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.modelType$2}));
            }
            {
                this.modelType$2 = modelType$2;
            }
        });
        this.org$apache$spark$mllib$classification$NaiveBayes$$modelType_$eq(modelType);
        return this;
    }

    public String getModelType() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$modelType();
    }

    public NaiveBayesModel run(RDD<LabeledPoint> data) {
        Tuple2 tuple2;
        Serializable requireNonnegativeValues = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Vector v) {
                Vector vector;
                block6: {
                    double[] dArray;
                    block5: {
                        block4: {
                            vector = v;
                            if (!(vector instanceof SparseVector)) break block4;
                            SparseVector sparseVector = (SparseVector)vector;
                            dArray = sparseVector.values();
                            break block5;
                        }
                        if (!(vector instanceof DenseVector)) break block6;
                        DenseVector denseVector = (DenseVector)vector;
                        dArray = denseVector.values();
                    }
                    double[] values = dArray;
                    if (Predef$.MODULE$.doubleArrayOps(values).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(double x$13) {
                            return this.apply$mcZD$sp(x$13);
                        }

                        public boolean apply$mcZD$sp(double x$13) {
                            return x$13 >= 0.0;
                        }
                    })) {
                        return;
                    }
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Naive Bayes requires nonnegative feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                }
                throw new MatchError((Object)vector);
            }
        };
        Serializable requireZeroOneBernoulliValues = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Vector v) {
                Vector vector;
                block6: {
                    double[] dArray;
                    block5: {
                        block4: {
                            vector = v;
                            if (!(vector instanceof SparseVector)) break block4;
                            SparseVector sparseVector = (SparseVector)vector;
                            dArray = sparseVector.values();
                            break block5;
                        }
                        if (!(vector instanceof DenseVector)) break block6;
                        DenseVector denseVector = (DenseVector)vector;
                        dArray = denseVector.values();
                    }
                    double[] values = dArray;
                    if (Predef$.MODULE$.doubleArrayOps(values).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(double v) {
                            return this.apply$mcZD$sp(v);
                        }

                        public boolean apply$mcZD$sp(double v) {
                            return v == 0.0 || v == 1.0;
                        }
                    })) {
                        return;
                    }
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bernoulli naive Bayes requires 0 or 1 feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                }
                throw new MatchError((Object)vector);
            }
        };
        Tuple2[] aggregated = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint p) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)p.label()), (Object)p.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Double$.MODULE$).combineByKey((Function1)new Serializable(this, (Function1)requireNonnegativeValues, (Function1)requireZeroOneBernoulliValues){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayes $outer;
            private final Function1 requireNonnegativeValues$1;
            private final Function1 requireZeroOneBernoulliValues$1;

            public final Tuple2<Object, DenseVector> apply(Vector v) {
                String string = this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$modelType();
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                Object object = !(string != null ? !string.equals(string2) : string2 != null) ? this.requireZeroOneBernoulliValues$1.apply((Object)v) : this.requireNonnegativeValues$1.apply((Object)v);
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)v.copy().toDense());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.requireNonnegativeValues$1 = requireNonnegativeValues$1;
                this.requireZeroOneBernoulliValues$1 = requireZeroOneBernoulliValues$1;
            }
        }, (Function2)new Serializable(this, (Function1)requireNonnegativeValues){
            public static final long serialVersionUID = 0L;
            private final Function1 requireNonnegativeValues$1;

            public final Tuple2<Object, DenseVector> apply(Tuple2<Object, DenseVector> c, Vector v) {
                this.requireNonnegativeValues$1.apply((Object)v);
                BLAS$.MODULE$.axpy(1.0, v, (Vector)c._2());
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(c._1$mcJ$sp() + 1L)), c._2());
            }
            {
                this.requireNonnegativeValues$1 = requireNonnegativeValues$1;
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, DenseVector> apply(Tuple2<Object, DenseVector> c1, Tuple2<Object, DenseVector> c2) {
                BLAS$.MODULE$.axpy(1.0, (Vector)c2._2(), (Vector)c1._2());
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(c1._1$mcJ$sp() + c2._1$mcJ$sp())), c1._2());
            }
        }).collect()).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Tuple2<Object, DenseVector>> x$14) {
                return x$14._1$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$);
        int numLabels2 = aggregated.length;
        LongRef numDocuments = new LongRef(0L);
        Predef$.MODULE$.refArrayOps((Object[])aggregated).foreach((Function1)new Serializable(this, numDocuments){
            public static final long serialVersionUID = 0L;
            private final LongRef numDocuments$1;

            public final void apply(Tuple2<Object, Tuple2<Object, DenseVector>> x0$1) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Object, DenseVector>> tuple22 = x0$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    long n = tuple2._1$mcJ$sp();
                    this.numDocuments$1.elem += n;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.numDocuments$1 = numDocuments$1;
            }
        });
        Tuple2 tuple22 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])aggregated).head();
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            int n;
            DenseVector v = (DenseVector)tuple2._2();
            int numFeatures = n = v.size();
            double[] labels = new double[numLabels2];
            double[] pi = new double[numLabels2];
            double[][] theta = (double[][])Array$.MODULE$.fill(numLabels2, (Function0)new Serializable(this, numFeatures){
                public static final long serialVersionUID = 0L;
                private final int numFeatures$2;

                public final double[] apply() {
                    return new double[this.numFeatures$2];
                }
                {
                    this.numFeatures$2 = numFeatures$2;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            double piLogDenom = package$.MODULE$.log((double)numDocuments.elem + (double)numLabels2 * this.org$apache$spark$mllib$classification$NaiveBayes$$lambda());
            IntRef i = new IntRef(0);
            Predef$.MODULE$.refArrayOps((Object[])aggregated).foreach((Function1)new Serializable(this, numFeatures, labels, pi, theta, piLogDenom, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NaiveBayes $outer;
                private final int numFeatures$2;
                private final double[] labels$1;
                private final double[] pi$1;
                private final double[][] theta$1;
                private final double piLogDenom$1;
                private final IntRef i$1;

                public final void apply(Tuple2<Object, Tuple2<Object, DenseVector>> x0$2) {
                    Tuple2<Object, Tuple2<Object, DenseVector>> tuple2;
                    block3: {
                        block6: {
                            double d;
                            DenseVector sumTermFreqs;
                            block5: {
                                String string;
                                long n;
                                block4: {
                                    tuple2 = x0$2;
                                    if (tuple2 == null) break block3;
                                    double label = tuple2._1$mcD$sp();
                                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                                    if (tuple22 == null) break block3;
                                    n = tuple22._1$mcJ$sp();
                                    sumTermFreqs = (DenseVector)tuple22._2();
                                    this.labels$1[this.i$1.elem] = label;
                                    this.pi$1[this.i$1.elem] = package$.MODULE$.log((double)n + this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda()) - this.piLogDenom$1;
                                    string = this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$modelType();
                                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                                    String string3 = string;
                                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block4;
                                    d = package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sumTermFreqs.values()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + (double)this.numFeatures$2 * this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda());
                                    break block5;
                                }
                                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                                String string5 = string;
                                if (string4 != null ? !string4.equals(string5) : string5 != null) break block6;
                                d = package$.MODULE$.log((double)n + 2.0 * this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda());
                            }
                            double thetaLogDenom = d;
                            for (int j = 0; j < this.numFeatures$2; ++j) {
                                this.theta$1[this.i$1.elem][j] = package$.MODULE$.log(sumTermFreqs.apply(j) + this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda()) - thetaLogDenom;
                            }
                            ++this.i$1.elem;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$modelType()})));
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.numFeatures$2 = numFeatures$2;
                    this.labels$1 = labels$1;
                    this.pi$1 = pi$1;
                    this.theta$1 = theta$1;
                    this.piLogDenom$1 = piLogDenom$1;
                    this.i$1 = i$1;
                }
            });
            return new NaiveBayesModel(labels, pi, theta, this.org$apache$spark$mllib$classification$NaiveBayes$$modelType());
        }
        throw new MatchError((Object)tuple22);
    }

    public NaiveBayes(double lambda, String modelType) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$lambda = lambda;
        this.org$apache$spark$mllib$classification$NaiveBayes$$modelType = modelType;
        Logging.class.$init$((Logging)this);
    }

    public NaiveBayes(double lambda) {
        this(lambda, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayes() {
        this(1.0, NaiveBayes$.MODULE$.Multinomial());
    }
}

