/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseMatrix;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Matrix$class;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.spark-project.guava.base.Objects;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@SQLUserDefinedType(udt=MatrixUDT.class)
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u00015\u00111\u0002R3og\u0016l\u0015\r\u001e:jq*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0005\t3\u0001\u0011)\u0019!C\u00015\u00059a.^7S_^\u001cX#A\u000e\u0011\u0005=a\u0012BA\u000f\u0011\u0005\rIe\u000e\u001e\u0015\u00041})\u0003C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003I\u0005\u0012QaU5oG\u0016\f\u0013AJ\u0001\u0006c9\u0002d\u0006\r\u0005\tQ\u0001\u0011\t\u0011)A\u00057\u0005Aa.^7S_^\u001c\b\u0005K\u0002(?\u0015B\u0001b\u000b\u0001\u0003\u0006\u0004%\tAG\u0001\b]Vl7i\u001c7tQ\rQs$\n\u0005\t]\u0001\u0011\t\u0011)A\u00057\u0005Aa.^7D_2\u001c\b\u0005K\u0002.?\u0015B\u0001\"\r\u0001\u0003\u0006\u0004%\tAM\u0001\u0007m\u0006dW/Z:\u0016\u0003M\u00022a\u0004\u001b7\u0013\t)\u0004CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010o%\u0011\u0001\b\u0005\u0002\u0007\t>,(\r\\3)\u0007AzR\u0005\u0003\u0005<\u0001\t\u0005\t\u0015!\u00034\u0003\u001d1\u0018\r\\;fg\u0002B3AO\u0010&\u0011!q\u0004A!b\u0001\n\u0003z\u0014\u0001D5t)J\fgn\u001d9pg\u0016$W#\u0001!\u0011\u0005=\t\u0015B\u0001\"\u0011\u0005\u001d\u0011un\u001c7fC:D3!P\u0010EC\u0005)\u0015!B\u0019/g9\u0002\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002\u001b%\u001cHK]1ogB|7/\u001a3!Q\r1u\u0004\u0012\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1ku*U*\u0011\u0005U\u0001\u0001\"B\rJ\u0001\u0004Y\u0002fA' K!)1&\u0013a\u00017!\u001aqjH\u0013\t\u000bEJ\u0005\u0019A\u001a)\u0007E{R\u0005C\u0003?\u0013\u0002\u0007\u0001\tK\u0002T?\u0011C3!S\u0010E\u0011\u0015Q\u0005\u0001\"\u0001X)\u0011a\u0005,\u0017.\t\u000be1\u0006\u0019A\u000e\t\u000b-2\u0006\u0019A\u000e\t\u000bE2\u0006\u0019A\u001a)\u0007Y{R\u0005C\u0003^\u0001\u0011\u0005c,\u0001\u0004fcV\fGn\u001d\u000b\u0003\u0001~CQ\u0001\u0019/A\u0002\u0005\f\u0011a\u001c\t\u0003\u001f\tL!a\u0019\t\u0003\u0007\u0005s\u0017\u0010C\u0003f\u0001\u0011\u0005c-\u0001\u0005iCND7i\u001c3f)\u0005Y\u0002B\u00025\u0001\t\u0003!\u0011.\u0001\u0005u_\n\u0013X-\u001a>f+\u0005Q\u0007cA6pm5\tAN\u0003\u0002\u0004[*\ta.\u0001\u0004ce\u0016,'0Z\u0005\u0003/1Da!\u001d\u0001\u0005\u0002\u0011\u0011\u0018!B1qa2LHC\u0001\u001ct\u0011\u0015!\b\u000f1\u0001\u001c\u0003\u0005I\u0007\"B9\u0001\t\u00032Hc\u0001\u001cxq\")A/\u001ea\u00017!)\u00110\u001ea\u00017\u0005\t!\u000eK\u0002v?\u0011Ca\u0001 \u0001\u0005\u0002\u0011i\u0018!B5oI\u0016DHcA\u000e\u007f\u007f\")Ao\u001fa\u00017!)\u0011p\u001fa\u00017!A\u00111\u0001\u0001\u0005\u0002\u0011\t)!\u0001\u0004va\u0012\fG/\u001a\u000b\t\u0003\u000f\ti!a\u0004\u0002\u0012A\u0019q\"!\u0003\n\u0007\u0005-\u0001C\u0001\u0003V]&$\bB\u0002;\u0002\u0002\u0001\u00071\u0004\u0003\u0004z\u0003\u0003\u0001\ra\u0007\u0005\b\u0003'\t\t\u00011\u00017\u0003\u00051\bbBA\f\u0001\u0011\u0005\u0013\u0011D\u0001\u0005G>\u0004\u00180F\u0001MQ\u0015\t)bHA\u000fC\t\ty\"A\u00032]Qr\u0003\u0007\u0003\u0005\u0002$\u0001!\tABA\u0013\u0003\ri\u0017\r\u001d\u000b\u0004\u0019\u0006\u001d\u0002\u0002CA\u0015\u0003C\u0001\r!a\u000b\u0002\u0003\u0019\u0004RaDA\u0017mYJ1!a\f\u0011\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0005\u0002\u0004\u0001!\t\u0001BA\u001a)\ra\u0015Q\u0007\u0005\t\u0003S\t\t\u00041\u0001\u0002,!9\u0011\u0011\b\u0001\u0005B\u0005e\u0011!\u0003;sC:\u001c\bo\\:fQ\u0011\t9d\b#\t\u0011\u0005}\u0002\u0001\"\u0011\u0007\u0003\u0003\nQBZ8sK\u0006\u001c\u0007.Q2uSZ,G\u0003BA\u0004\u0003\u0007B\u0001\"!\u000b\u0002>\u0001\u0007\u0011Q\t\t\t\u001f\u0005\u001d3d\u0007\u001c\u0002\b%\u0019\u0011\u0011\n\t\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004BBA'\u0001\u0011\u0005#$A\u0006ok6tuN\u001c>fe>\u001c\b&BA&?\u0005E\u0013EAA*\u0003\u0015\td&\u000e\u00181\u0011\u0019\t9\u0006\u0001C!5\u0005Qa.^7BGRLg/Z:)\u000b\u0005Us$!\u0015\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`\u0005AAo\\*qCJ\u001cX-\u0006\u0002\u0002bA\u0019Q#a\u0019\n\u0007\u0005\u0015$A\u0001\u0007Ta\u0006\u00148/Z'biJL\u0007\u0010\u000b\u0003\u0002\\}!\u0005f\u0002\u0001\u0002l\u0005m\u0014Q\u0010\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0015!\u0018\u0010]3t\u0015\r\t)HB\u0001\u0004gFd\u0017\u0002BA=\u0003_\u0012!cU)M+N,'\u000fR3gS:,G\rV=qK\u0006\u0019Q\u000f\u001a;$\u0005\u0005}\u0004cA\u000b\u0002\u0002&\u0019\u00111\u0011\u0002\u0003\u00135\u000bGO]5y+\u0012#\u0006f\u0001\u0001 K\u001d9\u0011\u0011\u0012\u0002\t\u0002\u0005-\u0015a\u0003#f]N,W*\u0019;sSb\u00042!FAG\r\u0019\t!\u0001#\u0001\u0002\u0010N)\u0011Q\u0012\b\u0002\u0012B\u0019q\"a%\n\u0007\u0005U\u0005C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004K\u0003\u001b#\t!!'\u0015\u0005\u0005-\u0005\u0002CAO\u0003\u001b#\t!a(\u0002\u000bi,'o\\:\u0015\u000b1\u000b\t+a)\t\re\tY\n1\u0001\u001c\u0011\u0019Y\u00131\u0014a\u00017!\"\u00111T\u0010E\u0011!\tI+!$\u0005\u0002\u0005-\u0016\u0001B8oKN$R\u0001TAW\u0003_Ca!GAT\u0001\u0004Y\u0002BB\u0016\u0002(\u0002\u00071\u0004\u000b\u0003\u0002(~!\u0005\u0002CA[\u0003\u001b#\t!a.\u0002\u0007\u0015LX\rF\u0002M\u0003sCq!a/\u00024\u0002\u00071$A\u0001oQ\u0011\t\u0019l\b#\t\u0011\u0005\u0005\u0017Q\u0012C\u0001\u0003\u0007\fAA]1oIR9A*!2\u0002H\u0006%\u0007BB\r\u0002@\u0002\u00071\u0004\u0003\u0004,\u0003\u007f\u0003\ra\u0007\u0005\t\u0003\u0017\fy\f1\u0001\u0002N\u0006\u0019!O\\4\u0011\t\u0005=\u0017\u0011\\\u0007\u0003\u0003#TA!a5\u0002V\u0006!Q\u000f^5m\u0015\t\t9.\u0001\u0003kCZ\f\u0017\u0002BAn\u0003#\u0014aAU1oI>l\u0007\u0006BA`?\u0011C\u0001\"!9\u0002\u000e\u0012\u0005\u00111]\u0001\u0006e\u0006tGM\u001c\u000b\b\u0019\u0006\u0015\u0018q]Au\u0011\u0019I\u0012q\u001ca\u00017!11&a8A\u0002mA\u0001\"a3\u0002`\u0002\u0007\u0011Q\u001a\u0015\u0005\u0003?|B\t\u0003\u0005\u0002p\u00065E\u0011AAy\u0003\u0011!\u0017.Y4\u0015\u00071\u000b\u0019\u0010\u0003\u0005\u0002v\u00065\b\u0019AA|\u0003\u00191Xm\u0019;peB\u0019Q#!?\n\u0007\u0005m(A\u0001\u0004WK\u000e$xN\u001d\u0015\u0005\u0003[|B\t\u0003\u0006\u0003\u0002\u00055\u0015\u0011!C\u0005\u0005\u0007\t1B]3bIJ+7o\u001c7wKR\u0011!Q\u0001\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)!!1BAk\u0003\u0011a\u0017M\\4\n\t\t=!\u0011\u0002\u0002\u0007\u001f\nTWm\u0019;)\t\u00055u\u0004\u0012\u0015\u0005\u0003\u000f{B\t")
public class DenseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final double[] values;
    private final boolean isTransposed;

    public static DenseMatrix diag(Vector vector) {
        return DenseMatrix$.MODULE$.diag(vector);
    }

    public static DenseMatrix randn(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.randn(n, n2, random);
    }

    public static DenseMatrix rand(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.rand(n, n2, random);
    }

    public static DenseMatrix eye(int n) {
        return DenseMatrix$.MODULE$.eye(n);
    }

    public static DenseMatrix ones(int n, int n2) {
        return DenseMatrix$.MODULE$.ones(n, n2);
    }

    public static DenseMatrix zeros(int n, int n2) {
        return DenseMatrix$.MODULE$.zeros(n, n2);
    }

    @Override
    public void org$apache$spark$mllib$linalg$Matrix$_setter_$isTransposed_$eq(boolean x$1) {
    }

    @Override
    public double[] toArray() {
        return Matrix$class.toArray(this);
    }

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(Vector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix$class.toString(this);
    }

    @Override
    public String toString(int maxLines, int maxLineWidth) {
        return Matrix$class.toString(this, maxLines, maxLineWidth);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public boolean isTransposed() {
        return this.isTransposed;
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            breeze.linalg.Matrix<Object> matrix2 = this.toBreeze();
            breeze.linalg.Matrix<Object> matrix3 = matrix.toBreeze();
            bl = !(matrix2 != null ? !matrix2.equals(matrix3) : matrix3 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Predef$.MODULE$.int2Integer(this.numRows()), Predef$.MODULE$.int2Integer(this.numCols()), this.toArray()});
    }

    @Override
    public breeze.linalg.Matrix<Object> toBreeze() {
        DenseMatrix.mcD.sp sp2;
        if (this.isTransposed()) {
            DenseMatrix.mcD.sp breezeMatrix = new DenseMatrix.mcD.sp(this.numCols(), this.numRows(), this.values());
            sp2 = (breeze.linalg.Matrix)breezeMatrix.t(breeze.linalg.DenseMatrix$.MODULE$.canTranspose());
        } else {
            sp2 = new DenseMatrix.mcD.sp(this.numRows(), this.numCols(), this.values());
        }
        return sp2;
    }

    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public double apply(int i, int j) {
        return this.values()[this.index(i, j)];
    }

    @Override
    public int index(int i, int j) {
        Predef$.MODULE$.require(i >= 0 && i < this.numRows(), (Function0)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DenseMatrix $outer;
            private final int i$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected 0 <= i < ", ", got i = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numRows()), BoxesRunTime.boxToInteger((int)this.i$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i$1 = i$1;
            }
        });
        Predef$.MODULE$.require(j >= 0 && j < this.numCols(), (Function0)new Serializable(this, j){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DenseMatrix $outer;
            private final int j$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected 0 <= j < ", ", got j = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numCols()), BoxesRunTime.boxToInteger((int)this.j$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.j$1 = j$1;
            }
        });
        return this.isTransposed() ? j + this.numCols() * i : i + this.numRows() * j;
    }

    @Override
    public void update(int i, int j, double v) {
        this.values()[this.index((int)i, (int)j)] = v;
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])this.values().clone());
    }

    @Override
    public DenseMatrix map(Function1<Object, Object> f) {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])Predef$.MODULE$.doubleArrayOps(this.values()).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), this.isTransposed());
    }

    @Override
    public DenseMatrix update(Function1<Object, Object> f) {
        int len = this.values().length;
        for (int i = 0; i < len; ++i) {
            this.values()[i] = f.apply$mcDD$sp(this.values()[i]);
        }
        return this;
    }

    @Override
    public DenseMatrix transpose() {
        return new DenseMatrix(this.numCols(), this.numRows(), this.values(), !this.isTransposed());
    }

    @Override
    public void foreachActive(Function3<Object, Object, Object, BoxedUnit> f) {
        if (this.isTransposed()) {
            for (int i = 0; i < this.numRows(); ++i) {
                int indStart = i * this.numCols();
                for (int j = 0; j < this.numCols(); ++j) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + j]));
                }
            }
        } else {
            for (int j = 0; j < this.numCols(); ++j) {
                int indStart = j * this.numRows();
                for (int i = 0; i < this.numRows(); ++i) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + i]));
                }
            }
        }
    }

    @Override
    public int numNonzeros() {
        return Predef$.MODULE$.doubleArrayOps(this.values()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$5) {
                return this.apply$mcZD$sp(x$5);
            }

            public boolean apply$mcZD$sp(double x$5) {
                return x$5 != 0.0;
            }
        });
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    public SparseMatrix toSparse() {
        ArrayBuilder.ofDouble spVals = new ArrayBuilder.ofDouble();
        int[] colPtrs = new int[this.numCols() + 1];
        ArrayBuilder.ofInt rowIndices = new ArrayBuilder.ofInt();
        int nnz = 0;
        int j = 0;
        while (j < this.numCols()) {
            for (int i = 0; i < this.numRows(); ++i) {
                double v = this.values()[this.index(i, j)];
                if (v == 0.0) continue;
                rowIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                spVals.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                ++nnz;
            }
            colPtrs[++j] = nnz;
        }
        return new SparseMatrix(this.numRows(), this.numCols(), colPtrs, (int[])rowIndices.result(), (double[])spVals.result());
    }

    public DenseMatrix(int numRows2, int numCols, double[] values, boolean isTransposed) {
        this.numRows = numRows2;
        this.numCols = numCols;
        this.values = values;
        this.isTransposed = isTransposed;
        Matrix$class.$init$(this);
        Predef$.MODULE$.require(values.length == numRows2 * numCols, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DenseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of values supplied doesn't match the ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size of the matrix! values.length: ", ", numRows * numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), BoxesRunTime.boxToInteger((int)(this.$outer.numRows() * this.$outer.numCols()))}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public DenseMatrix(int numRows2, int numCols, double[] values) {
        this(numRows2, numCols, values, false);
    }
}

