/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impurity;

import scala.Double$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3a!\u0001\u0002\u0002\u0002!q!AE%naV\u0014\u0018\u000e^=DC2\u001cW\u000f\\1u_JT!a\u0001\u0003\u0002\u0011%l\u0007/\u001e:jifT!!\u0002\u0004\u0002\tQ\u0014X-\u001a\u0006\u0003\u000f!\tQ!\u001c7mS\nT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t3\u0001\u0011)\u0019!C\u00017\u0005)1\u000f^1ug\u000e\u0001Q#\u0001\u000f\u0011\u0007Air$\u0003\u0002\u001f#\t)\u0011I\u001d:bsB\u0011\u0001\u0003I\u0005\u0003CE\u0011a\u0001R8vE2,\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\rM$\u0018\r^:!\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0011q%\u000b\t\u0003Q\u0001i\u0011A\u0001\u0005\u00063\u0011\u0002\r\u0001\b\u0005\u0006W\u00011\t\u0001L\u0001\u0005G>\u0004\u00180F\u0001(\u0011\u0015q\u0003A\"\u00010\u0003%\u0019\u0017\r\\2vY\u0006$X\rF\u0001 \u0011\u0015\t\u0004\u0001\"\u00013\u0003\r\tG\r\u001a\u000b\u0003OMBQ\u0001\u000e\u0019A\u0002\u001d\nQa\u001c;iKJDQA\u000e\u0001\u0005\u0002]\n\u0001b];ciJ\f7\r\u001e\u000b\u0003OaBQ\u0001N\u001bA\u0002\u001dBQA\u000f\u0001\u0007\u0002m\nQaY8v]R,\u0012\u0001\u0010\t\u0003!uJ!AP\t\u0003\t1{gn\u001a\u0005\u0006\u0001\u00021\t!Q\u0001\baJ,G-[2u+\u0005y\u0002\"B\"\u0001\t\u0003!\u0015\u0001\u00029s_\n$\"aH#\t\u000b\u0019\u0013\u0005\u0019A\u0010\u0002\u000b1\f'-\u001a7\t\u000b!\u0003A\u0011C%\u00025%tG-\u001a=PM2\u000b'oZ3ti\u0006\u0013(/Y=FY\u0016lWM\u001c;\u0015\u0005)k\u0005C\u0001\tL\u0013\ta\u0015CA\u0002J]RDQAT$A\u0002q\tQ!\u0019:sCf\u0004")
public abstract class ImpurityCalculator
implements Serializable {
    private final double[] stats;

    public double[] stats() {
        return this.stats;
    }

    public abstract ImpurityCalculator copy();

    public abstract double calculate();

    public ImpurityCalculator add(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ImpurityCalculator $outer;
            private final ImpurityCalculator other$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Two ImpurityCalculator instances cannot be added with different counts sizes."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Sizes are ", " and ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stats().length), BoxesRunTime.boxToInteger((int)this.other$1.stats().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] + other.stats()[i];
        }
        return this;
    }

    public ImpurityCalculator subtract(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ImpurityCalculator $outer;
            private final ImpurityCalculator other$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Two ImpurityCalculator instances cannot be subtracted with different counts sizes."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Sizes are ", " and ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stats().length), BoxesRunTime.boxToInteger((int)this.other$2.stats().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$2 = other$2;
            }
        });
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] - other.stats()[i];
        }
        return this;
    }

    public abstract long count();

    public abstract double predict();

    public double prob(double label) {
        return -1.0;
    }

    public int indexOfLargestArrayElement(double[] array) {
        Tuple3 result = (Tuple3)Predef$.MODULE$.doubleArrayOps(array).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x0$1, double x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, (Object)BoxesRunTime.boxToDouble((double)x1$1));
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    double currentValue = tuple2._2$mcD$sp();
                    if (tuple3 != null) {
                        int maxIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double maxValue = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        int currentIndex = BoxesRunTime.unboxToInt((Object)tuple3._3());
                        Tuple3 tuple32 = currentValue > maxValue ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)currentIndex), (Object)BoxesRunTime.boxToDouble((double)currentValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1))) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxIndex), (Object)BoxesRunTime.boxToDouble((double)maxValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1)));
                        return tuple32;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        if (BoxesRunTime.unboxToInt((Object)result._1()) < 0) {
            throw new RuntimeException("ImpurityCalculator internal error: indexOfLargestArrayElement failed");
        }
        return BoxesRunTime.unboxToInt((Object)result._1());
    }

    public ImpurityCalculator(double[] stats) {
        this.stats = stats;
    }
}

