/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquaresModel;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001-4Q!\u0001\u0002\u0001\t1\u0011\u0011%\u0013;fe\u0006$\u0018N^3msJ+w/Z5hQR,G\rT3bgR\u001c\u0016/^1sKNT!a\u0001\u0003\u0002\u000b=\u0004H/[7\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0003\u0002\u0001\u000e'e\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001e\u0004\"A\u0004\u000e\n\u0005my!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011A\u0010\u0002\u0019%t\u0017\u000e^5bY6{G-\u001a7\u0004\u0001U\t\u0001\u0005\u0005\u0002\"E5\t!!\u0003\u0002$\u0005\tIr+Z5hQR,G\rT3bgR\u001c\u0016/^1sKNlu\u000eZ3m\u0011!)\u0003A!A!\u0002\u0013\u0001\u0013!D5oSRL\u0017\r\\'pI\u0016d\u0007\u0005\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001)\u00031\u0011Xm^3jO\"$h)\u001e8d+\u0005I\u0003#\u0002\b+Y\u0001\u0012\u0014BA\u0016\u0010\u0005%1UO\\2uS>t'\u0007\u0005\u0002.a5\taF\u0003\u00020\t\u00059a-Z1ukJ,\u0017BA\u0019/\u0005!Ien\u001d;b]\u000e,\u0007\u0003\u0002\b4kUJ!\u0001N\b\u0003\rQ+\b\u000f\\33!\tqa'\u0003\u00028\u001f\t1Ai\\;cY\u0016D\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I!K\u0001\u000ee\u0016<X-[4ii\u001a+hn\u0019\u0011\t\u0011m\u0002!Q1A\u0005\u0002q\nABZ5u\u0013:$XM]2faR,\u0012!\u0010\t\u0003\u001dyJ!aP\b\u0003\u000f\t{w\u000e\\3b]\"A\u0011\t\u0001B\u0001B\u0003%Q(A\u0007gSRLe\u000e^3sG\u0016\u0004H\u000f\t\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\u0006A!/Z4QCJ\fW.F\u00016\u0011!1\u0005A!A!\u0002\u0013)\u0014!\u0003:fOB\u000b'/Y7!\u0011!A\u0005A!b\u0001\n\u0003I\u0015aB7bq&#XM]\u000b\u0002\u0015B\u0011abS\u0005\u0003\u0019>\u00111!\u00138u\u0011!q\u0005A!A!\u0002\u0013Q\u0015\u0001C7bq&#XM\u001d\u0011\t\u0011A\u0003!Q1A\u0005\u0002\u0011\u000b1\u0001^8m\u0011!\u0011\u0006A!A!\u0002\u0013)\u0014\u0001\u0002;pY\u0002BQ\u0001\u0016\u0001\u0005\u0002U\u000ba\u0001P5oSRtDc\u0002,X1fS6\f\u0018\t\u0003C\u0001AQ!H*A\u0002\u0001BQaJ*A\u0002%BQaO*A\u0002uBQaQ*A\u0002UBQ\u0001S*A\u0002)CQ\u0001U*A\u0002UBQA\u0018\u0001\u0005\u0002}\u000b1AZ5u)\t\u00017\r\u0005\u0002\"C&\u0011!M\u0001\u0002'\u0013R,'/\u0019;jm\u0016d\u0017PU3xK&<\u0007\u000e^3e\u0019\u0016\f7\u000f^*rk\u0006\u0014Xm]'pI\u0016d\u0007\"\u00023^\u0001\u0004)\u0017!C5ogR\fgnY3t!\r1\u0017\u000eL\u0007\u0002O*\u0011\u0001NB\u0001\u0004e\u0012$\u0017B\u00016h\u0005\r\u0011F\t\u0012")
public class IterativelyReweightedLeastSquares
implements Logging,
Serializable {
    private final WeightedLeastSquaresModel initialModel;
    private final Function2<Instance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc;
    private final boolean fitIntercept;
    private final double regParam;
    private final int maxIter;
    private final double tol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public WeightedLeastSquaresModel initialModel() {
        return this.initialModel;
    }

    public Function2<Instance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc() {
        return this.reweightFunc;
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    public IterativelyReweightedLeastSquaresModel fit(RDD<Instance> instances) {
        boolean converged = false;
        IntRef iter = IntRef.create((int)0);
        WeightedLeastSquaresModel model = this.initialModel();
        ObjectRef oldModel = ObjectRef.create(null);
        while (iter.elem < this.maxIter() && !converged) {
            oldModel.elem = model;
            RDD newInstances = instances.map((Function1)new Serializable(this, oldModel){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IterativelyReweightedLeastSquares $outer;
                private final ObjectRef oldModel$1;

                public final Instance apply(Instance instance) {
                    Tuple2 tuple2 = (Tuple2)this.$outer.reweightFunc().apply((Object)instance, (Object)((WeightedLeastSquaresModel)this.oldModel$1.elem));
                    if (tuple2 != null) {
                        Tuple2.mcDD.sp sp2;
                        double newOffset = tuple2._1$mcD$sp();
                        double newWeight = tuple2._2$mcD$sp();
                        Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(newOffset, newWeight);
                        double newOffset2 = sp3._1$mcD$sp();
                        double newWeight2 = sp3._2$mcD$sp();
                        return new Instance(newOffset2, newWeight2, instance.features());
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.oldModel$1 = oldModel$1;
                }
            }, ClassTag$.MODULE$.apply(Instance.class));
            model = new WeightedLeastSquares(this.fitIntercept(), this.regParam(), 0.0, false, false, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8()).fit((RDD<Instance>)newInstances);
            DenseVector oldCoefficients = ((WeightedLeastSquaresModel)oldModel.elem).coefficients();
            DenseVector coefficients2 = model.coefficients();
            BLAS$.MODULE$.axpy(-1.0, (Vector)coefficients2, (Vector)oldCoefficients);
            double maxTolOfCoefficients = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(oldCoefficients.toArray()).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x, double y) {
                    return this.apply$mcDDD$sp(x, y);
                }

                public double apply$mcDDD$sp(double x, double y) {
                    return package$.MODULE$.max(package$.MODULE$.abs(x), package$.MODULE$.abs(y));
                }
            }));
            double maxTol = package$.MODULE$.max(maxTolOfCoefficients, package$.MODULE$.abs(((WeightedLeastSquaresModel)oldModel.elem).intercept() - model.intercept()));
            if (maxTol < this.tol()) {
                converged = true;
                this.logInfo((Function0<String>)new Serializable(this, iter){
                    public static final long serialVersionUID = 0L;
                    private final IntRef iter$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IRLS converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iter$1.elem)}));
                    }
                    {
                        this.iter$1 = iter$1;
                    }
                });
            }
            this.logInfo((Function0<String>)new Serializable(this, iter, maxTol){
                public static final long serialVersionUID = 0L;
                private final IntRef iter$1;
                private final double maxTol$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iteration ", " : relative tolerance = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iter$1.elem), BoxesRunTime.boxToDouble((double)this.maxTol$1)}));
                }
                {
                    this.iter$1 = iter$1;
                    this.maxTol$1 = maxTol$1;
                }
            });
            ++iter.elem;
            if (iter.elem != this.maxIter()) continue;
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IterativelyReweightedLeastSquares $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IRLS reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.maxIter())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return new IterativelyReweightedLeastSquaresModel(model.coefficients(), model.intercept(), model.diagInvAtWA(), iter.elem);
    }

    public IterativelyReweightedLeastSquares(WeightedLeastSquaresModel initialModel, Function2<Instance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc, boolean fitIntercept, double regParam, int maxIter, double tol) {
        this.initialModel = initialModel;
        this.reweightFunc = reweightFunc;
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.maxIter = maxIter;
        this.tol = tol;
        Logging.class.$init$((Logging)this);
    }
}

