/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.r.LogisticRegressionWrapper$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg!B\u0001\u0003\u0001\ta!!\u0007'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:<&/\u00199qKJT!a\u0001\u0003\u0002\u0003IT!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0011\tA!\u001e;jY&\u0011\u0001$\u0006\u0002\u000b\u001b2;&/\u001b;bE2,\u0007\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u0011AL\u0007/\u001a7j]\u0016\u001c\u0001!F\u0001\u001e!\tqr$D\u0001\u0005\u0013\t\u0001CAA\u0007QSB,G.\u001b8f\u001b>$W\r\u001c\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u0005I\u0001/\u001b9fY&tW\r\t\u0005\tI\u0001\u0011)\u0019!C\u0001K\u0005Aa-Z1ukJ,7/F\u0001'!\rqq%K\u0005\u0003Q=\u0011Q!\u0011:sCf\u0004\"AK\u0017\u000f\u00059Y\u0013B\u0001\u0017\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051z\u0001\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0013\u0019,\u0017\r^;sKN\u0004\u0003\u0002C\u001a\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002\r1\f'-\u001a7t\u0011!)\u0004A!A!\u0002\u00131\u0013a\u00027bE\u0016d7\u000f\t\u0005\u0006o\u0001!I\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\teZD(\u0010\t\u0003u\u0001i\u0011A\u0001\u0005\u00065Y\u0002\r!\b\u0005\u0006IY\u0002\rA\n\u0005\u0006gY\u0002\rA\n\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0003\u001da'/T8eK2,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\tab\u00197bgNLg-[2bi&|g.\u0003\u0002G\u0007\n9Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0005\u0007\u0011\u0002\u0001\u000b\u0011B!\u0002\u00111\u0014Xj\u001c3fY\u0002BqA\u0013\u0001C\u0002\u0013\u0005Q%A\u0005s\r\u0016\fG/\u001e:fg\"1A\n\u0001Q\u0001\n\u0019\n!B\u001d$fCR,(/Z:!\u0011\u001dq\u0005A1A\u0005\u0002=\u000bQB]\"pK\u001a4\u0017nY5f]R\u001cX#\u0001)\u0011\u000799\u0013\u000b\u0005\u0002\u000f%&\u00111k\u0004\u0002\u0007\t>,(\r\\3\t\rU\u0003\u0001\u0015!\u0003Q\u00039\u00118i\\3gM&\u001c\u0017.\u001a8ug\u0002BQa\u0016\u0001\u0005\u0002a\u000b\u0011\u0002\u001e:b]N4wN]7\u0015\u0005ek\u0007C\u0001.k\u001d\tYvM\u0004\u0002]K:\u0011Q\f\u001a\b\u0003=\u000et!a\u00182\u000e\u0003\u0001T!!Y\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002g\r\u0005\u00191/\u001d7\n\u0005!L\u0017a\u00029bG.\fw-\u001a\u0006\u0003M\u001aI!a\u001b7\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00015j\u0011\u0015qg\u000b1\u0001p\u0003\u001d!\u0017\r^1tKR\u0004$\u0001\u001d<\u0011\u0007E\u0014H/D\u0001j\u0013\t\u0019\u0018NA\u0004ECR\f7/\u001a;\u0011\u0005U4H\u0002\u0001\u0003\no6\f\t\u0011!A\u0003\u0002a\u00141a\u0018\u00132#\tIH\u0010\u0005\u0002\u000fu&\u00111p\u0004\u0002\b\u001d>$\b.\u001b8h!\tqQ0\u0003\u0002\u007f\u001f\t\u0019\u0011I\\=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005)qO]5uKV\u0011\u0011Q\u0001\t\u0004)\u0005\u001d\u0011bAA\u0005+\tAQ\nT,sSR,'o\u0002\u0005\u0002\u000e\tA\tAAA\b\u0003eaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Xe\u0006\u0004\b/\u001a:\u0011\u0007i\n\tBB\u0004\u0002\u0005!\u0005!!a\u0005\u0014\u000b\u0005EQ\"!\u0006\u0011\tQ\t9\"O\u0005\u0004\u00033)\"AC'M%\u0016\fG-\u00192mK\"9q'!\u0005\u0005\u0002\u0005uACAA\b\u0011)\t\t#!\u0005C\u0002\u0013\u0005\u00111E\u0001\u001a!J+E)S\"U\u000b\u0012{F*\u0011\"F\u0019~Ke\nR#Y?\u000e{E*\u0006\u0002\u0002&A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00027b]\u001eT!!a\f\u0002\t)\fg/Y\u0005\u0004]\u0005%\u0002\"CA\u001b\u0003#\u0001\u000b\u0011BA\u0013\u0003i\u0001&+\u0012#J\u0007R+Ei\u0018'B\u0005\u0016cu,\u0013(E\u000bb{6i\u0014'!\u0011)\tI$!\u0005C\u0002\u0013\u0005\u00111E\u0001\u0014!J+E)S\"U\u000b\u0012{F*\u0011\"F\u0019~\u001bu\n\u0014\u0005\n\u0003{\t\t\u0002)A\u0005\u0003K\tA\u0003\u0015*F\t&\u001bE+\u0012#`\u0019\u0006\u0013U\tT0D\u001f2\u0003\u0003\u0002CA!\u0003#!\t!a\u0011\u0002\u0007\u0019LG\u000fF\u000b:\u0003\u000b\nI%!\u0014\u0002R\u0005U\u0013qLA2\u0003O\n\t(!\u001e\t\u000f\u0005\u001d\u0013q\ba\u00013\u0006!A-\u0019;b\u0011\u001d\tY%a\u0010A\u0002%\nqAZ8s[Vd\u0017\rC\u0004\u0002P\u0005}\u0002\u0019A)\u0002\u0011I,w\rU1sC6Dq!a\u0015\u0002@\u0001\u0007\u0011+A\bfY\u0006\u001cH/[2OKR\u0004\u0016M]1n\u0011!\t9&a\u0010A\u0002\u0005e\u0013aB7bq&#XM\u001d\t\u0004\u001d\u0005m\u0013bAA/\u001f\t\u0019\u0011J\u001c;\t\u000f\u0005\u0005\u0014q\ba\u0001#\u0006\u0019Ao\u001c7\t\u000f\u0005\u0015\u0014q\ba\u0001S\u00051a-Y7jYfD\u0001\"!\u001b\u0002@\u0001\u0007\u00111N\u0001\u0010gR\fg\u000eZ1sI&T\u0018\r^5p]B\u0019a\"!\u001c\n\u0007\u0005=tBA\u0004C_>dW-\u00198\t\u000f\u0005M\u0014q\ba\u0001!\u0006QA\u000f\u001b:fg\"|G\u000eZ:\t\u000f\u0005]\u0014q\ba\u0001S\u0005Iq/Z5hQR\u001cu\u000e\u001c\u0005\t\u0003w\n\t\u0002\"\u0011\u0002~\u0005!!/Z1e+\t\ty\b\u0005\u0003\u0015\u0003\u0003K\u0014bAAB+\tAQ\n\u0014*fC\u0012,'\u000f\u0003\u0005\u0002\b\u0006EA\u0011IAE\u0003\u0011aw.\u00193\u0015\u0007e\nY\tC\u0004\u0002\u000e\u0006\u0015\u0005\u0019A\u0015\u0002\tA\fG\u000f\u001b\u0004\b\u0003#\u000b\t\u0002AAJ\u0005}aunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Xe\u0006\u0004\b/\u001a:Xe&$XM]\n\u0005\u0003\u001f\u000b)\u0001\u0003\u0006\u0002\u0018\u0006=%\u0011!Q\u0001\ne\n\u0001\"\u001b8ti\u0006t7-\u001a\u0005\bo\u0005=E\u0011AAN)\u0011\ti*!)\u0011\t\u0005}\u0015qR\u0007\u0003\u0003#Aq!a&\u0002\u001a\u0002\u0007\u0011\b\u0003\u0005\u0002&\u0006=E\u0011KAT\u0003!\u0019\u0018M^3J[BdG\u0003BAU\u0003_\u00032ADAV\u0013\r\tik\u0004\u0002\u0005+:LG\u000fC\u0004\u0002\u000e\u0006\r\u0006\u0019A\u0015\u0007\u000f\u0005M\u0016\u0011\u0003\u0001\u00026\nyBj\\4jgRL7MU3he\u0016\u001c8/[8o/J\f\u0007\u000f]3s%\u0016\fG-\u001a:\u0014\t\u0005E\u0016q\u0010\u0005\bo\u0005EF\u0011AA])\t\tY\f\u0005\u0003\u0002 \u0006E\u0006\u0002CAD\u0003c#\t%a0\u0015\u0007e\n\t\rC\u0004\u0002\u000e\u0006u\u0006\u0019A\u0015")
public class LogisticRegressionWrapper
implements MLWritable {
    private final PipelineModel pipeline;
    private final String[] features;
    private final String[] labels;
    private final LogisticRegressionModel lrModel;
    private final String[] rFeatures;
    private final double[] rCoefficients;

    public static LogisticRegressionWrapper load(String string) {
        return LogisticRegressionWrapper$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionWrapper> read() {
        return LogisticRegressionWrapper$.MODULE$.read();
    }

    public static LogisticRegressionWrapper fit(Dataset<Row> dataset, String string, double d, double d2, int n, double d3, String string2, boolean bl, double[] dArray, String string3) {
        return LogisticRegressionWrapper$.MODULE$.fit(dataset, string, d, d2, n, d3, string2, bl, dArray, string3);
    }

    public static String PREDICTED_LABEL_COL() {
        return LogisticRegressionWrapper$.MODULE$.PREDICTED_LABEL_COL();
    }

    public static String PREDICTED_LABEL_INDEX_COL() {
        return LogisticRegressionWrapper$.MODULE$.PREDICTED_LABEL_INDEX_COL();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    public PipelineModel pipeline() {
        return this.pipeline;
    }

    public String[] features() {
        return this.features;
    }

    public String[] labels() {
        return this.labels;
    }

    private LogisticRegressionModel lrModel() {
        return this.lrModel;
    }

    public String[] rFeatures() {
        return this.rFeatures;
    }

    public double[] rCoefficients() {
        return this.rCoefficients;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        return this.pipeline().transform(dataset).drop(LogisticRegressionWrapper$.MODULE$.PREDICTED_LABEL_INDEX_COL()).drop(this.lrModel().getFeaturesCol()).drop(this.lrModel().getLabelCol());
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionWrapperWriter(this);
    }

    public LogisticRegressionWrapper(PipelineModel pipeline, String[] features, String[] labels) {
        int i;
        this.pipeline = pipeline;
        this.features = features;
        this.labels = labels;
        MLWritable$class.$init$(this);
        this.lrModel = (LogisticRegressionModel)pipeline.stages()[1];
        this.rFeatures = this.lrModel().getFitIntercept() ? (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"(Intercept)"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])features), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : features;
        int numRows2 = this.lrModel().coefficientMatrix().numRows();
        int numCols = this.lrModel().coefficientMatrix().numCols();
        int numColsWithIntercept = this.lrModel().getFitIntercept() ? numCols + 1 : numCols;
        double[] coefficients2 = new double[numRows2 * numColsWithIntercept];
        Seq coefficientVectors = this.lrModel().coefficientMatrix().rowIter().toSeq();
        if (this.lrModel().getFitIntercept()) {
            for (i = 0; i < numRows2; ++i) {
                coefficients2[i * numColsWithIntercept] = this.lrModel().interceptVector().apply(i);
                System.arraycopy(((Vector)coefficientVectors.apply(i)).toArray(), 0, coefficients2, i * numColsWithIntercept + 1, numCols);
            }
        } else {
            while (i < numRows2) {
                System.arraycopy(((Vector)coefficientVectors.apply(i)).toArray(), 0, coefficients2, i * numColsWithIntercept, numCols);
                ++i;
            }
        }
        this.rCoefficients = coefficients2;
    }

    public static class LogisticRegressionWrapperWriter
    extends MLWriter {
        private final LogisticRegressionWrapper instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject rMetadata;
            String rMetadataPath = new Path(path, "rMetadata").toString();
            String pipelinePath = new Path(path, "pipeline").toString();
            JsonAST.JObject x$2 = rMetadata = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.instance.getClass().getName()), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(String x) {
                    return JsonDSL$.MODULE$.string2jvalue(x);
                }
            }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)Predef$.MODULE$.refArrayOps((Object[])this.instance.features()).toSeq()), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JArray apply(Traversable<String> s) {
                    return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(String x) {
                            return JsonDSL$.MODULE$.string2jvalue(x);
                        }
                    });
                }
            })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labels"), (Object)Predef$.MODULE$.refArrayOps((Object[])this.instance.labels()).toSeq()), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JArray apply(Traversable<String> s) {
                    return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(String x) {
                            return JsonDSL$.MODULE$.string2jvalue(x);
                        }
                    });
                }
            }));
            Formats x$3 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$2);
            String rMetadataJson = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$2, x$3));
            this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rMetadataJson})), 1, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(rMetadataPath);
            this.instance.pipeline().save(pipelinePath);
        }

        public LogisticRegressionWrapperWriter(LogisticRegressionWrapper instance) {
            this.instance = instance;
        }
    }

    public static class LogisticRegressionWrapperReader
    extends MLReader<LogisticRegressionWrapper> {
        @Override
        public LogisticRegressionWrapper load(String path) {
            DefaultFormats$ format2 = DefaultFormats$.MODULE$;
            String rMetadataPath = new Path(path, "rMetadata").toString();
            String pipelinePath = new Path(path, "pipeline").toString();
            String rMetadataStr = (String)this.sc().textFile(rMetadataPath, 1).first();
            JsonAST.JValue rMetadata = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(rMetadataStr), JsonMethods$.MODULE$.parse$default$2());
            String[] features = (String[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(rMetadata).$bslash("features")).extract((Formats)format2, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)));
            String[] labels = (String[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(rMetadata).$bslash("labels")).extract((Formats)format2, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)));
            PipelineModel pipeline = PipelineModel$.MODULE$.load(pipelinePath);
            return new LogisticRegressionWrapper(pipeline, features, labels);
        }
    }
}

