/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.util.Random;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.BisectingKMeans$;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\ruc\u0001B\u0001\u0003\u00015\u0011qBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!a\u0001\n\u0013a\u0012!A6\u0016\u0003u\u0001\"a\u0004\u0010\n\u0005}\u0001\"aA%oi\"A\u0011\u0005\u0001BA\u0002\u0013%!%A\u0003l?\u0012*\u0017\u000f\u0006\u0002$MA\u0011q\u0002J\u0005\u0003KA\u0011A!\u00168ji\"9q\u0005IA\u0001\u0002\u0004i\u0012a\u0001=%c!A\u0011\u0006\u0001B\u0001B\u0003&Q$\u0001\u0002lA!A1\u0006\u0001BA\u0002\u0013%A$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\t[\u0001\u0011\t\u0019!C\u0005]\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\rz\u0003bB\u0014-\u0003\u0003\u0005\r!\b\u0005\tc\u0001\u0011\t\u0011)Q\u0005;\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002C\u001a\u0001\u0005\u0003\u0007I\u0011\u0002\u001b\u0002/5Lg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,W#A\u001b\u0011\u0005=1\u0014BA\u001c\u0011\u0005\u0019!u.\u001e2mK\"A\u0011\b\u0001BA\u0002\u0013%!(A\u000enS:$\u0015N^5tS\ndWm\u00117vgR,'oU5{K~#S-\u001d\u000b\u0003GmBqa\n\u001d\u0002\u0002\u0003\u0007Q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015)\u00036\u0003ai\u0017N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\r\t\u0005\t\u007f\u0001\u0011\t\u0019!C\u0005\u0001\u0006!1/Z3e+\u0005\t\u0005CA\bC\u0013\t\u0019\u0005C\u0001\u0003M_:<\u0007\u0002C#\u0001\u0005\u0003\u0007I\u0011\u0002$\u0002\u0011M,W\rZ0%KF$\"aI$\t\u000f\u001d\"\u0015\u0011!a\u0001\u0003\"A\u0011\n\u0001B\u0001B\u0003&\u0011)A\u0003tK\u0016$\u0007\u0005C\u0003L\u0001\u0011%A*\u0001\u0004=S:LGO\u0010\u000b\u0006\u001b>\u0003\u0016K\u0015\t\u0003\u001d\u0002i\u0011A\u0001\u0005\u00067)\u0003\r!\b\u0005\u0006W)\u0003\r!\b\u0005\u0006g)\u0003\r!\u000e\u0005\u0006\u007f)\u0003\r!\u0011\u0005\u0006\u0017\u0002!\t\u0001\u0016\u000b\u0002\u001b\"\u001a1K\u0016/\u0011\u0005]SV\"\u0001-\u000b\u0005e3\u0011AC1o]>$\u0018\r^5p]&\u00111\f\u0017\u0002\u0006'&t7-Z\u0011\u0002;\u0006)\u0011G\f\u001c/a!)q\f\u0001C\u0001A\u0006!1/\u001a;L)\t\t'-D\u0001\u0001\u0011\u0015Yb\f1\u0001\u001eQ\rqf\u000b\u0018\u0005\u0006K\u0002!\t\u0001H\u0001\u0005O\u0016$8\nK\u0002e-rCQ\u0001\u001b\u0001\u0005\u0002%\f\u0001c]3u\u001b\u0006D\u0018\n^3sCRLwN\\:\u0015\u0005\u0005T\u0007\"B\u0016h\u0001\u0004i\u0002fA4W9\")Q\u000e\u0001C\u00019\u0005\u0001r-\u001a;NCbLE/\u001a:bi&|gn\u001d\u0015\u0004YZc\u0006\"\u00029\u0001\t\u0003\t\u0018AG:fi6Kg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,GCA1s\u0011\u0015\u0019t\u000e1\u00016Q\ryg\u000b\u0018\u0005\u0006k\u0002!\t\u0001N\u0001\u001bO\u0016$X*\u001b8ESZL7/\u001b2mK\u000ecWo\u001d;feNK'0\u001a\u0015\u0004iZc\u0006\"\u0002=\u0001\t\u0003I\u0018aB:fiN+W\r\u001a\u000b\u0003CjDQaP<A\u0002\u0005C3a\u001e,]\u0011\u0015i\b\u0001\"\u0001A\u0003\u001d9W\r^*fK\u0012D3\u0001 ,]\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\t1A];o)\u0011\t)!a\u0003\u0011\u00079\u000b9!C\u0002\u0002\n\t\u0011ACQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn]'pI\u0016d\u0007bBA\u0007\u007f\u0002\u0007\u0011qB\u0001\u0006S:\u0004X\u000f\u001e\t\u0007\u0003#\t9\"a\u0007\u000e\u0005\u0005M!bAA\u000b\r\u0005\u0019!\u000f\u001a3\n\t\u0005e\u00111\u0003\u0002\u0004%\u0012#\u0005\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005B!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003K\tyB\u0001\u0004WK\u000e$xN\u001d\u0015\u0004\u007fZc\u0006bBA\u0001\u0001\u0011\u0005\u00111\u0006\u000b\u0005\u0003\u000b\ti\u0003\u0003\u0005\u00020\u0005%\u0002\u0019AA\u0019\u0003\u0011!\u0017\r^1\u0011\r\u0005M\u0012QHA\u000e\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001\u00026bm\u0006T1!a\u000f\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003\u007f\t)DA\u0004KCZ\f'\u000b\u0012#)\u0007\u00011FlB\u0004\u0002F\tAI!a\u0012\u0002\u001f\tK7/Z2uS:<7*T3b]N\u00042ATA%\r\u0019\t!\u0001#\u0003\u0002LM)\u0011\u0011\n\b\u0002NA\u0019q\"a\u0014\n\u0007\u0005E\u0003C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004L\u0003\u0013\"\t!!\u0016\u0015\u0005\u0005\u001d\u0003\"CA-\u0003\u0013\u0012\r\u0011\"\u0003A\u0003)\u0011vj\u0014+`\u0013:#U\t\u0017\u0005\t\u0003;\nI\u0005)A\u0005\u0003\u0006Y!kT(U?&sE)\u0012-!\u0011%\t\t'!\u0013C\u0002\u0013%\u0001)A\u000eN\u0003b{F)\u0013,J'&\u0013E*R0D\u0019V\u001bF+\u0012*`\u0013:#U\t\u0017\u0005\t\u0003K\nI\u0005)A\u0005\u0003\u0006aR*\u0011-`\t&3\u0016jU%C\u0019\u0016{6\tT+T)\u0016\u0013v,\u0013(E\u000bb\u0003\u0003\"CA5\u0003\u0013\u0012\r\u0011\"\u00035\u0003-aUIV#M?2KU*\u0013+\t\u0011\u00055\u0014\u0011\nQ\u0001\nU\nA\u0002T#W\u000b2{F*S'J)\u0002B\u0001\"!\u001d\u0002J\u0011%\u00111O\u0001\u000fY\u00164Go\u00115jY\u0012Le\u000eZ3y)\r\t\u0015Q\u000f\u0005\b\u0003o\ny\u00071\u0001B\u0003\u0015Ig\u000eZ3y\u0011!\tY(!\u0013\u0005\n\u0005u\u0014a\u0004:jO\"$8\t[5mI&sG-\u001a=\u0015\u0007\u0005\u000by\bC\u0004\u0002x\u0005e\u0004\u0019A!\t\u0011\u0005\r\u0015\u0011\nC\u0005\u0003\u000b\u000b1\u0002]1sK:$\u0018J\u001c3fqR\u0019\u0011)a\"\t\u000f\u0005]\u0014\u0011\u0011a\u0001\u0003\"A\u00111RA%\t\u0013\ti)A\u0005tk6l\u0017M]5{KR1\u0011q\u0012B3\u0005S\u0002r!!%\u0002\u0018\u0006\u000biJD\u0002\u0010\u0003'K1!!&\u0011\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011TAN\u0005\ri\u0015\r\u001d\u0006\u0004\u0003+\u0003\u0002\u0003BAP\u0003Ck!!!\u0013\u0007\u000f\u0005\r\u0016\u0011\n#\u0002&\nq1\t\\;ti\u0016\u00148+^7nCJL8cBAQ\u001d\u0005\u001d\u0016Q\n\t\u0004\u001f\u0005%\u0016bAAV!\t9\u0001K]8ek\u000e$\bBCAX\u0003C\u0013)\u001a!C\u0001\u0001\u0006!1/\u001b>f\u0011)\t\u0019,!)\u0003\u0012\u0003\u0006I!Q\u0001\u0006g&TX\r\t\u0005\f\u0003o\u000b\tK!f\u0001\n\u0003\tI,\u0001\u0004dK:$XM]\u000b\u0003\u0003w\u00032ATA_\u0013\r\tyL\u0001\u0002\u000f-\u0016\u001cGo\u001c:XSRDgj\u001c:n\u0011-\t\u0019-!)\u0003\u0012\u0003\u0006I!a/\u0002\u000f\r,g\u000e^3sA!Q\u0011qYAQ\u0005+\u0007I\u0011\u0001\u001b\u0002\t\r|7\u000f\u001e\u0005\u000b\u0003\u0017\f\tK!E!\u0002\u0013)\u0014!B2pgR\u0004\u0003bB&\u0002\"\u0012\u0005\u0011q\u001a\u000b\t\u0003;\u000b\t.a5\u0002V\"9\u0011qVAg\u0001\u0004\t\u0005\u0002CA\\\u0003\u001b\u0004\r!a/\t\u000f\u0005\u001d\u0017Q\u001aa\u0001k!Q\u0011\u0011\\AQ\u0003\u0003%\t!a7\u0002\t\r|\u0007/\u001f\u000b\t\u0003;\u000bi.a8\u0002b\"I\u0011qVAl!\u0003\u0005\r!\u0011\u0005\u000b\u0003o\u000b9\u000e%AA\u0002\u0005m\u0006\"CAd\u0003/\u0004\n\u00111\u00016\u0011)\t)/!)\u0012\u0002\u0013\u0005\u0011q]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIOK\u0002B\u0003W\\#!!<\u0011\t\u0005=\u0018q_\u0007\u0003\u0003cTA!a=\u0002v\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u00033BIA!!?\u0002r\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005u\u0018\u0011UI\u0001\n\u0003\ty0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0005!\u0006BA^\u0003WD!B!\u0002\u0002\"F\u0005I\u0011\u0001B\u0004\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u0003+\u0007U\nY\u000f\u0003\u0006\u0003\u000e\u0005\u0005\u0016\u0011!C!\u0005\u001f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\t!\u0011\u0011\u0019Ba\u0007\u000e\u0005\tU!\u0002\u0002B\f\u00053\tA\u0001\\1oO*\u0011\u0011qG\u0005\u0005\u0005;\u0011)B\u0001\u0004TiJLgn\u001a\u0005\n\u0005C\t\t+!A\u0005\u0002q\tA\u0002\u001d:pIV\u001cG/\u0011:jifD!B!\n\u0002\"\u0006\u0005I\u0011\u0001B\u0014\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u000b\u00030A\u0019qBa\u000b\n\u0007\t5\u0002CA\u0002B]fD\u0001b\nB\u0012\u0003\u0003\u0005\r!\b\u0005\u000b\u0005g\t\t+!A\u0005B\tU\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t]\u0002C\u0002B\u001d\u0005\u007f\u0011I#\u0004\u0002\u0003<)\u0019!Q\b\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003B\tm\"\u0001C%uKJ\fGo\u001c:\t\u0015\t\u0015\u0013\u0011UA\u0001\n\u0003\u00119%\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IEa\u0014\u0011\u0007=\u0011Y%C\u0002\u0003NA\u0011qAQ8pY\u0016\fg\u000eC\u0005(\u0005\u0007\n\t\u00111\u0001\u0003*!Q!1KAQ\u0003\u0003%\tE!\u0016\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\b\u0005\u000b\u00053\n\t+!A\u0005B\tm\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tE\u0001B\u0003B0\u0003C\u000b\t\u0011\"\u0011\u0003b\u00051Q-];bYN$BA!\u0013\u0003d!IqE!\u0018\u0002\u0002\u0003\u0007!\u0011\u0006\u0005\b\u0005O\nI\t1\u0001\u001e\u0003\u0005!\u0007\u0002\u0003B6\u0003\u0013\u0003\rA!\u001c\u0002\u0017\u0005\u001c8/[4o[\u0016tGo\u001d\t\u0007\u0003#\t9Ba\u001c\u0011\r=\u0011\t(QA^\u0013\r\u0011\u0019\b\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0007\u000f\t]\u0014\u0011\n\u0003\u0003z\tA2\t\\;ti\u0016\u00148+^7nCJL\u0018iZ4sK\u001e\fGo\u001c:\u0014\u000b\tUd\"!\u0014\t\u0015\t\u001d$Q\u000fBC\u0002\u0013\u0005A\u0004\u0003\u0006\u0003\u0000\tU$\u0011!Q\u0001\nu\t!\u0001\u001a\u0011\t\u000f-\u0013)\b\"\u0001\u0003\u0004R!!Q\u0011BD!\u0011\tyJ!\u001e\t\u000f\t\u001d$\u0011\u0011a\u0001;!I!1\u0012B;\u0001\u0004%I\u0001Q\u0001\u0002]\"Q!q\u0012B;\u0001\u0004%IA!%\u0002\u000b9|F%Z9\u0015\u0007\r\u0012\u0019\n\u0003\u0005(\u0005\u001b\u000b\t\u00111\u0001B\u0011!\u00119J!\u001e!B\u0013\t\u0015A\u00018!\u0011)\u0011YJ!\u001eC\u0002\u0013%!QT\u0001\u0004gVlWCAA\u000e\u0011%\u0011\tK!\u001e!\u0002\u0013\tY\"\u0001\u0003tk6\u0004\u0003\"\u0003BS\u0005k\u0002\r\u0011\"\u00035\u0003\u0015\u0019X/\\*r\u0011)\u0011IK!\u001eA\u0002\u0013%!1V\u0001\ngVl7+]0%KF$2a\tBW\u0011!9#qUA\u0001\u0002\u0004)\u0004\u0002\u0003BY\u0005k\u0002\u000b\u0015B\u001b\u0002\rM,XnU9!\u0011!\u0011)L!\u001e\u0005\u0002\t]\u0016aA1eIR!!\u0011\u0018B^\u001b\t\u0011)\b\u0003\u0005\u0003>\nM\u0006\u0019AA^\u0003\u00051\b\u0002\u0003Ba\u0005k\"\tAa1\u0002\u000b5,'oZ3\u0015\t\te&Q\u0019\u0005\t\u0005\u000f\u0014y\f1\u0001\u0003\u0006\u0006)q\u000e\u001e5fe\"A!1\u001aB;\t\u0003\u0011i-A\u0004tk6l\u0017M]=\u0016\u0005\u0005u\u0005\u0002\u0003Bi\u0003\u0013\"IAa5\u0002\u0017M\u0004H.\u001b;DK:$XM\u001d\u000b\u0007\u0005+\u00149N!7\u0011\u000f=\u0011\t(a/\u0002<\"A\u0011q\u0017Bh\u0001\u0004\tY\f\u0003\u0005\u0003\\\n=\u0007\u0019\u0001Bo\u0003\u0019\u0011\u0018M\u001c3p[B!!q\u001cBs\u001b\t\u0011\tO\u0003\u0003\u0003d\ne\u0011\u0001B;uS2LAAa:\u0003b\n1!+\u00198e_6D\u0001Ba;\u0002J\u0011%!Q^\u0001\u0012kB$\u0017\r^3BgNLwM\\7f]R\u001cH\u0003\u0003B7\u0005_\u0014\tPa?\t\u0011\t-$\u0011\u001ea\u0001\u0005[B\u0001Ba=\u0003j\u0002\u0007!Q_\u0001\u0011I&4\u0018n]5cY\u0016Le\u000eZ5dKN\u0004R!!%\u0003x\u0006KAA!?\u0002\u001c\n\u00191+\u001a;\t\u0011\tu(\u0011\u001ea\u0001\u0005\u007f\f\u0011C\\3x\u00072,8\u000f^3s\u0007\u0016tG/\u001a:t!\u001d\t\t*a&B\u0003wC\u0001ba\u0001\u0002J\u0011%1QA\u0001\nEVLG\u000e\u001a+sK\u0016$Baa\u0002\u0004\u000eA\u0019aj!\u0003\n\u0007\r-!A\u0001\nDYV\u001cH/\u001a:j]\u001e$&/Z3O_\u0012,\u0007\u0002CB\b\u0007\u0003\u0001\r!a$\u0002\u0011\rdWo\u001d;feN<!ba\u0005\u0002J\u0005\u0005\t\u0012BB\u000b\u00039\u0019E.^:uKJ\u001cV/\\7bef\u0004B!a(\u0004\u0018\u0019Q\u00111UA%\u0003\u0003EIa!\u0007\u0014\r\r]11DA'!)\u0019iba\tB\u0003w+\u0014QT\u0007\u0003\u0007?Q1a!\t\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\n\u0004 \t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f-\u001b9\u0002\"\u0001\u0004*Q\u00111Q\u0003\u0005\u000b\u00053\u001a9\"!A\u0005F\tm\u0003BCB\u0018\u0007/\t\t\u0011\"!\u00042\u0005)\u0011\r\u001d9msRA\u0011QTB\u001a\u0007k\u00199\u0004C\u0004\u00020\u000e5\u0002\u0019A!\t\u0011\u0005]6Q\u0006a\u0001\u0003wCq!a2\u0004.\u0001\u0007Q\u0007\u0003\u0006\u0004<\r]\u0011\u0011!CA\u0007{\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004@\r-\u0003#B\b\u0004B\r\u0015\u0013bAB\"!\t1q\n\u001d;j_:\u0004raDB$\u0003\u0006mV'C\u0002\u0004JA\u0011a\u0001V;qY\u0016\u001c\u0004BCB'\u0007s\t\t\u00111\u0001\u0002\u001e\u0006\u0019\u0001\u0010\n\u0019\t\u0015\rE3qCA\u0001\n\u0013\u0019\u0019&A\u0006sK\u0006$'+Z:pYZ,GCAB+!\u0011\u0011\u0019ba\u0016\n\t\re#Q\u0003\u0002\u0007\u001f\nTWm\u0019;\t\u0015\rE\u0013\u0011JA\u0001\n\u0013\u0019\u0019\u0006")
public class BisectingKMeans
implements Logging {
    private int k;
    private int maxIterations;
    private double minDivisibleClusterSize;
    private long seed;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    private void minDivisibleClusterSize_$eq(double x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    public BisectingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public BisectingKMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0)new Serializable(this, maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxIterations must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public BisectingKMeans setMinDivisibleClusterSize(double minDivisibleClusterSize) {
        Predef$.MODULE$.require(minDivisibleClusterSize > 0.0, (Function0)new Serializable(this, minDivisibleClusterSize){
            public static final long serialVersionUID = 0L;
            private final double minDivisibleClusterSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minDivisibleClusterSize must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minDivisibleClusterSize$1)}));
            }
            {
                this.minDivisibleClusterSize$1 = minDivisibleClusterSize$1;
            }
        });
        this.minDivisibleClusterSize_$eq(minDivisibleClusterSize);
        return this;
    }

    public double getMinDivisibleClusterSize() {
        return this.minDivisibleClusterSize();
    }

    public BisectingKMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public BisectingKMeansModel run(RDD<Vector> input) {
        BoxedUnit boxedUnit;
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, input){
                public static final long serialVersionUID = 0L;
                private final RDD input$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input RDD ", " is not directly cached, which may hurt performance if"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.input$1.id())}))).append((Object)" its parent RDDs are also not cached.").toString();
                }
                {
                    this.input$1 = input$1;
                }
            });
        }
        int d = BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Vector x$1) {
                return x$1.size();
            }
        }, ClassTag$.MODULE$.Int()).first());
        this.logInfo((Function0<String>)new Serializable(this, d){
            public static final long serialVersionUID = 0L;
            private final int d$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature dimension: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.d$1)}));
            }
            {
                this.d$1 = d$1;
            }
        });
        RDD norms = input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector v) {
                return Vectors$.MODULE$.norm(v, 2.0);
            }
        }, ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD vectors = input.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector x = (Vector)tuple2._1();
                    double norm2 = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(x, norm2);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        ObjectRef assignments = ObjectRef.create((Object)vectors.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, VectorWithNorm> apply(VectorWithNorm v) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()), (Object)v);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Map activeClusters = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem));
        ClusterSummary rootSummary = (ClusterSummary)activeClusters.apply((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()));
        long n = rootSummary.size();
        this.logInfo((Function0<String>)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final long n$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of points: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.n$1)}));
            }
            {
                this.n$1 = n$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, rootSummary){
            public static final long serialVersionUID = 0L;
            private final ClusterSummary rootSummary$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial cost: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.rootSummary$1.cost())}));
            }
            {
                this.rootSummary$1 = rootSummary$1;
            }
        });
        long minSize = this.minDivisibleClusterSize() >= 1.0 ? (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize()) : (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize() * (double)n);
        this.logInfo((Function0<String>)new Serializable(this, minSize){
            public static final long serialVersionUID = 0L;
            private final long minSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minimum number of points of a divisible cluster is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.minSize$1)}));
            }
            {
                this.minSize$1 = minSize$1;
            }
        });
        scala.collection.mutable.Seq inactiveClusters = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        Random random = new Random(this.seed());
        int numLeafClustersNeeded = this.k() - 1;
        IntRef level = IntRef.create((int)1);
        RDD preIndices = null;
        RDD indices = null;
        while (activeClusters.nonEmpty() && numLeafClustersNeeded > 0 && (double)level.elem < BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT()) {
            Map divisibleClusters = (Map)activeClusters.filter((Function1)new Serializable(this, minSize){
                public static final long serialVersionUID = 0L;
                private final long minSize$1;

                public final boolean apply(Tuple2<Object, ClusterSummary> x0$2) {
                    Tuple2<Object, ClusterSummary> tuple2 = x0$2;
                    if (tuple2 != null) {
                        ClusterSummary summary2 = (ClusterSummary)tuple2._2();
                        boolean bl = summary2.size() >= this.minSize$1 && summary2.cost() > MLUtils$.MODULE$.EPSILON() * (double)summary2.size();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.minSize$1 = minSize$1;
                }
            });
            if (divisibleClusters.size() > numLeafClustersNeeded) {
                divisibleClusters = ((TraversableOnce)((IterableLike)divisibleClusters.toSeq().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, ClusterSummary> x0$3) {
                        Tuple2<Object, ClusterSummary> tuple2 = x0$3;
                        if (tuple2 != null) {
                            ClusterSummary summary2 = (ClusterSummary)tuple2._2();
                            long l = -summary2.size();
                            return l;
                        }
                        throw new MatchError(tuple2);
                    }
                }, (Ordering)Ordering.Long$.MODULE$)).take(numLeafClustersNeeded)).toMap(Predef$.MODULE$.$conforms());
            }
            if (divisibleClusters.nonEmpty()) {
                BoxedUnit boxedUnit2;
                Set divisibleIndices = divisibleClusters.keys().toSet();
                this.logInfo((Function0<String>)new Serializable(this, level, divisibleIndices){
                    public static final long serialVersionUID = 0L;
                    private final IntRef level$1;
                    private final Set divisibleIndices$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dividing ", " clusters on level ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.divisibleIndices$1.size()), BoxesRunTime.boxToInteger((int)this.level$1.elem)}));
                    }
                    {
                        this.level$1 = level$1;
                        this.divisibleIndices$1 = divisibleIndices$1;
                    }
                });
                ObjectRef newClusterCenters = ObjectRef.create((Object)((Map)((TraversableLike)divisibleClusters.flatMap((Function1)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final Random random$1;

                    public final Iterator<Tuple2<Object, VectorWithNorm>> apply(Tuple2<Object, ClusterSummary> x0$4) {
                        Tuple2<Object, ClusterSummary> tuple2 = x0$4;
                        if (tuple2 != null) {
                            long index2 = tuple2._1$mcJ$sp();
                            ClusterSummary summary2 = (ClusterSummary)tuple2._2();
                            Tuple2<VectorWithNorm, VectorWithNorm> tuple22 = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(summary2.center(), this.random$1);
                            if (tuple22 != null) {
                                Tuple2 tuple23;
                                VectorWithNorm left = (VectorWithNorm)tuple22._1();
                                VectorWithNorm right = (VectorWithNorm)tuple22._2();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)left, (Object)right);
                                VectorWithNorm left2 = (VectorWithNorm)tuple24._1();
                                VectorWithNorm right2 = (VectorWithNorm)tuple24._2();
                                Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index2)), (Object)left2), new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index2)), (Object)right2)}));
                                return iterator;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.random$1 = random$1;
                    }
                }, Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x) {
                        return (Tuple2)Predef$.MODULE$.identity(x);
                    }
                }, Map$.MODULE$.canBuildFrom())));
                ObjectRef newClusters = ObjectRef.create(null);
                ObjectRef newAssignments = ObjectRef.create(null);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxIterations()).foreach$mVc$sp((Function1)new Serializable(this, d, assignments, divisibleIndices, newClusterCenters, newClusters, newAssignments){
                    public static final long serialVersionUID = 0L;
                    private final int d$1;
                    private final ObjectRef assignments$1;
                    public final Set divisibleIndices$1;
                    private final ObjectRef newClusterCenters$1;
                    private final ObjectRef newClusters$1;
                    private final ObjectRef newAssignments$1;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.newAssignments$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)this.assignments$1.elem), (Set<Object>)this.divisibleIndices$1, (Map<Object, VectorWithNorm>)((Map)this.newClusterCenters$1.elem)).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$run$1 $outer;

                            public final boolean apply(Tuple2<Object, VectorWithNorm> x0$5) {
                                Tuple2<Object, VectorWithNorm> tuple2 = x0$5;
                                if (tuple2 != null) {
                                    long index2 = tuple2._1$mcJ$sp();
                                    boolean bl = this.$outer.divisibleIndices$1.contains((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(index2)));
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.newClusters$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(this.d$1, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)this.newAssignments$1.elem));
                        this.newClusterCenters$1.elem = (Map)((Map)this.newClusters$1.elem).mapValues((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final VectorWithNorm apply(ClusterSummary x$3) {
                                return x$3.center();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x) {
                                return (Tuple2)Predef$.MODULE$.identity(x);
                            }
                        }, Map$.MODULE$.canBuildFrom());
                    }
                    {
                        this.d$1 = d$1;
                        this.assignments$1 = assignments$1;
                        this.divisibleIndices$1 = divisibleIndices$1;
                        this.newClusterCenters$1 = newClusterCenters$1;
                        this.newClusters$1 = newClusters$1;
                        this.newAssignments$1 = newAssignments$1;
                    }
                });
                if (preIndices == null) {
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    RDD qual$1 = preIndices;
                    boolean x$13 = qual$1.unpersist$default$1();
                    boxedUnit2 = qual$1.unpersist(x$13);
                }
                preIndices = indices;
                indices = RDD$.MODULE$.rddToPairRDDFunctions(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters.elem)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).keys().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                assignments.elem = indices.zip(vectors, ClassTag$.MODULE$.apply(VectorWithNorm.class));
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)activeClusters, Seq$.MODULE$.canBuildFrom());
                activeClusters = (Map)newClusters.elem;
                numLeafClustersNeeded -= divisibleClusters.size();
            } else {
                this.logInfo((Function0<String>)new Serializable(this, level){
                    public static final long serialVersionUID = 0L;
                    private final IntRef level$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"None active and divisible clusters left on level ", ". Stop iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.level$1.elem)}));
                    }
                    {
                        this.level$1 = level$1;
                    }
                });
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus(activeClusters, Seq$.MODULE$.canBuildFrom());
                activeClusters = Predef$.MODULE$.Map().empty();
            }
            ++level.elem;
        }
        if (indices == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            RDD qual$2 = indices;
            boolean x$14 = qual$2.unpersist$default$1();
            boxedUnit = qual$2.unpersist(x$14);
        }
        Map clusters = activeClusters.$plus$plus((GenTraversableOnce)inactiveClusters);
        ClusteringTreeNode root = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree((Map<Object, ClusterSummary>)clusters);
        return new BisectingKMeansModel(root);
    }

    public BisectingKMeansModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    private BisectingKMeans(int k, int maxIterations, double minDivisibleClusterSize, long seed) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.minDivisibleClusterSize = minDivisibleClusterSize;
        this.seed = seed;
        Logging.class.$init$((Logging)this);
    }

    public BisectingKMeans() {
        this(4, 20, 1.0, ScalaRunTime$.MODULE$.hash((Object)BisectingKMeans.class.getName()));
    }

    public static class ClusterSummary
    implements Product,
    Serializable {
        private final long size;
        private final VectorWithNorm center;
        private final double cost;

        public long size() {
            return this.size;
        }

        public VectorWithNorm center() {
            return this.center;
        }

        public double cost() {
            return this.cost;
        }

        public ClusterSummary copy(long size, VectorWithNorm center, double cost) {
            return new ClusterSummary(size, center, cost);
        }

        public long copy$default$1() {
            return this.size();
        }

        public VectorWithNorm copy$default$2() {
            return this.center();
        }

        public double copy$default$3() {
            return this.cost();
        }

        public String productPrefix() {
            return "ClusterSummary";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this.cost());
                    break;
                }
                case 1: {
                    object = this.center();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClusterSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.center()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cost()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClusterSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClusterSummary clusterSummary = (ClusterSummary)x$1;
            if (this.size() != clusterSummary.size()) return false;
            VectorWithNorm vectorWithNorm = this.center();
            VectorWithNorm vectorWithNorm2 = clusterSummary.center();
            if (vectorWithNorm == null) {
                if (vectorWithNorm2 != null) {
                    return false;
                }
            } else if (!vectorWithNorm.equals(vectorWithNorm2)) return false;
            if (this.cost() != clusterSummary.cost()) return false;
            if (!clusterSummary.canEqual(this)) return false;
            return true;
        }

        public ClusterSummary(long size, VectorWithNorm center, double cost) {
            this.size = size;
            this.center = center;
            this.cost = cost;
            Product.class.$init$((Product)this);
        }
    }

    public static class ClusterSummaryAggregator
    implements Serializable {
        private final int d;
        private long n;
        private final Vector sum;
        private double sumSq;

        public int d() {
            return this.d;
        }

        private long n() {
            return this.n;
        }

        private void n_$eq(long x$1) {
            this.n = x$1;
        }

        private Vector sum() {
            return this.sum;
        }

        private double sumSq() {
            return this.sumSq;
        }

        private void sumSq_$eq(double x$1) {
            this.sumSq = x$1;
        }

        public ClusterSummaryAggregator add(VectorWithNorm v) {
            this.n_$eq(this.n() + 1L);
            this.sumSq_$eq(this.sumSq() + v.norm() * v.norm());
            BLAS$.MODULE$.axpy(1.0, v.vector(), this.sum());
            return this;
        }

        public ClusterSummaryAggregator merge(ClusterSummaryAggregator other) {
            this.n_$eq(this.n() + other.n());
            this.sumSq_$eq(this.sumSq() + other.sumSq());
            BLAS$.MODULE$.axpy(1.0, other.sum(), this.sum());
            return this;
        }

        public ClusterSummary summary() {
            Vector mean2 = this.sum().copy();
            if (this.n() > 0L) {
                BLAS$.MODULE$.scal(1.0 / (double)this.n(), mean2);
            }
            VectorWithNorm center = new VectorWithNorm(mean2);
            double cost = scala.math.package$.MODULE$.max(this.sumSq() - (double)this.n() * center.norm() * center.norm(), 0.0);
            return new ClusterSummary(this.n(), center, cost);
        }

        public ClusterSummaryAggregator(int d) {
            this.d = d;
            this.n = 0L;
            this.sum = Vectors$.MODULE$.zeros(d);
            this.sumSq = 0.0;
        }
    }
}

