/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.GradientDescent$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u0001\u0003\u00015\u0011qb\u0012:bI&,g\u000e\u001e#fg\u000e,g\u000e\u001e\u0006\u0003\u0007\u0011\tAb\u001c9uS6L'0\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQA\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\tIq\n\u001d;j[&TXM\u001d\t\u00033qi\u0011A\u0007\u0006\u00037\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003;i\u0011q\u0001T8hO&tw\r\u0003\u0005 \u0001\t\u0005\r\u0011\"\u0003!\u0003!9'/\u00193jK:$X#A\u0011\u0011\u0005U\u0011\u0013BA\u0012\u0003\u0005!9%/\u00193jK:$\b\u0002C\u0013\u0001\u0005\u0003\u0007I\u0011\u0002\u0014\u0002\u0019\u001d\u0014\u0018\rZ5f]R|F%Z9\u0015\u0005\u001dR\u0003CA\b)\u0013\tI\u0003C\u0001\u0003V]&$\bbB\u0016%\u0003\u0003\u0005\r!I\u0001\u0004q\u0012\n\u0004\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0015B\u0011\u0002\u0013\u001d\u0014\u0018\rZ5f]R\u0004\u0003\u0002C\u0018\u0001\u0005\u0003\u0007I\u0011\u0002\u0019\u0002\u000fU\u0004H-\u0019;feV\t\u0011\u0007\u0005\u0002\u0016e%\u00111G\u0001\u0002\b+B$\u0017\r^3s\u0011!)\u0004A!a\u0001\n\u00131\u0014aC;qI\u0006$XM]0%KF$\"aJ\u001c\t\u000f-\"\u0014\u0011!a\u0001c!A\u0011\b\u0001B\u0001B\u0003&\u0011'\u0001\u0005va\u0012\fG/\u001a:!\u0011\u0019Y\u0004\u0001\"\u0001\u0007y\u00051A(\u001b8jiz\"2!\u0010 @!\t)\u0002\u0001C\u0003 u\u0001\u0007\u0011\u0005C\u00030u\u0001\u0007\u0011\u0007C\u0004B\u0001\u0001\u0007I\u0011\u0002\"\u0002\u0011M$X\r]*ju\u0016,\u0012a\u0011\t\u0003\u001f\u0011K!!\u0012\t\u0003\r\u0011{WO\u00197f\u0011\u001d9\u0005\u00011A\u0005\n!\u000bAb\u001d;faNK'0Z0%KF$\"aJ%\t\u000f-2\u0015\u0011!a\u0001\u0007\"11\n\u0001Q!\n\r\u000b\u0011b\u001d;faNK'0\u001a\u0011\t\u000f5\u0003\u0001\u0019!C\u0005\u001d\u0006ia.^7Ji\u0016\u0014\u0018\r^5p]N,\u0012a\u0014\t\u0003\u001fAK!!\u0015\t\u0003\u0007%sG\u000fC\u0004T\u0001\u0001\u0007I\u0011\u0002+\u0002#9,X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002(+\"91FUA\u0001\u0002\u0004y\u0005BB,\u0001A\u0003&q*\u0001\bok6LE/\u001a:bi&|gn\u001d\u0011\t\u000fe\u0003\u0001\u0019!C\u0005\u0005\u0006A!/Z4QCJ\fW\u000eC\u0004\\\u0001\u0001\u0007I\u0011\u0002/\u0002\u0019I,w\rU1sC6|F%Z9\u0015\u0005\u001dj\u0006bB\u0016[\u0003\u0003\u0005\ra\u0011\u0005\u0007?\u0002\u0001\u000b\u0015B\"\u0002\u0013I,w\rU1sC6\u0004\u0003bB1\u0001\u0001\u0004%IAQ\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007bB2\u0001\u0001\u0004%I\u0001Z\u0001\u0016[&t\u0017NQ1uG\"4%/Y2uS>tw\fJ3r)\t9S\rC\u0004,E\u0006\u0005\t\u0019A\"\t\r\u001d\u0004\u0001\u0015)\u0003D\u0003Ii\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\u001c\u0011\t\u000f%\u0004\u0001\u0019!C\u0005\u0005\u0006q1m\u001c8wKJ<WM\\2f)>d\u0007bB6\u0001\u0001\u0004%I\u0001\\\u0001\u0013G>tg/\u001a:hK:\u001cW\rV8m?\u0012*\u0017\u000f\u0006\u0002([\"91F[A\u0001\u0002\u0004\u0019\u0005BB8\u0001A\u0003&1)A\bd_:4XM]4f]\u000e,Gk\u001c7!\u0011\u0015\t\b\u0001\"\u0001s\u0003-\u0019X\r^*uKB\u001c\u0016N_3\u0015\u0005M$X\"\u0001\u0001\t\u000bU\u0004\b\u0019A\"\u0002\tM$X\r\u001d\u0005\u0006o\u0002!\t\u0001_\u0001\u0015g\u0016$X*\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8\u0015\u0005ML\b\"\u0002>w\u0001\u0004\u0019\u0015\u0001\u00034sC\u000e$\u0018n\u001c8\t\u000bq\u0004A\u0011A?\u0002!M,GOT;n\u0013R,'/\u0019;j_:\u001cHCA:\u007f\u0011\u0015y8\u00101\u0001P\u0003\u0015IG/\u001a:t\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\t1b]3u%\u0016<\u0007+\u0019:b[R\u00191/a\u0002\t\re\u000b\t\u00011\u0001D\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\t\u0011c]3u\u0007>tg/\u001a:hK:\u001cW\rV8m)\r\u0019\u0018q\u0002\u0005\b\u0003#\tI\u00011\u0001D\u0003%!x\u000e\\3sC:\u001cW\rC\u0004\u0002\u0016\u0001!\t!a\u0006\u0002\u0017M,Go\u0012:bI&,g\u000e\u001e\u000b\u0004g\u0006e\u0001BB\u0010\u0002\u0014\u0001\u0007\u0011\u0005C\u0004\u0002\u001e\u0001!\t!a\b\u0002\u0015M,G/\u00169eCR,'\u000fF\u0002t\u0003CAaaLA\u000e\u0001\u0004\t\u0004bBA\u0013\u0001\u0011\u0005\u0011qE\u0001\t_B$\u0018.\\5{KR1\u0011\u0011FA\u001b\u0003\u0017\u0002B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_!\u0011A\u00027j]\u0006dw-\u0003\u0003\u00024\u00055\"A\u0002,fGR|'\u000f\u0003\u0005\u00028\u0005\r\u0002\u0019AA\u001d\u0003\u0011!\u0017\r^1\u0011\r\u0005m\u0012\u0011IA#\u001b\t\tiDC\u0002\u0002@\u0019\t1A\u001d3e\u0013\u0011\t\u0019%!\u0010\u0003\u0007I#E\t\u0005\u0004\u0010\u0003\u000f\u001a\u0015\u0011F\u0005\u0004\u0003\u0013\u0002\"A\u0002+va2,'\u0007\u0003\u0005\u0002N\u0005\r\u0002\u0019AA\u0015\u00039Ig.\u001b;jC2<V-[4iiNDC!a\t\u0002RA!\u00111KA-\u001b\t\t)FC\u0002\u0002X\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY&!\u0016\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5\b\u000f\u0005}#\u0001#\u0001\u0002b\u0005yqI]1eS\u0016tG\u000fR3tG\u0016tG\u000fE\u0002\u0016\u0003G2a!\u0001\u0002\t\u0002\u0005\u00154CBA2\u001da\t9\u0007E\u0002\u0010\u0003SJ1!a\u001b\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dY\u00141\rC\u0001\u0003_\"\"!!\u0019\t\u0011\u0005M\u00141\rC\u0001\u0003k\nqB];o\u001b&t\u0017NQ1uG\"\u001cv\t\u0012\u000b\u0015\u0003o\ny(!!\u0002\u0004\u0006\u0015\u0015qQAE\u0003\u0017\u000bi)a$\u0011\u000f=\t9%!\u000b\u0002zA!q\"a\u001fD\u0013\r\ti\b\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0003o\t\t\b1\u0001\u0002:!1q$!\u001dA\u0002\u0005BaaLA9\u0001\u0004\t\u0004BB!\u0002r\u0001\u00071\t\u0003\u0004N\u0003c\u0002\ra\u0014\u0005\u00073\u0006E\u0004\u0019A\"\t\r\u0005\f\t\b1\u0001D\u0011!\ti%!\u001dA\u0002\u0005%\u0002BB5\u0002r\u0001\u00071\t\u0003\u0005\u0002t\u0005\rD\u0011AAJ)I\t9(!&\u0002\u0018\u0006e\u00151TAO\u0003?\u000b\t+a)\t\u0011\u0005]\u0012\u0011\u0013a\u0001\u0003sAaaHAI\u0001\u0004\t\u0003BB\u0018\u0002\u0012\u0002\u0007\u0011\u0007\u0003\u0004B\u0003#\u0003\ra\u0011\u0005\u0007\u001b\u0006E\u0005\u0019A(\t\re\u000b\t\n1\u0001D\u0011\u0019\t\u0017\u0011\u0013a\u0001\u0007\"A\u0011QJAI\u0001\u0004\tI\u0003\u0003\u0005\u0002(\u0006\rD\u0011BAU\u0003-I7oQ8om\u0016\u0014x-\u001a3\u0015\u0011\u0005-\u0016\u0011WA[\u0003s\u00032aDAW\u0013\r\ty\u000b\u0005\u0002\b\u0005>|G.Z1o\u0011!\t\u0019,!*A\u0002\u0005%\u0012a\u00049sKZLw.^:XK&<\u0007\u000e^:\t\u0011\u0005]\u0016Q\u0015a\u0001\u0003S\tabY;se\u0016tGoV3jO\"$8\u000f\u0003\u0004j\u0003K\u0003\ra\u0011\u0005\u000b\u0003{\u000b\u0019'!A\u0005\n\u0005}\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006!A.\u00198h\u0015\t\tY-\u0001\u0003kCZ\f\u0017\u0002BAh\u0003\u000b\u0014aa\u00142kK\u000e$\b\u0006BA2\u0003#BC!!\u0018\u0002R\u0001")
public class GradientDescent
implements Optimizer,
Logging {
    private Gradient gradient;
    private Updater updater;
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private double convergenceTol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Tuple2<Vector, double[]> runMiniBatchSGD(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient2, Updater updater, double d, int n, double d2, double d3, Vector vector) {
        return GradientDescent$.MODULE$.runMiniBatchSGD(rDD, gradient2, updater, d, n, d2, d3, vector);
    }

    public static Tuple2<Vector, double[]> runMiniBatchSGD(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient2, Updater updater, double d, int n, double d2, double d3, Vector vector, double d4) {
        return GradientDescent$.MODULE$.runMiniBatchSGD(rDD, gradient2, updater, d, n, d2, d3, vector, d4);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private Gradient gradient() {
        return this.gradient;
    }

    private void gradient_$eq(Gradient x$1) {
        this.gradient = x$1;
    }

    private Updater updater() {
        return this.updater;
    }

    private void updater_$eq(Updater x$1) {
        this.updater = x$1;
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    public GradientDescent setStepSize(double step) {
        Predef$.MODULE$.require(step > 0.0, (Function0)new Serializable(this, step){
            public static final long serialVersionUID = 0L;
            private final double step$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial step size must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.step$1)}));
            }
            {
                this.step$1 = step$1;
            }
        });
        this.stepSize_$eq(step);
        return this;
    }

    public GradientDescent setMiniBatchFraction(double fraction) {
        Predef$.MODULE$.require(fraction > 0.0 && fraction <= 1.0, (Function0)new Serializable(this, fraction){
            public static final long serialVersionUID = 0L;
            private final double fraction$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fraction for mini-batch SGD must be in range (0, 1] but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.fraction$1)}));
            }
            {
                this.fraction$1 = fraction$1;
            }
        });
        this.miniBatchFraction_$eq(fraction);
        return this;
    }

    public GradientDescent setNumIterations(int iters) {
        Predef$.MODULE$.require(iters >= 0, (Function0)new Serializable(this, iters){
            public static final long serialVersionUID = 0L;
            private final int iters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of iterations must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iters$1)}));
            }
            {
                this.iters$1 = iters$1;
            }
        });
        this.numIterations_$eq(iters);
        return this;
    }

    public GradientDescent setRegParam(double regParam) {
        Predef$.MODULE$.require(regParam >= 0.0, (Function0)new Serializable(this, regParam){
            public static final long serialVersionUID = 0L;
            private final double regParam$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Regularization parameter must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.regParam$1)}));
            }
            {
                this.regParam$1 = regParam$1;
            }
        });
        this.regParam_$eq(regParam);
        return this;
    }

    public GradientDescent setConvergenceTol(double tolerance) {
        Predef$.MODULE$.require(tolerance >= 0.0 && tolerance <= 1.0, (Function0)new Serializable(this, tolerance){
            public static final long serialVersionUID = 0L;
            private final double tolerance$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Convergence tolerance must be in range [0, 1] but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.tolerance$1)}));
            }
            {
                this.tolerance$1 = tolerance$1;
            }
        });
        this.convergenceTol_$eq(tolerance);
        return this;
    }

    public GradientDescent setGradient(Gradient gradient2) {
        this.gradient_$eq(gradient2);
        return this;
    }

    public GradientDescent setUpdater(Updater updater) {
        this.updater_$eq(updater);
        return this;
    }

    @Override
    @DeveloperApi
    public Vector optimize(RDD<Tuple2<Object, Vector>> data, Vector initialWeights) {
        Tuple2<Vector, double[]> tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(data, this.gradient(), this.updater(), this.stepSize(), this.numIterations(), this.regParam(), this.miniBatchFraction(), initialWeights, this.convergenceTol());
        if (tuple2 != null) {
            Vector weights;
            Vector vector;
            Vector weights2 = vector = (weights = (Vector)tuple2._1());
            return weights2;
        }
        throw new MatchError(tuple2);
    }

    public GradientDescent(Gradient gradient2, Updater updater) {
        this.gradient = gradient2;
        this.updater = updater;
        Logging.class.$init$((Logging)this);
        this.stepSize = 1.0;
        this.numIterations = 100;
        this.regParam = 0.0;
        this.miniBatchFraction = 1.0;
        this.convergenceTol = 0.001;
    }
}

