/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator$class;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r4Q!\u0001\u0002\u0001\r9\u0011q\u0002S5oO\u0016\fum\u001a:fO\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"Y4he\u0016<\u0017\r^8s\u0015\t)a!A\u0003paRLWN\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\u00111r#G\u0010\u000e\u0003\tI!\u0001\u0007\u0002\u00039\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peB\u0011!$H\u0007\u00027)\u0011ADB\u0001\bM\u0016\fG/\u001e:f\u0013\tq2D\u0001\u0005J]N$\u0018M\\2f!\t1\u0002\u0001\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003$\u00035\u00117MR3biV\u0014Xm]*uI\u000e\u0001\u0001c\u0001\u0013(S5\tQE\u0003\u0002'\u0011\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0003Q\u0015\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007AQC&\u0003\u0002,#\t)\u0011I\u001d:bsB\u0011\u0001#L\u0005\u0003]E\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019\u0019LG/\u00138uKJ\u001cW\r\u001d;\u0011\u0005A\u0011\u0014BA\u001a\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u000fE\u000e\u001cu.\u001a4gS\u000eLWM\u001c;t!\r!se\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\ta\u0001\\5oC2<\u0017B\u0001\u001f:\u0005\u00191Vm\u0019;pe\")a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"2\u0001\u0011\"D)\ty\u0012\tC\u00036{\u0001\u0007a\u0007C\u0003\"{\u0001\u00071\u0005C\u00031{\u0001\u0007\u0011\u0007C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002\u000fB\u0011\u0001\u0003S\u0005\u0003\u0013F\u00111!\u00138u\u0011\u0019Y\u0005\u0001)A\u0005\u000f\u0006aa.^7GK\u0006$XO]3tA!9Q\n\u0001b\u0001\n\u00131\u0015\u0001\u00078v[\u001a+\u0017\r^;sKN\u0004F.^:J]R,'oY3qi\"1q\n\u0001Q\u0001\n\u001d\u000b\u0011D\\;n\r\u0016\fG/\u001e:fgBcWo]%oi\u0016\u00148-\u001a9uA!A\u0011\u000b\u0001EC\u0002\u0013%!+A\td_\u00164g-[2jK:$8/\u0011:sCf,\u0012!\u000b\u0005\t)\u0002A\t\u0011)Q\u0005S\u0005\u00112m\\3gM&\u001c\u0017.\u001a8ug\u0006\u0013(/Y=!Q\t\u0019f\u000b\u0005\u0002\u0011/&\u0011\u0001,\u0005\u0002\niJ\fgn]5f]RDqA\u0017\u0001C\u0002\u0013Ec)A\u0002eS6Da\u0001\u0018\u0001!\u0002\u00139\u0015\u0001\u00023j[\u0002BQA\u0018\u0001\u0005\u0002}\u000b1!\u00193e)\t\u0001\u0017-D\u0001\u0001\u0011\u0015\u0011W\f1\u0001\u001a\u0003!Ign\u001d;b]\u000e,\u0007")
public class HingeAggregator
implements DifferentiableLossAggregator<Instance, HingeAggregator> {
    private final Broadcast<double[]> bcFeaturesStd;
    private final boolean fitIntercept;
    private final Broadcast<Vector> bcCoefficients;
    private final int org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures;
    private final int numFeaturesPlusIntercept;
    private transient double[] coefficientsArray;
    private final int dim;
    private double weightSum;
    private double lossSum;
    private final double[] gradientSumArray;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private double[] coefficientsArray$lzycompute() {
        HingeAggregator hingeAggregator = this;
        synchronized (hingeAggregator) {
            block5: {
                if (!this.bitmap$trans$0) {
                    double[] values;
                    DenseVector denseVector;
                    Option option;
                    Vector vector = (Vector)this.bcCoefficients.value();
                    if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block5;
                    double[] dArray = values = (double[])option.get();
                    this.coefficientsArray = dArray;
                    this.bitmap$trans$0 = true;
                }
                return this.coefficientsArray;
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients only supports dense vector"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bcCoefficients.value().getClass()}))).toString());
        }
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    @TraitSetter
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    @TraitSetter
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        HingeAggregator hingeAggregator = this;
        synchronized (hingeAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator$class.gradientSumArray(this);
                this.bitmap$0 = true;
            }
            return this.gradientSumArray;
        }
    }

    @Override
    public double[] gradientSumArray() {
        return this.bitmap$0 ? this.gradientSumArray : this.gradientSumArray$lzycompute();
    }

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator$class.merge(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator$class.gradient(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator$class.weight(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator$class.loss(this);
    }

    public int org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures() {
        return this.org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures;
    }

    private int numFeaturesPlusIntercept() {
        return this.numFeaturesPlusIntercept;
    }

    private double[] coefficientsArray() {
        return this.bitmap$trans$0 ? this.coefficientsArray : this.coefficientsArray$lzycompute();
    }

    @Override
    public int dim() {
        return this.dim;
    }

    @Override
    public HingeAggregator add(Instance instance) {
        Instance instance2 = instance;
        if (instance2 != null) {
            double dotProduct;
            double labelScaled;
            double loss2;
            double label = instance2.label();
            double weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures() == features.size(), (Function0)new Serializable(this, features){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HingeAggregator $outer;
                private final Vector features$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimensions mismatch when adding new instance."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Expecting ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures()), BoxesRunTime.boxToInteger((int)this.features$1.size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.features$1 = features$1;
                }
            });
            Predef$.MODULE$.require(weight >= 0.0, (Function0)new Serializable(this, weight){
                public static final long serialVersionUID = 0L;
                private final double weight$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"instance weight, ", " has to be >= 0.0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.weight$1)}));
                }
                {
                    this.weight$1 = weight$1;
                }
            });
            if (weight == 0.0) {
                return this;
            }
            double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
            double[] localCoefficients = this.coefficientsArray();
            double[] localGradientSumArray = this.gradientSumArray();
            DoubleRef sum = DoubleRef.create((double)0.0);
            features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localCoefficients, sum){
                public static final long serialVersionUID = 0L;
                private final double[] localFeaturesStd$1;
                private final double[] localCoefficients$1;
                private final DoubleRef sum$1;

                public final void apply(int index2, double value) {
                    this.apply$mcVID$sp(index2, value);
                }

                public void apply$mcVID$sp(int index2, double value) {
                    if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                        this.sum$1.elem += this.localCoefficients$1[index2] * value / this.localFeaturesStd$1[index2];
                    }
                }
                {
                    this.localFeaturesStd$1 = localFeaturesStd$1;
                    this.localCoefficients$1 = localCoefficients$1;
                    this.sum$1 = sum$1;
                }
            });
            if (this.fitIntercept) {
                sum.elem += localCoefficients[this.numFeaturesPlusIntercept() - 1];
            }
            double d = loss2 = 1.0 > (labelScaled = (double)2 * label - 1.0) * (dotProduct = sum.elem) ? (1.0 - labelScaled * dotProduct) * weight : 0.0;
            if (1.0 > labelScaled * dotProduct) {
                double gradientScale = -labelScaled * weight;
                features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localGradientSumArray, gradientScale){
                    public static final long serialVersionUID = 0L;
                    private final double[] localFeaturesStd$1;
                    private final double[] localGradientSumArray$1;
                    private final double gradientScale$1;

                    public final void apply(int index2, double value) {
                        this.apply$mcVID$sp(index2, value);
                    }

                    public void apply$mcVID$sp(int index2, double value) {
                        if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                            this.localGradientSumArray$1[index2] = this.localGradientSumArray$1[index2] + value * this.gradientScale$1 / this.localFeaturesStd$1[index2];
                        }
                    }
                    {
                        this.localFeaturesStd$1 = localFeaturesStd$1;
                        this.localGradientSumArray$1 = localGradientSumArray$1;
                        this.gradientScale$1 = gradientScale$1;
                    }
                });
                if (this.fitIntercept) {
                    int n = localGradientSumArray.length - 1;
                    localGradientSumArray[n] = localGradientSumArray[n] + gradientScale;
                }
            }
            this.lossSum_$eq(this.lossSum() + loss2);
            this.weightSum_$eq(this.weightSum() + weight);
            HingeAggregator hingeAggregator = this;
            return hingeAggregator;
        }
        throw new MatchError((Object)instance2);
    }

    public HingeAggregator(Broadcast<double[]> bcFeaturesStd, boolean fitIntercept, Broadcast<Vector> bcCoefficients) {
        this.bcFeaturesStd = bcFeaturesStd;
        this.fitIntercept = fitIntercept;
        this.bcCoefficients = bcCoefficients;
        DifferentiableLossAggregator$class.$init$(this);
        this.org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.numFeaturesPlusIntercept = fitIntercept ? this.org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures() + 1 : this.org$apache$spark$ml$optim$aggregator$HingeAggregator$$numFeatures();
        this.dim = this.numFeaturesPlusIntercept();
    }
}

