/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.source.libsvm.LibSVMFileFormat$;
import org.apache.spark.ml.source.libsvm.LibSVMFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.ml.source.libsvm.LibSVMOptions;
import org.apache.spark.ml.source.libsvm.LibSVMOptions$;
import org.apache.spark.ml.source.libsvm.LibSVMOutputWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\u0001\u0003\u0001\tq!\u0001\u0005'jEN3VJR5mK\u001a{'/\\1u\u0015\t\u0019A!\u0001\u0004mS\n\u001ch/\u001c\u0006\u0003\u000b\u0019\taa]8ve\u000e,'BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\u0011\u0001q\"G\u0010\u0011\u0005A9R\"A\t\u000b\u0005I\u0019\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001F\u000b\u0002\u0013\u0015DXmY;uS>t'B\u0001\f\t\u0003\r\u0019\u0018\u000f\\\u0005\u00031E\u00111\u0003V3yi\n\u000b7/\u001a3GS2,gi\u001c:nCR\u0004\"AG\u000f\u000e\u0003mQ!\u0001H\u000b\u0002\u000fM|WO]2fg&\u0011ad\u0007\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002%C\t9Aj\\4hS:<\u0007\"\u0002\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003\tAQ\u0001\f\u0001\u0005B5\n\u0011b\u001d5peRt\u0015-\\3\u0015\u00039\u0002\"aL\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003iEBQ!\u000f\u0001\u0005B5\n\u0001\u0002^8TiJLgn\u001a\u0005\u0006w\u0001!I\u0001P\u0001\rm\u0016\u0014\u0018NZ=TG\",W.\u0019\u000b\u0004{\u0001C\u0005C\u0001\u0019?\u0013\ty\u0014G\u0001\u0003V]&$\b\"B!;\u0001\u0004\u0011\u0015A\u00033bi\u0006\u001c6\r[3nCB\u00111IR\u0007\u0002\t*\u0011Q)F\u0001\u0006if\u0004Xm]\u0005\u0003\u000f\u0012\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015I%\b1\u0001K\u0003)1wN],sSRLgn\u001a\t\u0003a-K!\u0001T\u0019\u0003\u000f\t{w\u000e\\3b]\")a\n\u0001C!\u001f\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)\u0011\u00016+\u00170\u0011\u0007A\n&)\u0003\u0002Sc\t1q\n\u001d;j_:DQ\u0001V'A\u0002U\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"AV,\u000e\u0003UI!\u0001W\u000b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bik\u0005\u0019A.\u0002\u000f=\u0004H/[8ogB!q\u0006\u0018\u0018/\u0013\tivGA\u0002NCBDQaX'A\u0002\u0001\fQAZ5mKN\u00042!Y5m\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002fO\u00051AH]8pizJ\u0011AM\u0005\u0003QF\nq\u0001]1dW\u0006<W-\u0003\u0002kW\n\u00191+Z9\u000b\u0005!\f\u0004CA7s\u001b\u0005q'BA8q\u0003\t17O\u0003\u0002r\u0015\u00051\u0001.\u00193p_BL!a\u001d8\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003v\u0001\u0011\u0005c/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\rF\u0004xun\f9!!\u0003\u0011\u0005AA\u0018BA=\u0012\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015!F\u000f1\u0001V\u0011\u0015aH\u000f1\u0001~\u0003\rQwN\u0019\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0001/A\u0005nCB\u0014X\rZ;dK&\u0019\u0011QA@\u0003\u0007){'\rC\u0003[i\u0002\u00071\fC\u0003Bi\u0002\u0007!\tC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003#\ty#!\r\u00024\u0005]\u00121HA$\u0003\u0013\u0002r\u0001MA\n\u0003/\ti\"C\u0002\u0002\u0016E\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007A\tI\"C\u0002\u0002\u001cE\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006C\u0006}\u00111E\u0005\u0004\u0003CY'\u0001C%uKJ\fGo\u001c:\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u0016\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u0017\u0003O\u00111\"\u00138uKJt\u0017\r\u001c*po\"1A+a\u0003A\u0002UCa!QA\u0006\u0001\u0004\u0011\u0005bBA\u001b\u0003\u0017\u0001\rAQ\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u0011\u0011HA\u0006\u0001\u0004\u0011\u0015A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\t\u0003{\tY\u00011\u0001\u0002@\u00059a-\u001b7uKJ\u001c\b\u0003B1j\u0003\u0003\u00022AGA\"\u0013\r\t)e\u0007\u0002\u0007\r&dG/\u001a:\t\ri\u000bY\u00011\u0001\\\u0011!\tY%a\u0003A\u0002\u00055\u0013A\u00035bI>|\u0007oQ8oMB!\u0011qJA+\u001b\t\t\tFC\u0002\u0002TA\fAaY8oM&!\u0011qKA)\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class LibSVMFileFormat
extends TextBasedFileFormat
implements DataSourceRegister,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String shortName() {
        return "libsvm";
    }

    public String toString() {
        return "LibSVM";
    }

    private void verifySchema(StructType dataSchema, boolean forWriting) {
        if (dataSchema.size() == 2 && dataSchema.apply(0).dataType().sameType(DataTypes.DoubleType) && dataSchema.apply(1).dataType().sameType((DataType)new VectorUDT()) && (forWriting || (int)dataSchema.apply(1).metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES()) > 0)) {
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal schema for libsvm data, schema=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSchema})));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        int numFeatures = BoxesRunTime.unboxToInt((Object)libSVMOptions.numFeatures().getOrElse((Function0)new Serializable(this, sparkSession, options, files){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMFileFormat $outer;
            private final SparkSession sparkSession$1;
            private final Map options$1;
            private final Seq files$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                Predef$.MODULE$.require(this.files$1.nonEmpty(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No input path specified for libsvm data";
                    }
                });
                this.$outer.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "'numFeatures' option not specified, determining the number of features by going though the input. If you know the number in advance, please specify it via 'numFeatures' option to avoid the extra scan.";
                    }
                });
                Seq paths = (Seq)this.files$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(FileStatus x$1) {
                        return x$1.getPath().toString();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD<Tuple3<Object, int[], double[]>> parsed = MLUtils$.MODULE$.parseLibSVMFile(this.sparkSession$1, (Seq<String>)paths, (Map<String, String>)this.options$1);
                return MLUtils$.MODULE$.computeNumFeatures(parsed);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sparkSession$1 = sparkSession$1;
                this.options$1 = options$1;
                this.files$1 = files$1;
            }
        }));
        Metadata featuresMetadata = new MetadataBuilder().putLong(LibSVMOptions$.MODULE$.NUM_FEATURES(), (long)numFeatures).build();
        StructField structField = new StructField("label", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("features", (DataType)new VectorUDT(), false, featuresMetadata);
        return new Some((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema, true);
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new LibSVMOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)".libsvm").append((Object)CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        this.verifySchema(dataSchema, false);
        int numFeatures = (int)dataSchema.apply("features").metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES());
        Predef$.MODULE$.assert(numFeatures > 0);
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        boolean isSparse = libSVMOptions.isSparse();
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, dataSchema, requiredSchema, numFeatures, isSparse, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            public final StructType requiredSchema$1;
            public final int numFeatures$1;
            public final boolean isSparse$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<UnsafeRow> apply(PartitionedFile file) {
                HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value());
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, linesReader){
                    public static final long serialVersionUID = 0L;
                    public final HadoopFileLinesReader linesReader$1;

                    public final TaskContext apply(TaskContext x$4) {
                        return x$4.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$apply$1 $outer;

                            public final void apply(TaskContext x$5) {
                                this.$outer.linesReader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.linesReader$1 = linesReader$1;
                    }
                });
                Iterator points = linesReader.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Text x$6) {
                        return x$6.toString().trim();
                    }
                }).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String line) {
                        return line.isEmpty() || line.startsWith("#");
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final LabeledPoint apply(String line) {
                        Tuple3<Object, int[], double[]> tuple3 = MLUtils$.MODULE$.parseLibSVMRecord(line);
                        if (tuple3 != null) {
                            Tuple3 tuple32;
                            double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                            int[] indices = (int[])tuple3._2();
                            double[] values = (double[])tuple3._3();
                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)indices, (Object)values);
                            double label2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                            int[] indices2 = (int[])tuple33._2();
                            double[] values2 = (double[])tuple33._3();
                            return new LabeledPoint(label2, Vectors$.MODULE$.sparse(this.$outer.numFeatures$1, indices2, values2));
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                ExpressionEncoder converter = RowEncoder$.MODULE$.apply(this.dataSchema$1);
                Seq fullOutput = (Seq)this.dataSchema$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AttributeReference apply(StructField f) {
                        String x$8 = f.name();
                        DataType x$9 = f.dataType();
                        boolean x$10 = f.nullable();
                        Metadata x$11 = f.metadata();
                        ExprId x$12 = AttributeReference$.MODULE$.apply$default$5(x$8, x$9, x$10, x$11);
                        Seq x$13 = AttributeReference$.MODULE$.apply$default$6(x$8, x$9, x$10, x$11);
                        return new AttributeReference(x$8, x$9, x$10, x$11, x$12, x$13);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq requiredOutput = (Seq)fullOutput.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final boolean apply(AttributeReference a) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.requiredSchema$1.fieldNames()).contains((Object)a.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                UnsafeProjection requiredColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)requiredOutput, fullOutput);
                return points.map((Function1)new Serializable(this, converter, requiredColumns){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;
                    private final ExpressionEncoder converter$1;
                    private final UnsafeProjection requiredColumns$1;

                    public final UnsafeRow apply(LabeledPoint pt) {
                        SparseVector features = this.$outer.isSparse$1 ? pt.features().toSparse() : pt.features().toDense();
                        return this.requiredColumns$1.apply(this.converter$1.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)pt.label()), features}))));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.converter$1 = converter$1;
                        this.requiredColumns$1 = requiredColumns$1;
                    }
                });
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.numFeatures$1 = numFeatures$1;
                this.isSparse$1 = isSparse$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }

    public LibSVMFileFormat() {
        Logging.class.$init$((Logging)this);
    }
}

