/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public void checkColumnType(StructType schema, String colName, DataType dataType, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? new StringBuilder().append((Object)" ").append((Object)msg).toString() : "";
        Predef$.MODULE$.require(actualDataType.equals(dataType), (Function0)new Serializable(colName, dataType, actualDataType, message){
            public static final long serialVersionUID = 0L;
            private final String colName$1;
            private final DataType dataType$1;
            private final DataType actualDataType$1;
            private final String message$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " must be of type ", " but was actually "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.colName$1, this.dataType$1.catalogString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.actualDataType$1.catalogString(), this.message$1}))).toString();
            }
            {
                this.colName$1 = colName$1;
                this.dataType$1 = dataType$1;
                this.actualDataType$1 = actualDataType$1;
                this.message$1 = message$1;
            }
        });
    }

    public String checkColumnType$default$4() {
        return "";
    }

    public void checkColumnTypes(StructType schema, String colName, Seq<DataType> dataTypes, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? new StringBuilder().append((Object)" ").append((Object)msg).toString() : "";
        Predef$.MODULE$.require(dataTypes.exists((Function1)new Serializable(actualDataType){
            public static final long serialVersionUID = 0L;
            private final DataType actualDataType$2;

            public final boolean apply(Object x$1) {
                return this.actualDataType$2.equals(x$1);
            }
            {
                this.actualDataType$2 = actualDataType$2;
            }
        }), (Function0)new Serializable(colName, dataTypes, actualDataType, message){
            public static final long serialVersionUID = 0L;
            private final String colName$3;
            private final Seq dataTypes$1;
            private final DataType actualDataType$2;
            private final String message$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " must be of type equal to one of the following types: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.colName$3}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " but was actually of type "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.dataTypes$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(DataType x$1) {
                        return x$1.catalogString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.actualDataType$2.catalogString(), this.message$2}))).toString();
            }
            {
                this.colName$3 = colName$3;
                this.dataTypes$1 = dataTypes$1;
                this.actualDataType$2 = actualDataType$2;
                this.message$2 = message$2;
            }
        });
    }

    public String checkColumnTypes$default$4() {
        return "";
    }

    public void checkNumericType(StructType schema, String colName, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? new StringBuilder().append((Object)" ").append((Object)msg).toString() : "";
        Predef$.MODULE$.require(actualDataType instanceof NumericType, (Function0)new Serializable(colName, actualDataType, message){
            public static final long serialVersionUID = 0L;
            private final String colName$2;
            private final DataType actualDataType$3;
            private final String message$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " must be of type ", " but was actually of type "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.colName$2, NumericType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.actualDataType$3.catalogString(), this.message$3}))).toString();
            }
            {
                this.colName$2 = colName$2;
                this.actualDataType$3 = actualDataType$3;
                this.message$3 = message$3;
            }
        });
    }

    public String checkNumericType$default$3() {
        return "";
    }

    public StructType appendColumn(StructType schema, String colName, DataType dataType, boolean nullable) {
        if (colName.isEmpty()) {
            return schema;
        }
        return this.appendColumn(schema, new StructField(colName, dataType, nullable, StructField$.MODULE$.apply$default$4()));
    }

    public StructType appendColumn(StructType schema, StructField col) {
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).contains((Object)col.name()), (Function0)new Serializable(col){
            public static final long serialVersionUID = 0L;
            private final StructField col$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1.name()}));
            }
            {
                this.col$1 = col$1;
            }
        });
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).$colon$plus((Object)col, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public boolean appendColumn$default$4() {
        return false;
    }

    public void validateVectorCompatibleColumn(StructType schema, String colName) {
        List typeCandidates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new VectorUDT(), new ArrayType((DataType)DoubleType$.MODULE$, false), new ArrayType((DataType)FloatType$.MODULE$, false)}));
        this.checkColumnTypes(schema, colName, (Seq<DataType>)typeCandidates, this.checkColumnTypes$default$4());
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

