/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.PartitionwiseSampledRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.BernoulliCellSampler;
import org.apache.spark.util.random.RandomSampler;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class MLUtils$
implements Logging {
    public static final MLUtils$ MODULE$;
    private double EPSILON;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new MLUtils$();
    }

    /*
     * WARNING - void declaration
     */
    private double EPSILON$lzycompute() {
        MLUtils$ mLUtils$ = this;
        synchronized (mLUtils$) {
            if (!this.bitmap$0) {
                void var2_2;
                double eps = 1.0;
                while (1.0 + eps / 2.0 != 1.0) {
                    eps /= 2.0;
                }
                this.EPSILON = var2_2;
                this.bitmap$0 = true;
            }
            return this.EPSILON;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Dataset<Row> convertVectorColumnsToML(Dataset<?> dataset, String ... cols) {
        return this.convertVectorColumnsToML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertVectorColumnsFromML(Dataset<?> dataset, String ... cols) {
        return this.convertVectorColumnsFromML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertMatrixColumnsToML(Dataset<?> dataset, String ... cols) {
        return this.convertMatrixColumnsToML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertMatrixColumnsFromML(Dataset<?> dataset, String ... cols) {
        return this.convertMatrixColumnsFromML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public double EPSILON() {
        return this.bitmap$0 ? this.EPSILON : this.EPSILON$lzycompute();
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures, int minPartitions) {
        int n;
        RDD<Tuple3<Object, int[], double[]>> parsed = this.parseLibSVMFile(sc, path, minPartitions);
        if (numFeatures > 0) {
            n = numFeatures;
        } else {
            parsed.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
            n = this.computeNumFeatures(parsed);
        }
        int d = n;
        return parsed.map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final int d$1;

            public final LabeledPoint apply(Tuple3<Object, int[], double[]> x0$1) {
                Tuple3<Object, int[], double[]> tuple3 = x0$1;
                if (tuple3 != null) {
                    double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    int[] indices = (int[])tuple3._2();
                    double[] values = (double[])tuple3._3();
                    LabeledPoint labeledPoint = new LabeledPoint(label, Vectors$.MODULE$.sparse(this.d$1, indices, values));
                    return labeledPoint;
                }
                throw new MatchError(tuple3);
            }
            {
                this.d$1 = d$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public int computeNumFeatures(RDD<Tuple3<Object, int[], double[]>> rdd) {
        return BoxesRunTime.unboxToInt((Object)rdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<Object, int[], double[]> x0$2) {
                Tuple3<Object, int[], double[]> tuple3 = x0$2;
                if (tuple3 != null) {
                    int[] indices = (int[])tuple3._2();
                    int n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(indices).lastOption().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    return n;
                }
                throw new MatchError(tuple3);
            }
        }, ClassTag$.MODULE$.Int()).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x, int y) {
                return this.apply$mcIII$sp(x, y);
            }

            public int apply$mcIII$sp(int x, int y) {
                return scala.math.package$.MODULE$.max(x, y);
            }
        })) + 1;
    }

    public RDD<Tuple3<Object, int[], double[]>> parseLibSVMFile(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }, ClassTag$.MODULE$.apply(String.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String line) {
                return !line.isEmpty() && !line.startsWith("#");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, int[], double[]> apply(String line) {
                return MLUtils$.MODULE$.parseLibSVMRecord(line);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public RDD<Tuple3<Object, int[], double[]>> parseLibSVMFile(SparkSession sparkSession, Seq<String> paths, Map<String, String> options) {
        SparkSession x$12 = sparkSession;
        Seq<String> x$13 = paths;
        String x$14 = TextFileFormat.class.getName();
        Map x$15 = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSource$.MODULE$.GLOB_PATHS_KEY()), (Object)"false")})));
        Option x$16 = DataSource$.MODULE$.apply$default$4();
        Seq x$17 = DataSource$.MODULE$.apply$default$5();
        Option x$18 = DataSource$.MODULE$.apply$default$6();
        Option x$19 = DataSource$.MODULE$.apply$default$8();
        Dataset lines = sparkSession.baseRelationToDataFrame(new DataSource(x$12, x$14, x$13, x$16, x$17, x$18, x$15, x$19).resolveRelation(false)).select("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return lines.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.trim((Column)lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("line")})).filter(functions$.MODULE$.not(functions$.MODULE$.length((Column)lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"line"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)).or(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"line"}))).$((Seq)Nil$.MODULE$).startsWith("#")))).as(lines.sqlContext().implicits().newStringEncoder()).rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, int[], double[]> apply(String line) {
                return MLUtils$.MODULE$.parseLibSVMRecord(line);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public Tuple3<Object, int[], double[]> parseLibSVMRecord(String line) {
        String[] items = new StringOps(Predef$.MODULE$.augmentString(line)).split(' ');
        double label = new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])items).head())).toDouble();
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])items).tail()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(String item) {
                String[] indexAndValue = new StringOps(Predef$.MODULE$.augmentString(item)).split(':');
                int index2 = new StringOps(Predef$.MODULE$.augmentString(indexAndValue[0])).toInt() - 1;
                double value = new StringOps(Predef$.MODULE$.augmentString(indexAndValue[1])).toDouble();
                return new Tuple2.mcID.sp(index2, value);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 != null) {
            Tuple2 tuple22;
            int[] indices = (int[])tuple2._1();
            double[] values = (double[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)indices, (Object)values);
            int[] indices2 = (int[])tuple23._1();
            double[] values2 = (double[])tuple23._2();
            IntRef previous = IntRef.create((int)-1);
            int indicesLength = indices2.length;
            for (int i = 0; i < indicesLength; ++i) {
                int current = indices2[i];
                Predef$.MODULE$.require(current > previous.elem, (Function0)new Serializable(line, previous, current){
                    public static final long serialVersionUID = 0L;
                    private final String line$1;
                    private final IntRef previous$1;
                    private final int current$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"indices should be one-based and in ascending order;"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" found current=", ", previous=", "; line=\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.current$1), BoxesRunTime.boxToInteger((int)this.previous$1.elem), this.line$1}))).toString();
                    }
                    {
                        this.line$1 = line$1;
                        this.previous$1 = previous$1;
                        this.current$1 = current$1;
                    }
                });
                previous.elem = current;
            }
            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), Predef$.MODULE$.intArrayOps(indices2).toArray(ClassTag$.MODULE$.Int()), Predef$.MODULE$.doubleArrayOps(values2).toArray(ClassTag$.MODULE$.Double()));
        }
        throw new MatchError((Object)tuple2);
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures) {
        return this.loadLibSVMFile(sc, path, numFeatures, sc.defaultMinPartitions());
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path) {
        return this.loadLibSVMFile(sc, path, -1);
    }

    public void saveAsLibSVMFile(RDD<LabeledPoint> data, String dir) {
        RDD dataStr = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LabeledPoint x0$3) {
                LabeledPoint labeledPoint = x0$3;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector features = labeledPoint.features();
                    StringBuilder sb = new StringBuilder(((Object)BoxesRunTime.boxToDouble((double)label)).toString());
                    features.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, sb){
                        public static final long serialVersionUID = 0L;
                        private final StringBuilder sb$1;

                        public final void apply(int x0$4, double x1$1) {
                            this.apply$mcVID$sp(x0$4, x1$1);
                        }

                        public void apply$mcVID$sp(int x0$4, double x1$1) {
                            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$4, x1$1);
                            if (sp2 != null) {
                                int i = sp2._1$mcI$sp();
                                double v = sp2._2$mcD$sp();
                                this.sb$1.$plus$eq(' ');
                                this.sb$1.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1)), BoxesRunTime.boxToDouble((double)v)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)sp2);
                        }
                        {
                            this.sb$1 = sb$1;
                        }
                    });
                    String string = sb.mkString();
                    return string;
                }
                throw new MatchError((Object)labeledPoint);
            }
        }, ClassTag$.MODULE$.apply(String.class));
        dataStr.saveAsTextFile(dir);
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String s) {
                return Vectors$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path) {
        return sc.textFile(path, sc.defaultMinPartitions()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String s) {
                return Vectors$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String s) {
                return LabeledPoint$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String dir) {
        return this.loadLabeledPoints(sc, dir, sc.defaultMinPartitions());
    }

    public <T> Tuple2<RDD<T>, RDD<T>>[] kFold(RDD<T> rdd, int numFolds, int seed, ClassTag<T> evidence$1) {
        return this.kFold(rdd, numFolds, (long)seed, evidence$1);
    }

    public <T> Tuple2<RDD<T>, RDD<T>>[] kFold(RDD<T> rdd, int numFolds, long seed, ClassTag<T> evidence$2) {
        float numFoldsF = numFolds;
        return (Tuple2[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFolds).map((Function1)new Serializable(rdd, seed, evidence$2, numFoldsF){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$1;
            private final long seed$1;
            private final ClassTag evidence$2$1;
            private final float numFoldsF$1;

            public final Tuple2<PartitionwiseSampledRDD<T, T>, PartitionwiseSampledRDD<T, T>> apply(int fold) {
                BernoulliCellSampler sampler = new BernoulliCellSampler((double)((float)(fold - 1) / this.numFoldsF$1), (double)((float)fold / this.numFoldsF$1), false);
                PartitionwiseSampledRDD validation = new PartitionwiseSampledRDD(this.rdd$1, (RandomSampler)sampler, true, this.seed$1, this.evidence$2$1, this.evidence$2$1);
                PartitionwiseSampledRDD training = new PartitionwiseSampledRDD(this.rdd$1, (RandomSampler)sampler.cloneComplement(), true, this.seed$1, this.evidence$2$1, this.evidence$2$1);
                return new Tuple2((Object)training, (Object)validation);
            }
            {
                this.rdd$1 = rdd$1;
                this.seed$1 = seed$1;
                this.evidence$2$1 = evidence$2$1;
                this.numFoldsF$1 = numFoldsF$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Vector appendBias(Vector vector) {
        block4: {
            Vector vector2;
            block3: {
                Vector vector3;
                block2: {
                    vector3 = vector;
                    if (!(vector3 instanceof DenseVector)) break block2;
                    DenseVector denseVector = (DenseVector)vector3;
                    double[] inputValues = denseVector.values();
                    int inputLength = inputValues.length;
                    double[] outputValues = (double[])Array$.MODULE$.ofDim(inputLength + 1, ClassTag$.MODULE$.Double());
                    System.arraycopy(inputValues, 0, outputValues, 0, inputLength);
                    outputValues[inputLength] = 1.0;
                    vector2 = Vectors$.MODULE$.dense(outputValues);
                    break block3;
                }
                if (!(vector3 instanceof SparseVector)) break block4;
                SparseVector sparseVector = (SparseVector)vector3;
                double[] inputValues = sparseVector.values();
                int[] inputIndices = sparseVector.indices();
                int inputValuesLength = inputValues.length;
                int dim = sparseVector.size();
                double[] outputValues = (double[])Array$.MODULE$.ofDim(inputValuesLength + 1, ClassTag$.MODULE$.Double());
                int[] outputIndices = (int[])Array$.MODULE$.ofDim(inputValuesLength + 1, ClassTag$.MODULE$.Int());
                System.arraycopy(inputValues, 0, outputValues, 0, inputValuesLength);
                System.arraycopy(inputIndices, 0, outputIndices, 0, inputValuesLength);
                outputValues[inputValuesLength] = 1.0;
                outputIndices[inputValuesLength] = dim;
                vector2 = Vectors$.MODULE$.sparse(dim + 1, outputIndices, outputValues);
            }
            return vector2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support vector type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector.getClass()})));
    }

    public Dataset<Row> convertVectorColumnsToML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Iterable<String> apply(String c) {
                Iterable iterable;
                DataType dataType = this.schema$1.apply(c).dataType();
                Class<?> clazz = dataType.getClass();
                Class<org.apache.spark.mllib.linalg.VectorUDT> clazz2 = org.apache.spark.mllib.linalg.VectorUDT.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)c));
                } else {
                    Class<?> clazz3 = dataType.getClass();
                    Class<VectorUDT> clazz4 = VectorUDT.class;
                    Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0)new Serializable(this, dataType, c){
                        public static final long serialVersionUID = 0L;
                        private final DataType dataType$1;
                        private final String c$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " must be old Vector type to be converted to new type but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.c$1, this.dataType$1}));
                        }
                        {
                            this.dataType$1 = dataType$1;
                            this.c$1 = c$1;
                        }
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.schema$1 = schema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$4) {
                Class<?> clazz = x$4.dataType().getClass();
                Class<org.apache.spark.mllib.linalg.VectorUDT> clazz2 = org.apache.spark.mllib.linalg.VectorUDT.class;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$5) {
                return x$5.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Vector column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.";
            }
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator4$1() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator5$1() {
            }
        }
        UserDefinedFunction convertToML = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.ml.linalg.Vector apply(Vector v) {
                return v.asML();
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator4$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator5$1()));
        Column[] exprs = (Column[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(colSet, convertToML){
            public static final long serialVersionUID = 0L;
            private final Set colSet$1;
            private final UserDefinedFunction convertToML$1;

            public final Column apply(StructField field) {
                String c = field.name();
                return this.colSet$1.contains((Object)c) ? this.convertToML$1.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
            }
            {
                this.colSet$1 = colSet$1;
                this.convertToML$1 = convertToML$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> convertVectorColumnsFromML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;

            public final Iterable<String> apply(String c) {
                Iterable iterable;
                DataType dataType = this.schema$2.apply(c).dataType();
                Class<?> clazz = dataType.getClass();
                Class<VectorUDT> clazz2 = VectorUDT.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)c));
                } else {
                    Class<?> clazz3 = dataType.getClass();
                    Class<org.apache.spark.mllib.linalg.VectorUDT> clazz4 = org.apache.spark.mllib.linalg.VectorUDT.class;
                    Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0)new Serializable(this, dataType, c){
                        public static final long serialVersionUID = 0L;
                        private final DataType dataType$2;
                        private final String c$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " must be new Vector type to be converted to old type but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.c$2, this.dataType$2}));
                        }
                        {
                            this.dataType$2 = dataType$2;
                            this.c$2 = c$2;
                        }
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.schema$2 = schema$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$6) {
                Class<?> clazz = x$6.dataType().getClass();
                Class<VectorUDT> clazz2 = VectorUDT.class;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$7) {
                return x$7.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Vector column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.";
            }
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator6$1() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator7$1() {
            }
        }
        UserDefinedFunction convertFromML = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(org.apache.spark.ml.linalg.Vector v) {
                return Vectors$.MODULE$.fromML(v);
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator6$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator7$1()));
        Column[] exprs = (Column[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(colSet, convertFromML){
            public static final long serialVersionUID = 0L;
            private final Set colSet$2;
            private final UserDefinedFunction convertFromML$1;

            public final Column apply(StructField field) {
                String c = field.name();
                return this.colSet$2.contains((Object)c) ? this.convertFromML$1.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
            }
            {
                this.colSet$2 = colSet$2;
                this.convertFromML$1 = convertFromML$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> convertMatrixColumnsToML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$3;

            public final Iterable<String> apply(String c) {
                Iterable iterable;
                DataType dataType = this.schema$3.apply(c).dataType();
                Class<?> clazz = dataType.getClass();
                Class<MatrixUDT> clazz2 = MatrixUDT.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)c));
                } else {
                    Class<?> clazz3 = dataType.getClass();
                    Class<org.apache.spark.ml.linalg.MatrixUDT> clazz4 = org.apache.spark.ml.linalg.MatrixUDT.class;
                    Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0)new Serializable(this, dataType, c){
                        public static final long serialVersionUID = 0L;
                        private final DataType dataType$3;
                        private final String c$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " must be old Matrix type to be converted to new type but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.c$3, this.dataType$3}));
                        }
                        {
                            this.dataType$3 = dataType$3;
                            this.c$3 = c$3;
                        }
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.schema$3 = schema$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$8) {
                Class<?> clazz = x$8.dataType().getClass();
                Class<MatrixUDT> clazz2 = MatrixUDT.class;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$9) {
                return x$9.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Matrix column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.";
            }
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator8$1() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator9$1() {
            }
        }
        UserDefinedFunction convertToML = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.ml.linalg.Matrix apply(Matrix v) {
                return v.asML();
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator8$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator9$1()));
        Column[] exprs = (Column[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(colSet, convertToML){
            public static final long serialVersionUID = 0L;
            private final Set colSet$3;
            private final UserDefinedFunction convertToML$2;

            public final Column apply(StructField field) {
                String c = field.name();
                return this.colSet$3.contains((Object)c) ? this.convertToML$2.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
            }
            {
                this.colSet$3 = colSet$3;
                this.convertToML$2 = convertToML$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> convertMatrixColumnsFromML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$4;

            public final Iterable<String> apply(String c) {
                Iterable iterable;
                DataType dataType = this.schema$4.apply(c).dataType();
                Class<?> clazz = dataType.getClass();
                Class<org.apache.spark.ml.linalg.MatrixUDT> clazz2 = org.apache.spark.ml.linalg.MatrixUDT.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)c));
                } else {
                    Class<?> clazz3 = dataType.getClass();
                    Class<MatrixUDT> clazz4 = MatrixUDT.class;
                    Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0)new Serializable(this, dataType, c){
                        public static final long serialVersionUID = 0L;
                        private final DataType dataType$4;
                        private final String c$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " must be new Matrix type to be converted to old type but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.c$4, this.dataType$4}));
                        }
                        {
                            this.dataType$4 = dataType$4;
                            this.c$4 = c$4;
                        }
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.schema$4 = schema$4;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$10) {
                Class<?> clazz = x$10.dataType().getClass();
                Class<org.apache.spark.ml.linalg.MatrixUDT> clazz2 = org.apache.spark.ml.linalg.MatrixUDT.class;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$11) {
                return x$11.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Matrix column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.";
            }
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator10$1() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator11$1() {
            }
        }
        UserDefinedFunction convertFromML = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Matrix apply(org.apache.spark.ml.linalg.Matrix m) {
                return Matrices$.MODULE$.fromML(m);
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator10$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator11$1()));
        Column[] exprs = (Column[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(colSet, convertFromML){
            public static final long serialVersionUID = 0L;
            private final Set colSet$4;
            private final UserDefinedFunction convertFromML$2;

            public final Column apply(StructField field) {
                String c = field.name();
                return this.colSet$4.contains((Object)c) ? this.convertFromML$2.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
            }
            {
                this.colSet$4 = colSet$4;
                this.convertFromML$2 = convertFromML$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public double fastSquaredDistance(Vector v1, double norm1, Vector v2, double norm2, double precision2) {
        int n = v1.size();
        Predef$.MODULE$.require(v2.size() == n);
        Predef$.MODULE$.require(norm1 >= 0.0 && norm2 >= 0.0);
        double sumSquaredNorm = norm1 * norm1 + norm2 * norm2;
        double normDiff = norm1 - norm2;
        double sqDist = 0.0;
        double precisionBound1 = 2.0 * this.EPSILON() * sumSquaredNorm / (normDiff * normDiff + this.EPSILON());
        if (precisionBound1 < precision2) {
            sqDist = sumSquaredNorm - 2.0 * BLAS$.MODULE$.dot(v1, v2);
        } else if (v1 instanceof SparseVector || v2 instanceof SparseVector) {
            double dotValue = BLAS$.MODULE$.dot(v1, v2);
            sqDist = scala.math.package$.MODULE$.max(sumSquaredNorm - 2.0 * dotValue, 0.0);
            double precisionBound2 = this.EPSILON() * (sumSquaredNorm + 2.0 * scala.math.package$.MODULE$.abs(dotValue)) / (sqDist + this.EPSILON());
            if (precisionBound2 > precision2) {
                sqDist = Vectors$.MODULE$.sqdist(v1, v2);
            }
        } else {
            sqDist = Vectors$.MODULE$.sqdist(v1, v2);
        }
        return sqDist;
    }

    public double fastSquaredDistance$default$5() {
        return 1.0E-6;
    }

    public double log1pExp(double x) {
        return x > 0.0 ? x + scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(-x)) : scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(x));
    }

    private MLUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

