/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.SequenceReference;
import org.spark_project.dmg.pmml.Time;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "sequenceReference", "time"})
@XmlRootElement(name="ConsequentSequence", namespace="http://www.dmg.org/PMML-4_2")
public class ConsequentSequence
extends PMMLObject
implements HasExtensions {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="SequenceReference", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private SequenceReference sequenceReference;
    @XmlElement(name="Time", namespace="http://www.dmg.org/PMML-4_2")
    private Time time;

    public ConsequentSequence() {
    }

    public ConsequentSequence(SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public SequenceReference getSequenceReference() {
        return this.sequenceReference;
    }

    public ConsequentSequence setSequenceReference(SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
        return this;
    }

    public Time getTime() {
        return this.time;
    }

    public ConsequentSequence setTime(Time time) {
        this.time = time;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public ConsequentSequence addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getSequenceReference(), this.getTime());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

