/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.NeuralOutput;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "neuralOutputs"})
@XmlRootElement(name="NeuralOutputs", namespace="http://www.dmg.org/PMML-4_2")
public class NeuralOutputs
extends PMMLObject
implements Iterable<NeuralOutput>,
HasExtensions {
    @XmlAttribute(name="numberOfOutputs")
    private Integer numberOfOutputs;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="NeuralOutput", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<NeuralOutput> neuralOutputs;

    public NeuralOutputs() {
    }

    public NeuralOutputs(List<NeuralOutput> neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
    }

    public Integer getNumberOfOutputs() {
        return this.numberOfOutputs;
    }

    public NeuralOutputs setNumberOfOutputs(Integer numberOfOutputs) {
        this.numberOfOutputs = numberOfOutputs;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<NeuralOutput> getNeuralOutputs() {
        if (this.neuralOutputs == null) {
            this.neuralOutputs = new ArrayList<NeuralOutput>();
        }
        return this.neuralOutputs;
    }

    @Override
    public Iterator<NeuralOutput> iterator() {
        return this.getNeuralOutputs().iterator();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public NeuralOutputs addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeuralOutputs() {
        return this.neuralOutputs != null && this.neuralOutputs.size() > 0;
    }

    public NeuralOutputs addNeuralOutputs(NeuralOutput ... neuralOutputs) {
        this.getNeuralOutputs().addAll(Arrays.asList(neuralOutputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasNeuralOutputs()) {
                status = PMMLObject.traverse(visitor, this.getNeuralOutputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

