/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.ImputerModel$;
import org.apache.spark.ml.feature.ImputerParams;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCols;
import org.apache.spark.ml.param.shared.HasRelativeError;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0010!\u0001-B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0005\u0010\u0005\t'\u0002\u0011\t\u0011)A\u0005{!AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003X\u0011\u0019Y\u0007\u0001\"\u0001#Y\")\u0011\u000f\u0001C\u0001e\")\u0011\u0010\u0001C\u0001u\")Q\u0010\u0001C\u0001}\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001BCA\b\u0001!\u0015\r\u0011\"\u0003\u0002\u0012!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!!$\u0001\t\u0003\nyiB\u0004\u0002\u0016\u0002B\t!a&\u0007\r}\u0001\u0003\u0012AAM\u0011\u0019Y\u0017\u0003\"\u0001\u0002.\u001a9\u0011qV\t\u0001#\u0005E\u0006\"CAZ'\t\u0005\t\u0015!\u00031\u0011\u0019Y7\u0003\"\u0001\u00026\"9\u0011QX\n\u0005R\u0005}fABAf#\u0011\ti\r\u0003\u0004l/\u0011\u0005\u0011Q\u001b\u0005\n\u00033<\"\u0019!C\u0005\u00037D\u0001\"a;\u0018A\u0003%\u0011Q\u001c\u0005\b\u0003[<B\u0011IAx\u0011\u001d\t\u00190\u0005C!\u0003kDq!!<\u0012\t\u0003\nI\u0010C\u0005\u0002\u0000F\t\t\u0011\"\u0003\u0003\u0002\ta\u0011*\u001c9vi\u0016\u0014Xj\u001c3fY*\u0011\u0011EI\u0001\bM\u0016\fG/\u001e:f\u0015\t\u0019C%\u0001\u0002nY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001a#'\u000e\t\u0004[9\u0002T\"\u0001\u0012\n\u0005=\u0012#!B'pI\u0016d\u0007CA\u0019\u0001\u001b\u0005\u0001\u0003CA\u00194\u0013\t!\u0004EA\u0007J[B,H/\u001a:QCJ\fWn\u001d\t\u0003mej\u0011a\u000e\u0006\u0003q\t\nA!\u001e;jY&\u0011!h\u000e\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\tQ\b\u0005\u0002?\u000f:\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005*\na\u0001\u0010:p_Rt$\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!AR\")\u0007\u0005Y\u0015\u000b\u0005\u0002M\u001f6\tQJ\u0003\u0002OI\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Ak%!B*j]\u000e,\u0017%\u0001*\u0002\u000bIr#G\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005-\u000b\u0016aC:veJ|w-\u0019;f\t\u001a+\u0012a\u0016\t\u00031\u0016t!!\u00172\u000f\u0005i\u0003gBA.`\u001d\tafL\u0004\u0002A;&\t\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003C\u0012\n1a]9m\u0013\t\u0019G-A\u0004qC\u000e\\\u0017mZ3\u000b\u0005\u0005$\u0013B\u00014h\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002dI\"\u001a1aS)\u0002\u0019M,(O]8hCR,GI\u0012\u0011)\u0007\u0011Y\u0015+\u0001\u0004=S:LGO\u0010\u000b\u0004a5|\u0007\"B\u001e\u0006\u0001\u0004i\u0004fA7L#\")Q+\u0002a\u0001/\"\u001aqnS)\u0002\u0017M,G/\u00138qkR\u001cu\u000e\u001c\u000b\u0003gRl\u0011\u0001\u0001\u0005\u0006k\u001a\u0001\r!P\u0001\u0006m\u0006dW/\u001a\u0015\u0004\r-;\u0018%\u0001=\u0002\u000bMr\u0003G\f\u0019\u0002\u0019M,GoT;uaV$8i\u001c7\u0015\u0005M\\\b\"B;\b\u0001\u0004i\u0004fA\u0004Lo\u0006a1/\u001a;J]B,HoQ8mgR\u00111o \u0005\u0007k\"\u0001\r!!\u0001\u0011\u000b\u0005\r\u0011QA\u001f\u000e\u0003\rK1!a\u0002D\u0005\u0015\t%O]1z\u00035\u0019X\r^(viB,HoQ8mgR\u00191/!\u0004\t\rUL\u0001\u0019AA\u0001\u0003)\u0019XO\u001d:pO\u0006$Xm]\u000b\u0003\u0003'\u0001r!!\u0006\u0002 u\n\u0019#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003%IW.\\;uC\ndWMC\u0002\u0002\u001e\r\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t#a\u0006\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0004\u0005\u0015\u0012bAA\u0014\u0007\n1Ai\\;cY\u0016D3ACA\u0016!\u0011\t\u0019!!\f\n\u0007\u0005=2IA\u0005ue\u0006t7/[3oi\u0006IAO]1og\u001a|'/\u001c\u000b\u0004/\u0006U\u0002bBA\u001c\u0017\u0001\u0007\u0011\u0011H\u0001\bI\u0006$\u0018m]3ua\u0011\tY$a\u0012\u0011\r\u0005u\u0012qHA\"\u001b\u0005!\u0017bAA!I\n9A)\u0019;bg\u0016$\b\u0003BA#\u0003\u000fb\u0001\u0001\u0002\u0007\u0002J\u0005U\u0012\u0011!A\u0001\u0006\u0003\tYEA\u0002`II\nB!!\u0014\u0002TA!\u00111AA(\u0013\r\t\tf\u0011\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019!!\u0016\n\u0007\u0005]3IA\u0002B]f\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003;\nI\u0007\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019\u0007Z\u0001\u0006if\u0004Xm]\u0005\u0005\u0003O\n\tG\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a\u001b\r\u0001\u0004\ti&\u0001\u0004tG\",W.Y\u0001\u0005G>\u0004\u0018\u0010F\u00021\u0003cBq!a\u001d\u000e\u0001\u0004\t)(A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tYHI\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003\u007f\nIH\u0001\u0005QCJ\fW.T1q\u0003\u00159(/\u001b;f+\t\t)\tE\u00027\u0003\u000fK1!!#8\u0005!iEj\u0016:ji\u0016\u0014\bf\u0001\bL#\u0006AAo\\*ue&tw\rF\u0001>Q\ry1j\u001e\u0015\u0004\u0001-\u000b\u0016\u0001D%naV$XM]'pI\u0016d\u0007CA\u0019\u0012'\u001d\t\u00121TAQ\u0003O\u0003B!a\u0001\u0002\u001e&\u0019\u0011qT\"\u0003\r\u0005s\u0017PU3g!\u00111\u00141\u0015\u0019\n\u0007\u0005\u0015vG\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004B!a\u0001\u0002*&\u0019\u00111V\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005]%AE%naV$XM]'pI\u0016dwK]5uKJ\u001c2aEAC\u0003!Ign\u001d;b]\u000e,G\u0003BA\\\u0003w\u00032!!/\u0014\u001b\u0005\t\u0002BBAZ+\u0001\u0007\u0001'\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\t\t-a2\u0011\t\u0005\r\u00111Y\u0005\u0004\u0003\u000b\u001c%\u0001B+oSRDa!!3\u0017\u0001\u0004i\u0014\u0001\u00029bi\"\u0014Q\"S7qkR,'OU3bI\u0016\u00148cA\f\u0002PB!a'!51\u0013\r\t\u0019n\u000e\u0002\t\u001b2\u0013V-\u00193feR\u0011\u0011q\u001b\t\u0004\u0003s;\u0012!C2mCN\u001ch*Y7f+\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\t1\fgn\u001a\u0006\u0003\u0003O\fAA[1wC&\u0019\u0001*!9\u0002\u0015\rd\u0017m]:OC6,\u0007%\u0001\u0003m_\u0006$Gc\u0001\u0019\u0002r\"1\u0011\u0011Z\u000eA\u0002u\nAA]3bIV\u0011\u0011q\u001a\u0015\u00049-\u000bFc\u0001\u0019\u0002|\"1\u0011\u0011Z\u000fA\u0002uB3!H&R\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0001\u0003BAp\u0005\u000bIAAa\u0002\u0002b\n1qJ\u00196fGRD3!E&RQ\r\u00012*\u0015")
public class ImputerModel
extends Model<ImputerModel>
implements ImputerParams,
MLWritable {
    private transient Map<String, Object> surrogates;
    private final String uid;
    private final Dataset<Row> surrogateDF;
    private final Param<String> strategy;
    private final DoubleParam missingValue;
    private final DoubleParam relativeError;
    private final StringArrayParam outputCols;
    private final Param<String> outputCol;
    private final StringArrayParam inputCols;
    private final Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    public static ImputerModel load(String string) {
        return ImputerModel$.MODULE$.load(string);
    }

    public static MLReader<ImputerModel> read() {
        return ImputerModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getStrategy() {
        return ImputerParams.getStrategy$(this);
    }

    @Override
    public double getMissingValue() {
        return ImputerParams.getMissingValue$(this);
    }

    @Override
    public Tuple2<String[], String[]> getInOutCols() {
        return ImputerParams.getInOutCols$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return ImputerParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getRelativeError() {
        return HasRelativeError.getRelativeError$(this);
    }

    @Override
    public final String[] getOutputCols() {
        return HasOutputCols.getOutputCols$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String[] getInputCols() {
        return HasInputCols.getInputCols$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final Param<String> strategy() {
        return this.strategy;
    }

    @Override
    public final DoubleParam missingValue() {
        return this.missingValue;
    }

    @Override
    public final void org$apache$spark$ml$feature$ImputerParams$_setter_$strategy_$eq(Param<String> x$1) {
        this.strategy = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$ImputerParams$_setter_$missingValue_$eq(DoubleParam x$1) {
        this.missingValue = x$1;
    }

    @Override
    public final DoubleParam relativeError() {
        return this.relativeError;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRelativeError$_setter_$relativeError_$eq(DoubleParam x$1) {
        this.relativeError = x$1;
    }

    @Override
    public final StringArrayParam outputCols() {
        return this.outputCols;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCols$_setter_$outputCols_$eq(StringArrayParam x$1) {
        this.outputCols = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Dataset<Row> surrogateDF() {
        return this.surrogateDF;
    }

    public ImputerModel setInputCol(String value) {
        return (ImputerModel)this.set(this.inputCol(), value);
    }

    public ImputerModel setOutputCol(String value) {
        return (ImputerModel)this.set(this.outputCol(), value);
    }

    public ImputerModel setInputCols(String[] value) {
        return (ImputerModel)this.set(this.inputCols(), value);
    }

    public ImputerModel setOutputCols(String[] value) {
        return (ImputerModel)this.set(this.outputCols(), value);
    }

    private Map<String, Object> surrogates$lzycompute() {
        ImputerModel imputerModel = this;
        synchronized (imputerModel) {
            if (!this.bitmap$trans$0) {
                Row row = (Row)this.surrogateDF().head();
                this.surrogates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String name = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)name, (Object)BoxesRunTime.boxToDouble((double)row.getDouble(index)));
                    return tuple22;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$trans$0 = true;
            }
        }
        return this.surrogates;
    }

    private Map<String, Object> surrogates() {
        return !this.bitmap$trans$0 ? this.surrogates$lzycompute() : this.surrogates;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        Tuple2<String[], String[]> tuple2 = this.getInOutCols();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] inputColumns = (String[])tuple2._1();
        String[] outputColumns = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)inputColumns, (Object)outputColumns);
        Tuple2 tuple23 = tuple22;
        String[] inputColumns2 = (String[])tuple23._1();
        String[] outputColumns2 = (String[])tuple23._2();
        Column[] newCols = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputColumns2)).map((Function1 & Serializable & scala.Serializable)inputCol -> {
            double surrogate = BoxesRunTime.unboxToDouble((Object)this.surrogates().apply(inputCol));
            DataType inputType = dataset.schema().apply(inputCol).dataType();
            Column ic = functions$.MODULE$.col(inputCol).cast((DataType)DoubleType$.MODULE$);
            return functions$.MODULE$.when(ic.isNull(), (Object)BoxesRunTime.boxToDouble((double)surrogate)).when(ic.$eq$eq$eq(this.$(this.missingValue())), (Object)BoxesRunTime.boxToDouble((double)surrogate)).otherwise((Object)ic).cast(inputType);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.withColumns((Seq)Predef$.MODULE$.wrapRefArray((Object[])outputColumns2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])newCols)).toDF();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    @Override
    public ImputerModel copy(ParamMap extra) {
        ImputerModel copied = new ImputerModel(this.uid(), this.surrogateDF());
        return (ImputerModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new ImputerModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(44).append("ImputerModel: uid=").append(this.uid()).append(", strategy=").append((Object)this.$(this.strategy())).append(", missingValue=").append(this.$(this.missingValue())).append(this.get(this.inputCols()).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(15).append(", numInputCols=").append(((String[])c).length).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(this.get(this.outputCols()).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(16).append(", numOutputCols=").append(((String[])c).length).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    public ImputerModel(String uid, Dataset<Row> surrogateDF) {
        this.uid = uid;
        this.surrogateDF = surrogateDF;
        HasInputCol.$init$(this);
        HasInputCols.$init$(this);
        HasOutputCol.$init$(this);
        HasOutputCols.$init$(this);
        HasRelativeError.$init$(this);
        ImputerParams.$init$(this);
        MLWritable.$init$(this);
    }

    public static class ImputerModelWriter
    extends MLWriter {
        private final ImputerModel instance;

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            String dataPath = new Path(path, "data").toString();
            this.instance.surrogateDF().repartition(1).write().parquet(dataPath);
        }

        public ImputerModelWriter(ImputerModel instance) {
            this.instance = instance;
        }
    }

    public static class ImputerReader
    extends MLReader<ImputerModel> {
        private final String className = ImputerModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public ImputerModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Dataset surrogateDF = this.sqlContext().read().parquet(dataPath);
            ImputerModel model = new ImputerModel(metadata.uid(), (Dataset<Row>)surrogateDF);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }
}

