/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.GBTClassifier;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.GBTClassifierWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class GBTClassifierWrapper$
implements MLReadable<GBTClassifierWrapper> {
    public static GBTClassifierWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new GBTClassifierWrapper$();
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public GBTClassifierWrapper fit(Dataset<Row> data, String formula, int maxDepth, int maxBins, int maxIter, double stepSize, int minInstancesPerNode, double minInfoGain, int checkpointInterval, String lossType, String seed, double subsamplingRate, int maxMemoryInMB, boolean cacheNodeIds, String handleInvalid) {
        RFormula rFormula = new RFormula().setFormula(formula).setForceIndexLabel(true).setHandleInvalid(handleInvalid);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        Tuple2<String[], String[]> tuple2 = RWrapperUtils$.MODULE$.getFeaturesAndLabels((RFormulaModel)rFormulaModel, data);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] features = (String[])tuple2._1();
        String[] labels = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)features, (Object)labels);
        Tuple2 tuple23 = tuple22;
        String[] features2 = (String[])tuple23._1();
        String[] labels2 = (String[])tuple23._2();
        GBTClassifier rfc = (GBTClassifier)((Predictor)((Predictor)new GBTClassifier().setMaxDepth(maxDepth).setMaxBins(maxBins).setMaxIter(maxIter).setStepSize(stepSize).setMinInstancesPerNode(minInstancesPerNode).setMinInfoGain(minInfoGain).setCheckpointInterval(checkpointInterval).setLossType(lossType).setSubsamplingRate(subsamplingRate).setMaxMemoryInMB(maxMemoryInMB).setCacheNodeIds(cacheNodeIds).setFeaturesCol(rFormula.getFeaturesCol())).setLabelCol(rFormula.getLabelCol())).setPredictionCol(this.PREDICTED_LABEL_INDEX_COL());
        Object object = seed != null && seed.length() > 0 ? rfc.setSeed(new StringOps(Predef$.MODULE$.augmentString(seed)).toLong()) : BoxedUnit.UNIT;
        IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels2);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, rfc, idxToStr})).fit((Dataset)data);
        return new GBTClassifierWrapper((PipelineModel)pipeline, formula, features2);
    }

    @Override
    public MLReader<GBTClassifierWrapper> read() {
        return new GBTClassifierWrapper.GBTClassifierWrapperReader();
    }

    @Override
    public GBTClassifierWrapper load(String path) {
        return (GBTClassifierWrapper)MLReadable.load$(this, path);
    }

    private GBTClassifierWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

