/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r5b\u0001B A\u0001-C\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t%\u0019\u0005\tq\u0002\u0011\t\u0011)A\u0005E\"A!\u0010\u0001BC\u0002\u0013\u00051\u0010\u0003\u0005\u0000\u0001\t\u0005\t\u0015!\u0003Q\u0011)\t\u0019\u0001\u0001BC\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\u000b\u0001\t\u0015\r\u0011\"\u0001\u0002\u0006!Q\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u0011\u0005u\u0001\u0001\"\u0001C\u0003?Aq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!Q\u00111\f\u0001\t\u0006\u0004%I!!\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003w\u0002A\u0011IA?\u0011\u001d\t9\r\u0001C!\u0003\u0013Dq!!8\u0001\t\u0003\ny\u000eC\u0004\u0002t\u0002!\t%!>\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002\u001d9!q\u0001!\t\u0002\t%aAB A\u0011\u0003\u0011Y\u0001C\u0004\u0002\u001e]!\tAa\b\t\u000f\t\u0005r\u0003\"\u0011\u0003$!9!QF\f\u0005B\t=ba\u0002B\u001c/\u00019\"\u0011\b\u0005\n\u0005\u000fZ\"\u0011!Q\u0001\nYCq!!\b\u001c\t\u0003\u0011IE\u0002\u0004\u0003Rm!%1\u000b\u0005\tuz\u0011)\u001a!C\u0001w\"AqP\bB\tB\u0003%\u0001\u000b\u0003\u0006\u0002\u0004y\u0011)\u001a!C\u0001\u0003\u000bA!\"!\u0005\u001f\u0005#\u0005\u000b\u0011BA\u0004\u0011)\t)B\bBK\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u00033q\"\u0011#Q\u0001\n\u0005\u001d\u0001bBA\u000f=\u0011\u0005!1\f\u0005\n\u0003;t\u0012\u0011!C\u0001\u0005OB\u0011Ba\u001c\u001f#\u0003%\tA!\u001d\t\u0013\t\u0015e$%A\u0005\u0002\t\u001d\u0005\"\u0003BF=E\u0005I\u0011\u0001BD\u0011%\u0011iIHA\u0001\n\u0003\u0012y\tC\u0005\u0003 z\t\t\u0011\"\u0001\u00024!I!\u0011\u0015\u0010\u0002\u0002\u0013\u0005!1\u0015\u0005\n\u0005Ss\u0012\u0011!C!\u0005WC\u0011B!/\u001f\u0003\u0003%\tAa/\t\u0013\t\u0015g$!A\u0005B\t\u001d\u0007\"CA\u0000=\u0005\u0005I\u0011\tBe\u0011%\u0011YMHA\u0001\n\u0003\u0012imB\u0005\u0003Rn\t\t\u0011#\u0003\u0003T\u001aI!\u0011K\u000e\u0002\u0002#%!Q\u001b\u0005\b\u0003;\u0019D\u0011\u0001Br\u0011%\typMA\u0001\n\u000b\u0012I\rC\u0005\u0003fN\n\t\u0011\"!\u0003h\"I!q^\u001a\u0002\u0002\u0013\u0005%\u0011\u001f\u0005\b\u0007\u0007YB\u0011KB\u0003\r\u0019\u0019ya\u0006\u0003\u0004\u0012!9\u0011QD\u001d\u0005\u0002\rM\u0001\"CB\fs\t\u0007I\u0011\u0002BH\u0011!\u0019I\"\u000fQ\u0001\n\tE\u0005b\u0002B\u0017s\u0011\u000531\u0004\u0005\n\u0007?9\u0012\u0011!C\u0005\u0007C\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2T!!\u0011\"\u0002\u0015I,wM]3tg&|gN\u0003\u0002D\t\u0006\u0011Q\u000e\u001c\u0006\u0003\u000b\u001a\u000bQa\u001d9be.T!a\u0012%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0015aA8sO\u000e\u00011\u0003\u0002\u0001M/j\u0003B!\u0014(Q-6\t\u0001)\u0003\u0002P\u0001\ny!+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002R)6\t!K\u0003\u0002T\u0005\u00061A.\u001b8bY\u001eL!!\u0016*\u0003\rY+7\r^8s!\ti\u0005\u0001\u0005\u0002N1&\u0011\u0011\f\u0011\u0002\u001c\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005msV\"\u0001/\u000b\u0005u\u0013\u0015\u0001B;uS2L!a\u0018/\u0003\u00155cuK]5uC\ndW-A\u0002vS\u0012,\u0012A\u0019\t\u0003G2t!\u0001\u001a6\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dT\u0015A\u0002\u001fs_>$hHC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tY\u0007.\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6iQ\r\t\u0001O\u001e\t\u0003cRl\u0011A\u001d\u0006\u0003g\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\t)(OA\u0003TS:\u001cW-I\u0001x\u0003\u0015\tdF\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t\u0001h/\u0001\u0007d_\u00164g-[2jK:$8/F\u0001QQ\r\u0019\u0001/`\u0011\u0002}\u0006)!G\f\u0019/a\u0005i1m\\3gM&\u001c\u0017.\u001a8ug\u0002B3\u0001\u00029~\u0003%Ig\u000e^3sG\u0016\u0004H/\u0006\u0002\u0002\bA!\u0011\u0011BA\u0006\u001b\u0005A\u0017bAA\u0007Q\n1Ai\\;cY\u0016D3!\u00029w\u0003)Ig\u000e^3sG\u0016\u0004H\u000f\t\u0015\u0004\rA4\u0018!B:dC2,\u0007fA\u0004qm\u000611oY1mK\u0002B3\u0001\u00039w\u0003\u0019a\u0014N\\5u}QIa+!\t\u0002&\u0005%\u0012Q\u0006\u0005\u0006A&\u0001\rA\u0019\u0015\u0005\u0003C\u0001h\u000fC\u0003{\u0013\u0001\u0007\u0001\u000b\u000b\u0003\u0002&Al\bbBA\u0002\u0013\u0001\u0007\u0011q\u0001\u0015\u0005\u0003S\u0001h\u000fC\u0004\u0002\u0016%\u0001\r!a\u0002)\t\u00055\u0002O^\u0001\f]Vlg)Z1ukJ,7/\u0006\u0002\u00026A!\u0011\u0011BA\u001c\u0013\r\tI\u0004\u001b\u0002\u0004\u0013:$\b\u0006\u0002\u0006q\u0003{\t#!a\u0010\u0002\u000bMr\u0003G\f\u0019\u00021M,G/U;b]RLG.\u001a)s_\n\f'-\u001b7ji&,7\u000f\u0006\u0003\u0002F\u0005\u001dS\"\u0001\u0001\t\u000f\u0005%3\u00021\u0001\u0002L\u0005)a/\u00197vKB1\u0011\u0011BA'\u0003\u000fI1!a\u0014i\u0005\u0015\t%O]1zQ\rY\u0001O^\u0001\u0010g\u0016$\u0018+^1oi&dWm]\"pYR!\u0011QIA,\u0011\u0019\tI\u0005\u0004a\u0001E\"\u001aA\u0002\u001d<\u0002\u0015}\u000bX/\u00198uS2,7/\u0006\u0002\u0002`A1\u0011\u0011BA'\u0003\u0017\n\u0001\u0003\\1nE\u0012\f''U;b]RLG.Z:\u0015\u0007A\u000b)\u0007C\u0004\u0002h9\u0001\r!a\u0002\u0002\r1\fWN\u00193b\u0003A\u0001(/\u001a3jGR\fV/\u00198uS2,7\u000fF\u0002Q\u0003[Ba!a\u001c\u0010\u0001\u0004\u0001\u0016\u0001\u00034fCR,(/Z:)\u0007=\u0001X0A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005\u001d\u0011q\u000f\u0005\u0007\u0003_\u0002\u0002\u0019\u0001))\u0007A\u0001X0A\u0005ue\u0006t7OZ8s[R!\u0011qPAQ!\u0011\t\t)a'\u000f\t\u0005\r\u0015Q\u0013\b\u0005\u0003\u000b\u000b\tJ\u0004\u0003\u0002\b\u0006=e\u0002BAE\u0003\u001bs1!ZAF\u0013\u0005I\u0015BA$I\u0013\t)e)C\u0002\u0002\u0014\u0012\u000b1a]9m\u0013\u0011\t9*!'\u0002\u000fA\f7m[1hK*\u0019\u00111\u0013#\n\t\u0005u\u0015q\u0014\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!a&\u0002\u001a\"9\u00111U\tA\u0002\u0005\u0015\u0016a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003O\u000b\u0019\f\u0005\u0004\u0002*\u0006-\u0016qV\u0007\u0003\u00033KA!!,\u0002\u001a\n9A)\u0019;bg\u0016$\b\u0003BAY\u0003gc\u0001\u0001\u0002\u0007\u00026\u0006\u0005\u0016\u0011!A\u0001\u0006\u0003\t9LA\u0002`II\nB!!/\u0002@B!\u0011\u0011BA^\u0013\r\ti\f\u001b\u0002\b\u001d>$\b.\u001b8h!\u0011\tI!!1\n\u0007\u0005\r\u0007NA\u0002B]fD3!\u00059~\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BAf\u0003/\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0005\u0003#\fI*A\u0003usB,7/\u0003\u0003\u0002V\u0006='AC*ueV\u001cG\u000fV=qK\"9\u0011\u0011\u001c\nA\u0002\u0005-\u0017AB:dQ\u0016l\u0017\rK\u0002\u0013aZ\fAaY8qsR\u0019a+!9\t\u000f\u0005\r8\u00031\u0001\u0002f\u0006)Q\r\u001f;sCB!\u0011q]Aw\u001b\t\tIOC\u0002\u0002l\n\u000bQ\u0001]1sC6LA!a<\u0002j\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u0014aZ\fQa\u001e:ji\u0016,\"!a>\u0011\u0007m\u000bI0C\u0002\u0002|r\u0013\u0001\"\u0014'Xe&$XM\u001d\u0015\u0004)A4\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\tDC!\u00069\u0002>!\u001a\u0001\u0001\u001d<\u00025\u00053EkU;sm&4\u0018\r\u001c*fOJ,7o]5p]6{G-\u001a7\u0011\u00055;2cB\f\u0003\u000e\tM!\u0011\u0004\t\u0005\u0003\u0013\u0011y!C\u0002\u0003\u0012!\u0014a!\u00118z%\u00164\u0007\u0003B.\u0003\u0016YK1Aa\u0006]\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u0003\u0013\u0011Y\"C\u0002\u0003\u001e!\u0014AbU3sS\u0006d\u0017N_1cY\u0016$\"A!\u0003\u0002\tI,\u0017\rZ\u000b\u0003\u0005K\u0001Ba\u0017B\u0014-&\u0019!\u0011\u0006/\u0003\u00115c%+Z1eKJD3!\u00079w\u0003\u0011aw.\u00193\u0015\u0007Y\u0013\t\u0004\u0003\u0004\u00034i\u0001\rAY\u0001\u0005a\u0006$\b\u000eK\u0002\u001baZ\u0014\u0001%\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2<&/\u001b;feN)1$a>\u0003<A!!Q\bB\"\u001b\t\u0011yDC\u0002\u0003B\u0011\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0005\u000b\u0012yDA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016$BAa\u0013\u0003PA\u0019!QJ\u000e\u000e\u0003]AaAa\u0012\u001e\u0001\u00041&\u0001\u0002#bi\u0006\u001crA\bB\u0007\u0005+\u0012I\u0002\u0005\u0003\u0002\n\t]\u0013b\u0001B-Q\n9\u0001K]8ek\u000e$H\u0003\u0003B/\u0005C\u0012\u0019G!\u001a\u0011\u0007\t}c$D\u0001\u001c\u0011\u0015QX\u00051\u0001Q\u0011\u001d\t\u0019!\na\u0001\u0003\u000fAq!!\u0006&\u0001\u0004\t9\u0001\u0006\u0005\u0003^\t%$1\u000eB7\u0011\u001dQh\u0005%AA\u0002AC\u0011\"a\u0001'!\u0003\u0005\r!a\u0002\t\u0013\u0005Ua\u0005%AA\u0002\u0005\u001d\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005gR3\u0001\u0015B;W\t\u00119\b\u0005\u0003\u0003z\t\u0005UB\u0001B>\u0015\u0011\u0011iHa \u0002\u0013Ut7\r[3dW\u0016$'BA:i\u0013\u0011\u0011\u0019Ia\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t%%\u0006BA\u0004\u0005k\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005#\u0003BAa%\u0003\u001e6\u0011!Q\u0013\u0006\u0005\u0005/\u0013I*\u0001\u0003mC:<'B\u0001BN\u0003\u0011Q\u0017M^1\n\u00075\u0014)*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}&Q\u0015\u0005\n\u0005Oc\u0013\u0011!a\u0001\u0003k\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BW!\u0019\u0011yK!.\u0002@6\u0011!\u0011\u0017\u0006\u0004\u0005gC\u0017AC2pY2,7\r^5p]&!!q\u0017BY\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tu&1\u0019\t\u0005\u0003\u0013\u0011y,C\u0002\u0003B\"\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003(:\n\t\u00111\u0001\u0002@\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00026Q\u0011!\u0011S\u0001\u0007KF,\u0018\r\\:\u0015\t\tu&q\u001a\u0005\n\u0005O\u000b\u0014\u0011!a\u0001\u0003\u007f\u000bA\u0001R1uCB\u0019!qL\u001a\u0014\u000bM\u00129N!\u0007\u0011\u0017\te'q\u001c)\u0002\b\u0005\u001d!QL\u0007\u0003\u00057T1A!8i\u0003\u001d\u0011XO\u001c;j[\u0016LAA!9\u0003\\\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\tM\u0017!B1qa2LH\u0003\u0003B/\u0005S\u0014YO!<\t\u000bi4\u0004\u0019\u0001)\t\u000f\u0005\ra\u00071\u0001\u0002\b!9\u0011Q\u0003\u001cA\u0002\u0005\u001d\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005g\u0014y\u0010\u0005\u0004\u0002\n\tU(\u0011`\u0005\u0004\u0005oD'AB(qi&|g\u000eE\u0005\u0002\n\tm\b+a\u0002\u0002\b%\u0019!Q 5\u0003\rQ+\b\u000f\\34\u0011%\u0019\taNA\u0001\u0002\u0004\u0011i&A\u0002yIA\n\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0007\u000f\u0019i\u0001\u0005\u0003\u0002\n\r%\u0011bAB\u0006Q\n!QK\\5u\u0011\u0019\u0011\u0019\u0004\u000fa\u0001E\n\u0001\u0013I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\rI$Q\u0005\u000b\u0003\u0007+\u00012A!\u0014:\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\"2AVB\u000f\u0011\u0019\u0011\u0019$\u0010a\u0001E\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019\u0019\u0003\u0005\u0003\u0003\u0014\u000e\u0015\u0012\u0002BB\u0014\u0005+\u0013aa\u00142kK\u000e$\bfA\fqm\"\u001aa\u0003\u001d<")
public class AFTSurvivalRegressionModel
extends RegressionModel<Vector, AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private double[][] _quantiles;
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private volatile boolean bitmap$0;

    public static AFTSurvivalRegressionModel load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.coefficients().size();
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        this.set(this.quantileProbabilities(), value);
        this._quantiles()[0] = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)q -> scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) * this.scale()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return this;
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    private double[][] _quantiles$lzycompute() {
        AFTSurvivalRegressionModel aFTSurvivalRegressionModel = this;
        synchronized (aFTSurvivalRegressionModel) {
            if (!this.bitmap$0) {
                this._quantiles = (double[][])((Object[])new double[][]{(double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)q -> scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) * this.scale()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))});
                this.bitmap$0 = true;
            }
        }
        return this._quantiles;
    }

    private double[][] _quantiles() {
        return !this.bitmap$0 ? this._quantiles$lzycompute() : this._quantiles;
    }

    private Vector lambda2Quantiles(double lambda) {
        double[] quantiles = (double[])this._quantiles()[0].clone();
        int i = 0;
        while (i < quantiles.length) {
            int n = i++;
            quantiles[n] = quantiles[n] * lambda;
        }
        return Vectors$.MODULE$.dense(quantiles);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = this.predict(features);
        return this.lambda2Quantiles(lambda);
    }

    @Override
    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)Seq$.MODULE$.empty();
        Seq predictionColumns = (Seq)Seq$.MODULE$.empty();
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            Column predCol = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predCol.as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (this.hasQuantilesCol()) {
            Column column;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)lambda -> this.lambda2Quantiles(BoxesRunTime.unboxToDouble((Object)lambda)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)predictionColumns.head()}));
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column quanCol = column;
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.quantilesCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)quanCol.as(this.$(this.quantilesCol()), outputSchema.apply(this.$(this.quantilesCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append(this.uid()).append(": AFTSurvivalRegressionModel.transform() does nothing").append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = this.validateAndTransformSchema(schema, false);
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.predictionCol()));
            }
            if (!this.isDefined(this.quantilesCol()) || !new StringOps(Predef$.MODULE$.augmentString(this.$(this.quantilesCol()))).nonEmpty()) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.quantilesCol()), this.$(this.quantileProbabilities()).length);
        }
        return var2_2;
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(46).append("AFTSurvivalRegressionModel: uid=").append(this.uid()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
    }

    public static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            double d;
            Vector vector;
            Object scale;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().parquet(dataPath);
                    row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object coefficients = ((SeqLike)some.get()).apply(0);
                    Object intercept = ((SeqLike)some.get()).apply(1);
                    scale = ((SeqLike)some.get()).apply(2);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (!(intercept instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (scale instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
            Tuple3 tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
            Tuple3 tuple32 = tuple3;
            Vector coefficients = (Vector)tuple32._1();
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;
        private final AFTSurvivalRegressionModel instance;

        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                }
            }
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

