/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u000f\u001f\u0001%B\u0001B\u0012\u0001\u0003\u0006\u0004%\te\u0012\u0005\n/\u0002\u0011\t\u0011)A\u0005\u0011bC\u0001B\u0017\u0001\u0003\u0006\u0004%\te\u0017\u0005\nA\u0002\u0011\t\u0011)A\u00059\u0006D\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005K\"AQ\u000e\u0001BC\u0002\u0013\u0005A\r\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003f\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001di\bA1A\u0005\n\u0011DaA \u0001!\u0002\u0013)\u0007\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007Aa!\u001d\u0001\u0005\u0002\u0005-\u0001\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0011%\ti\u0002\u0001a\u0001\n\u0013\ty\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0015BA\f\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u000e\u0001\t\u0003\t)\u0002C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0015\u0002D!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA>\u0001\u0011\u0005\u0013QP\u0004\b\u0003\u000bs\u0002\u0012AAD\r\u0019ib\u0004#\u0001\u0002\n\"1\u0011/\u0007C\u0001\u0003/Cq!!'\u001a\t\u0003\nY\nC\u0005\u0002$f\t\t\u0011\"\u0003\u0002&\n9Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003?\u0001\nab\u00197bgNLg-[2bi&|gN\u0003\u0002\"E\u0005)Q\u000e\u001c7jE*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001Q\u0003\u0007\u000e\u001eA!\tYc&D\u0001-\u0015\ti\u0003%\u0001\u0006sK\u001e\u0014Xm]:j_:L!a\f\u0017\u0003-\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'/T8eK2\u0004\"!\r\u001a\u000e\u0003yI!a\r\u0010\u0003'\rc\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u0002\u0013\u0001B;uS2L!a\u0010\u001f\u0003\u0011M\u000bg/Z1cY\u0016\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u0011\u0002\tAlW\u000e\\\u0005\u0003\u000b\n\u0013a\u0002U'N\u0019\u0016C\bo\u001c:uC\ndW-A\u0004xK&<\u0007\u000e^:\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u0011\u0002\r1Lg.\u00197h\u0013\ti%J\u0001\u0004WK\u000e$xN\u001d\u0015\u0004\u0003=+\u0006C\u0001)T\u001b\u0005\t&B\u0001*#\u0003)\tgN\\8uCRLwN\\\u0005\u0003)F\u0013QaU5oG\u0016\f\u0013AV\u0001\u0006c9\u0002d\u0006M\u0001\to\u0016Lw\r\u001b;tA%\u0011aI\f\u0015\u0004\u0005=+\u0016!C5oi\u0016\u00148-\u001a9u+\u0005a\u0006CA\u001b^\u0013\tqfG\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0007=+\u0016AC5oi\u0016\u00148-\u001a9uA%\u0011!L\f\u0015\u0004\t=+\u0016a\u00038v[\u001a+\u0017\r^;sKN,\u0012!\u001a\t\u0003k\u0019L!a\u001a\u001c\u0003\u0007%sG\u000fK\u0002\u0006\u001f&\f\u0013A[\u0001\u0006c9\u001ad\u0006M\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0015\u0004\r=K\u0017A\u00038v[\u000ec\u0017m]:fg\"\u001aqaT5\u0002\u00179,Xn\u00117bgN,7\u000f\t\u0015\u0004\u0011=K\u0017A\u0002\u001fj]&$h\bF\u0003tiZD(\u0010\u0005\u00022\u0001!)a)\u0003a\u0001\u0011\"\u001aAoT+\t\u000biK\u0001\u0019\u0001/)\u0007Y|U\u000bC\u0003d\u0013\u0001\u0007Q\rK\u0002y\u001f&DQ!\\\u0005A\u0002\u0015D3A_(jQ\rIq*[\u0001\u0011I\u0006$\u0018mV5uQ\nK\u0017m]*ju\u0016\f\u0011\u0003Z1uC^KG\u000f\u001b\"jCN\u001c\u0016N_3!\u000319X-[4iiN\f%O]1z+\t\t\u0019\u0001\u0005\u00036\u0003\u000ba\u0016bAA\u0004m\t)\u0011I\u001d:bs\u0006iq/Z5hQR\u001c\u0018I\u001d:bs\u0002\"Ra]A\u0007\u0003\u001fAQA\u0012\bA\u0002!CQA\u0017\bA\u0002qC3AD(V\u0003%!\bN]3tQ>dG-\u0006\u0002\u0002\u0018A!Q'!\u0007]\u0013\r\tYB\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001bQD'/Z:i_2$w\fJ3r)\u0011\t\t#a\n\u0011\u0007U\n\u0019#C\u0002\u0002&Y\u0012A!\u00168ji\"I\u0011\u0011\u0006\t\u0002\u0002\u0003\u0007\u0011qC\u0001\u0004q\u0012\n\u0014A\u0003;ie\u0016\u001c\bn\u001c7eA\u0005a1/\u001a;UQJ,7\u000f[8mIR!\u0011\u0011GA\u001a\u001b\u0005\u0001\u0001BBA\n%\u0001\u0007A\fK\u0002\u0013\u001fV\u000bAbZ3u)\"\u0014Xm\u001d5pY\u0012D3aE(j\u00039\u0019G.Z1s)\"\u0014Xm\u001d5pY\u0012$\"!!\r)\u0007QyU+\u0001\u0007qe\u0016$\u0017n\u0019;Q_&tG\u000fF\u0004]\u0003\u000b\nI%!\u0014\t\r\u0005\u001dS\u00031\u0001I\u0003)!\u0017\r^1NCR\u0014\u0018\u000e\u001f\u0005\u0007\u0003\u0017*\u0002\u0019\u0001%\u0002\u0019],\u0017n\u001a5u\u001b\u0006$(/\u001b=\t\u000bi+\u0002\u0019\u0001/\u0002\tM\fg/\u001a\u000b\u0007\u0003C\t\u0019&a\u0018\t\u000f\u0005Uc\u00031\u0001\u0002X\u0005\u00111o\u0019\t\u0005\u00033\nY&D\u0001#\u0013\r\tiF\t\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003C2\u0002\u0019AA2\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005\u0015\u00141\u000f\b\u0005\u0003O\ny\u0007E\u0002\u0002jYj!!a\u001b\u000b\u0007\u00055\u0004&\u0001\u0004=e>|GOP\u0005\u0004\u0003c2\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0005]$AB*ue&twMC\u0002\u0002rYB3AF(j\u0003!!xn\u0015;sS:<GCAA2Q\u0011\u0001q*!!\"\u0005\u0005\r\u0015!\u0002\u0019/q9\u0002\u0014a\u0006'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t\t\u0014d\u0005\u0004\u001a\u0003\u0017\u000b\t\n\u000e\t\u0004k\u00055\u0015bAAHm\t1\u0011I\\=SK\u001a\u0004BaOAJg&\u0019\u0011Q\u0013\u001f\u0003\r1{\u0017\rZ3s)\t\t9)\u0001\u0003m_\u0006$G#B:\u0002\u001e\u0006}\u0005bBA+7\u0001\u0007\u0011q\u000b\u0005\b\u0003CZ\u0002\u0019AA2Q\rYr*[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016\u0001\u00027b]\u001eT!!!-\u0002\t)\fg/Y\u0005\u0005\u0003k\u000bYK\u0001\u0004PE*,7\r\u001e\u0015\u00043=K\u0007f\u0001\rPS\u0002")
public class LogisticRegressionModel
extends GeneralizedLinearModel
implements ClassificationModel,
Saveable,
PMMLExportable {
    private final int numFeatures;
    private final int numClasses;
    private final int dataWithBiasSize;
    private final double[] weightsArray;
    private Option<Object> threshold;

    public static LogisticRegressionModel load(SparkContext sparkContext, String string) {
        return LogisticRegressionModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public void toPMML(String localPath) {
        PMMLExportable.toPMML$((PMMLExportable)this, localPath);
    }

    @Override
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable.toPMML$(this, sc, path);
    }

    @Override
    public void toPMML(OutputStream outputStream) {
        PMMLExportable.toPMML$((PMMLExportable)this, outputStream);
    }

    @Override
    public String toPMML() {
        return PMMLExportable.toPMML$(this);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel.predict$(this, testData);
    }

    @Override
    public Vector weights() {
        return super.weights();
    }

    @Override
    public double intercept() {
        return super.intercept();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public int numClasses() {
        return this.numClasses;
    }

    private int dataWithBiasSize() {
        return this.dataWithBiasSize;
    }

    private double[] weightsArray() {
        return this.weightsArray;
    }

    private Option<Object> threshold() {
        return this.threshold;
    }

    private void threshold_$eq(Option<Object> x$1) {
        this.threshold = x$1;
    }

    public LogisticRegressionModel setThreshold(double threshold) {
        this.threshold_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)threshold)));
        return this;
    }

    public Option<Object> getThreshold() {
        return this.threshold();
    }

    public LogisticRegressionModel clearThreshold() {
        this.threshold_$eq((Option<Object>)None$.MODULE$);
        return this;
    }

    @Override
    public double predictPoint(Vector dataMatrix, Vector weightMatrix, double intercept) {
        double d;
        Predef$.MODULE$.require(dataMatrix.size() == this.numFeatures());
        if (this.numClasses() == 2) {
            double d2;
            double margin = BLAS$.MODULE$.dot(weightMatrix, dataMatrix) + intercept;
            double score = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            Option<Object> option = this.threshold();
            if (option instanceof Some) {
                Some some = (Some)option;
                double t = BoxesRunTime.unboxToDouble((Object)some.value());
                d2 = score > t ? 1.0 : 0.0;
            } else if (None$.MODULE$.equals(option)) {
                d2 = score;
            } else {
                throw new MatchError(option);
            }
            d = d2;
        } else {
            IntRef bestClass = IntRef.create((int)0);
            DoubleRef maxMargin = DoubleRef.create((double)0.0);
            boolean withBias = dataMatrix.size() + 1 == this.dataWithBiasSize();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numClasses() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block1: {
                    DoubleRef margin = DoubleRef.create((double)0.0);
                    dataMatrix.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> margin$1.elem += value * this.weightsArray()[i * this.dataWithBiasSize() + index]);
                    if (withBias) {
                        margin.elem += this.weightsArray()[i * this.dataWithBiasSize() + dataMatrix.size()];
                    }
                    if (!(margin.elem > maxMargin$1.elem)) break block1;
                    maxMargin$1.elem = margin.elem;
                    bestClass$1.elem = i + 1;
                }
            });
            d = bestClass.elem;
        }
        return d;
    }

    @Override
    public void save(SparkContext sc, String path) {
        GLMClassificationModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getClass().getName(), this.numFeatures(), this.numClasses(), this.weights(), this.intercept(), this.threshold());
    }

    @Override
    public String toString() {
        return new StringBuilder(29).append(super.toString()).append(", numClasses = ").append(this.numClasses()).append(", threshold = ").append(this.threshold().getOrElse((Function0 & Serializable & scala.Serializable)() -> "None")).toString();
    }

    public LogisticRegressionModel(Vector weights, double intercept, int numFeatures, int numClasses) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        super(weights, intercept);
        ClassificationModel.$init$(this);
        PMMLExportable.$init$(this);
        if (numClasses == 2) {
            Predef$.MODULE$.require(weights.size() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("LogisticRegressionModel with numClasses = 2 was given non-matching values:").append(" numFeatures = ").append(this.numFeatures()).append(", but weights.size = ").append(this.weights().size()).toString());
        } else {
            int weightsSizeWithoutIntercept = (numClasses - 1) * numFeatures;
            int weightsSizeWithIntercept = (numClasses - 1) * (numFeatures + 1);
            Predef$.MODULE$.require(weights.size() == weightsSizeWithoutIntercept || weights.size() == weightsSizeWithIntercept, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("LogisticRegressionModel.load with numClasses = ").append(this.numClasses()).append(" and numFeatures = ").append(this.numFeatures()).append(" expected weights of length ").append(weightsSizeWithoutIntercept).append(" (without intercept)").append(" or ").append(weightsSizeWithIntercept).append(" (with intercept),").append(" but was given weights of length ").append(this.weights().size()).toString());
        }
        this.dataWithBiasSize = weights.size() / (numClasses - 1);
        Vector vector = weights;
        if (!(vector instanceof DenseVector)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("weights only supports dense vector but got type ").append(weights.getClass()).append(".").toString());
        }
        DenseVector denseVector = (DenseVector)vector;
        double[] dArray = denseVector.values();
        this.weightsArray = dArray;
        this.threshold = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
    }

    public LogisticRegressionModel(Vector weights, double intercept) {
        this(weights, intercept, weights.size(), 2);
    }
}

