/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.mllib.fpm.FPTree;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t%d\u0001\u0002\u000f\u001e\u0001!B\u0001\u0002\u000f\u0001\u0003\u0002\u0004%I!\u000f\u0005\t{\u0001\u0011\t\u0019!C\u0005}!AA\t\u0001B\u0001B\u0003&!\b\u0003\u0005F\u0001\t\u0005\r\u0011\"\u0003G\u0011!Q\u0005A!a\u0001\n\u0013Y\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0015B$\t\r9\u0003A\u0011A\u0011P\u0011\u0015q\u0005\u0001\"\u0001U\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u00159\u0007\u0001\"\u0001i\u0011\u00199\u0007\u0001\"\u0001\u0002\u001c!9\u0011q\n\u0001\u0005\n\u0005E\u0003bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u000f\u001d\ti+\bE\u0001\u0003_3a\u0001H\u000f\t\u0002\u0005E\u0006B\u0002(\u0012\t\u0003\t\u0019L\u0002\u0004\u00026F\u0001\u0011q\u0017\u0005\u000b\u0003w\u001b\"Q1A\u0005\u0002\u0005u\u0006BCAd'\t\u0005\t\u0015!\u0003\u0002@\"Q\u00111Z\n\u0003\u0006\u0004%\t!!4\t\u0015\u0005E7C!A!\u0002\u0013\t\u0019\u0007\u0003\u0004O'\u0011\u0005\u0011Q\u001b\u0005\b\u0003K\u001cB\u0011AAt\u0011\u001d\t9p\u0005C!\u0003sD\u0011B!\u0004\u0012\u0003\u0003%IAa\u0004\u0003\u0011\u0019\u0003vI]8xi\"T!AH\u0010\u0002\u0007\u0019\u0004XN\u0003\u0002!C\u0005)Q\u000e\u001c7jE*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Is&\u000e\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\n\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005Q\n$a\u0002'pO\u001eLgn\u001a\t\u0003UYJ!aN\u0016\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u00155LgnU;qa>\u0014H/F\u0001;!\tQ3(\u0003\u0002=W\t1Ai\\;cY\u0016\fa\"\\5o'V\u0004\bo\u001c:u?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011!\u0006Q\u0005\u0003\u0003.\u0012A!\u00168ji\"91IAA\u0001\u0002\u0004Q\u0014a\u0001=%c\u0005YQ.\u001b8TkB\u0004xN\u001d;!\u00035qW/\u001c)beRLG/[8ogV\tq\t\u0005\u0002+\u0011&\u0011\u0011j\u000b\u0002\u0004\u0013:$\u0018!\u00058v[B\u000b'\u000f^5uS>t7o\u0018\u0013fcR\u0011q\b\u0014\u0005\b\u0007\u0016\t\t\u00111\u0001H\u00039qW/\u001c)beRLG/[8og\u0002\na\u0001P5oSRtDc\u0001)S'B\u0011\u0011\u000bA\u0007\u0002;!)\u0001h\u0002a\u0001u!)Qi\u0002a\u0001\u000fR\t\u0001\u000bK\u0002\t-r\u0003\"a\u0016.\u000e\u0003aS!!W\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\\1\n)1+\u001b8dK\u0006\nQ,A\u00032]Mr\u0003'A\u0007tKRl\u0015N\\*vaB|'\u000f\u001e\u000b\u0003A\u0006l\u0011\u0001\u0001\u0005\u0006q%\u0001\rA\u000f\u0015\u0004\u0013Yc\u0016\u0001E:fi:+X\u000eU1si&$\u0018n\u001c8t)\t\u0001W\rC\u0003F\u0015\u0001\u0007q\tK\u0002\u000b-r\u000b1A];o+\tI\u0007\u000fF\u0002k\u0003\u0007!\"a[=\u0011\u0007Ecg.\u0003\u0002n;\tia\tU$s_^$\b.T8eK2\u0004\"a\u001c9\r\u0001\u0011)\u0011o\u0003b\u0001e\n!\u0011\n^3n#\t\u0019h\u000f\u0005\u0002+i&\u0011Qo\u000b\u0002\b\u001d>$\b.\u001b8h!\tQs/\u0003\u0002yW\t\u0019\u0011I\\=\t\u000fi\\\u0011\u0011!a\u0002w\u0006QQM^5eK:\u001cW\r\n\u001b\u0011\u0007q|h.D\u0001~\u0015\tq8&A\u0004sK\u001adWm\u0019;\n\u0007\u0005\u0005QP\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u001d\t)a\u0003a\u0001\u0003\u000f\tA\u0001Z1uCB1\u0011\u0011BA\b\u0003'i!!a\u0003\u000b\u0007\u00055\u0011%A\u0002sI\u0012LA!!\u0005\u0002\f\t\u0019!\u000b\u0012#\u0011\t)\n)B\\\u0005\u0004\u0003/Y#!B!se\u0006L\bfA\u0006W9V1\u0011QDA\u0012\u0003s!B!a\b\u0002&A!\u0011\u000b\\A\u0011!\ry\u00171\u0005\u0003\u0006c2\u0011\rA\u001d\u0005\b\u0003\u000ba\u0001\u0019AA\u0014!\u0019\tI#a\r\u000285\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0003kCZ\f'bAA\u0019C\u0005\u0019\u0011\r]5\n\t\u0005U\u00121\u0006\u0002\b\u0015\u00064\u0018M\u0015#E!\ry\u0017\u0011\b\u0003\b\u0003wa!\u0019AA\u001f\u0005\u0019\u0011\u0015m]6fiF\u00191/a\u0010\u0011\r\u0005\u0005\u0013\u0011JA\u0011\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013\u0001\u00027b]\u001eT!!!\f\n\t\u0005-\u00131\t\u0002\t\u0013R,'/\u00192mK\"\u001aAB\u0016/\u0002\u0019\u001d,gN\u0012:fc&#X-\\:\u0016\t\u0005M\u0013\u0011\r\u000b\t\u0003+\ny'!\u001e\u0002zQ!\u0011qKA5!\u0015Q\u0013QCA-!\u001dQ\u00131LA0\u0003GJ1!!\u0018,\u0005\u0019!V\u000f\u001d7feA\u0019q.!\u0019\u0005\u000bEl!\u0019\u0001:\u0011\u0007)\n)'C\u0002\u0002h-\u0012A\u0001T8oO\"I\u00111N\u0007\u0002\u0002\u0003\u000f\u0011QN\u0001\u000bKZLG-\u001a8dK\u0012*\u0004\u0003\u0002?\u0000\u0003?Bq!!\u0002\u000e\u0001\u0004\t\t\b\u0005\u0004\u0002\n\u0005=\u00111\u000f\t\u0006U\u0005U\u0011q\f\u0005\b\u0003oj\u0001\u0019AA2\u0003!i\u0017N\\\"pk:$\bbBA>\u001b\u0001\u0007\u0011QP\u0001\fa\u0006\u0014H/\u001b;j_:,'\u000f\u0005\u0003\u0002\u0000\u0005\u0005U\"A\u0011\n\u0007\u0005\r\u0015EA\u0006QCJ$\u0018\u000e^5p]\u0016\u0014\u0018aD4f]\u001a\u0013X-]%uK6\u001cX\r^:\u0016\t\u0005%%Q\u0004\u000b\u000b\u0003\u0017\u0013)Ca\u000b\u0003.\tEB\u0003BAG\u0005?\u0001b!!\u0003\u0002\u0010\u0005=\u0005#BAI'\tmabAAJ!9!\u0011QSAV\u001d\u0011\t9*!+\u000f\t\u0005e\u0015q\u0015\b\u0005\u00037\u000b)K\u0004\u0003\u0002\u001e\u0006\rVBAAP\u0015\r\t\tkJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019J!\u0001J\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\tqr$\u0001\u0005G!\u001e\u0013xn\u001e;i!\t\t\u0016cE\u0002\u0012SU\"\"!a,\u0003\u0017\u0019\u0013X-]%uK6\u001cX\r^\u000b\u0005\u0003s\u000b\u0019mE\u0002\u0014SU\nQ!\u001b;f[N,\"!a0\u0011\u000b)\n)\"!1\u0011\u0007=\f\u0019\rB\u0003r'\t\u0007!\u000fK\u0002\u0015-r\u000ba!\u001b;f[N\u0004\u0003fA\u000bW9\u0006!aM]3r+\t\t\u0019\u0007K\u0002\u0017-r\u000bQA\u001a:fc\u0002B3a\u0006,])\u0019\t9.a7\u0002`B)\u0011\u0011\\\n\u0002B6\t\u0011\u0003C\u0004\u0002<b\u0001\r!a0)\t\u0005mg\u000b\u0018\u0005\b\u0003\u0017D\u0002\u0019AA2Q\u0011\tyN\u0016/)\u0007a1F,A\u0005kCZ\f\u0017\n^3ngV\u0011\u0011\u0011\u001e\t\u0007\u0003W\f\t0!1\u000e\u0005\u00055(\u0002BAx\u0003\u000f\nA!\u001e;jY&!\u00111_Aw\u0005\u0011a\u0015n\u001d;)\u0007e1F,\u0001\u0005u_N#(/\u001b8h)\t\tY\u0010\u0005\u0003\u0002~\n\u0015a\u0002BA\u0000\u0005\u0003\u00012!!(,\u0013\r\u0011\u0019aK\u0001\u0007!J,G-\u001a4\n\t\t\u001d!\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\r1\u0006K\u0002\u0014-r\u000b1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0003\t\u0005\u0003\u0003\u0012\u0019\"\u0003\u0003\u0003\u0016\u0005\r#AB(cU\u0016\u001cG\u000fK\u0002\u0012-rC3\u0001\u0005,]!\ry'Q\u0004\u0003\u0006c:\u0011\rA\u001d\u0005\n\u0005Cq\u0011\u0011!a\u0002\u0005G\t!\"\u001a<jI\u0016t7-\u001a\u00137!\u0011axPa\u0007\t\u000f\u0005\u0015a\u00021\u0001\u0003(A1\u0011\u0011BA\b\u0005S\u0001RAKA\u000b\u00057Aq!a\u001e\u000f\u0001\u0004\t\u0019\u0007C\u0004\u000309\u0001\rA!\u000b\u0002\u0013\u0019\u0014X-]%uK6\u001c\bbBA>\u001d\u0001\u0007\u0011QP\u0001\u0014O\u0016t7i\u001c8e)J\fgn]1di&|gn]\u000b\u0005\u0005o\u0011)\u0006\u0006\u0005\u0003:\t]#Q\fB3)\u0011\u0011YD!\u0014\u0011\u000f\tu\"qI$\u0003L5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%A\u0004nkR\f'\r\\3\u000b\u0007\t\u00153&\u0001\u0006d_2dWm\u0019;j_:LAA!\u0013\u0003@\t\u0019Q*\u00199\u0011\t)\n)b\u0012\u0005\n\u0005\u001fz\u0011\u0011!a\u0002\u0005#\n!\"\u001a<jI\u0016t7-\u001a\u00138!\u0011axPa\u0015\u0011\u0007=\u0014)\u0006B\u0003r\u001f\t\u0007!\u000fC\u0004\u0003Z=\u0001\rAa\u0017\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\t\u0006U\u0005U!1\u000b\u0005\b\u0005?z\u0001\u0019\u0001B1\u0003)IG/Z7U_J\u000bgn\u001b\t\b\u0003{\u0014\u0019Ga\u0015H\u0013\u0011\u0011IE!\u0003\t\u000f\u0005mt\u00021\u0001\u0002~!\u001a\u0001A\u0016/")
public class FPGrowth
implements Logging,
scala.Serializable {
    private double minSupport;
    private int numPartitions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.numPartitions = x$1;
    }

    public FPGrowth setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Minimal support level must be in range [0, 1] but got ").append(minSupport).toString());
        this.minSupport_$eq(minSupport);
        return this;
    }

    public FPGrowth setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Number of partitions must be positive but got ").append(numPartitions).toString());
        this.numPartitions_$eq(numPartitions);
        return this;
    }

    public <Item> FPGrowthModel<Item> run(RDD<Object> data, ClassTag<Item> evidence$4) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Input data is not cached.");
        }
        long count = data.count();
        long minCount = (long)package$.MODULE$.ceil(this.minSupport() * (double)count);
        int numParts = this.numPartitions() > 0 ? this.numPartitions() : data.partitions().length;
        HashPartitioner partitioner = new HashPartitioner(numParts);
        Tuple2<Item, Object>[] freqItemsCount = this.genFreqItems(data, minCount, (Partitioner)partitioner, evidence$4);
        RDD<FreqItemset<Item>> freqItemsets = this.genFreqItemsets(data, minCount, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])freqItemsCount)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2._1(), Array$.MODULE$.canBuildFrom(evidence$4)), (Partitioner)partitioner, evidence$4);
        Map itemSupport = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])freqItemsCount)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object item = tuple2._1();
            long cnt = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(item), (Object)BoxesRunTime.boxToDouble((double)((double)cnt / (double)count)));
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new FPGrowthModel<Item>(freqItemsets, itemSupport, evidence$4);
    }

    public <Item, Basket extends Iterable<Item>> FPGrowthModel<Item> run(JavaRDD<Basket> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$3).asScala()).toArray(tag), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass()))), tag);
    }

    private <Item> Tuple2<Item, Object>[] genFreqItems(RDD<Object> data, long minCount, Partitioner partitioner, ClassTag<Item> evidence$5) {
        RDD x$1 = data.flatMap((Function1 & Serializable & scala.Serializable)t -> {
            Set uniq = Predef$.MODULE$.genericArrayOps(t).toSet();
            if (ScalaRunTime$.MODULE$.array_length(t) != uniq.size()) {
                throw new SparkException(new StringBuilder(47).append("Items in a transaction must be unique but got ").append(Predef$.MODULE$.genericArrayOps(t).toSeq()).append(".").toString());
            }
            return Predef$.MODULE$.genericArrayOps(t);
        }, evidence$5).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)BoxesRunTime.boxToLong((long)1L)), ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag<Item> x$2 = evidence$5;
        ClassTag x$3 = ClassTag$.MODULE$.Long();
        Null$ x$42 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).reduceByKey(partitioner, (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$4, x$5) -> x$4 + x$5).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)FPGrowth.$anonfun$genFreqItems$4(minCount, x$6))).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)FPGrowth.$anonfun$genFreqItems$5(x$7)), (Ordering)Ordering.Long$.MODULE$);
    }

    private <Item> RDD<FreqItemset<Item>> genFreqItemsets(RDD<Object> data, long minCount, Object freqItems, Partitioner partitioner, ClassTag<Item> evidence$6) {
        Map itemToRank = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(freqItems).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1 & Serializable & scala.Serializable)transaction -> this.genCondTransactions(transaction, itemToRank, partitioner, evidence$6), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)), (Ordering)Ordering.Int$.MODULE$).aggregateByKey(new FPTree(), partitioner.numPartitions(), (Function2 & Serializable & scala.Serializable)(tree, transaction) -> tree.add(Predef$.MODULE$.wrapIntArray(transaction), 1L), (Function2 & Serializable & scala.Serializable)(tree1, tree2) -> tree1.merge(tree2), ClassTag$.MODULE$.apply(FPTree.class)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int part = tuple2._1$mcI$sp();
            FPTree tree = (FPTree)tuple2._2();
            Iterator iterator = tree.extract(minCount, (JFunction1.mcZI.sp & Serializable & scala.Serializable)x -> partitioner.getPartition((Object)BoxesRunTime.boxToInteger((int)x)) == part);
            return iterator;
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List ranks = (List)tuple2._1();
            long count = tuple2._2$mcJ$sp();
            FreqItemset freqItemset = new FreqItemset(((TraversableOnce)ranks.map((Function1 & Serializable & scala.Serializable)i -> ScalaRunTime$.MODULE$.array_apply(freqItems, BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).toArray(evidence$6), count);
            return freqItemset;
        }, ClassTag$.MODULE$.apply(FreqItemset.class));
    }

    private <Item> scala.collection.mutable.Map<Object, int[]> genCondTransactions(Object transaction, Map<Item, Object> itemToRank, Partitioner partitioner, ClassTag<Item> evidence$7) {
        scala.collection.mutable.Map output = Map$.MODULE$.empty();
        int[] filtered = (int[])Predef$.MODULE$.genericArrayOps(transaction).flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(itemToRank.get(key)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Arrays.sort(filtered);
        int n = filtered.length;
        for (int i = n - 1; i >= 0; --i) {
            int item = filtered[i];
            int part = partitioner.getPartition((Object)BoxesRunTime.boxToInteger((int)item));
            if (output.contains((Object)BoxesRunTime.boxToInteger((int)part))) continue;
            output.update((Object)BoxesRunTime.boxToInteger((int)part), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(filtered)).slice(0, i + 1));
        }
        return output;
    }

    public static final /* synthetic */ boolean $anonfun$genFreqItems$4(long minCount$1, Tuple2 x$6) {
        return x$6._2$mcJ$sp() >= minCount$1;
    }

    public static final /* synthetic */ long $anonfun$genFreqItems$5(Tuple2 x$7) {
        return -x$7._2$mcJ$sp();
    }

    public FPGrowth(double minSupport, int numPartitions) {
        this.minSupport = minSupport;
        this.numPartitions = numPartitions;
        Logging.$init$((Logging)this);
    }

    public FPGrowth() {
        this(0.3, -1);
    }

    public static class FreqItemset<Item>
    implements scala.Serializable {
        private final Object items;
        private final long freq;

        public Object items() {
            return this.items;
        }

        public long freq() {
            return this.freq;
        }

        public java.util.List<Item> javaItems() {
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(this.items()).toList()).asJava();
        }

        public String toString() {
            return new StringBuilder(2).append(Predef$.MODULE$.genericArrayOps(this.items()).mkString("{", ",", "}")).append(": ").append(this.freq()).toString();
        }

        public FreqItemset(Object items, long freq) {
            this.items = items;
            this.freq = freq;
        }
    }
}

