/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3Qa\u0003\u0007\u0001\u001dYA\u0001\u0002\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005G!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0001\u0004A!b\u0001\n\u0003\u0011\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011I\u0002!Q1A\u0005\u0002MB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\u0006\u0001\u0002!\t!\u0011\u0002\u001a/\u0016Lw\r\u001b;fI2+\u0017m\u001d;TcV\f'/Z:N_\u0012,GN\u0003\u0002\u000e\u001d\u0005)q\u000e\u001d;j[*\u0011q\u0002E\u0001\u0003[2T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\rG>,gMZ5dS\u0016tGo]\u0002\u0001+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u000f\u0003\u0019a\u0017N\\1mO&\u0011\u0001&\n\u0002\f\t\u0016t7/\u001a,fGR|'/A\u0007d_\u00164g-[2jK:$8\u000fI\u0001\nS:$XM]2faR,\u0012\u0001\f\t\u000315J!AL\r\u0003\r\u0011{WO\u00197f\u0003)Ig\u000e^3sG\u0016\u0004H\u000fI\u0001\fI&\fw-\u00138w\u0003R<\u0016)\u0001\u0007eS\u0006<\u0017J\u001c<Bi^\u000b\u0005%\u0001\tpE*,7\r^5wK\"K7\u000f^8ssV\tA\u0007E\u0002\u0019k1J!AN\r\u0003\u000b\u0005\u0013(/Y=\u0002#=\u0014'.Z2uSZ,\u0007*[:u_JL\b%\u0001\u0004=S:LGO\u0010\u000b\u0006uqjdh\u0010\t\u0003w\u0001i\u0011\u0001\u0004\u0005\u0006A%\u0001\ra\t\u0005\u0006U%\u0001\r\u0001\f\u0005\u0006a%\u0001\ra\t\u0005\u0006e%\u0001\r\u0001N\u0001\baJ,G-[2u)\ta#\tC\u0003D\u0015\u0001\u0007A)\u0001\u0005gK\u0006$XO]3t!\t!S)\u0003\u0002GK\t1a+Z2u_J\u0004")
public class WeightedLeastSquaresModel
implements Serializable {
    private final DenseVector coefficients;
    private final double intercept;
    private final DenseVector diagInvAtWA;
    private final double[] objectiveHistory;

    public DenseVector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public DenseVector diagInvAtWA() {
        return this.diagInvAtWA;
    }

    public double[] objectiveHistory() {
        return this.objectiveHistory;
    }

    public double predict(Vector features) {
        return BLAS$.MODULE$.dot((Vector)this.coefficients(), features) + this.intercept();
    }

    public WeightedLeastSquaresModel(DenseVector coefficients, double intercept, DenseVector diagInvAtWA, double[] objectiveHistory) {
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.diagInvAtWA = diagInvAtWA;
        this.objectiveHistory = objectiveHistory;
    }
}

