/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.tree.TreeEnsembleParams$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;

public final class RandomForest$
implements scala.Serializable,
Logging {
    public static RandomForest$ MODULE$;
    private final String[] supportedFeatureSubsetStrategies;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RandomForest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RandomForestModel trainClassifier(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        Enumeration.Value value = strategy.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Classification();
        Predef$.MODULE$.require(!(value != null ? !value.equals(value2) : value2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("RandomForest.trainClassifier given Strategy with invalid algo: ").append(strategy.algo()).toString());
        RandomForest rf = new RandomForest(strategy, numTrees, featureSubsetStrategy, seed);
        return rf.run(input);
    }

    public RandomForestModel trainClassifier(RDD<LabeledPoint> input, int numClasses, Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), impurityType, maxDepth, numClasses, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
        return this.trainClassifier(input, strategy, numTrees, featureSubsetStrategy, seed);
    }

    public RandomForestModel trainClassifier(JavaRDD<LabeledPoint> input, int numClasses, java.util.Map<Integer, Integer> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        return this.trainClassifier((RDD<LabeledPoint>)input.rdd(), numClasses, (Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.$conforms()), numTrees, featureSubsetStrategy, impurity, maxDepth, maxBins, seed);
    }

    public int trainClassifier$default$9() {
        return Utils$.MODULE$.random().nextInt();
    }

    public RandomForestModel trainRegressor(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        Enumeration.Value value = strategy.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Regression();
        Predef$.MODULE$.require(!(value != null ? !value.equals(value2) : value2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("RandomForest.trainRegressor given Strategy with invalid algo: ").append(strategy.algo()).toString());
        RandomForest rf = new RandomForest(strategy, numTrees, featureSubsetStrategy, seed);
        return rf.run(input);
    }

    public RandomForestModel trainRegressor(RDD<LabeledPoint> input, Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        Strategy strategy = new Strategy(Algo$.MODULE$.Regression(), impurityType, maxDepth, 0, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
        return this.trainRegressor(input, strategy, numTrees, featureSubsetStrategy, seed);
    }

    public RandomForestModel trainRegressor(JavaRDD<LabeledPoint> input, java.util.Map<Integer, Integer> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        return this.trainRegressor((RDD<LabeledPoint>)input.rdd(), (Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.$conforms()), numTrees, featureSubsetStrategy, impurity, maxDepth, maxBins, seed);
    }

    public int trainRegressor$default$8() {
        return Utils$.MODULE$.random().nextInt();
    }

    public String[] supportedFeatureSubsetStrategies() {
        return this.supportedFeatureSubsetStrategies;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomForest$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.supportedFeatureSubsetStrategies = TreeEnsembleParams$.MODULE$.supportedFeatureSubsetStrategies();
    }
}

