/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.mining;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.LocalTransformations;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.StringValue;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitable;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.mining.Segment;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.Removed;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "localTransformations", "segments"})
@XmlRootElement(name="Segmentation", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_0)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"multipleModelMethod", "missingPredictionTreatment", "missingThreshold", "extensions", "localTransformations", "segments"})
public class Segmentation
extends PMMLObject
implements HasExtensions<Segmentation> {
    @XmlAttribute(name="multipleModelMethod", required=true)
    @JsonProperty(value="multipleModelMethod")
    private MultipleModelMethod multipleModelMethod;
    @XmlAttribute(name="x-missingPredictionTreatment")
    @org.sparkproject.jpmml.model.annotations.Extension
    @JsonProperty(value="x-missingPredictionTreatment")
    private MissingPredictionTreatment missingPredictionTreatment;
    @XmlAttribute(name="x-missingThreshold")
    @org.sparkproject.jpmml.model.annotations.Extension
    @JsonProperty(value="x-missingThreshold")
    private Double missingThreshold;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    @Removed(value=Version.PMML_4_1)
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="Segment", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="Segment")
    private List<Segment> segments;
    private static final Double DEFAULT_MISSING_THRESHOLD = 1.0;
    private static final long serialVersionUID = 67305485L;

    public Segmentation() {
    }

    public Segmentation(@Property(value="multipleModelMethod") MultipleModelMethod multipleModelMethod, @Property(value="segments") List<Segment> segments) {
        this.multipleModelMethod = multipleModelMethod;
        this.segments = segments;
    }

    public MultipleModelMethod getMultipleModelMethod() {
        return this.multipleModelMethod;
    }

    public Segmentation setMultipleModelMethod(@Property(value="multipleModelMethod") MultipleModelMethod multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
        return this;
    }

    public MissingPredictionTreatment getMissingPredictionTreatment() {
        if (this.missingPredictionTreatment == null) {
            return MissingPredictionTreatment.CONTINUE;
        }
        return this.missingPredictionTreatment;
    }

    public Segmentation setMissingPredictionTreatment(@Property(value="missingPredictionTreatment") MissingPredictionTreatment missingPredictionTreatment) {
        this.missingPredictionTreatment = missingPredictionTreatment;
        return this;
    }

    public Double getMissingThreshold() {
        if (this.missingThreshold == null) {
            return DEFAULT_MISSING_THRESHOLD;
        }
        return this.missingThreshold;
    }

    public Segmentation setMissingThreshold(@Property(value="missingThreshold") Double missingThreshold) {
        this.missingThreshold = missingThreshold;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Segmentation addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    public Segmentation setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasSegments() {
        return this.segments != null && this.segments.size() > 0;
    }

    public List<Segment> getSegments() {
        if (this.segments == null) {
            this.segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    public Segmentation addSegments(Segment ... segments) {
        this.getSegments().addAll(Arrays.asList(segments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasSegments()) {
                status = PMMLObject.traverse(visitor, this.getSegments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum MultipleModelMethod implements StringValue<MultipleModelMethod>
    {
        MAJORITY_VOTE("majorityVote"),
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote"),
        AVERAGE("average"),
        WEIGHTED_AVERAGE("weightedAverage"),
        MEDIAN("median"),
        WEIGHTED_MEDIAN("x-weightedMedian"),
        MAX("max"),
        SUM("sum"),
        WEIGHTED_SUM("x-weightedSum"),
        SELECT_FIRST("selectFirst"),
        SELECT_ALL("selectAll"),
        MODEL_CHAIN("modelChain");

        private final String value;

        private MultipleModelMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static MultipleModelMethod fromValue(String v) {
            for (MultipleModelMethod c : MultipleModelMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    @org.sparkproject.jpmml.model.annotations.Extension
    public static enum MissingPredictionTreatment implements StringValue<MissingPredictionTreatment>
    {
        RETURN_MISSING("returnMissing"),
        SKIP_SEGMENT("skipSegment"),
        CONTINUE("continue");

        private final String value;

        private MissingPredictionTreatment(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static MissingPredictionTreatment fromValue(String v) {
            for (MissingPredictionTreatment c : MissingPredictionTreatment.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

