/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.visitors;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

abstract class AbstractImmutableList<E>
extends AbstractCollection<E>
implements List<E> {
    AbstractImmutableList() {
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        ListIterator result = new ListIterator<E>(){
            private int cursor;
            {
                this.cursor = index;
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != AbstractImmutableList.this.size();
            }

            @Override
            public E next() {
                try {
                    int i = this.cursor;
                    Object next = AbstractImmutableList.this.get(i);
                    this.cursor = i + 1;
                    return next;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor != 0;
            }

            @Override
            public E previous() {
                try {
                    int i = this.cursor - 1;
                    Object previous = AbstractImmutableList.this.get(i);
                    this.cursor = i;
                    return previous;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void add(E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return result;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<E> it = this.listIterator();
        while (it.hasNext()) {
            if (!Objects.equals(object, it.next())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<E> it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            if (!Objects.equals(object, it.previous())) continue;
            return it.nextIndex();
        }
        return -1;
    }
}

