/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$FamilyAndLink$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%c\u0001B\u001f?\u0001%C\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t%\u001a\u0005\ty\u0002\u0011\t\u0011)A\u0005M\"Aa\u0010\u0001BC\u0002\u0013\u0005q\u0010C\u0005\u0002\u0004\u0001\u0011\t\u0011)A\u0005\u001d\"Q\u0011q\u0001\u0001\u0003\u0006\u0004%\t!!\u0003\t\u0015\u0005U\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0005\u0002\u001a\u0001!\t\u0001QA\u000e\u0011\u001d\tI\u0003\u0001C\u0001\u0003WA!\"!\u000e\u0001\u0011\u000b\u0007I\u0011BA\u001c\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!a\u0012\u0001\t\u0013\ty\u0005C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011\u0011\u0016\u0001\u0005R\u0005-\u0006bBA]\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\t9\u000e\u0001C!\u00033Dq!!<\u0001\t\u0003\ny\u000fC\u0005\u0002z\u0002\u0011\r\u0011\"\u0011\u0002|\"A!1\u0001\u0001!\u0002\u0013\ti\u0010C\u0004\u0003\u0006\u0001!\tEa\u0002\b\u000f\tEa\b#\u0001\u0003\u0014\u00191QH\u0010E\u0001\u0005+Aq!!\u0007\u0018\t\u0003\u0011\u0019\u0004C\u0004\u00036]!\tEa\u000e\t\u000f\t\u0005s\u0003\"\u0011\u0003D\u00199!1J\f\u0001/\t5\u0003\"\u0003B.7\t\u0005\t\u0015!\u0003U\u0011\u001d\tIb\u0007C\u0001\u0005;2aA!\u001a\u001c\t\n\u001d\u0004BCA\u0004=\tU\r\u0011\"\u0001\u0002\n!Q\u0011Q\u0003\u0010\u0003\u0012\u0003\u0006I!a\u0003\t\u0011yt\"Q3A\u0005\u0002}D\u0011\"a\u0001\u001f\u0005#\u0005\u000b\u0011\u0002(\t\u000f\u0005ea\u0004\"\u0001\u0003~!I\u0011q\u001b\u0010\u0002\u0002\u0013\u0005!q\u0011\u0005\n\u0005\u001bs\u0012\u0013!C\u0001\u0005\u001fC\u0011Ba)\u001f#\u0003%\tA!*\t\u0013\t%f$!A\u0005B\t-\u0006\"\u0003B\\=\u0005\u0005I\u0011AA~\u0011%\u0011ILHA\u0001\n\u0003\u0011Y\fC\u0005\u0003Bz\t\t\u0011\"\u0011\u0003D\"I!\u0011\u001b\u0010\u0002\u0002\u0013\u0005!1\u001b\u0005\n\u0005;t\u0012\u0011!C!\u0005?D\u0011Ba9\u001f\u0003\u0003%\tE!:\t\u0013\t\u0015a$!A\u0005B\t\u001d\b\"\u0003Bu=\u0005\u0005I\u0011\tBv\u000f%\u0011yoGA\u0001\u0012\u0013\u0011\tPB\u0005\u0003fm\t\t\u0011#\u0003\u0003t\"9\u0011\u0011D\u0019\u0005\u0002\r\u0005\u0001\"\u0003B\u0003c\u0005\u0005IQ\tBt\u0011%\u0019\u0019!MA\u0001\n\u0003\u001b)\u0001C\u0005\u0004\fE\n\t\u0011\"!\u0004\u000e!91qD\u000e\u0005R\r\u0005bABB\u0016/\u0011\u0019i\u0003C\u0004\u0002\u001a]\"\taa\f\t\u0013\rMrG1A\u0005\n\t-\u0006\u0002CB\u001bo\u0001\u0006IA!,\t\u000f\t\u0005s\u0007\"\u0011\u00048!I11H\f\u0002\u0002\u0013%1Q\b\u0002!\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002@\u0001\u0006Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u0005\u0013\u0015AA7m\u0015\t\u0019E)A\u0003ta\u0006\u00148N\u0003\u0002F\r\u00061\u0011\r]1dQ\u0016T\u0011aR\u0001\u0004_J<7\u0001A\n\u0006\u0001)+\u0006L\u0018\t\u0005\u00172sE+D\u0001?\u0013\tieHA\bSK\u001e\u0014Xm]:j_:lu\u000eZ3m!\ty%+D\u0001Q\u0015\t\t\u0006)\u0001\u0004mS:\fGnZ\u0005\u0003'B\u0013aAV3di>\u0014\bCA&\u0001!\tYe+\u0003\u0002X}\tyr)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:\u0014\u0015m]3\u0011\u0005ecV\"\u0001.\u000b\u0005m\u0003\u0015\u0001B;uS2L!!\u0018.\u0003\u00155cuK]5uC\ndW\rE\u0002Z?\u0006L!\u0001\u0019.\u0003%!\u000b7\u000f\u0016:bS:LgnZ*v[6\f'/\u001f\t\u0003\u0017\nL!a\u0019 \u0003U\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o)J\f\u0017N\\5oON+X.\\1ss\u0006\u0019Q/\u001b3\u0016\u0003\u0019\u0004\"a\u001a9\u000f\u0005!t\u0007CA5m\u001b\u0005Q'BA6I\u0003\u0019a$o\\8u})\tQ.A\u0003tG\u0006d\u0017-\u0003\u0002pY\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\tyG\u000eK\u0002\u0002ij\u0004\"!\u001e=\u000e\u0003YT!a\u001e\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002zm\n)1+\u001b8dK\u0006\n10A\u00033]Ar\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002uu\u0006a1m\\3gM&\u001c\u0017.\u001a8ugV\ta\nK\u0002\u0004ij\fQbY8fM\u001aL7-[3oiN\u0004\u0003f\u0001\u0003uu\u0006I\u0011N\u001c;fe\u000e,\u0007\u000f^\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00105\tA.C\u0002\u0002\u00121\u0014a\u0001R8vE2,\u0007fA\u0003uu\u0006Q\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u0011)\u0007\u0019!(0\u0001\u0004=S:LGO\u0010\u000b\b)\u0006u\u0011\u0011EA\u0013\u0011\u0015!w\u00011\u0001gQ\u0011\ti\u0002\u001e>\t\u000by<\u0001\u0019\u0001()\t\u0005\u0005BO\u001f\u0005\b\u0003\u000f9\u0001\u0019AA\u0006Q\u0011\t)\u0003\u001e>\u0002)M,G\u000fT5oWB\u0013X\rZ5di&|gnQ8m)\u0011\ti#a\f\u000e\u0003\u0001Aa!!\r\t\u0001\u00041\u0017!\u0002<bYV,\u0007f\u0001\u0005uu\u0006ia-Y7jYf\fe\u000e\u001a'j].,\"!!\u000f\u0011\t\u0005m\u0012\u0011\t\b\u0004\u0017\u0006u\u0012bAA }\u0005Yr)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:LA!a\u0011\u0002F\tia)Y7jYf\fe\u000e\u001a'j].T1!a\u0010?\u0003\u001d\u0001(/\u001a3jGR$B!a\u0003\u0002L!1\u0011Q\n\u0006A\u00029\u000b\u0001BZ3biV\u0014Xm\u001d\u000b\u0007\u0003\u0017\t\t&a\u0015\t\r\u000553\u00021\u0001O\u0011\u001d\t)f\u0003a\u0001\u0003\u0017\taa\u001c4gg\u0016$\u0018a\u00039sK\u0012L7\r\u001e'j].$b!a\u0003\u0002\\\u0005u\u0003BBA'\u0019\u0001\u0007a\nC\u0004\u0002V1\u0001\r!a\u0003\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA2\u0003\u000b\u0003B!!\u001a\u0002\u00009!\u0011qMA=\u001d\u0011\tI'!\u001e\u000f\t\u0005-\u00141\u000f\b\u0005\u0003[\n\tHD\u0002j\u0003_J\u0011aR\u0005\u0003\u000b\u001aK!a\u0011#\n\u0007\u0005]$)A\u0002tc2LA!a\u001f\u0002~\u00059\u0001/Y2lC\u001e,'bAA<\u0005&!\u0011\u0011QAB\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002|\u0005u\u0004bBAD\u001b\u0001\u0007\u0011\u0011R\u0001\bI\u0006$\u0018m]3ua\u0011\tY)a&\u0011\r\u00055\u0015qRAJ\u001b\t\ti(\u0003\u0003\u0002\u0012\u0006u$a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003+\u000b9\n\u0004\u0001\u0005\u0019\u0005e\u0015QQA\u0001\u0002\u0003\u0015\t!a'\u0003\u0007}##'\u0005\u0003\u0002\u001e\u0006\r\u0006\u0003BA\u0007\u0003?K1!!)m\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0004\u0002&&\u0019\u0011q\u00157\u0003\u0007\u0005s\u00170A\u0007ue\u0006t7OZ8s[&k\u0007\u000f\u001c\u000b\u0005\u0003G\ni\u000bC\u0004\u0002\b:\u0001\r!a,1\t\u0005E\u0016Q\u0017\t\u0007\u0003\u001b\u000by)a-\u0011\t\u0005U\u0015Q\u0017\u0003\r\u0003o\u000bi+!A\u0001\u0002\u000b\u0005\u00111\u0014\u0002\u0004?\u0012\u001a\u0014aB:v[6\f'/_\u000b\u0002C\"\u001aq\u0002\u001e>\u0002\u0011\u00154\u0018\r\\;bi\u0016$B!a1\u0002JB\u00191*!2\n\u0007\u0005\u001dgH\u0001\u0012HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\b\u0003\u000f\u0003\u0002\u0019AAfa\u0011\ti-!5\u0011\r\u00055\u0015qRAh!\u0011\t)*!5\u0005\u0019\u0005M\u0017\u0011ZA\u0001\u0002\u0003\u0015\t!a'\u0003\u0007}#C\u0007K\u0002\u0011ij\fAaY8qsR\u0019A+a7\t\u000f\u0005u\u0017\u00031\u0001\u0002`\u0006)Q\r\u001f;sCB!\u0011\u0011]At\u001b\t\t\u0019OC\u0002\u0002f\u0002\u000bQ\u0001]1sC6LA!!;\u0002d\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u0012ij\fQa\u001e:ji\u0016,\"!!=\u0011\u0007e\u000b\u00190C\u0002\u0002vj\u0013\u0001\"\u0014'Xe&$XM\u001d\u0015\u0004%QT\u0018a\u00038v[\u001a+\u0017\r^;sKN,\"!!@\u0011\t\u00055\u0011q`\u0005\u0004\u0005\u0003a'aA%oi\u0006aa.^7GK\u0006$XO]3tA\u0005AAo\\*ue&tw\rF\u0001gQ\u0011)BOa\u0003\"\u0005\t5\u0011!B\u001a/a9\u0002\u0004f\u0001\u0001uu\u0006\u0001s)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tYucE\u0004\u0018\u0005/\u0011iBa\t\u0011\t\u00055!\u0011D\u0005\u0004\u00057a'AB!osJ+g\r\u0005\u0003Z\u0005?!\u0016b\u0001B\u00115\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\t\u0015\"qF\u0007\u0003\u0005OQAA!\u000b\u0003,\u0005\u0011\u0011n\u001c\u0006\u0003\u0005[\tAA[1wC&!!\u0011\u0007B\u0014\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011\u0019\"\u0001\u0003sK\u0006$WC\u0001B\u001d!\u0011I&1\b+\n\u0007\tu\"L\u0001\u0005N\u0019J+\u0017\rZ3sQ\rIBO_\u0001\u0005Y>\fG\rF\u0002U\u0005\u000bBaAa\u0012\u001b\u0001\u00041\u0017\u0001\u00029bi\"D3A\u0007;{\u0005\u0019:UM\\3sC2L'0\u001a3MS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u00067\u0005E(q\n\t\u0005\u0005#\u00129&\u0004\u0002\u0003T)\u0019!Q\u000b\"\u0002\u0011%tG/\u001a:oC2LAA!\u0017\u0003T\t9Aj\\4hS:<\u0017\u0001C5ogR\fgnY3\u0015\t\t}#1\r\t\u0004\u0005CZR\"A\f\t\r\tmS\u00041\u0001U\u0005\u0011!\u0015\r^1\u0014\u000fy\u00119B!\u001b\u0003pA!\u0011Q\u0002B6\u0013\r\u0011i\u0007\u001c\u0002\b!J|G-^2u!\u0011\u0011\tH!\u001f\u000f\t\tM$q\u000f\b\u0004S\nU\u0014\"A7\n\u0007\u0005mD.\u0003\u0003\u00032\tm$bAA>YR1!q\u0010BB\u0005\u000b\u00032A!!\u001f\u001b\u0005Y\u0002bBA\u0004G\u0001\u0007\u00111\u0002\u0005\u0006}\u000e\u0002\rA\u0014\u000b\u0007\u0005\u007f\u0012IIa#\t\u0013\u0005\u001dA\u0005%AA\u0002\u0005-\u0001b\u0002@%!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tJ\u000b\u0003\u0002\f\tM5F\u0001BK!\u0011\u00119Ja(\u000e\u0005\te%\u0002\u0002BN\u0005;\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005]d\u0017\u0002\u0002BQ\u00053\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa*+\u00079\u0013\u0019*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005[\u0003BAa,\u000366\u0011!\u0011\u0017\u0006\u0005\u0005g\u0013Y#\u0001\u0003mC:<\u0017bA9\u00032\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAR\u0005{C\u0011Ba0*\u0003\u0003\u0005\r!!@\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\r\u0005\u0004\u0003H\n5\u00171U\u0007\u0003\u0005\u0013T1Aa3m\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001f\u0014IM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002Bk\u00057\u0004B!!\u0004\u0003X&\u0019!\u0011\u001c7\u0003\u000f\t{w\u000e\\3b]\"I!qX\u0016\u0002\u0002\u0003\u0007\u00111U\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003.\n\u0005\b\"\u0003B`Y\u0005\u0005\t\u0019AA\u007f\u0003!A\u0017m\u001d5D_\u0012,GCAA\u007f)\t\u0011i+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005+\u0014i\u000fC\u0005\u0003@>\n\t\u00111\u0001\u0002$\u0006!A)\u0019;b!\r\u0011\t)M\n\u0006c\tU(1\u0005\t\n\u0005o\u0014i0a\u0003O\u0005\u007fj!A!?\u000b\u0007\tmH.A\u0004sk:$\u0018.\\3\n\t\t}(\u0011 \u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001By\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011yha\u0002\u0004\n!9\u0011q\u0001\u001bA\u0002\u0005-\u0001\"\u0002@5\u0001\u0004q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u001f\u0019Y\u0002\u0005\u0004\u0002\u000e\rE1QC\u0005\u0004\u0007'a'AB(qi&|g\u000eE\u0004\u0002\u000e\r]\u00111\u0002(\n\u0007\reAN\u0001\u0004UkBdWM\r\u0005\n\u0007;)\u0014\u0011!a\u0001\u0005\u007f\n1\u0001\u001f\u00131\u0003!\u0019\u0018M^3J[BdG\u0003BB\u0012\u0007S\u0001B!!\u0004\u0004&%\u00191q\u00057\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0005\u000f2\u0004\u0019\u00014\u0003M\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u00028\u0005s!\"a!\r\u0011\u0007\t\u0005t'A\u0005dY\u0006\u001c8OT1nK\u0006Q1\r\\1tg:\u000bW.\u001a\u0011\u0015\u0007Q\u001bI\u0004\u0003\u0004\u0003Hm\u0002\rAZ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007\u007f\u0001BAa,\u0004B%!11\tBY\u0005\u0019y%M[3di\"\u001aq\u0003\u001e>)\u0007Y!(\u0010")
public class GeneralizedLinearRegressionModel
extends RegressionModel<Vector, GeneralizedLinearRegressionModel>
implements GeneralizedLinearRegressionBase,
MLWritable,
HasTrainingSummary<GeneralizedLinearRegressionTrainingSummary> {
    private GeneralizedLinearRegression.FamilyAndLink familyAndLink;
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final int numFeatures;
    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary;
    private Param<String> family;
    private DoubleParam variancePower;
    private Param<String> link;
    private DoubleParam linkPower;
    private Param<String> linkPredictionCol;
    private Param<String> offsetCol;
    private Param<String> solver;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private DoubleParam tol;
    private IntParam maxIter;
    private BooleanParam fitIntercept;
    private volatile boolean bitmap$0;

    public static GeneralizedLinearRegressionModel load(String path) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<GeneralizedLinearRegressionModel> read() {
        return GeneralizedLinearRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<GeneralizedLinearRegressionTrainingSummary> setSummary(Option<GeneralizedLinearRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return GeneralizedLinearRegressionBase.getFamily$(this);
    }

    @Override
    public double getVariancePower() {
        return GeneralizedLinearRegressionBase.getVariancePower$(this);
    }

    @Override
    public String getLink() {
        return GeneralizedLinearRegressionBase.getLink$(this);
    }

    @Override
    public double getLinkPower() {
        return GeneralizedLinearRegressionBase.getLinkPower$(this);
    }

    @Override
    public String getLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.getLinkPredictionCol$(this);
    }

    @Override
    public String getOffsetCol() {
        return GeneralizedLinearRegressionBase.getOffsetCol$(this);
    }

    @Override
    public boolean hasWeightCol() {
        return GeneralizedLinearRegressionBase.hasWeightCol$(this);
    }

    @Override
    public boolean hasOffsetCol() {
        return GeneralizedLinearRegressionBase.hasOffsetCol$(this);
    }

    @Override
    public boolean hasLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.hasLinkPredictionCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return GeneralizedLinearRegressionBase.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<GeneralizedLinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public final DoubleParam variancePower() {
        return this.variancePower;
    }

    @Override
    public final Param<String> link() {
        return this.link;
    }

    @Override
    public final DoubleParam linkPower() {
        return this.linkPower;
    }

    @Override
    public final Param<String> linkPredictionCol() {
        return this.linkPredictionCol;
    }

    @Override
    public final Param<String> offsetCol() {
        return this.offsetCol;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$variancePower_$eq(DoubleParam x$1) {
        this.variancePower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(Param<String> x$1) {
        this.link = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPower_$eq(DoubleParam x$1) {
        this.linkPower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(Param<String> x$1) {
        this.linkPredictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$offsetCol_$eq(Param<String> x$1) {
        this.offsetCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public GeneralizedLinearRegressionModel setLinkPredictionCol(String value) {
        return (GeneralizedLinearRegressionModel)this.set(this.linkPredictionCol(), value);
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if (!this.bitmap$0) {
                this.familyAndLink = GeneralizedLinearRegression$FamilyAndLink$.MODULE$.apply(this);
                this.bitmap$0 = true;
            }
        }
        return this.familyAndLink;
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink() {
        return !this.bitmap$0 ? this.familyAndLink$lzycompute() : this.familyAndLink;
    }

    @Override
    public double predict(Vector features) {
        return this.predict(features, 0.0);
    }

    private double predict(Vector features, double offset) {
        double eta = this.predictLink(features, offset);
        return this.familyAndLink().fitted(eta);
    }

    private double predictLink(Vector features, double offset) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept() + offset;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        return this.transformImpl(dataset);
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Dataset outputData;
        block4: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            Column offset2 = !this.hasOffsetCol() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0)) : functions$.MODULE$.col(this.$(this.offsetCol())).cast((DataType)DoubleType$.MODULE$);
            outputData = dataset;
            int numColsOutput = 0;
            if (this.hasLinkPredictionCol()) {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(GeneralizedLinearRegressionModel $outer) {
                    }
                }
                UserDefinedFunction predLinkUDF = functions$.MODULE$.udf((Function2 & Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predictLink(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(null)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double());
                outputData = outputData.withColumn(this.$(this.linkPredictionCol()), predLinkUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})), outputSchema.apply(this.$(this.linkPredictionCol())).metadata());
                ++numColsOutput;
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                if (this.hasLinkPredictionCol()) {
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1)(JFunction1.mcDD.sp & Serializable)eta -> this.familyAndLink().fitted(eta), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double());
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.linkPredictionCol()))})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                } else {
                    JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(GeneralizedLinearRegressionModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function2 & Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predict(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(null)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double());
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                }
                ++numColsOutput;
            }
            if (numColsOutput != false) break block4;
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append(new StringBuilder(59).append(this.uid()).append(": GeneralizedLinearRegressionModel.transform() does nothing").toString()).append(" because no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    @Override
    public GeneralizedLinearRegressionTrainingSummary summary() {
        return (GeneralizedLinearRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public GeneralizedLinearRegressionSummary evaluate(Dataset<?> dataset) {
        return new GeneralizedLinearRegressionSummary(dataset, this);
    }

    @Override
    public GeneralizedLinearRegressionModel copy(ParamMap extra) {
        GeneralizedLinearRegressionModel copied = this.copyValues(new GeneralizedLinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (GeneralizedLinearRegressionModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new GeneralizedLinearRegressionModelWriter(this);
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public String toString() {
        return new StringBuilder(0).append(new StringBuilder(56).append("GeneralizedLinearRegressionModel: uid=").append(this.uid()).append(", family=").append((Object)this.$(this.family())).append(", link=").append((Object)this.$(this.link())).append(", ").toString()).append(new StringBuilder(12).append("numFeatures=").append(this.numFeatures()).toString()).toString();
    }

    public GeneralizedLinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasFitIntercept.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        GeneralizedLinearRegressionBase.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numFeatures = coefficients.size();
        Statics.releaseFence();
    }

    private static class GeneralizedLinearRegressionModelReader
    extends MLReader<GeneralizedLinearRegressionModel> {
        private final String className = GeneralizedLinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GeneralizedLinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = (Row)this.sparkSession().read().parquet(dataPath).select("intercept", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients = (Vector)data.getAs(1);
            GeneralizedLinearRegressionModel model = new GeneralizedLinearRegressionModel(metadata.uid(), coefficients, intercept);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GeneralizedLinearRegressionModelWriter
    extends MLWriter {
        private volatile GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data$module;
        private final GeneralizedLinearRegressionModel instance;

        private GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2(GeneralizedLinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GeneralizedLinearRegressionModelWriter generalizedLinearRegressionModelWriter = this;
            synchronized (generalizedLinearRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$(this);
                }
            }
        }

        public GeneralizedLinearRegressionModelWriter(GeneralizedLinearRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ GeneralizedLinearRegressionModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients) {
                return new Data(this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer(), intercept, coefficients);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "intercept";
                        break;
                    }
                    case 1: {
                        string = "coefficients";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GeneralizedLinearRegressionModelWriter org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GeneralizedLinearRegressionModelWriter $outer, double intercept, Vector coefficients) {
                this.intercept = intercept;
                this.coefficients = coefficients;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

