/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.visitors;

import java.util.HashSet;
import java.util.Set;
import org.sparkproject.dmg.pmml.Field;
import org.sparkproject.dmg.pmml.Model;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Visitable;
import org.sparkproject.dmg.pmml.mining.MiningModel;
import org.sparkproject.jpmml.model.visitors.DeepFieldResolver;
import org.sparkproject.jpmml.model.visitors.DeepFieldResolverUtil;

abstract class ModelCleaner
extends DeepFieldResolver {
    private Set<Field<?>> activeFields = new HashSet();

    ModelCleaner() {
    }

    @Override
    public void applyTo(Visitable visitable) {
        this.activeFields.clear();
        super.applyTo(visitable);
    }

    @Override
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof MiningModel) {
            MiningModel miningModel = (MiningModel)parent;
            this.processMiningModel(miningModel);
        } else if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        }
        return parent;
    }

    private void processMiningModel(MiningModel miningModel) {
        Set<Field<?>> activeFields = this.getActiveFields();
        activeFields.addAll(DeepFieldResolverUtil.getActiveFields((DeepFieldResolver)this, miningModel));
    }

    private void processModel(Model model) {
        Set<Field<?>> activeFields = this.getActiveFields();
        activeFields.addAll(DeepFieldResolverUtil.getActiveFields((DeepFieldResolver)this, model));
    }

    public Set<Field<?>> getActiveFields() {
        return this.activeFields;
    }
}

