/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u001dd\u0001B\"E\u0001=C\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t%\u001a\u0005\ty\u0002\u0011\t\u0011)A\u0005M\"Aa\u0010\u0001BC\u0002\u0013\u0005q\u0010C\u0005\u0002\b\u0001\u0011\t\u0011)A\u0005)\"Q\u00111\u0002\u0001\u0003\u0006\u0004%\t!!\u0004\t\u0015\u0005e\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u001e\u0001\u0011)\u0019!C\u0001\u0003\u001bA!\"!\t\u0001\u0005\u0003\u0005\u000b\u0011BA\b\u0011!\t)\u0003\u0001C\u0001\r\u0006\u001d\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\tY\u0006\u0001C\u0001\u0003;B!\"a\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0000\u0011-\t)\u0007\u0001a\u0001\u0002\u0004%I!a\u001a\t\u0015\u0005M\u0004\u00011A\u0001B\u0003&A\u000b\u0003\u0005\u0002v\u0001!\tERA<\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!a*\u0001\t\u0003\tI\u000bC\u0004\u00022\u0002!\t!a-\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"9\u0011Q\u001f\u0001\u0005B\u0005]\bb\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0005\b\u00057\u0001A\u0011\tB\u000f\u0011\u001d\u00119\u0003\u0001C!\u0005S9qAa\fE\u0011\u0003\u0011\tD\u0002\u0004D\t\"\u0005!1\u0007\u0005\b\u0003KQB\u0011\u0001B)\u0011\u001d\u0011\u0019F\u0007C!\u0005+BqAa\u0018\u001b\t\u0003\u0012\tGB\u0004\u0003ji\u0001!Da\u001b\t\u0013\tedD!A!\u0002\u0013Q\u0006bBA\u0013=\u0011\u0005!1\u0010\u0004\u0007\u0005\u0007sBI!\"\t\u0011y\f#Q3A\u0005\u0002}D\u0011\"a\u0002\"\u0005#\u0005\u000b\u0011\u0002+\t\u0015\u0005-\u0011E!f\u0001\n\u0003\ti\u0001\u0003\u0006\u0002\u001a\u0005\u0012\t\u0012)A\u0005\u0003\u001fA!\"!\b\"\u0005+\u0007I\u0011AA\u0007\u0011)\t\t#\tB\tB\u0003%\u0011q\u0002\u0005\b\u0003K\tC\u0011\u0001BN\u0011%\u0011Y!IA\u0001\n\u0003\u00119\u000bC\u0005\u00030\u0006\n\n\u0011\"\u0001\u00032\"I!QY\u0011\u0012\u0002\u0013\u0005!q\u0019\u0005\n\u0005\u0017\f\u0013\u0013!C\u0001\u0005\u000fD\u0011B!4\"\u0003\u0003%\tEa4\t\u0013\tm\u0017%!A\u0005\u0002\u0005m\u0002\"\u0003BoC\u0005\u0005I\u0011\u0001Bp\u0011%\u0011\u0019/IA\u0001\n\u0003\u0012)\u000fC\u0005\u0003t\u0006\n\t\u0011\"\u0001\u0003v\"I!q`\u0011\u0002\u0002\u0013\u00053\u0011\u0001\u0005\n\u0007\u000b\t\u0013\u0011!C!\u0007\u000fA\u0011Ba\n\"\u0003\u0003%\te!\u0003\t\u0013\r-\u0011%!A\u0005B\r5q!CB\t=\u0005\u0005\t\u0012BB\n\r%\u0011\u0019IHA\u0001\u0012\u0013\u0019)\u0002C\u0004\u0002&]\"\taa\t\t\u0013\t\u001dr'!A\u0005F\r%\u0001\"CB\u0013o\u0005\u0005I\u0011QB\u0014\u0011%\u0019ycNA\u0001\n\u0003\u001b\t\u0004C\u0004\u0004Dy!\tf!\u0012\u0007\r\r%#\u0004BB&\u0011\u001d\t)#\u0010C\u0001\u0007\u001bB\u0011b!\u0015>\u0005\u0004%IAa4\t\u0011\rMS\b)A\u0005\u0005#DqAa\u0018>\t\u0003\u001a)\u0006C\u0005\u0004Zi\t\t\u0011\"\u0003\u0004\\\tQ\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fY*\u0011QIR\u0001\u000be\u0016<'/Z:tS>t'BA$I\u0003\tiGN\u0003\u0002J\u0015\u0006)1\u000f]1sW*\u00111\nT\u0001\u0007CB\f7\r[3\u000b\u00035\u000b1a\u001c:h\u0007\u0001\u0019B\u0001\u0001)\\=B!\u0011K\u0015+[\u001b\u0005!\u0015BA*E\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA+Y\u001b\u00051&BA,G\u0003\u0019a\u0017N\\1mO&\u0011\u0011L\u0016\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005E\u0003\u0001CA)]\u0013\tiFIA\u000eB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8QCJ\fWn\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u001a\u000bA!\u001e;jY&\u00111\r\u0019\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\ta\r\u0005\u0002ha:\u0011\u0001N\u001c\t\u0003S2l\u0011A\u001b\u0006\u0003W:\u000ba\u0001\u0010:p_Rt$\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d\u0017A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c7)\u0007\u0005!(\u0010\u0005\u0002vq6\taO\u0003\u0002x\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005e4(!B*j]\u000e,\u0017%A>\u0002\u000bErcG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005QT\u0018\u0001D2pK\u001a4\u0017nY5f]R\u001cX#\u0001+)\t\r!\u00181A\u0011\u0003\u0003\u000b\tQA\r\u00181]A\nQbY8fM\u001aL7-[3oiN\u0004\u0003\u0006\u0002\u0003u\u0003\u0007\t\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0016\u0005\u0005=\u0001\u0003BA\t\u0003'i\u0011\u0001\\\u0005\u0004\u0003+a'A\u0002#pk\ndW\rK\u0002\u0006ij\f!\"\u001b8uKJ\u001cW\r\u001d;!Q\r1AO_\u0001\u0006g\u000e\fG.\u001a\u0015\u0004\u000fQT\u0018AB:dC2,\u0007\u0005K\u0002\tij\fa\u0001P5oSRtD#\u0003.\u0002*\u00055\u0012\u0011GA\u001b\u0011\u0015!\u0017\u00021\u0001gQ\u0011\tI\u0003\u001e>\t\u000byL\u0001\u0019\u0001+)\u000b\u00055B/a\u0001\t\u000f\u0005-\u0011\u00021\u0001\u0002\u0010!\"\u0011\u0011\u0007;{\u0011\u001d\ti\"\u0003a\u0001\u0003\u001fAC!!\u000euu\u0006Ya.^7GK\u0006$XO]3t+\t\ti\u0004\u0005\u0003\u0002\u0012\u0005}\u0012bAA!Y\n\u0019\u0011J\u001c;)\t)!\u0018QI\u0011\u0003\u0003\u000f\nQa\r\u00181]A\n\u0001d]3u#V\fg\u000e^5mKB\u0013xNY1cS2LG/[3t)\u0011\ti%a\u0014\u000e\u0003\u0001Aq!!\u0015\f\u0001\u0004\t\u0019&A\u0003wC2,X\r\u0005\u0004\u0002\u0012\u0005U\u0013qB\u0005\u0004\u0003/b'!B!se\u0006L\bfA\u0006uu\u0006y1/\u001a;Rk\u0006tG/\u001b7fg\u000e{G\u000e\u0006\u0003\u0002N\u0005}\u0003BBA)\u0019\u0001\u0007a\rK\u0002\rij\f!bX9vC:$\u0018\u000e\\3t\u00039y\u0016/^1oi&dWm]0%KF$B!!\u001b\u0002pA!\u0011\u0011CA6\u0013\r\ti\u0007\u001c\u0002\u0005+:LG\u000f\u0003\u0005\u0002r9\t\t\u00111\u0001U\u0003\rAH%M\u0001\f?F,\u0018M\u001c;jY\u0016\u001c\b%A\u0007p]B\u000b'/Y7DQ\u0006tw-\u001a\u000b\u0005\u0003S\nI\bC\u0004\u0002|A\u0001\r!! \u0002\u000bA\f'/Y71\t\u0005}\u0014Q\u0012\t\u0007\u0003\u0003\u000b))!#\u000e\u0005\u0005\r%bAA>\r&!\u0011qQAB\u0005\u0015\u0001\u0016M]1n!\u0011\tY)!$\r\u0001\u0011a\u0011qRA=\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\n\u0019q\f\n\u001a\u0012\t\u0005M\u0015\u0011\u0014\t\u0005\u0003#\t)*C\u0002\u0002\u00182\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0012\u0005m\u0015bAAOY\n\u0019\u0011I\\=\u0002!1\fWN\u00193beE+\u0018M\u001c;jY\u0016\u001cHc\u0001+\u0002$\"9\u0011QU\tA\u0002\u0005=\u0011A\u00027b[\n$\u0017-\u0001\tqe\u0016$\u0017n\u0019;Rk\u0006tG/\u001b7fgR\u0019A+a+\t\r\u00055&\u00031\u0001U\u0003!1W-\u0019;ve\u0016\u001c\b\u0006\u0002\nu\u0003\u0007\tq\u0001\u001d:fI&\u001cG\u000f\u0006\u0003\u0002\u0010\u0005U\u0006BBAW'\u0001\u0007A\u000b\u000b\u0003\u0014i\u0006\r\u0011!\u0003;sC:\u001chm\u001c:n)\u0011\ti,a8\u0011\t\u0005}\u0016\u0011\u001c\b\u0005\u0003\u0003\f\u0019N\u0004\u0003\u0002D\u0006=g\u0002BAc\u0003\u001btA!a2\u0002L:\u0019\u0011.!3\n\u00035K!a\u0013'\n\u0005%S\u0015bAAi\u0011\u0006\u00191/\u001d7\n\t\u0005U\u0017q[\u0001\ba\u0006\u001c7.Y4f\u0015\r\t\t\u000eS\u0005\u0005\u00037\fiNA\u0005ECR\fgI]1nK*!\u0011Q[Al\u0011\u001d\t\t\u000f\u0006a\u0001\u0003G\fq\u0001Z1uCN,G\u000f\r\u0003\u0002f\u0006=\bCBAt\u0003S\fi/\u0004\u0002\u0002X&!\u00111^Al\u0005\u001d!\u0015\r^1tKR\u0004B!a#\u0002p\u0012a\u0011\u0011_Ap\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\n\u0019q\fJ\u001a)\tQ!\u00181A\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011\u0011 B\u0003!\u0011\tYP!\u0001\u000e\u0005\u0005u(\u0002BA\u0000\u0003/\fQ\u0001^=qKNLAAa\u0001\u0002~\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\t\u001dQ\u00031\u0001\u0002z\u000611o\u00195f[\u0006D3!\u0006;{\u0003\u0011\u0019w\u000e]=\u0015\u0007i\u0013y\u0001C\u0004\u0003\u0012Y\u0001\rAa\u0005\u0002\u000b\u0015DHO]1\u0011\t\u0005\u0005%QC\u0005\u0005\u0005/\t\u0019I\u0001\u0005QCJ\fW.T1qQ\r1BO_\u0001\u0006oJLG/Z\u000b\u0003\u0005?\u00012a\u0018B\u0011\u0013\r\u0011\u0019\u0003\u0019\u0002\t\u001b2;&/\u001b;fe\"\u001aq\u0003\u001e>\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001a\u0015\u00051Q\f)\u0005K\u0002\u0001ij\f!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2\u0004\"!\u0015\u000e\u0014\u000fi\u0011)Da\u000f\u0003BA!\u0011\u0011\u0003B\u001c\u0013\r\u0011I\u0004\u001c\u0002\u0007\u0003:L(+\u001a4\u0011\t}\u0013iDW\u0005\u0004\u0005\u007f\u0001'AC'M%\u0016\fG-\u00192mKB!!1\tB'\u001b\t\u0011)E\u0003\u0003\u0003H\t%\u0013AA5p\u0015\t\u0011Y%\u0001\u0003kCZ\f\u0017\u0002\u0002B(\u0005\u000b\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"A!\r\u0002\tI,\u0017\rZ\u000b\u0003\u0005/\u0002Ba\u0018B-5&\u0019!1\f1\u0003\u00115c%+Z1eKJD3\u0001\b;{\u0003\u0011aw.\u00193\u0015\u0007i\u0013\u0019\u0007\u0003\u0004\u0003fu\u0001\rAZ\u0001\u0005a\u0006$\b\u000eK\u0002\u001eij\u0014\u0001%\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2<&/\u001b;feN)aDa\b\u0003nA!!q\u000eB;\u001b\t\u0011\tHC\u0002\u0003t!\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0005o\u0012\tHA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016$BA! \u0003\u0002B\u0019!q\u0010\u0010\u000e\u0003iAaA!\u001f!\u0001\u0004Q&\u0001\u0002#bi\u0006\u001cr!\tB\u001b\u0005\u000f\u0013i\t\u0005\u0003\u0002\u0012\t%\u0015b\u0001BFY\n9\u0001K]8ek\u000e$\b\u0003\u0002BH\u0005/sAA!%\u0003\u0016:\u0019\u0011Na%\n\u00035L1!!6m\u0013\u0011\u0011yE!'\u000b\u0007\u0005UG\u000e\u0006\u0005\u0003\u001e\n\u0005&1\u0015BS!\r\u0011y*I\u0007\u0002=!)a\u0010\u000ba\u0001)\"9\u00111\u0002\u0015A\u0002\u0005=\u0001bBA\u000fQ\u0001\u0007\u0011q\u0002\u000b\t\u0005;\u0013IKa+\u0003.\"9a0\u000bI\u0001\u0002\u0004!\u0006\"CA\u0006SA\u0005\t\u0019AA\b\u0011%\ti\"\u000bI\u0001\u0002\u0004\ty!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tM&f\u0001+\u00036.\u0012!q\u0017\t\u0005\u0005s\u0013\t-\u0004\u0002\u0003<*!!Q\u0018B`\u0003%)hn\u00195fG.,GM\u0003\u0002xY&!!1\u0019B^\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IM\u000b\u0003\u0002\u0010\tU\u0016AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tE\u0007\u0003\u0002Bj\u00053l!A!6\u000b\t\t]'\u0011J\u0001\u0005Y\u0006tw-C\u0002r\u0005+\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001a\n\u0005\b\"CA9_\u0005\u0005\t\u0019AA\u001f\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001Bt!\u0019\u0011IOa<\u0002\u001a6\u0011!1\u001e\u0006\u0004\u0005[d\u0017AC2pY2,7\r^5p]&!!\u0011\u001fBv\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t](Q \t\u0005\u0003#\u0011I0C\u0002\u0003|2\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002rE\n\t\u00111\u0001\u0002\u001a\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011\tna\u0001\t\u0013\u0005E$'!AA\u0002\u0005u\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005uBC\u0001Bi\u0003\u0019)\u0017/^1mgR!!q_B\b\u0011%\t\t(NA\u0001\u0002\u0004\tI*\u0001\u0003ECR\f\u0007c\u0001BPoM)qga\u0006\u0003BAY1\u0011DB\u0010)\u0006=\u0011q\u0002BO\u001b\t\u0019YBC\u0002\u0004\u001e1\fqA];oi&lW-\u0003\u0003\u0004\"\rm!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u001111C\u0001\u0006CB\u0004H.\u001f\u000b\t\u0005;\u001bIca\u000b\u0004.!)aP\u000fa\u0001)\"9\u00111\u0002\u001eA\u0002\u0005=\u0001bBA\u000fu\u0001\u0007\u0011qB\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\u0019da\u0010\u0011\r\u0005E1QGB\u001d\u0013\r\u00199\u0004\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013\u0005E11\b+\u0002\u0010\u0005=\u0011bAB\u001fY\n1A+\u001e9mKNB\u0011b!\u0011<\u0003\u0003\u0005\rA!(\u0002\u0007a$\u0003'\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\tIga\u0012\t\r\t\u0015D\b1\u0001g\u0005\u0001\ne\tV*veZLg/\u00197SK\u001e\u0014Xm]:j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\u0007u\u00129\u0006\u0006\u0002\u0004PA\u0019!qP\u001f\u0002\u0013\rd\u0017m]:OC6,\u0017AC2mCN\u001ch*Y7fAQ\u0019!la\u0016\t\r\t\u0015\u0014\t1\u0001g\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019i\u0006\u0005\u0003\u0003T\u000e}\u0013\u0002BB1\u0005+\u0014aa\u00142kK\u000e$\bf\u0001\u000euu\"\u001a\u0011\u0004\u001e>")
public class AFTSurvivalRegressionModel
extends RegressionModel<Vector, AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private Vector _quantiles;
    private Param<String> censorCol;
    private DoubleArrayParam quantileProbabilities;
    private Param<String> quantilesCol;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private BooleanParam fitIntercept;
    private DoubleParam tol;
    private IntParam maxIter;

    public static AFTSurvivalRegressionModel load(String path) {
        return AFTSurvivalRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.coefficients().size();
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    private Vector _quantiles() {
        return this._quantiles;
    }

    private void _quantiles_$eq(Vector x$1) {
        this._quantiles = x$1;
    }

    @Override
    public void onParamChange(Param<?> param) {
        block2: {
            String string = param.name();
            String string2 = "quantileProbabilities";
            if (string != null ? !string.equals(string2) : string2 != null) break block2;
            if (this.isDefined(this.quantileProbabilities())) {
                this._quantiles_$eq(Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities())), (Function1)(JFunction1.mcDD.sp & Serializable)q -> scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) * this.scale()), (ClassTag)ClassTag$.MODULE$.Double())));
            } else {
                this._quantiles_$eq(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Vector lambda2Quantiles(double lambda) {
        void var3_2;
        Vector quantiles = this._quantiles().copy();
        BLAS$.MODULE$.scal(lambda, quantiles);
        return var3_2;
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = this.predict(features);
        return this.lambda2Quantiles(lambda);
    }

    @Override
    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)package$.MODULE$.Seq().empty();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            Column predCol = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null))).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predCol.as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (this.hasQuantilesCol()) {
            Column column;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable)lambda -> this.lambda2Quantiles(BoxesRunTime.unboxToDouble((Object)lambda)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double()).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)predictionColumns.head()}));
            } else {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(null))).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column quanCol = column;
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.quantilesCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)quanCol.as(this.$(this.quantilesCol()), outputSchema.apply(this.$(this.quantilesCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append(new StringBuilder(53).append(this.uid()).append(": AFTSurvivalRegressionModel.transform() does nothing").toString()).append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = this.validateAndTransformSchema(schema, false);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.predictionCol()));
            }
            if (!this.isDefined(this.quantilesCol()) || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.quantilesCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.quantilesCol()), this.$(this.quantileProbabilities()).length);
        }
        return var2_2;
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(46).append("AFTSurvivalRegressionModel: uid=").append(this.uid()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
        Statics.releaseFence();
    }

    private static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            double d;
            Vector vector;
            Object scale;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    Some some;
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().parquet(dataPath);
                    row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block2;
                    Object coefficients = ((SeqOps)some.get()).apply(0);
                    Object intercept = ((SeqOps)some.get()).apply(1);
                    scale = ((SeqOps)some.get()).apply(2);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (!(intercept instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (scale instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
            Tuple3 tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
            Tuple3 tuple32 = tuple3;
            Vector coefficients = (Vector)tuple32._1();
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;
        private final AFTSurvivalRegressionModel instance;

        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                }
            }
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "coefficients";
                        break;
                    }
                    case 1: {
                        string = "intercept";
                        break;
                    }
                    case 2: {
                        string = "scale";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

