/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.spark.network.sasl.SaslEncryptionBackend;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.base.Throwables;
import org.spark-project.guava.collect.ImmutableMap;

public class SparkSaslServer
implements SaslEncryptionBackend {
    private final Logger logger = LoggerFactory.getLogger(SparkSaslServer.class);
    static final String DEFAULT_REALM = "default";
    static final String DIGEST = "DIGEST-MD5";
    static final String QOP_AUTH_CONF = "auth-conf";
    static final String QOP_AUTH = "auth";
    private final String secretKeyId;
    private final SecretKeyHolder secretKeyHolder;
    private SaslServer saslServer;

    public SparkSaslServer(String secretKeyId, SecretKeyHolder secretKeyHolder, boolean alwaysEncrypt) {
        this.secretKeyId = secretKeyId;
        this.secretKeyHolder = secretKeyHolder;
        String qop = alwaysEncrypt ? QOP_AUTH_CONF : String.format("%s,%s", QOP_AUTH_CONF, QOP_AUTH);
        ImmutableMap<String, String> saslProps = ImmutableMap.builder().put("javax.security.sasl.server.authentication", "true").put("javax.security.sasl.qop", qop).build();
        try {
            this.saslServer = Sasl.createSaslServer(DIGEST, null, DEFAULT_REALM, saslProps, new DigestCallbackHandler());
        }
        catch (SaslException e) {
            throw Throwables.propagate(e);
        }
    }

    public synchronized boolean isComplete() {
        return this.saslServer != null && this.saslServer.isComplete();
    }

    public Object getNegotiatedProperty(String name) {
        return this.saslServer.getNegotiatedProperty(name);
    }

    public synchronized byte[] response(byte[] token) {
        try {
            return this.saslServer != null ? this.saslServer.evaluateResponse(token) : new byte[]{};
        }
        catch (SaslException e) {
            throw Throwables.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        if (this.saslServer != null) {
            try {
                this.saslServer.dispose();
            }
            catch (SaslException saslException) {
            }
            finally {
                this.saslServer = null;
            }
        }
    }

    @Override
    public byte[] wrap(byte[] data, int offset, int len) throws SaslException {
        return this.saslServer.wrap(data, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] data, int offset, int len) throws SaslException {
        return this.saslServer.unwrap(data, offset, len);
    }

    public static String encodeIdentifier(String identifier) {
        Preconditions.checkNotNull(identifier, "User cannot be null if SASL is enabled");
        return Base64.encode((ByteBuf)Unpooled.wrappedBuffer((byte[])identifier.getBytes(StandardCharsets.UTF_8))).toString(StandardCharsets.UTF_8);
    }

    public static char[] encodePassword(String password) {
        Preconditions.checkNotNull(password, "Password cannot be null if SASL is enabled");
        return Base64.encode((ByteBuf)Unpooled.wrappedBuffer((byte[])password.getBytes(StandardCharsets.UTF_8))).toString(StandardCharsets.UTF_8).toCharArray();
    }

    private class DigestCallbackHandler
    implements CallbackHandler {
        private DigestCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    SparkSaslServer.this.logger.trace("SASL server callback: setting username");
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(SparkSaslServer.encodeIdentifier(SparkSaslServer.this.secretKeyHolder.getSaslUser(SparkSaslServer.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    SparkSaslServer.this.logger.trace("SASL server callback: setting password");
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(SparkSaslServer.encodePassword(SparkSaslServer.this.secretKeyHolder.getSecretKey(SparkSaslServer.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    SparkSaslServer.this.logger.trace("SASL server callback: setting realm");
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authId = ac.getAuthenticationID();
                    String authzId = ac.getAuthorizationID();
                    ac.setAuthorized(authId.equals(authzId));
                    if (ac.isAuthorized()) {
                        ac.setAuthorizedID(authzId);
                    }
                    SparkSaslServer.this.logger.debug("SASL Authorization complete, authorized set to {}", (Object)ac.isAuthorized());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
        }
    }
}

