/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.apache.spark.network.shuffle.ShuffleIndexRecord;

public class ShuffleIndexInformation {
    private final LongBuffer offsets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShuffleIndexInformation(File indexFile) throws IOException {
        int size = (int)indexFile.length();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.offsets = buffer.asLongBuffer();
        try (FilterInputStream dis = null;){
            dis = new DataInputStream(new FileInputStream(indexFile));
            ((DataInputStream)dis).readFully(buffer.array());
        }
    }

    public ShuffleIndexRecord getIndex(int reduceId) {
        long offset = this.offsets.get(reduceId);
        long nextOffset = this.offsets.get(reduceId + 1);
        return new ShuffleIndexRecord(offset, nextOffset - offset);
    }
}

